/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.cert.service;

import com.huawei.ism.tool.channel.cert.utils.SSLCertUtils;
import com.huawei.ism.tool.channel.config.entity.InternetParams;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.https.conn.HttpsConnManager;
import com.huawei.ism.tool.https.entity.HttpsConnection;
import com.huawei.ism.tool.obase.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsChannelHandler.class);

    public boolean testConnection(InternetParams internetConfig) {
        LOGGER.info("start to test Connection...");
        String fileTestUrl = HttpsPropUtils.getFileTestUrl();
        boolean isConnected = this.testServerConnection(internetConfig, fileTestUrl);
        LOGGER.info("finished test Connection.");
        return isConnected;
    }

    private boolean testServerConnection(InternetParams internetParams, String url) {
        if (null == internetParams) {
            LOGGER.info("test server connection failed , because internet params is null");
            return false;
        }
        HttpsConnection httpsConnection = HttpsConnManager.getInstance().getHttpsConnByUrl(url, internetParams.isUseProxy() ? internetParams.getHttpProxy() : null, SSLCertUtils.getSSLFactory());
        if (null == httpsConnection || !httpsConnection.isSuccess()) {
            LOGGER.info("test server connection failed , because https is not success");
            return false;
        }
        String resultCode = HttpsConnManager.getInstance().getHttpsResponseParams(httpsConnection.getConnection(), "resultCode");
        return !StringUtils.isNULLStr(resultCode);
    }
}

