# coding=utf-8

from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common


def execute(context, is_in_expand_scm=False):
    """存储池扩容状态检查


    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    if not need_add_disk_domain_controller(context, is_in_expand_scm, logger):
        logger.logInfo("no need add disk domain to controller")
        contextUtil.handleSuccess(context)
        return
    try:
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)

        result = {"flag": True, "errMsg": "", "suggestion": ""}

        # 触发Pool扩容
        cmd = "add disk_domain controller"
        check_ret = cliUtil.execCmdInDeveloperModePrompt(cli, cmd, True, lang)

        # 命令执行成功
        if check_ret[0] and cliUtil.queryResultWithNoRecord(check_ret[1]):
            contextUtil.handleSuccess(context)
            logger.logPass()
            return

        result["flag"] = False
        result["errMsg"], result["suggestion"] = common.getMsg(lang, "expand.storage.pool.fail")
        logger.logNoPass("cmd not execute successfully")
        contextUtil.handleFailure(context, result)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def need_add_disk_domain_controller(context, is_in_expand_scm, logger):
    """
    判断是否需要扩容存储池
    :param context:
    :return:
    """
    need_expand_scm = contextUtil.getItem(context, "need_expand_scm", False)
    if not is_in_expand_scm:
        logger.logInfo("current step is expand ctrl post check")
        # 当前步骤为扩控后评估（2->4, 2->8, 高端内双活）
        if need_expand_scm:
            # 记录需要扩缓存池
            logger.logInfo("no need to expand scm.")
            context["need_add_disk_domain_controller"] = True
            return False
        return True
    else:
        # 当前步骤为扩缓存池
        logger.logInfo("current step is expand scm")
        return context.get("need_add_disk_domain_controller", False)
