# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from com.huawei.tool.framwork.util.func import LocalHostUtil


def execute(context):
    return CheckNonArrayIp(context).check_array_ip()


class CheckNonArrayIp:

    def __init__(self, dataDict):
        self.dev = dataDict.get("dev")
        self.lang = contextUtil.getLang(dataDict)
        self.cli = contextUtil.getCliCommon(dataDict)
        self.logger = contextUtil.getLogger(dataDict)
        self.all_cli_ret = []
        self.err_msg = ""
        self.ip = self.dev.getIp()
        self.dev_version = self.dev.getProductVersion()
        self.dev_type = contextUtil.getProductModel(dataDict)

    def check_array_ip(self):
        """
        @summary: 查询连接的IP是否为阵列IP
        @return: True表示是维护IP；False表示非阵列P
        """
        try:
            self.logger.info("check_non_array_ip start.")
            # 判断版本范围
            isSvp = LocalHostUtil.isRunInSvp()
            self.logger.info(
                "check_non_array_ip isRunInSvp result:{}.".format(isSvp))
            if isSvp:
                self.logger.info("dev is svp ")
                return True, ""
            # 判断版本范围
            if not self.is_limit_version():
                self.logger.info(
                    "The version is not in the range of the array IP address verification：{}".format(
                        self.dev_version))
                return True, ""
            # 获取维护口IP列表
            result, dev_maint_ip_list, error_msg = self.get_maintenance_ip()
            if result is not True:
                self.logger.error(
                    "get_maintenance_ip:{}".format(
                        baseUtil.getPyResource(self.lang,
                                               "query.result.abnormal")))
            # 获取管理口IP列表
            flag, dev_manag_ip_list, error_msg = self.get_management_ip()
            if result is not True:
                self.logger.error("get_management_ip:{}".format(
                    baseUtil.getPyResource(self.lang,
                                           "query.result.abnormal")))
            # 判断是否是阵列IP
            if self.ip in dev_maint_ip_list or self.ip in dev_manag_ip_list:
                self.logger.info("current ip is array ip.")
                return True, ""
            else:
                self.logger.error(
                    "current ip is not array ip.lang={}{}".format(self.lang,
                                                                  baseUtil.getPyResource(
                                                                      self.lang,
                                                                      "login.ip.not.array.ip")))
                return False, baseUtil.getPyResource(self.lang,
                                                     "login.ip.not.array.ip")
            return True, ""
        except Exception as ex:
            self.logger.error(
                "Exception occurred when check array ip:{}".format(str(ex)))
            return True, ""

    def is_limit_version(self):
        """
        版本的范围如下：
        V3R6C50SPC100/V5R7C30SPC100（不含）之前版本
        doradoV3R1C30SPC100（不含）之前的版本
        所有TV2/18000V1
        :return:
        """
        self.logger.info("check_non_array_ip is_limit_version .")
        self.logger.info("dev_type:{},dev_version:{} .".format(self.dev_type,
                                                               self.dev_version))
        is_dorado = baseUtil.isDoradoDev(self.dev_type)
        # doradoV3
        if is_dorado:
            if "v3" in self.dev_version.lower() and self.dev_version <= "V300R001C30":
                self.logger.info("dev_version is dorado v3")
                return True
            self.logger.info("dev_version is dorado v6")
        else:
            if "v5" in self.dev_version.lower() and self.dev_version <= "V500R007C30":
                return True
            if self.dev_version <= "V300R006C50":
                return True
        self.logger.info("is_limit_version is not in limit")
        return False

    def get_maintenance_ip(self):
        '''
        @summary: 查询维护IP
        @return: 维护IP列表；
        '''
        self.logger.info("check_non_array_ip get_maintenance_ip start.")
        dev_maint_ip_list = []
        cmd = "show port general logic_type=Maintenance_Port physical_type=ETH"
        flag, cli_ret, error_msg = cliUtil.execCmdInCliMode(self.cli, cmd, True,
                                                            self.lang)
        self.all_cli_ret.append(cli_ret)
        if flag is not True:
            self.logger.info(
                "Failed to execute Maintenance IP cmd, cliRet:{}".format(
                    cli_ret))
            return flag, dev_maint_ip_list, error_msg
        else:
            cli_ret_dict_list = cliUtil.getHorizontalCliRet(cli_ret)
            for item in cli_ret_dict_list:
                dev_maint_ip_list.append(item.get("IPv4 Address"))
                dev_maint_ip_list.append(item.get("IPv6 Address"))
            self.logger.info(
                "The device maintence ip list is:{}".format(dev_maint_ip_list))
        return True, dev_maint_ip_list, ""

    def get_management_ip(self):
        '''
        @summary: 查询管理IP
        @return: 管理IP列表；
        '''
        self.logger.info("check_non_array_ip get_management_ip start.")
        dev_manag_ip_list = []
        cmd = "show port general logic_type=Management_Port physical_type=ETH"
        flag, cli_ret, error_msg = cliUtil.execCmdInCliMode(self.cli, cmd, True,
                                                            self.lang)
        self.all_cli_ret.append(cli_ret)
        if flag is not True:
            self.logger.info(
                "Failed to execute Management ip, cliRet:{}".format(
                    cli_ret))
            return flag, dev_manag_ip_list, error_msg
        else:
            cli_ret_dict_list = cliUtil.getHorizontalCliRet(cli_ret)
            for item in cli_ret_dict_list:
                dev_manag_ip_list.append(item.get("IPv4 Address"))
                dev_manag_ip_list.append(item.get("IPv6 Address"))
            self.logger.info(
                "The device Management ip list is:{}".format(dev_manag_ip_list))
        return True, dev_manag_ip_list, ""
