# -*- coding: UTF-8 -*-


# 扩容硬盘柜和硬盘框
class CABINET():

    def __init__(self, bayId, bayName, bayType, enginId):
        self.id = bayId
        self.name = bayName
        self.type = bayType
        self.enginId = enginId
        self.partitons = {
            "0": [],  # 分区0的硬盘框信息：框号，框类型（2U/4U）
            "1": [],  # 分区1的硬盘框信息：框号，框类型（2U/4U）
            "2": [],  # 分区2的硬盘框信息：框号，框类型（2U/4U）
            "3": [],  # 分区3的硬盘框信息：框号，框类型（2U/4U）
        }
        # 域编号：[(框名称、框类型（2U/4U）、起始位置、所属柜)]
        self.newpartitions = {}
        return

    def add_enclosure_to_partition(self, enclosureInfo, partitonNum):
        '''
        @summary: 添加硬盘框信息到指定分区
        '''
        partitonNum = str(partitonNum)
        currentPartiton = self.partitons.get(partitonNum, None)
        # 不存在该分区直接返回失败
        if currentPartiton is None:
            return False

        currentPartiton.append(enclosureInfo)
        self.partitons[partitonNum] = currentPartiton
        return True

    def get_one_partiton(self, partitonNum):
        '''
        @summary: 获取指定分区的硬盘框信息
        '''
        partitonNum = str(partitonNum)
        currentPartiton = self.partitons.get(partitonNum, None)
        return currentPartiton

    def get_id(self):
        '''
        @summary: 获取当前柜编号
        '''
        return self.id

    def get_name(self):
        '''
        @summary: 获取当前柜柜号
        '''
        return self.name

    def get_type(self):
        '''
        @summary: 获取当前柜类型
        '''
        return self.type

    def get_enginId(self):
        '''
        @summary: 获取当前柜类所属引擎
        '''
        return self.enginId

    def get_partitions(self):
        '''
        @summary: 获取所有分区字典
        '''
        return self.partitons

    def add_enclosure_to_newpartition(self, enclosureInfo, partitonNum):
        '''
        @summary: 添加硬盘框信息到指定分区
        '''
        partitonNum = str(partitonNum)
        currentPartiton = self.newpartitions.get(partitonNum, [])
        currentPartiton.append(enclosureInfo)
        self.newpartitions[partitonNum] = currentPartiton
        return True

    def get_one_newpartiton(self, partitonNum):
        '''
        @summary: 获取指定分区的硬盘框信息
        '''
        partitonNum = str(partitonNum)
        currentPartiton = self.newpartitions.get(partitonNum, [])
        return currentPartiton

    def get_newpartitions(self):
        '''
        @summary: 获取所有分区字典
        '''
        return self.newpartitions
