﻿# -*- coding: UTF-8 -*-
import re
import time

from com.huawei.ism.tool.base.utils import PingUtils  # @UnresolvedImport #IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽

import cbb.business.operate.fru.common.BaseFactory as BaseFactory
import cbb.business.operate.fru.common.FuncFactory as FuncFactory
from cbb.business.operate.fru.common import checkRedundantSwitch
import cbb.business.operate.fru.common.config as conf
from cbb.business.operate.fru.common import config
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil


class Loop():
    ________TEST_ZONE________ = None

    '''
    Function: 模块测试入口，供TestFactory调用
    '''

    @staticmethod
    def testEntrance(context):
        BaseFactory.log.debug(context, "enter sub test function.")

        # 测试SAS环路完整性检查
        Loop.checkAllSasLoopIntegrity_UNUSE(context)
        Loop.checkAllSasLoopIntegrity_TEMP_UNUSE(context)

        # 测试SAS环路冗余检测

        Loop.checkSasLoopRedandent_TEMP(context, "2.0")

        # 测试PCIe
        Loop.getPcieRelateInfo(context)
        Loop.checkAllPcieLoopIntegrity(context)
        Loop.checkPcieSwitchRedandent(context, "1090519040")  # "DSW1"

        # 测试管理网口
        Loop.checkAllMgmtCableIntegrity(context)

        return

    @staticmethod
    def getPcieRelateInfo(context):
        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.DISK)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.POWER)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.BACKUP_POWER)

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.FAN)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.BAY)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.FC_PORT)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.BOND_PORT)

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test

        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
        return

    '''
    Function：获取冗余控制器：只有当前更换的FRU的父类型为控制器，且用户当前context中的当前FRU中包含parentID时，该方法有效
    '''

    @staticmethod
    def getRedundantCntrId(context, curCntrId):
        recs = FuncFactory.getUsableRedCntr(context, curCntrId)

        if recs != None and len(recs) > 0:
            return restUtil.Tlv2Rest.getRecordValue(recs[0], restData.PublicAttributes.ID)
        else:
            return None

    ________SAS_CHECK_ZONE________ = None

    @staticmethod
    def getSASCardSlot(cardNum, side="R"):
        if cardNum == 0:
            return "%s%s" % (side, 5)
        elif cardNum == 1:
            return "%s%s" % (side, 4)
        else:
            raise Exception("get sas card slot error")

    @staticmethod
    def getDetectingSASPortRecords(context, isExchangeKeyValue=False):
        '''
        @summary: 获取需要检测的SAS端口信息集合
        @note: SAS线缆连接规则
                                环路0的A级联板上连线规则：
                "DAEX00.A.PRI":"CTEX.R5.P0"
                "DAEX01.A.PRI":"DAEX00.A.EXP"
                "DAEX02.A.PRI":"DAEX01.A.EXP"
                "DAEX03.A.PRI":"DAEX02.A.EXP"
                                环路0的B级联板上连线规则：
                "DAEX00.B.PRI":"CTEX.L5.P0"
                "DAEX01.B.PRI":"DAEX02.B.EXP"
                "DAEX02.B.PRI":"DAEX03.B.EXP"
                "DAEX03.B.PRI":"DAEX00.B.EXP"
                                环路0之外的其他环路的A级联板上连线规则：
                "DAEX10.A.PRI":"CTEX.R5.P1"
                "DAEX11.A.PRI":"DAEX10.A.EXP"
                "DAEX12.A.PRI":"DAEX11.A.EXP"
                "DAEX13.A.PRI":"DAEX12.A.EXP"
                                环路0之外的其他环路的B级联板上连线规则：
                "DAEX10.B.PRI":"DAEX11.B.EXP"
                "DAEX11.B.PRI":"DAEX12.B.EXP"
                "DAEX12.B.PRI":"DAEX13.B.EXP"
                "DAEX13.B.PRI":"CTEX.L5.P1"
        '''
        diskEncInfoList = Loop.getDiskEnclosure(context)

        requiredSasPortDict = {}
        daeList = [diskEncInfo["name"] for diskEncInfo in diskEncInfoList]

        for diskEncInfo in diskEncInfoList:
            name = diskEncInfo["name"]
            engNum = int(name[3])  # 引擎号

            portNum = name[4]  # SAS卡端口号
            if not portNum.isdigit():
                portNum = ord(portNum) - ord("A") + 10
            portNum = int(portNum)

            slotNum = int(name[5])
            cardNum = slotNum / 4  # 第几张卡
            depthNum = slotNum % 4  # 当前位于的级联深度

            aSideSrcPort = "%s.A.PRI" % name
            bSideSrcPort = "%s.B.PRI" % name
            aSideSrcPortHighPower = "%s.A.P0" % name
            bSideSrcPortHighPower = "%s.B.P0" % name
            aSideDesPort = ""
            bSideDesPort = ""
            aSideDesPortHighPower = ""
            bSideDesPortHighPower = ""

            # 0号环路正正接
            if portNum == 0 and cardNum == 0:
                if slotNum == 0:
                    aSideDesPort = "CTE%s.R5.P0" % engNum
                    bSideDesPort = "CTE%s.L5.P0" % engNum
                    aSideDesPortHighPower = aSideDesPort
                    bSideDesPortHighPower = bSideDesPort
                else:
                    aSideDesPort = "DAE%s%s%s.A.EXP" % (engNum, name[4], slotNum - 1)
                    aSideDesPortHighPower = "DAE%s%s%s.A.P1" % (engNum, name[4], slotNum - 1)
                    currentLoopLastDAE = "DAE%s%s%s" % (engNum, name[4], slotNum + 1)
                    if currentLoopLastDAE not in daeList or (slotNum + 1) / 4 != slotNum / 4:
                        currentLoopLastDAE = "DAE%s%s%s" % (engNum, name[4], 0)
                    bSideDesPort = "%s.B.EXP" % currentLoopLastDAE
                    bSideDesPortHighPower = "%s.B.P1" % currentLoopLastDAE
            else:
                if depthNum == 0:
                    aSideDesPort = "CTE%s.%s.P%s" % (engNum, Loop.getSASCardSlot(cardNum, side="R"), portNum)
                    aSideDesPortHighPower = aSideDesPort
                else:
                    aSideDesPort = "DAE%s%s%s.A.EXP" % (engNum, name[4], slotNum - 1)
                    aSideDesPortHighPower = "DAE%s%s%s.A.P1" % (engNum, name[4], slotNum - 1)

                currentLoopLastDAE = "DAE%s%s%s" % (engNum, name[4], slotNum + 1)
                if currentLoopLastDAE not in daeList or (slotNum + 1) / 4 != slotNum / 4:
                    bSideDesPort = "CTE%s.%s.P%s" % (engNum, Loop.getSASCardSlot(cardNum, side="L"), portNum)
                    bSideDesPortHighPower = bSideDesPort
                else:
                    bSideDesPort = "DAE%s%s%s.B.EXP" % (engNum, name[4], slotNum + 1)
                    bSideDesPortHighPower = "DAE%s%s%s.B.P1" % (engNum, name[4], slotNum + 1)

            requiredSasPortDict[aSideSrcPort] = aSideDesPort
            requiredSasPortDict[bSideSrcPort] = bSideDesPort
            requiredSasPortDict[aSideSrcPortHighPower] = aSideDesPortHighPower
            requiredSasPortDict[bSideSrcPortHighPower] = bSideDesPortHighPower

        if isExchangeKeyValue:
            for (key, value) in requiredSasPortDict.items():
                requiredSasPortDict.setdefault(value, key)

        BaseFactory.log.info(context, "requiredSasPortDict:%s" % str(requiredSasPortDict))

        return requiredSasPortDict

    @staticmethod
    def getDiskEnclosureSasPortDictForDorado18000(context):
        diskEncInfoList = Loop.getDiskEnclosure(context)
        requiredSasPortDict = {}
        daeList = [diskEncInfo.get("name", "") for diskEncInfo in diskEncInfoList]
        daeNames = list(filter(lambda dae : dae and len(dae) >= 3, daeList))

        for daeName in daeNames:
            daeSASPortDict, _ = Loop.getDiskEnclosureStandardSASPortDict(daeName, config.DORADO18000_EXP_SLOT_DICT)
            requiredSasPortDict.update(daeSASPortDict)
        return requiredSasPortDict

    @staticmethod
    def getDetectingSASPortRecordsForDorado18000(context, isExchangeKeyValue=False):
        """获取Dorado18000 V3设备所有的硬盘框的SAS端口标准组网SAS连线规则字典：{'硬盘框上的端口' : '控制器上的端口'},

        如果isExchangeKeyValue为真，则返回字典的键值对进行翻转后的字典.

        :param context:
        :param isExchangeKeyValue:
        :return:
        """
        diskEncInfoList = Loop.getDiskEnclosure(context)
        requiredSasPortDict = {}
        requiredSinglePathDict = {}
        daeList = [diskEncInfo["name"] for diskEncInfo in diskEncInfoList]

        for daeName in daeList:
            daeSASPortDict, daeSingleDict = Loop.getDiskEnclosureStandardSASPortDict(daeName)
            requiredSasPortDict.update(daeSASPortDict)
            requiredSinglePathDict.update(daeSingleDict)

        reversedRequiredSasDictPort = {}
        for (key, value) in requiredSasPortDict.items():
            reversedRequiredSasDictPort.setdefault(value, key)

        reversedRequiredSingleDictPort = {}
        for (key, value) in requiredSinglePathDict.items():
            reversedRequiredSingleDictPort.setdefault(value, key)

        contextUtil.setItem(context, 'allSASPortDict', requiredSasPortDict)
        contextUtil.setItem(context, 'reversedAllSASPortDict', reversedRequiredSasDictPort)
        BaseFactory.log.info(context, "requiredSasPortDict:%s" % str(requiredSasPortDict))
        BaseFactory.log.info(context, "reversedRequiredSingleDictPort:%s" % str(reversedRequiredSingleDictPort))

        if isExchangeKeyValue:
            return reversedRequiredSasDictPort, reversedRequiredSingleDictPort
        else:
            return requiredSasPortDict, requiredSinglePathDict

    @staticmethod
    def getDiskEnclosureStandardSASPortDict(daeName, portDict=None):
        engineSASPortDict = {}
        engineSinglePortDict = {}
        engineNum = daeName[3]
        baseSasPortDict = portDict if portDict else config.DORADO_18000V3_SMB0_SAS_PORT_DICT
        baseSinglePathDict = config.DORADO_18000V3_SMB0_SINGLEPATH_DICT
        if '0' == engineNum:
            engineSASPortDict = baseSasPortDict
            engineSinglePortDict = baseSinglePathDict
        else:
            for daeSasPort in baseSasPortDict:
                if daeSasPort.replace('0', engineNum, 1).split('.')[0] == daeName:
                    engineSASPortDict[daeSasPort.replace('0', engineNum, 1)] = baseSasPortDict.get(daeSasPort).replace(
                        '0', engineNum, 1)
            for daeSasPort in baseSinglePathDict:
                if daeSasPort.replace('0', engineNum, 1).split('.')[0] == daeName:
                    engineSinglePortDict[daeSasPort.replace('0', engineNum, 1)] = baseSinglePathDict.get(
                        daeSasPort).replace(
                        '0', engineNum, 1)

        daeSASPortDict = {}
        for daePort in engineSASPortDict:
            if daePort.startswith(daeName):
                daeSASPortDict[daePort] = engineSASPortDict.get(daePort)

        daeSingleDict = {}
        for daePort in engineSinglePortDict:
            if daePort.startswith(daeName):
                daeSingleDict[daePort] = engineSinglePortDict.get(daePort)

        return daeSASPortDict, daeSingleDict

    @staticmethod
    def getDiskEnclosure(context):
        """获取系统所有的硬盘框信息字典的列表.

        :param context:
        :return:
        """
        records = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        BaseFactory.log.info(context, "enclosureInfoRecords:%s" % records)
        diskEncInfoList = []
        for record in records:
            logicType = restUtil.Tlv2Rest.getRecordValue(record, restData.Hardware.Enclosure.LOGIC_TYPE)
            if logicType != restData.Enum.EnclosureTypeEnum.EXP:
                continue
            diskEncInfo = {
                "id": restUtil.Tlv2Rest.getRecordValue(record, restData.Hardware.Enclosure.ID),
                "name": restUtil.Tlv2Rest.getRecordValue(record, restData.Hardware.Enclosure.NAME),
                "location": restUtil.Tlv2Rest.getRecordValue(record, restData.Hardware.Enclosure.LOCATION),
                "logicType": restUtil.Tlv2Rest.getRecordValue(record, restData.Hardware.Enclosure.LOGIC_TYPE),
                "expanderDepth": restUtil.Tlv2Rest.getRecordValue(record, restData.Hardware.Enclosure.EXPANDER_DEPTH),
            }
            diskEncInfoList.append(diskEncInfo.copy())
        BaseFactory.log.info(context, "diskEncInfoList:%s" % diskEncInfoList)
        return diskEncInfoList

    @staticmethod
    def getIntfRecordByKey(context, intfKey, trueIdFalseLoc=True, allIntfRecs=None, filterNormal=False):
        '''
        @summary: 通过id获取指定接口卡的记录，并按接口参数决定是否进行正常筛选
        '''
        if allIntfRecs == None:
            allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)

        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, intfKey)
        if True != trueIdFalseLoc:
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.LOCATION,
                                                        restData.Enum.ConditionTypeEnum.EQ, intfKey)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        if True == filterNormal:
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        return restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)

    @staticmethod
    def getIntfLocationById(context, intfId, allIntfRecs=None):
        '''
        @summary: 通过id获取指定接口卡的location
        '''
        tmpRecs = Loop.getIntfRecordByKey(context, intfId, True, allIntfRecs, False)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "record of intfId:%s is not existed." % intfId)
            return None
        else:
            return restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.IntfModule.LOCATION)

    @staticmethod
    def getRedIntfLocForBigSasCard(context, intfLoc):
        '''
        @summary: 获取指定大卡location对应的冗余大卡location
        '''
        if None == intfLoc or "" == intfLoc:
            BaseFactory.log.error(context, "null intfLoc:%s" % intfLoc)
            return None

        redLoc = None  # CTE0.L0
        if intfLoc[-2] == "L":
            redLoc = intfLoc.replace("L", "R")
        elif intfLoc[-2] == "R":
            redLoc = intfLoc.replace("R", "L")
        else:
            BaseFactory.log.error(context, "invalid intfLoc:%s" % intfLoc)
            return None

        return redLoc

    @staticmethod
    def getRedIntfRecForBigSasCard(context, intfKey, trueIdFalseLoc=True,
                                   allIntfRecs=None, filterNormal=True):
        '''
        @summary: 通过Id/Location获取指定大卡的冗余接口卡记录，并由参数决定是否进行是否正常的筛选
        '''
        if None == allIntfRecs:
            allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)

        # 获取当前大卡location。如果intfKey为Id，则转换得到Location
        intfLoc = intfKey
        if True == trueIdFalseLoc:  # intfKey为大卡的Id，需要转换
            intfLoc = Loop.getIntfLocationById(context, intfKey, allIntfRecs)  # e.g. CTE0.L0
            if None == intfLoc:
                BaseFactory.log.error(context, "fail to translate id of %s to location." % intfKey)
                return None  # 如果检查时，该卡已拔出，可能存在误报风险

        # 获取冗余Sas大卡记录
        redIntfLoc = Loop.getRedIntfLocForBigSasCard(context, intfLoc)
        tmpRecs = Loop.getIntfRecordByKey(context, redIntfLoc, False, allIntfRecs, True)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no record of redIntfLoc:%s found." % redIntfLoc)
            return None
        else:
            return tmpRecs[0]

    @staticmethod
    def getSasIntfExpboardPortRecords(context, intfId, allSasPortRecs=None, filterLinkup=False):
        '''
        @summary: 通过Id获取指定SAS接口卡或级联板下的端口信息，并由参数决定是否进行是否已连接筛选
        '''
        if None == allSasPortRecs:
            allSasPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, intfId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        if True == filterLinkup:
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allSasPortRecs, conditionList)
        if True == filterLinkup:
            restUtil.Tlv2Rest.logRecList(context, tmpRecs, "all NORMAL LINK_UP sas port of intf:%s" % intfId)
        else:
            restUtil.Tlv2Rest.logRecList(context, tmpRecs, "all sas port of intf:%s" % intfId)
        return tmpRecs

    @staticmethod
    def getAllLoopEncListForBigSasCard(context, intfId, allIntfRecs=None, allSasPortRecs=None):
        '''
        @summary: 检查指定SAS大卡下已连接SAS环路中的硬盘框WWN列表
        @attention: 如果指定的接口卡不存在，则返回False
        '''
        # 获取指定SAS大卡的信息
        intfLoc = Loop.getIntfLocationById(context, intfId, allIntfRecs)  # e.g. CTE0.L0
        if None == intfLoc:  # 指定大卡不存在
            BaseFactory.log.error(context, "the intf:%s is inexsited." % intfId)
            return []

        # 获取指定SAS大卡的已连接端口所连接的硬盘框WWN列表
        # 此处采用超时方式获取，避免因系统刷新不及时，导致刚上电的大卡上查回的WWN列表为空。
        TIMEOUT = 45
        startTime = time.time()
        while True:
            # 获取卡下所连硬盘框WWN列表
            intfPortRecs = Loop.getSasIntfExpboardPortRecords(context, intfId, allSasPortRecs, True)
            allEncWwnList = []
            for portRec in intfPortRecs:
                wwnList = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.ENCLOSURE_WWNLIST)
                allEncWwnList.extend(wwnList.split(','))
            # 如果列表不为空，则终止循环
            if len(allEncWwnList) > 0:
                break
            # 如果超时时间到，则终止循环
            if (time.time() - startTime) > TIMEOUT:
                BaseFactory.log.info(context, "the intf:{} still has no disk enc connected after wait {} sec."
                                     .format(intfId, TIMEOUT))
                break
            # 睡一会儿后重试
            time.sleep(5)

        # 返回查询结果
        BaseFactory.log.info(context, "the enc wwn list under intf:%s is %s" % (intfId, allEncWwnList))
        return allEncWwnList

    @staticmethod
    def isRedIntfCanAcsAllDiskEncOfSpecifiedIntfForBigSasCard(context, intfId, allIntfRecs=None, allSasPortRecs=None):
        '''
        @summary: 检查指定SAS大卡所连接的SAS环路，其对称槽位的SAS大卡是否都已连接
        @note: 当冗余接口卡能访问到当前接口卡下能访问的所有框时，检查通过，否则不通过
        @attention 1: 如果当前接口卡不存在，或不正常，或其下无连接的端口，则返回True 
        @attention 2: 如果其冗余接口卡不存在，或冗余接口卡不能访问当前接口卡下的所有框，则返回False
        '''
        if None == allIntfRecs:
            allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        if None == allSasPortRecs:
            allSasPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)

        # 获取指定SAS大卡的信息，若该卡不存在或不正常，则检查通过
        tmpRecs = Loop.getIntfRecordByKey(context, intfId, True, allIntfRecs, True)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "the intf:%s is inexisted or Not NORMAL RUNNING. pass it." % intfId)
            return True
        intfLoc = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.IntfModule.LOCATION)

        # 如果指定SAS大卡下无已连接端口，则认为从本端看，组网对称，检查通过。
        tmpRecs = Loop.getSasIntfExpboardPortRecords(context, intfId, allSasPortRecs, True)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no NORMAL LINK_UP port existed under intf:%s. pass it." % intfLoc)
            return True

        # 获取冗余SAS大卡的信息
        redIntfLoc = Loop.getRedIntfLocForBigSasCard(context, intfLoc)
        if None == redIntfLoc:
            BaseFactory.log.error(context, "fail to get redundant intf location for intf:%s" % intfLoc)
            return False
        tmpRecs = Loop.getIntfRecordByKey(context, redIntfLoc, False, allIntfRecs, True)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "the NORMAL RUNNING redundant intf:%s is inexisted. no pass." % redIntfLoc)
            return False
        redIntfId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.IntfModule.ID)

        # 获取指定SAS大卡和冗余SAS大卡所连接的环路列表
        curLoopWwnList = Loop.getAllLoopEncListForBigSasCard(context, intfId, allIntfRecs, allSasPortRecs)
        if None == curLoopWwnList or 0 == len(curLoopWwnList):
            BaseFactory.log.info(context, "no loop existed under intf:%s, pass it." % intfLoc)
            return True

        redLoopWwnList = Loop.getAllLoopEncListForBigSasCard(context, redIntfId, allIntfRecs, allSasPortRecs)
        if None == redLoopWwnList or 0 == len(redLoopWwnList):
            BaseFactory.log.info(context, "no loop existed under redundant intf:%s, no pass." % redIntfLoc)
            return False

        BaseFactory.log.info(context, "curLoopWwnList=%s, redLoopWwnList=%s" % (curLoopWwnList, redLoopWwnList))
        errLoopWwnList = []
        for loopId in curLoopWwnList:
            if loopId not in redLoopWwnList:
                errLoopWwnList.append(loopId)

        if len(errLoopWwnList) > 0:
            BaseFactory.log.error(context, "the redundant loop of errLoopList:%s is inexisted for intf:%s."
                                  % (errLoopWwnList, intfLoc))
            return False
        else:
            BaseFactory.log.info(context, "the sas path under intf:%s is symmetrical." % intfLoc)
            return True

    @staticmethod
    def checkDiskPathRedundantForBigSasCard(context, intfId):

        # 参数检查
        if None == intfId or "" == intfId:
            BaseFactory.log.error(context, "the intfId:%s is none." % intfId)
            return False
        idInfos = intfId.split(".")  # e.g. 0.139 -> 0=引擎0，139=接口卡内部槽位号
        if len(idInfos) < 2:
            BaseFactory.log.error(context, "the intfId:%s is invalid." % intfId)
            return False

        # 查询接口卡下是否存在链路不完整的硬盘（任一控制器通过该接口卡访问硬盘的链路不通时，则认为不完整）
        nodeId = int(idInfos[0]) * 4
        slotId = int(idInfos[1])
        param0 = (restData.Sys.SasCardLinkInfo.NID, nodeId)
        param1 = (restData.Sys.SasCardLinkInfo.SAS_CARD_SLOT_NUM, slotId)
        param2 = (restData.Sys.SasCardLinkInfo.CMD_TYPE, 2)
        paramlist = restUtil.Tlv2Rest.getParamList(param0, param1, param2)
        rest = contextUtil.getRest(context)

        rstRec = restUtil.Tlv2Rest.execCmd(rest, restData.TlvCmd.CHECK_SAS_CARD_LINK_STATUS, paramlist, False)
        # 返回值不存在或者为空，直接返回False
        if rstRec == None or len(rstRec) == 0:
            BaseFactory.log.error(context,
                                  "the redundant disk path of intf:%s is NOT EXISTED. rstRec==None or len(rstRec)==0" % intfId)
            return False
        # 通过返回的字段0进行判断，0=完整，其他=不完整
        chkStatus = restUtil.Tlv2Rest.getRecordValue(rstRec, restData.Sys.SasCardLinkInfo.NID)
        BaseFactory.log.info(context, "intfId=%s, chkStatus=%s" % (intfId, chkStatus))
        if 0 == chkStatus:
            BaseFactory.log.error(context, "the redundant disk path of intf:%s is EXISTED." % intfId)
            return True
        else:
            BaseFactory.log.error(context, "the redundant disk path of intf:%s is NOT EXISTED." % intfId)
            return False

    @staticmethod
    def checkSasRedundantPathForBigSasCard(context, rplIntfId):

        # 当前SAS接口卡是否故障，故障则通过
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.INTF_MODULE, rplIntfId)
        if True == isFault:
            BaseFactory.log.info(context, "the backintf:%s is fault, replace it directly. check pass." % rplIntfId)
            BaseFactory.result.setResultPass(context)
            return True

        # 判断待换接口卡与其冗余接口卡（对称槽位）上的组网是否对称，不对称则不通过
        # 注意：下面的实现中，未要求组网严格对称，仅要求冗余侧能访问当前侧能访问的级联框即可
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        isSymm = Loop.isRedIntfCanAcsAllDiskEncOfSpecifiedIntfForBigSasCard(context, rplIntfId, allIntfRecs, None)
        if False == isSymm:
            BaseFactory.log.error(context, "the network of rplIntfId:%s is not symmetrical." % rplIntfId)
            BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                   FuncFactory.LangKey.PUBSUG_CONTACT_TECH_SPT_ENGINEER_FOR_HELP)
            return False

        # 判断当前接口卡下所有环路连接的硬盘，是否有其他冗余环路也可以访问
        isPass = Loop.checkDiskPathRedundantForBigSasCard(context, rplIntfId)
        if False == isPass:
            BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                   FuncFactory.LangKey.PUBSUG_CONTACT_TECH_SPT_ENGINEER_FOR_HELP)
            return False
        else:
            BaseFactory.result.setResultPass(context)
            return True

    # 获取与指定级联板同侧（相连，A或B板侧）的所有级联板和端口信息
    @staticmethod
    def getSamePartExpboardAndPortRecs(context, expCardId, allBoardRecs=None, allPortRecs=None):
        # 830上量前的老版本。
        # 1、级联框丝印编号原则：DAExyz：其中，x表示所连引擎的ID，y表示该引擎下的SAS环路号（环路号与SAS环路一一对应），z表示框在环路中的级联深度。
        # 2、最大级联深度为10个框。

        # 830大规模上量版本中扩展了支持的SAS扣卡数量。具体内容如下：
        # 1、仅V3的3U而后6U涉及该修改，其他硬件型号不涉及
        # 2、级联框编号规则中，级联深度变化：3U最多5个框（0-4或8-C）,6U最多8个框（0-7或8-F）
        # 3、级联框编号规则中，环路号发生变化，一个环路号可对应两个级联深度范围不同的环路，引擎号不变。如环路号为1时，可表示DAE010-DAE017和DAE018-DAE01F两个环路。

        sysVersion = FuncFactory.getCntrSoftVerString(context)
        # 内部版本号编号规则：以T版本号64(STRING)=2.20.02.231（控制器的TLV字段）为例：
        # 对于530和830的版本来说，其中2.20.02部分均相同；最后三位依次递增，且530版本为[200,230]；830版本为[231,...]；版本号中无B版本信息
        # 530和830的V3版本的编号规则与此相同。
        NEW_RULE_ACTIVE_V3_VERSION = "3.20.01.132"  ##v300R001C10SPC100B012 #新规则生效版本
        # 注意：最后一个版本为3.20.01.132.12，但工具无法从TLV中获取到B版本，故按照发布规则，只有认为3.20.01.132这个版本就已经使用了新规则。
        BaseFactory.log.info(context, "current cntr soft version is {}, new rule active version is {}"
                             .format(sysVersion, NEW_RULE_ACTIVE_V3_VERSION))

        sysType = FuncFactory.getSystemProductType(context)
        if sysType in FuncFactory.FRUCONST.V3_ENGIN_PRODUCT_TYPE_LIST and sysVersion >= NEW_RULE_ACTIVE_V3_VERSION:
            # V3 3U和6U的新版本，使用新规则(注意：此处版本比较采用字符串比较)
            return Loop.getSamePartExpboardAndPortRecs_New_Rule(context, expCardId, allBoardRecs, allPortRecs)
        else:
            # T，以及老版本的V3设备均使用老的规则进行检查
            return Loop.getSamePartExpboardAndPortRecs_OLD_Rule(context, expCardId, allBoardRecs, allPortRecs)

    # 级联框新丝印编号规则时的处理方法：级联深度号的8-F复用后的版本
    @staticmethod
    def getSamePartExpboardAndPortRecs_New_Rule(context, expCardId, allBoardRecs=None, allPortRecs=None):
        # 获取expCardId对应的级联板的信息
        # 此时，同一环路号的低位级联深度（0-7）和高位级联深度（8-F）可表示两个级联环路。
        expCardRec = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.EXPBOARD, expCardId)
        location = restUtil.Tlv2Rest.getRecordValue(expCardRec,
                                                    restData.Hardware.Expboard.LOCATION)  # DAE000.A, DAE010.B
        encLoc = location.split('.')[0]  # 所属硬盘框，如DAE010
        partLoc = location.split('.')[1]  # 所属环路侧，如B
        loopLoc = encLoc[:-1]  # 所属SAS环路，如DAE01
        loopLen = int(encLoc[-1], 16)  # 级联深度，如0或8

        # 构造环路的location列表
        samePartLocList = []
        if loopLen < 8:  # 相同环路号的低位深度环路
            for i in range(0, 8):
                tmpLoc = loopLoc + str(i) + "." + partLoc
                samePartLocList.append(tmpLoc)
        else:  # 相同环路号的高位深度环路
            for i in range(8, 16):
                tmpLoc = loopLoc + hex(i)[-1].upper() + "." + partLoc
                samePartLocList.append(tmpLoc)
        BaseFactory.log.info(context, "cur expboard location=%s, samePartLocList=%s" % (location, samePartLocList))

        # 获取与expCardId所在环路同侧的所有级联板信息
        if None == allBoardRecs:
            allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.EQOR, samePartLocList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        samePartCardRecs = restUtil.Tlv2Rest.filter(allBoardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, samePartCardRecs, "the same part loop expboard of %s:" % expCardId)

        # 获取与expCardId所在环路同侧的所有SAS端口信息
        cardIdList = []
        for cardRec in samePartCardRecs:
            cardId = restUtil.Tlv2Rest.getRecordValue(cardRec, restData.Hardware.Expboard.ID)
            if cardId not in cardIdList:
                cardIdList.append(cardId)
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, cardIdList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        samePartPortsRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, samePartPortsRecs, "the same part loop port of %s:" % expCardId)

        # 返回结果
        return (samePartCardRecs, samePartPortsRecs)

    # 级联框老丝印编号规则时的处理方法：级联深度号的8-F复用前的版本
    @staticmethod
    def getSamePartExpboardAndPortRecs_OLD_Rule(context, expCardId, allBoardRecs=None, allPortRecs=None):
        # 获取expCardId对应的级联板的信息
        # 级联框丝印编号原则：DAExyz：其中，x表示所连引擎的ID，y表示该引擎下的SAS环路号，z表示框在环路中的级联深度。
        expCardRec = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.EXPBOARD, expCardId)
        location = restUtil.Tlv2Rest.getRecordValue(expCardRec,
                                                    restData.Hardware.Expboard.LOCATION)  # DAE000.A, DAE010.B
        encLoc = location.split('.')[0]  # 所属硬盘框，如DAE010
        partLoc = location.split('.')[1]  # 所属环路侧，如B
        loopLoc = encLoc[:-1]  # 所属SAS环路，如DAE01
        samePartLocRex = loopLoc + ".*" + partLoc

        # 获取与expCardId所在环路同侧的所有级联板信息
        if None == allBoardRecs:
            allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.LIKE, samePartLocRex)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        samePartCardRecs = restUtil.Tlv2Rest.filter(allBoardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, samePartCardRecs, "the same part loop expboard of %s:" % expCardId)

        # 获取与expCardId所在环路同侧的所有SAS端口信息
        cardIdList = []
        for cardRec in samePartCardRecs:
            cardId = restUtil.Tlv2Rest.getRecordValue(cardRec, restData.Hardware.Expboard.ID)
            if cardId not in cardIdList:
                cardIdList.append(cardId)
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, cardIdList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        samePartPortsRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, samePartPortsRecs, "the same part loop port of %s:" % expCardId)

        # 返回结果
        return (samePartCardRecs, samePartPortsRecs)

    # 筛选出状态正常的级联板和端口信息
    @staticmethod
    def getNormalSamePartExpboardAndPortRecs(context, expCardRecs, sasPortRecs):

        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        normalCardRecs = restUtil.Tlv2Rest.filter(expCardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, normalCardRecs, "the NORMAL RUNNING part loop expboards:")

        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition3)
        normalPortRecs = restUtil.Tlv2Rest.filter(sasPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, normalPortRecs, "the LINK_UP part loop ports:")

        return (normalCardRecs, normalPortRecs)

    @staticmethod
    def getLinkedSasIntfRecForExpboard(context, expCardId, allPortRecs=None):
        '''
        @summary: 判断指定SAS级联板所在半边SAS环路所连接的SAS接口卡ID列表
        '''

        # 若当前级联板下无已连接端口，说明板子已拔出或无SAS连接
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
            allPCIePortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
            if allPortRecs:
                if allPCIePortRecs:
                    allPortRecs.extend(allPCIePortRecs)
            else:
                allPortRecs = allPCIePortRecs

        # 以当前级联板下连接的端口出发，遍历获取连接的SAS接口卡
        doneSasPortList = []  # 已经遍历过的SAS端口列表
        peerExpboardList = []  # 当前对端级联板列表
        peerExpboardList.append(expCardId)
        linkedSasIntfIdList = []  # 返回项

        while True:
            # 如果级联板需要遍历，则停止搜索
            if len(peerExpboardList) == 0:
                break

            # 获取级联板下的已连接端口
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQOR, peerExpboardList)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)

            # 获取级联板下端口连接的对端端口ID列表
            linkedPeerPortList = []
            for portRec in tmpRecs:
                type = restUtil.Tlv2Rest.getRecordValue(portRec, restData.PublicAttributes.TYPE)
                if type == restData.Enum.ObjEnum.PCIE_PORT:
                    peerId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.PciePort.CURRENT_PEER_PORT_ID)
                else:
                    peerId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)

                if FuncFactory.FRUCONST.INVALID_PORT_ID != peerId:
                    linkedPeerPortList.append(peerId)

            # 如果无对端端口，则停止搜索
            if len(linkedPeerPortList) == 0:
                break

            # 获取对端端口记录
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQOR,
                                                        linkedPeerPortList)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                        restData.Enum.ConditionTypeEnum.NEAND,
                                                        doneSasPortList)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            doneSasPortList.extend(linkedPeerPortList)  # 将当前连接的端口信息加入下次需要剔除的端口列表

            # 获取对端级联板ID列表
            peerExpboardList = []
            for portRec in tmpRecs:
                parentId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.PARENT_ID)
                parentType = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.PARENT_TYPE)
                if restData.Enum.ObjEnum.INTF_MODULE == parentType and linkedSasIntfIdList.count(parentId) == 0:
                    linkedSasIntfIdList.append(parentId)
                elif peerExpboardList.count(parentId) == 0:
                    peerExpboardList.append(parentId)

        BaseFactory.log.info(context,
                             "the linkedSasIntfIdList of expboard:{} is {}".format(expCardId, linkedSasIntfIdList))
        return linkedSasIntfIdList

    '''
    Function：检查系统中指定级联板是否存在SAS冗余路径，函数内部未设置报错信息
    params:
        context = 工具上下文
        expCardId = 待查询是否存在冗余路径的级联板ID
    Return: 指定级联板是否存在冗余路径。False=不存在；True=存在
    Algrithm: 算法原理：获取当前SAS环路的冗余侧所有级联板和端口，若冗余侧所有级联板均正常，且端口连接数量正确，则检查通过，否则不通过
    Attention1: 该算法要求多级联框时，不同框之间的级联板不能混连，如0框的A板不能连其他框的B板，仅能连A板；
    Attention2: 在多框交叉混连和线缆连接错误时有误报和漏报可能。
    '''

    @staticmethod
    def checkSasPathRedandentForExpboard(context, expCardId,
                                         allBoardRecs=None, allPortRecs=None):
        BaseFactory.log.info(context, "enter checkSasPathRedandentForExpboard, expCardId=" + expCardId)

        # 若待换级联板故障，则检查通过
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.EXPBOARD, expCardId)
        if True == isFault:
            BaseFactory.log.info(context, "the expboard is fault, replace it directly, check pass.")
            return True

        # 若当前级联板下无已连接端口，说明板子已拔出或无SAS连接，检查通过
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
            allPciePortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
            if allPortRecs:
                if allPciePortRecs:
                    allPortRecs.extend(allPciePortRecs)
            else:
                allPortRecs = allPciePortRecs

        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, expCardId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        curLinkPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, curLinkPortRecs)
        if len(curLinkPortRecs) == 0:
            BaseFactory.log.error(context, "the linkup sas port info of card:%s is inexisted, check pass." % expCardId)
            return True

        # 若冗余级联板不存在或状态不正常，则检查不通过
        expEncId = FuncFactory.getFruParentEncId(context, restData.Enum.ObjEnum.EXPBOARD, expCardId)
        if None == allBoardRecs:
            allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, expEncId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.ID,
                                                    restData.Enum.ConditionTypeEnum.NE, expCardId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2, condition3)
        tmpRecs = restUtil.Tlv2Rest.filter(allBoardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs,
                                     "the normal redundant expboard of allBoardRecs %s:" % allBoardRecs)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs, "the normal redundant expboard of %s:" % expCardId)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no redundant and normal expboard of "
                                  + expCardId + " is existed, check failed.")
            return False

        redCardId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.Expboard.ID)
        # 获取当前级联板所在半边SAS环路所连接的SAS接口卡信息
        linkedSasIntfIdList = Loop.getLinkedSasIntfRecForExpboard(context, expCardId, allPortRecs)
        if len(linkedSasIntfIdList) == 0:
            BaseFactory.log.info(context, "the expboard:%s linked to no sas intf, check pass." % expCardId)
            return True
        if len(linkedSasIntfIdList) != 1:
            BaseFactory.log.error(context, "the expboard:%s linked to more than one sas intf, check fail." % expCardId)
            return False
        linkedSasIntfId = linkedSasIntfIdList[0]
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, linkedSasIntfId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
        if 0 == len(tmpRecs):
            BaseFactory.log.info(context,
                                 "the sas intf of the expboard:%s linked to is inexisted, check pass." % expCardId)
            return True
        intfModel = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.IntfModule.MODEL)

        # 如果是SAS大卡，则按接口卡的冗余检查方案进行判断
        if restData.Enum.IntfModelEnum.SAS_12PORT_BACKEND_MODULE == intfModel:
            return Loop.checkSasRedundantPathForBigSasCard(context, linkedSasIntfId)

        # 获取当前级联板和冗余级联板的同侧环路中的所有级联板和端口信息
        (curPartCardRecs, curPartPortsRecs) = Loop.getSamePartExpboardAndPortRecs(context, expCardId, allBoardRecs,
                                                                                  allPortRecs)
        (redPartCardRecs, redPartPortsRecs) = Loop.getSamePartExpboardAndPortRecs(context, redCardId, allBoardRecs,
                                                                                  allPortRecs)
        (redPartNormalCardRecs, redPartLinkupPortsRecs) = Loop.getNormalSamePartExpboardAndPortRecs(context,
                                                                                                    redPartCardRecs,
                                                                                                    redPartPortsRecs)

        # 如果冗余侧级联板的数量比当前侧少，则检查不通过
        if len(redPartCardRecs) < len(curPartCardRecs):
            BaseFactory.log.error(context,
                                  "the redundant loop part expboard num:%d is less than current loop part expboard num:%d of %s, check failed."
                                  % (len(redPartCardRecs), len(curPartCardRecs), expCardId))
            return False

        # 如果冗余侧存在不正常的级联板，则检查不通过
        if len(redPartNormalCardRecs) < len(redPartCardRecs):
            BaseFactory.log.error(context,
                                  "the redundant loop part of %s existed abnormal expboard. normal:%d, all:%d. check failed."
                                  % (expCardId, len(redPartNormalCardRecs), len(redPartCardRecs)))
            return False

        # 如果冗余侧存在该连而未连的SAS端口，则检查不通过
        if len(redPartNormalCardRecs) == 1:
            if len(redPartLinkupPortsRecs) < 1:
                BaseFactory.log.error(context,
                                      "the redundant loop part of %s existed non-linkup port. check failed." % expCardId)
                return False
        elif len(redPartNormalCardRecs) > 1:
            realLinkupPortNum = len(redPartLinkupPortsRecs)
            shouldLinkupPortNum = len(redPartNormalCardRecs) * 2 - 1  # 冗余侧未连接的端口仅能有一个
            if realLinkupPortNum < shouldLinkupPortNum:
                BaseFactory.log.error(context,
                                      "the realLinkupPortNum:%d is less than shouldLinkupPortNum:%d in redundant loop part of %s. check failed."
                                      % (realLinkupPortNum, shouldLinkupPortNum, expCardId))
                return False
        else:
            BaseFactory.log.error(context, "unexpected redPartNormalCardRecs size:%d of %s" % (
            len(redPartNormalCardRecs), expCardId))
            return False

        # 冗余路径必须有一个口连接到SAS接口卡（或控制器，不为级联板即可），无则检查不通过
        redPartLinkupPortIdList = []
        for tmpRec in redPartLinkupPortsRecs:
            redPartLinkupPortIdList.append(restUtil.Tlv2Rest.getRecordValue(tmpRec, restData.PublicAttributes.ID))
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                    restData.Enum.ConditionTypeEnum.NE,
                                                    restData.Enum.ObjEnum.EXPBOARD)  # 不为级联板，即意味着为控制器（盘控一体）或SAS接口卡（独立机头或盘控一体）
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.CURRENT_PEER_PORT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, redPartLinkupPortIdList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs,
                                     "the linkup sas intf or cntr port of redundant path part of expCardId:%s" % expCardId)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context,
                                  "the linkup sas intf or cntr port of redundant path part of expCardId:%s is inexisted." % expCardId)
            return False

        # 冗余侧路径连接到的SAS接口卡（盘控一体时为控制器）是否正常，不正常则不通过
        redIntfPortRec = tmpRecs[0]
        redIntfType = restUtil.Tlv2Rest.getRecordValue(redIntfPortRec, restData.PublicAttributes.PARENT_TYPE)
        redIntfId = restUtil.Tlv2Rest.getRecordValue(redIntfPortRec, restData.PublicAttributes.PARENT_ID)
        isFault = FuncFactory.isFruFault(context, redIntfType, redIntfId)
        if True == isFault:
            BaseFactory.result.setResultPass(context)
            BaseFactory.log.info(context, "the parent intf(or cntr):%s(%s),%s of redIntfPort is fault, check fail."
                                 % (restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrObjEnum, redIntfType), redIntfType,
                                    redIntfId))
            return False

        # 冗余侧路径连接到的SAS接口卡所在的控制器是否正常，不正常则不通过
        redCntrRec = FuncFactory.getFruParentRecord(context, redIntfType, redIntfId, restData.Enum.ObjEnum.CONTROLLER)
        redCntrId = restUtil.Tlv2Rest.getRecordValue(redCntrRec, restData.PublicAttributes.ID)
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.CONTROLLER, redCntrId)
        if True == isFault:
            redCntrLoc = restUtil.Tlv2Rest.getRecordValue(redCntrRec, restData.PublicAttributes.LOCATION)
            BaseFactory.log.info(context, "the parent cntr:%s of redIntfPort is fault, check fail." % redCntrLoc)
            return False

        # 返回检查通过
        BaseFactory.log.info(context, "the redundant sas path of %s is existed, check pass." % expCardId)
        return True

    @staticmethod
    def getLinkUpPCIePortByIntf(allPCIePortsRecords, intfId):
        condition0 = restUtil.Tlv2Rest.getCondition(restData.PublicAttributesExtend.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, intfId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        linkedBackIntfPortRecs = restUtil.Tlv2Rest.filter(allPCIePortsRecords, conditionList)
        return linkedBackIntfPortRecs

    @staticmethod
    def getRedCtrl(context, ctrlId):
        tmpRecs = FuncFactory.getUsableRedCntr(context, ctrlId)
        if None == tmpRecs or len(tmpRecs) == 0:
            BaseFactory.log.error(context, "the redundant ctrl of %s is not existed." % ctrlId)
            return ""

        redCntrId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.Controller.ID)
        BaseFactory.log.error(context, "the redundant ctrl of %s is %s." % (ctrlId, redCntrId))
        return redCntrId

    @staticmethod
    def getPCIeIntfOnCtrl(context, ctrlId):
        allCardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, ctrlId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQOR,
                                                    FuncFactory.g_strBackEndIntfModelList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2, condition3)
        tmpRecs = restUtil.Tlv2Rest.filter(allCardRecs, conditionList)
        return tmpRecs

    @staticmethod
    def getPCIePortsOnIntfs(allPCIePorts, intfRecords):
        redCardIdList = []
        for tmpRec in intfRecords:
            tmpCardId = restUtil.Tlv2Rest.getRecordValue(tmpRec, restData.PublicAttributes.ID)
            redCardIdList.append(tmpCardId)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, redCardIdList)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPCIePorts, conditionList)
        return tmpRecs

    @staticmethod
    def checkRedPCIeIntf(context, linkedPorts, allPortRecs):
        allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        for portRec in linkedPorts:
            portId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.PublicAttributes.ID)
            # 获取端口所连级联板的ID
            peerPortId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.PciePort.CURRENT_PEER_PORT_ID)
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, peerPortId)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.ObjEnum.EXPBOARD)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            if len(tmpRecs) == 0:
                BaseFactory.log.error(context,
                                      "unexpected: the peer expboard port of linked backintf portid:%s is inexisted."
                                      % portId)
                continue
            expboardId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)
            # 检查冗余级联板所在的半边SAS环路是否正常，若不存在，见检查不通过
            if False == Loop.checkSasPathRedandentForExpboard(context, expboardId, allBoardRecs=allBoardRecs,
                                                              allPortRecs=allPortRecs):
                BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                       FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
                return False
            return True

    '''
    Function：检查指定PCIe接口卡是否存在冗余SAS路径
    params:
        context=工具上下文
        selCardId=指定SAS接口卡ID
        selIntfRec=None, allCardRecs=None, allPortRecs=None,可选参数
    Return: 检查指定PCIe接口卡是否存在冗余SAS路径：True / False(报错信息已设置)
    '''

    @staticmethod
    def checkRedCable4PCIeIntf(context, selCardId, selCntrId):
        BaseFactory.log.info(context, "Start to check cable on the interface(%s)" % selCardId)

        # 当前SAS接口卡是否故障，故障则通过
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.INTF_MODULE, selCardId)
        if True == isFault:
            BaseFactory.log.info(context, "the backintf:%s is fault, replace it directly. check pass." % selCardId)
            BaseFactory.result.setResultPass(context)
            return True

        # 当前接口卡上的SAS端口是否有连接（不关心连接端口的健康状态，有连接就算），无则通过
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
        linkedPorts = Loop.getLinkUpPCIePortByIntf(allPortRecs, selCardId)
        restUtil.Tlv2Rest.logRecList(context, linkedPorts, "The linked pcie port info under selCard:%s" % selCardId)
        selLinkPortNum = len(linkedPorts)
        if selLinkPortNum == 0:
            BaseFactory.log.info(context, "The sas ports are not existed on %s. Pass." % selCardId)
            BaseFactory.result.setResultPass(context)
            return True

        # 有没有冗余控制器，无则不通过
        redCntrId = Loop.getRedCtrl(context, selCntrId)
        if redCntrId == "":
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.CNTR_EXISTED_NONE_REDT_CNTR)
            return False

        # 冗余控制器上有无正常运行的PCIe接口卡，无则不通过
        redPCIeIntfs = Loop.getPCIeIntfOnCtrl(context, redCntrId)
        restUtil.Tlv2Rest.logRecList(context, redPCIeIntfs, "the pcie intf under redCntrId:%s" % redCntrId)
        if len(redPCIeIntfs) == 0:
            BaseFactory.log.error(context, "Dont have pcie intf on redCtrlId:%s" % redCntrId)
            BaseFactory.result.setResultFailByKeys(context,
                                                   FuncFactory.LangKey.BACKINTF_EXISTED_NONE_NORMAL_REDT_SAS_INTF,
                                                   FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
            return False

        # 冗余控制器上SAS接口卡的正常已连接端口数量不能少于当前接口卡，否则不通过(该判断可有可无，有可缩短异常场景的判断时间)
        redPCIePorts = Loop.getPCIePortsOnIntfs(allPortRecs, redPCIeIntfs)
        redLinkPortNum = len(redPCIePorts)
        BaseFactory.log.info(context, "the linkup port num of curintf and redintf is: %d, %d" % (
            selLinkPortNum, redLinkPortNum))
        if redLinkPortNum < selLinkPortNum:
            BaseFactory.log.info(context,
                                 "the linkup port num of redintf is less than the curintf to be repleace, check fail.")
            BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                   FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
            return False

        # 检查待换接口卡所连的级联框上的冗余路径是否正常（正确性检查，PCIe交叉组网或连接错误时有风险）
        if not Loop.checkRedPCIeIntf(context, linkedPorts, allPortRecs):
            return False

        # 显示界面，让用户冗余控制器端的SAS线缆是否连接正确，确认正确则进入下一步
        BaseFactory.log.info(context, "the redundant sas path of selCardId:%s is existed. check pass." % selCardId)
        BaseFactory.result.setResultPass(context)
        return True

    '''
    Function：检查指定SAS接口卡是否存在冗余SAS路径
    params:
        context=工具上下文
        selCardId=指定SAS接口卡ID
        selIntfRec=None, allCardRecs=None, allPortRecs=None,可选参数
    Return: 指定SAS接口卡是否存在冗余SAS路径：True / False(报错信息已设置)
    '''

    @staticmethod
    def checkSasRedundantPathForBackIntf(context, selCardId,
                                         selIntfRec=None, allCardRecs=None, allPortRecs=None):
        BaseFactory.log.info(context,
                             u"==========begin-checkSasRedundantPathForBackIntf，selCardId=%s==========" % selCardId)

        # 当前SAS接口卡是否故障，故障则通过
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.INTF_MODULE, selCardId)
        if True == isFault:
            BaseFactory.log.info(context, "the backintf:%s is fault, replace it directly. check pass." % selCardId)
            BaseFactory.result.setResultPass(context)
            return True

        # 当前接口卡上的SAS端口是否有连接（不关心连接端口的健康状态，有连接就算），无则通过
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, selCardId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        linkedBackIntfPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, linkedBackIntfPortRecs,
                                     "the linked port info under selCard:%s" % selCardId)
        selLinkPortNum = len(linkedBackIntfPortRecs)
        if selLinkPortNum == 0:
            BaseFactory.log.info(context,
                                 "the backintf:%s has no sas port, replace it directly. check pass." % selCardId)
            BaseFactory.result.setResultPass(context)
            return True

        # 有没有冗余控制器，无则不通过
        if None == selIntfRec:
            selIntfRec = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.INTF_MODULE, selCardId)
        selCntrId = restUtil.Tlv2Rest.getRecordValue(selIntfRec,
                                                     restData.Hardware.IntfModule.PARENT_ID)  # 待更换SAS卡所在的控制器
        tmpRecs = FuncFactory.getUsableRedCntr(context, selCntrId)
        if None == tmpRecs or len(tmpRecs) == 0:
            BaseFactory.log.error(context, "the redundant cntr of selCntrId:%s is inexisted." % selCntrId)
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.CNTR_EXISTED_NONE_REDT_CNTR)
            return False
        redCntrId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.Controller.ID)
        BaseFactory.log.info(context, "to be replaced fruinfo: selCardId:%s, selCntrId:%s, redCntrId:%s"
                             % (selCardId, selCntrId, redCntrId))

        # 冗余控制器上有无正常运行的SAS接口卡，无则不通过
        if None == allCardRecs:
            allCardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, redCntrId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQOR,
                                                    FuncFactory.g_strBackEndIntfModelList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2, condition3)
        tmpRecs = restUtil.Tlv2Rest.filter(allCardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs, "the sas intf under redCntrId:%s" % redCntrId)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no NORMAL RUNNING sas intf existed in redCntrId:%s" % redCntrId)
            BaseFactory.result.setResultFailByKeys(context,
                                                   FuncFactory.LangKey.BACKINTF_EXISTED_NONE_NORMAL_REDT_SAS_INTF,
                                                   FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
            return False

        # 冗余控制器上SAS接口卡的正常已连接端口数量不能少于当前接口卡，否则不通过(该判断可有可无，有可缩短异常场景的判断时间)
        redCardIdList = []
        for tmpRec in tmpRecs:
            tmpCardId = restUtil.Tlv2Rest.getRecordValue(tmpRec, restData.PublicAttributes.ID)
            redCardIdList.append(tmpCardId)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, redCardIdList)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs, "the linkup sas port under redCntrId:%s" % redCntrId)
        redLinkPortNum = len(tmpRecs)
        BaseFactory.log.info(context, "the linkup port num of curintf and redintf is: %d, %d" % (
        selLinkPortNum, redLinkPortNum))
        if redLinkPortNum < selLinkPortNum:
            BaseFactory.log.info(context,
                                 "the linkup port num of redintf is less than the curintf to be repleace, check fail.")
            BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                   FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
            return False

        # 检查待换接口卡所连的级联框上的冗余路径是否正常（正确性检查，SAS交叉组网或连接错误时有风险）
        allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        for portRec in linkedBackIntfPortRecs:
            portId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.ID)
            # 获取端口所连级联板的ID
            peerPortId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, peerPortId)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.ObjEnum.EXPBOARD)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            if len(tmpRecs) == 0:
                BaseFactory.log.error(context,
                                      "unexpected: the peer expboard port of linked backintf portid:%s is inexisted."
                                      % portId)
                continue
            expboardId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)
            # 检查冗余级联板所在的半边SAS环路是否正常，若不存在，见检查不通过
            if False == Loop.checkSasPathRedandentForExpboard(context, expboardId, allBoardRecs, allPortRecs):
                BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                       FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
                return False

        # 显示界面，让用户冗余控制器端的SAS线缆是否连接正确，确认正确则进入下一步
        BaseFactory.log.info(context, "the redundant sas path of selCardId:%s is existed. check pass." % selCardId)
        BaseFactory.result.setResultPass(context)
        return True

    '''
    Function：检查指定FRU所在控制器是否存在冗余SAS路径
    params:
        context=工具上下文
        fruType, fruId=FRU信息
        Notes: FRU必须为控制器或控制器下的子FRU
    Return: 指定FRU所在控制器是否存在冗余SAS路径：True / False(报错信息已设置)
    '''

    @staticmethod
    def checkSasPathRedundantForFruOwnedCntr(context, fruType, fruId):

        BaseFactory.log.info(context, "enter checkSasPathRedundantForFruOwnedCntr. fruType=%s, fruId=%s."
                             % (restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrObjEnum, fruType), fruId))

        # 获取FRU所在控制器的信息
        curCntrRec = FuncFactory.getFruParentRecord(context, fruType, fruId, restData.Enum.ObjEnum.CONTROLLER)
        curCntrId = restUtil.Tlv2Rest.getRecordValue(curCntrRec, restData.PublicAttributes.ID)
        curCntrLoc = restUtil.Tlv2Rest.getRecordValue(curCntrRec, restData.PublicAttributes.LOCATION)

        # 判断冗余控制器是否存在，不存在则不通过
        redCntrId = Loop.getRedundantCntrId(context, curCntrId)
        if redCntrId == None:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.EXPBOARD_EXISTED_NONE_REDT_SAS_PATH)
            return False

        # 如果当前控制器故障，则检查通过（先检查冗余控制器，再检查当前控制器故障，避免单控故障场景）
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.CONTROLLER, curCntrId)
        if True == isFault:
            BaseFactory.log.info(context,
                                 "the fru owned cntr:%s is fault, replace it directly. check pass." % curCntrId)
            BaseFactory.result.setResultPass(context)
            return True

        # 分别考虑机框为盘控一体和独立机头两种情况，来处理SAS冗余路径是否存在
        proModel = FuncFactory.getSystemProductModel(context)
        BaseFactory.log.info(context, "the product model is %s."
                             % restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrProductModeEnum, proModel))
        # 盘控一体时，由于SAS口在控制器上，且空闲槽位不能插SAS卡，故只需要求控制器上的SAS端口有冗余路径即可。
        if proModel in FuncFactory.g_diskCntrBundleEncProductModels:
            # 接口卡上SAS端口：获取FRU所在控制器下的所有SAS接口卡信息（一个控制器下可有多个SAS接口卡）
            allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, curCntrId)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                        restData.Enum.ConditionTypeEnum.EQOR,
                                                        FuncFactory.g_strBackEndIntfModelList)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
            cntrIntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, cntrIntfRecs, "all sas intf under parent cntr:%s" % curCntrLoc)
            # 如果FRU所在控制器无SAS接口卡，则通过
            if cntrIntfRecs != None and len(cntrIntfRecs) != 0:
                # 遍历判断所有SAS接口卡是否均存在冗余SAS路径，若任一接口卡不存在冗余，则检查不通过
                allSasPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
                for intfRec in cntrIntfRecs:
                    intfId = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.PublicAttributes.ID)
                    intfLoc = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.PublicAttributes.LOCATION)
                    BaseFactory.log.info(context,
                                         "The sas intf : %s on control is existed, location : %s." % (intfId, intfLoc))
                    # 判断当前SAS接口卡的SAS路径是否存在，不存在时错误已设置
                    if False == Loop.checkSasRedundantPathForBackIntf(context, intfId,
                                                                      intfRec, allIntfRecs, allSasPortRecs):
                        BaseFactory.log.error(context,
                                              "the redundant sas path of sas intf:%s is inexisted, check fail." % intfLoc)
                        return False
                    else:
                        BaseFactory.log.info(context,
                                             "the redundant sas path of sas intf:%s is existed, continue." % intfLoc)

            # 板载SAS端口：如果控制器下无已连接的SAS端口，则检查通过
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, curCntrId)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
            cntrPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, cntrPortRecs, "all linkup sas port on parent cntr:%s" % curCntrLoc)
            if len(cntrPortRecs) == 0:
                BaseFactory.log.info(context, "the parent cntr:%s has no linkup sas port, check pass." % curCntrLoc)
                BaseFactory.result.setResultPass(context)
                return True

            # 遍历判断所有已连接SAS端口是否均存在冗余SAS路径，若任一端口不存在冗余，则检查不通过
            allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
            for portRec in cntrPortRecs:
                # 获取所连级联板ID
                portLoc = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.ID)
                expEncPortId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
                condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                            restData.Enum.ConditionTypeEnum.EQ, expEncPortId)
                conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
                tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
                expEncPortRec = tmpRecs[0]
                expBoardId = restUtil.Tlv2Rest.getRecordValue(expEncPortRec, restData.Hardware.SasPort.PARENT_ID)
                # 判断该级联板所在环路是否存在冗余路径
                if False == Loop.checkSasPathRedandentForExpboard(context, expBoardId,
                                                                  allBoardRecs, allPortRecs):
                    BaseFactory.log.error(context,
                                          "the redundant sas path of sas port:%s is inexisted, check fail." % portLoc)
                    BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.BACKINTF_REDT_PATH_CHECK_FAIL,
                                                           FuncFactory.LangKey.PUBSUG_ASSURE_REDT_CNTR_SAS_PORT_NORMAL)
                    return False
                else:
                    BaseFactory.log.info(context,
                                         "the redundant sas path of sas port:%s is existed, continue." % portLoc)
            pass

        # 独立机头时，要求控制器下所有SAS接口卡的冗余路径均存在；
        elif proModel in FuncFactory.g_noDiskCntrEncProductModels:
            # 获取FRU所在控制器下的所有SAS接口卡信息（一个控制器下可有多个SAS接口卡）
            allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, curCntrId)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                        restData.Enum.ConditionTypeEnum.EQOR,
                                                        FuncFactory.g_strBackEndIntfModelList)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
            cntrIntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, cntrIntfRecs, "all sas intf under parent cntr:%s" % curCntrLoc)
            # 如果FRU所在控制器无SAS接口卡，则通过
            if len(cntrIntfRecs) == 0:
                BaseFactory.result.setResultPass(context)
                return True

            # 遍历判断所有SAS接口卡是否均存在冗余SAS路径，若任一接口卡不存在冗余，则检查不通过
            allSasPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
            for intfRec in cntrIntfRecs:
                intfId = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.PublicAttributes.ID)
                intfLoc = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.PublicAttributes.LOCATION)
                # 判断当前SAS接口卡的SAS路径是否存在，不存在时错误已设置
                if False == Loop.checkSasRedundantPathForBackIntf(context, intfId,
                                                                  intfRec, allIntfRecs, allSasPortRecs):
                    BaseFactory.log.error(context,
                                          "the redundant sas path of sas intf:%s is inexisted, check fail." % intfLoc)
                    return False
                else:
                    BaseFactory.log.info(context,
                                         "the redundant sas path of sas intf:%s is existed, continue." % intfLoc)

        # 无法识别的产品型号
        else:
            BaseFactory.log.error(context, "unexpected error: unsupported product model:%s" % proModel)
            BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.PUBERR_UNEXPECTED_TOOL_ERROR,
                                                   FuncFactory.LangKey.PUBSUG_CONTACT_TECH_SPT_ENGINEER_FOR_HELP)
            return False

        # 检查通过
        BaseFactory.log.info(context,
                             "the redundant sas path of all sas intf under cntr:%s is existed, check pass." % curCntrLoc)
        BaseFactory.result.setResultPass(context)
        return True

    # Function: 获取系统中所有SAS环路的编号列表
    @staticmethod
    def getAllSasLoopIdList(context):
        # 获取所有的硬盘框信息
        tmpRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.EnclosureTypeEnum.EXP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        allExpEncRecs = restUtil.Tlv2Rest.filter(tmpRecs, conditionList)

        # 解析硬盘框location，获取所有SAS环路列表(列表号为数字部分的第二位)
        # 如：3号环路：DAE030，DAE031，...，DAE03F，
        loopIdList = []
        for encRec in allExpEncRecs:
            location = restUtil.Tlv2Rest.getRecordValue(encRec, restData.Hardware.Enclosure.LOCATION)
            loopId = location[-2]
            loopIdList.append(loopId)

        return loopIdList

    # Function: 获取指定接口卡连接的SAS环路的编号列表
    @staticmethod
    def getIntfLinkedSasLoopIdList(context, intfId, allSasPortRecs=None):

        if None == allSasPortRecs:
            allSasPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)

        # 获取接口卡下的所有已连接端口
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, intfId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        intfPortRecs = restUtil.Tlv2Rest.filter(allSasPortRecs, conditionList)
        # 获取端口连接的SAS环路ID
        loopIdList = []
        for portRec in intfPortRecs:
            peerPortId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
            peerEncRec = FuncFactory.getFruParentEncRec(context, restData.Enum.ObjEnum.SAS_PORT, peerPortId)
            encLoc = restUtil.Tlv2Rest.getRecordValue(peerEncRec, restData.Hardware.Enclosure.LOCATION)
            loopId = encLoc[-2]
            if loopId not in loopIdList:
                loopIdList.append(loopId)

        # 返回结果
        return loopIdList

    # Function: 获取指定控制器连接的SAS环路的编号列表
    @staticmethod
    def getCntrLinkedSasLoopIdList(context, cntrId):

        # 获取当前控制器上的SAS接口卡
        allCardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, cntrId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQOR,
                                                    FuncFactory.g_strBackEndIntfModelList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        cntrIntfRecs = restUtil.Tlv2Rest.filter(allCardRecs, conditionList)

        # 获取接口卡所连接的sAS环路ID列表
        # 原理：后端SAS接口卡上的已连接端口的对端端口ID可查到，通过其反查所在硬盘框的SAS环路ID
        loopIdList = []
        allSasPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        for intfRec in cntrIntfRecs:
            intfId = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.Hardware.SasPort.ID)
            intfLoopIdList = Loop.getIntfLinkedSasLoopIdList(context, intfId, allSasPortRecs)
            for loopId in intfLoopIdList:
                if loopId not in loopIdList:
                    loopIdList.append(loopId)
                else:
                    pass

        # 返回结果
        return loopIdList

    '''
    Function：检查指定控制器上的SAS路径是否完整
    params:
        context=工具上下文
        cntrId=待检查冗余路径的控制器ID
    Return: cntrId上的SAS路径是否完整：True / False
    '''

    @staticmethod
    def checkSasPathIntegerityForCntr(context, cntrId):

        BaseFactory.log.info(context, "enter checkSasPathIntegerityForCntr. cntrId=" + cntrId)

        # 获取所有级联环路ID列表 和当前控制器连接到的级联环路列表
        allSasLoopIdList = Loop.getAllSasLoopIdList(context)
        cntrSasLoopIdList = Loop.getCntrLinkedSasLoopIdList(context, cntrId)

        # 判断是否所有级联环路均控制器均有连接，否则报错
        BaseFactory.log.info(context, "allSasLoopIdList=%s, cntrSasLoopIdList=%s"
                             % (str(allSasLoopIdList), str(cntrSasLoopIdList)))
        for loopId in allSasLoopIdList:
            if loopId not in cntrSasLoopIdList:
                BaseFactory.log.error(context, "not all sas loop connected to cntr:%d" % cntrId)
                return False

        # 返回成功
        return True

    @staticmethod
    def getSasPortOnCntrl(context, ctrlId):
        '''
        @describe:获取控制器上的SAS端口，包括接口卡上和板载的SAS端口
        @param context:上下文
        @param ctrlId:控制器ID
        '''
        sasPortsList = []
        allSasPorts = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        # 获取控制器下接口卡
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, ctrlId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQOR,
                                                    FuncFactory.g_strBackEndIntfModelList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        cntrIntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
        if len(cntrIntfRecs) != 0:
            for intfRec in cntrIntfRecs:
                intfId = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.PublicAttributes.ID)
                condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                            restData.Enum.ConditionTypeEnum.EQ,
                                                            intfId)
                condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                            restData.Enum.ConditionTypeEnum.EQ,
                                                            restData.Enum.RunningStatusEnum.LINK_UP)
                conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
                sasPortsOnIntf = restUtil.Tlv2Rest.filter(allSasPorts, conditionList)
                if None != sasPortsOnIntf and len(sasPortsOnIntf) != 0:
                    for sasPort in sasPortsOnIntf:
                        sasPortLoction = restUtil.Tlv2Rest.getRecordValue(sasPort, restData.PublicAttributes.LOCATION)
                        sasPortsList.append(sasPortLoction)

        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    ctrlId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        sasPortsOnCtrl = restUtil.Tlv2Rest.filter(allSasPorts, conditionList)
        if None != sasPortsOnCtrl and len(sasPortsOnCtrl) != 0:
            for sasPort in sasPortsOnCtrl:
                sasPortLoction = restUtil.Tlv2Rest.getRecordValue(sasPort, restData.PublicAttributes.LOCATION)
                sasPortsList.append(sasPortLoction)
        return sasPortsList

    '''
    Function: 备份所在控制器上已连接的SAS端口数量
    '''
    BACKUP_LINKED_SAS_PORT_LIST = "backupLinkedSasPortList"

    @staticmethod
    def backupLinkedSasPortList(context, cntrId):
        proModel = FuncFactory.getSystemProductType(context)
        sasPortsList = []
        # 针对盘控一体的设备，备份已连接的SAS端口数量
        if proModel in [BaseFactory.const.SYSMODEL["S5500T"], BaseFactory.const.SYSMODEL["S2600T"],
                        BaseFactory.const.SYSMODEL["5X00V3"]]:
            sasPortsList = Loop.getSasPortOnCntrl(context, cntrId)
        BaseFactory.log.info(context, "The backing up sas Ports List is : %s" % str(sasPortsList))
        BaseFactory.persist.setModule(context, Loop.BACKUP_LINKED_SAS_PORT_LIST, sasPortsList)
        return

    '''
    Function: 获取备份在上下文中的已连接SAS端口数量
    Return: 返回备份在上下文中的已连接SAS端口数量
    '''

    @staticmethod
    def getBackupLinkedSasPortList(context):
        return BaseFactory.persist.getModule(context, Loop.BACKUP_LINKED_SAS_PORT_LIST)

    BACKUP_LINKED_FRONT_PORT_NUM = "backupLinkedFrontPortNum"

    @staticmethod
    def backupLinkedFrontPortNum(context, cntrId):
        LinkedFrontPortNum = 0

        allEthPortsRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        # 控制器上板载前端口例如 H.P0
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    cntrId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.PortLogicTypeEnum.HOST)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        hostPortOnCtrl = restUtil.Tlv2Rest.filter(allEthPortsRecs, conditionList)
        BaseFactory.log.info(context, "all host eth ports on ctrl: %s" % str(hostPortOnCtrl))
        if len(hostPortOnCtrl) > 0:
            LinkedFrontPortNum += len(hostPortOnCtrl)

        # 控制器上接口卡上的前端口
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    cntrId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        IntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)

        frontIntfId = []
        for intf in IntfRecs:
            model = restUtil.Tlv2Rest.getRecordValue(intf, restData.Hardware.IntfModule.MODEL)
            if model in FuncFactory.g_frontEndIntfModels:
                moduleId = restUtil.Tlv2Rest.getRecordValue(intf, restData.Hardware.IntfModule.ID)
                frontIntfId.append(moduleId)

        BaseFactory.log.info(context, "all front intfs id list: %s" % str(frontIntfId))

        frontPortType = [restData.Enum.ObjEnum.ETH_PORT, restData.Enum.ObjEnum.FC_PORT]
        for portType in frontPortType:

            allPortsRecs = FuncFactory.getFruListInfo(context, portType)
            condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQOR,
                                                        frontIntfId)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOGIC_TYPE,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.PortLogicTypeEnum.HOST)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
            portRecs = restUtil.Tlv2Rest.filter(allPortsRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, portRecs, "type=%s linked front ports are:" % portType)

            if len(portRecs) > 0:
                LinkedFrontPortNum += len(portRecs)

        BaseFactory.log.info(context, "there are %s linked front ports" % str(LinkedFrontPortNum))

        BaseFactory.persist.setModule(context, Loop.BACKUP_LINKED_FRONT_PORT_NUM, LinkedFrontPortNum)
        return

    @staticmethod
    def getBackupLinkedFrontPortNum(context):
        LinkedFrontPortNum = BaseFactory.persist.getModule(context, Loop.BACKUP_LINKED_FRONT_PORT_NUM)
        if None == LinkedFrontPortNum:
            LinkedFrontPortNum = 0

        return LinkedFrontPortNum

    ______SAS_BAK______ = 0
    '''
    Function: 获取SAS环路检测所需的端口信息
    Return: SAS端口信息元组：(所有的SAS端口记录, 所有引擎A控的已连接SAS端口记录, 所有引擎B控的已连接SAS端口记录)
    '''

    @staticmethod
    def getSasPortInfo(context):
        # 获取所有的SAS端口信息
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        restUtil.Tlv2Rest.logRecList(context, allPortRecs)  # for test
        # 获取所有引擎中Ａ控上的已连接SAS端口信息
        aCond1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                restData.Enum.ConditionTypeEnum.EQ,
                                                restData.Enum.ObjEnum.INTF_MODULE)
        aCond2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                restData.Enum.ConditionTypeEnum.LIKE, "A")
        aCond3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                restData.Enum.ConditionTypeEnum.EQ,
                                                restData.Enum.RunningStatusEnum.LINK_UP)
        aCondlist = restUtil.Tlv2Rest.getConditionList(aCond1, aCond2, aCond3)
        aRecs = restUtil.Tlv2Rest.filter(allPortRecs, aCondlist)
        restUtil.Tlv2Rest.logRecList(context, aRecs)  # for test
        # 获取所有引擎中B控上的已连接SAS端口信息
        bCond1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                restData.Enum.ConditionTypeEnum.EQ,
                                                restData.Enum.ObjEnum.INTF_MODULE)
        bCond2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                restData.Enum.ConditionTypeEnum.LIKE, "B")
        bCond3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                restData.Enum.ConditionTypeEnum.EQ,
                                                restData.Enum.RunningStatusEnum.LINK_UP)
        bCondlist = restUtil.Tlv2Rest.getConditionList(bCond1, bCond2, bCond3)
        bRecs = restUtil.Tlv2Rest.filter(allPortRecs, bCondlist)
        restUtil.Tlv2Rest.logRecList(context, bRecs)  # for test
        # 返回结果
        return (allPortRecs, aRecs, bRecs)

    '''
    Function: 指定一个引擎上的SAS端口，获取其整个环路上的端口连接关系
    Realation: 沿指定的引擎端口，不断向下搜索与其相连的硬盘框，并获取所有沿途硬盘框两个级联板上所有端口的连接关系
    Params: 
        context = 工具上下文
        enginSasPortId = 与引擎相连的SAS端口ID
        allPortRecs = 所有的SAS端口记录
    Return: SAS端口连接关系列表(localRelList, peerRelList)。其中，
        localRelList为与enginSasPortId相连的级联板侧的连接关系。列表中的元素先后顺序与硬盘框级联顺序相同；
        peerRelList为对端级联板侧的连接关系。其与localRelList中相同下表的元素属于同一个硬盘框。
    '''

    @staticmethod
    def getSasConnRelation(context, enginSasPortId, allPortRecs):
        # 初始化硬盘框上SAS端口连接关系列表，localRelList和peerRelList上相同下标的元素位于同一个硬盘框下
        localRelList = []  # 所有硬盘框上本端控制器上SAS端口连接关系列表，元素顺序代表了硬盘框的连接顺序
        peerRelList = []  # 所有硬盘框上对端控制器上SAS端口连接关系列表，元素顺序代表了硬盘框的连接顺序

        lastExpPortId = enginSasPortId
        while lastExpPortId != BaseFactory.const.INVALID_SAS_PORTID:  # 此循环条件不可能为假，搜索结束条件在下面
            ##初始化当前硬盘框上的双控的SAS端口连接关系。pri=PRI端口的本端和对端SAS端口ID；exp代表EXP端口的本端和对端SAS端口ID
            localRelItem = {"card": "", "pri_local": "", "pri_peer": "", "exp_local": "", "exp_peer": ""}
            peerRelItem = {"card": "", "pri_local": "", "pri_peer": "", "exp_local": "", "exp_peer": ""}

            # 获取与lastExpPortId端口连接的硬盘框PRI端口信息
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, lastExpPortId)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            localPriPortId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                              restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
            BaseFactory.log.info(context, "localPriPortId=" + str(localPriPortId))
            if BaseFactory.const.INVALID_SAS_PORTID == localPriPortId:
                # 搜索结束条件：无端口与lastExpPortId端口相连，即不存在后续硬盘框，则停止关系查询
                BaseFactory.log.info(context,
                                     "no sas port connect to the sas port " + lastExpPortId + ", search stopped.")
                break

            # 获取当前硬盘框上【本端】级联板SAS端口连接关系
            # 获取与lastExpPortId相连的当前硬盘框的本端PRI端口ID（注意：对端PRI端口不能反查得到本端端口）
            localRelItem["pri_local"] = localPriPortId
            localRelItem["pri_peer"] = lastExpPortId
            # 获取当前硬盘框的本端PRI端口信息
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, localPriPortId)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            parentId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)
            localRelItem["card"] = parentId
            # 获取与PRI端口同级联板的另一EXP端口信息(此处假定一个级联板上有且仅有两个SAS端口)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, parentId)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.NAME,
                                                        restData.Enum.ConditionTypeEnum.EQ, "EXP")
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            if len(tmpRecs) == 0:  # 错误检测，一个级联板上至少有两个端口
                BaseFactory.log.error(context, "the another sas port of localcard " + parentId
                                      + "'s port " + localPriPortId + " is not existed, search failed.")
                return False
            localExpPortId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.ID)
            localExpPeerPortId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                                  restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
            localRelItem["exp_local"] = localExpPortId
            localRelItem["exp_peer"] = localExpPeerPortId

            # 获取用户硬盘框框号和本端接口板号
            localLocation = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                             restData.Hardware.SasPort.LOCATION)  # e.g. DAE000.A.EXP
            tmpInfos = localLocation.split(".")  # 0=DAE000, 1=A, 2=EXP
            userSubrackId = tmpInfos[0]  # DAE000
            localCardId = localLocation.rstrip(tmpInfos[2])  # DAE000.A.

            # 获取当前硬盘框上【对端】级联板SAS端口连接关系
            # 获取对端SAS级联口信息
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.LOCATION,
                                                        restData.Enum.ConditionTypeEnum.LIKE, userSubrackId)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.LOCATION,
                                                        restData.Enum.ConditionTypeEnum.NLIKE, localCardId)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
            cardPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            if len(cardPortRecs) < 2:
                # 如果对端SAS级联口数量异常（无级联板，或端口损坏，或误检），则检查不通过
                BaseFactory.log.error(context, "the peer sas port number of localcard(" + localCardId
                                      + ") is less than 2, peer sas card is abnormal, search failed.")
                return False
            # 整理对端SAS端口的连接信息
            recNum = len(cardPortRecs)
            for index in range(0, recNum):
                rec = cardPortRecs[index]
                peerPortId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.ID)
                name = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.NAME)
                if "PRI" == name:
                    # 该口为PRI口，其对端端口无法直接获取，需通过筛选获得与其相连的端口。
                    peerRelItem["pri_local"] = peerPortId
                    condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.CURRENT_PEER_PORT_ID,
                                                                restData.Enum.ConditionTypeEnum.EQ, peerPortId)
                    conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
                    tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
                    if len(tmpRecs) == 0:
                        peerRelItem["pri_peer"] = BaseFactory.const.INVALID_SAS_PORTID
                    else:
                        peerRelItem["pri_peer"] = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                                                   restData.Hardware.SasPort.ID)
                elif "EXP" == name:
                    # 该口为EXP口，可直接获取
                    peerRelItem["exp_local"] = peerPortId
                    peerRelItem["exp_peer"] = restUtil.Tlv2Rest.getRecordValue(rec,
                                                                               restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
                    peerRelItem["card"] = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.PARENT_ID)
                else:
                    peerLocation = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.LOCATION)
                    BaseFactory.log.error(context, "the location of peer sas port is " + peerLocation
                                          + ", name is " + name + ", not expected, search failed.")
                    return False

            # 保存当前硬盘框的端口连接关系，并设置循环条件，继续检测下一硬盘框的连接关系
            localRelList.append(localRelItem)
            peerRelList.append(peerRelItem)
            lastExpPortId = localRelItem["exp_local"]

        # 正常搜索完毕，返回从enginSasPortId端口开始的硬盘框环路连接关系
        BaseFactory.log.info(context,
                             "localRelList=" + str(localRelList) + ", peerRelList=" + str(peerRelList))  # for test
        return (localRelList, peerRelList)

    '''
    Function: 是否为SAS环路连接方式——全正接 
    LF=Left Forward,左边正接，RF=Right Forward,右边正接
    Params:
        leftConnRel = 级联框环路中的左侧连接关系
        rightConnRel = 级联框环路中的右侧连接关系
        allPortRecs = 所有的SAS端口记录
    Return: SAS环路连接方式是否为【全正接】
    '''

    @staticmethod
    def isSasLoopRel_LF_RF(context, leftConnRel, rightConnRel, allPortRecs):
        # 入口参数校验
        if len(leftConnRel) != len(rightConnRel):
            BaseFactory.log.error(context,
                                  "the expand card number is not equal in left and right conn rel, check failed.")
            return False
        if len(leftConnRel) == 0:
            BaseFactory.log.error(context, "the loop has no expand board, check failed.")
            return False

        # 判断左右两边的引擎SAS端口是否分别位于两个控制器上
        leftEngPortId = leftConnRel[0]["pri_peer"]
        rightEngPortId = rightConnRel[0]["pri_peer"]
        leftCard = leftConnRel[0]["card"]
        rightCard = rightConnRel[0]["card"]
        orValList = restUtil.Tlv2Rest.getMultiConditionValueList(leftEngPortId, rightEngPortId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, orValList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.ObjEnum.INTF_MODULE)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        if len(tmpRecs) != 2:
            BaseFactory.log.info(context, "the first sas port " + leftEngPortId + " in card " + leftCard
                                 + " or port " + rightEngPortId + " in card " + rightCard
                                 + " is not engine port, check failed.")
            return False
        else:
            parentId0 = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)  # 0A.0
            parentId0 = parentId0.split(".")[0]  # 0A
            parentId1 = restUtil.Tlv2Rest.getRecordValue(tmpRecs[1], restData.Hardware.SasPort.PARENT_ID)  # 0B.0
            parentId1 = parentId1.split(".")[0]  # 0B
            if parentId0 == parentId1:
                BaseFactory.log.info(context, "the first sas port " + leftEngPortId + " in card " + leftCard
                                     + " or port " + rightEngPortId + " in card " + rightCard
                                     + " existed in same controller " + parentId0 + ", check failed.")
                return False

        # 最后一个硬盘框的级联关系检查
        subrackNum = len(leftConnRel)
        lastLeftRel = leftConnRel[subrackNum - 1]
        lastRightRel = rightConnRel[subrackNum - 1]
        if lastLeftRel["exp_peer"] != BaseFactory.const.INVALID_SAS_PORTID \
                or lastRightRel["exp_peer"] != BaseFactory.const.INVALID_SAS_PORTID:
            BaseFactory.log.info(context, "the last sas port " + lastLeftRel["exp_local"]
                                 + " in card " + lastLeftRel["card"] + " of disk enclosure " + str(subrackNum - 1)
                                 + " OR the last sas port " + lastRightRel["pri_local"]
                                 + " in card " + lastRightRel["card"] + " of disk enclosure " + str(subrackNum - 1)
                                 + " connected to other port. check failed.")
            return False

        # 判断两边的硬盘框环路是否均为正接
        for index in range(1, subrackNum):
            # 左侧连接关系检查
            lastLeftRel = leftConnRel[index - 1]
            curLeftRel = leftConnRel[index]
            if lastLeftRel["exp_peer"] != curLeftRel["pri_local"]:
                BaseFactory.log.info(context, "the sas port " + lastLeftRel["exp_local"]
                                     + " in card " + lastLeftRel["card"] + " of disk enclosure " + str(index - 1)
                                     + " is not connect to the sas port " + curLeftRel["pri_local"]
                                     + " in card " + curLeftRel["card"] + " of disk enclosure " + str(index)
                                     + ". check failed.")
                return False
            # 右侧连接关系检查
            lastRightRel = rightConnRel[index - 1]
            curRightRel = rightConnRel[index]
            if lastRightRel["exp_peer"] != curRightRel["pri_local"]:
                BaseFactory.log.info(context, "the sas port " + lastRightRel["exp_local"]
                                     + " in card " + lastRightRel["card"] + " of disk enclosure " + str(index - 1)
                                     + " is not connect to the sas port " + curRightRel["pri_local"]
                                     + " in card " + curRightRel["card"] + " of disk enclosure " + str(index)
                                     + ". check failed.")
                return False

        # 所有的异常检查均通过，则确认组网为全正接，检查通过
        return True

    '''
    Function: 是否为SAS环路连接方式——左正右反
    LF=Left Forward,左边正接，RR=Right Reverse,右边反接
    Params:
        leftConnRel = 级联框环路中的左侧连接关系
        rightConnRel = 级联框环路中的右侧连接关系
        allPortRecs = 所有的SAS端口记录
    Return: SAS环路连接方式是否为【左边正接，右边反接】
    '''

    @staticmethod
    def isSasLoopRel_LF_RR(context, leftConnRel, rightConnRel, allPortRecs):
        # 入口参数校验
        if len(leftConnRel) != len(rightConnRel):
            BaseFactory.log.error(context,
                                  "the expand card number is not equal in left and right conn rel, check failed.")
            return False
        if len(leftConnRel) == 0:
            BaseFactory.log.error(context, "the loop has no expand board, check failed.")
            return False

        # 获取级联的硬盘框数量
        subrackNum = len(leftConnRel)

        # 判断左右两边的引擎SAS端口是否分别位于两个控制器上
        leftEngPortId = leftConnRel[0]["pri_peer"]
        rightEngPortId = rightConnRel[subrackNum - 1]["pri_peer"]
        leftCard = leftConnRel[0]["card"]
        rightCard = rightConnRel[subrackNum - 1]["card"]
        orValList = restUtil.Tlv2Rest.getMultiConditionValueList(leftEngPortId, rightEngPortId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, orValList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.ObjEnum.INTF_MODULE)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        if len(tmpRecs) != 2:
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)
            BaseFactory.log.info(context, "the first sas port " + leftEngPortId + " in card " + leftCard
                                 + " or port " + rightEngPortId + " in card " + rightCard
                                 + " is not engine port, check failed.")
            return False
        else:
            parentId0 = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)  # 0A.0
            parentId0 = parentId0.split(".")[0]  # 0A
            parentId1 = restUtil.Tlv2Rest.getRecordValue(tmpRecs[1], restData.Hardware.SasPort.PARENT_ID)  # 0B.0
            parentId1 = parentId1.split(".")[0]  # 0B
            if parentId0 == parentId1:
                BaseFactory.log.info(context, "the first sas port " + leftEngPortId + " in card " + leftCard
                                     + " or port " + rightEngPortId + " in card " + rightCard
                                     + " existed in same controller " + parentId0 + ", check failed.")
                return False

        # 两边最后一个级联口的连接关系检查（应为未连接）
        lastLeftRel = leftConnRel[subrackNum - 1]
        lastRightRel = rightConnRel[0]
        if lastLeftRel["exp_peer"] != BaseFactory.const.INVALID_SAS_PORTID \
                or lastRightRel["exp_peer"] != BaseFactory.const.INVALID_SAS_PORTID:
            BaseFactory.log.info(context, "the last sas port " + lastLeftRel["exp_local"]
                                 + " in card " + lastLeftRel["card"] + " of disk enclosure " + str(subrackNum - 1)
                                 + " OR the last sas port " + lastRightRel["pri_local"]
                                 + " in card " + lastRightRel["card"] + " of disk enclosure " + str(0)
                                 + " connected to other port. check failed.")
            return False

        # 判断硬盘框环路是否为左边正接，右边反接
        for index in range(1, subrackNum):
            # 左侧连接关系检查（正接）
            lastLeftRel = leftConnRel[index - 1]
            curLeftRel = leftConnRel[index]
            if lastLeftRel["exp_peer"] != curLeftRel["pri_local"]:
                BaseFactory.log.info(context, "the sas port " + lastLeftRel["exp_local"]
                                     + " in card " + lastLeftRel["card"] + " of disk enclosure " + str(index - 1)
                                     + " is not connect to the sas port " + curLeftRel["pri_local"]
                                     + " in card " + curLeftRel["card"] + " of disk enclosure " + str(index)
                                     + ". check failed.")
                return False

            # 右侧连接关系检查（反接）
            lastRightRel = rightConnRel[index]
            curRightRel = rightConnRel[index - 1]
            if lastRightRel["exp_peer"] != curRightRel["pri_local"]:
                BaseFactory.log.info(context, "the sas port " + lastRightRel["exp_local"]
                                     + " in card " + lastRightRel["card"] + " of disk enclosure " + str(index)
                                     + " is not connect to the sas port " + curRightRel["pri_local"]
                                     + " in card " + curRightRel["card"] + " of disk enclosure " + str(index - 1)
                                     + ". check failed.")
                return False

        # 所有的异常检查均通过，则确认组网为全正接，检查通过
        return True

    '''
    Function: 是否为SAS环路连接方式——左正右特
    LF=Left Forward,左边正接，RR=Right Forward Reverse,右边第一个框正接，后面的框反接 
    Params:
        leftConnRel = 级联框环路中的左侧连接关系
        rightConnRel = 级联框环路中的右侧连接关系
        allPortRecs = 所有的SAS端口记录
    Return: SAS环路连接方式是否为【左边正接，右边先正接再反接】
    '''

    @staticmethod
    def isSasLoopRel_LF_RFR(context, leftConnRel, rightConnRel, allPortRecs):
        # 入口参数校验
        if len(leftConnRel) != len(rightConnRel):
            BaseFactory.log.error(context,
                                  "the expand card number is not equal in left and right conn rel, check failed.")
            return False
        if len(leftConnRel) < 2:  # 如果硬盘框个数小于2，则不可能为正反接，直接返回不通过
            BaseFactory.log.error(context, "the disk enclosure number is less than 2, check failed.")
            return False

        # 获取级联的硬盘框数量
        subrackNum = len(leftConnRel)

        # 判断左右两边的引擎SAS端口是否分别位于两个控制器上
        leftEngPortId = leftConnRel[0]["pri_peer"]
        rightEngPortId = rightConnRel[0]["pri_peer"]
        leftCard = leftConnRel[0]["card"]
        rightCard = rightConnRel[0]["card"]
        orValList = restUtil.Tlv2Rest.getMultiConditionValueList(leftEngPortId, rightEngPortId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, orValList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.ObjEnum.INTF_MODULE)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        if len(tmpRecs) != 2:
            BaseFactory.log.info(context, "the first sas port " + leftEngPortId + " in card " + leftCard
                                 + " or port " + rightEngPortId + " in card " + rightCard
                                 + " is not engine port, check failed.")
            return False
        else:
            parentId0 = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)  # 0A.0
            parentId0 = parentId0.split(".")[0]  # 0A
            parentId1 = restUtil.Tlv2Rest.getRecordValue(tmpRecs[1], restData.Hardware.SasPort.PARENT_ID)  # 0B.0
            parentId1 = parentId1.split(".")[0]  # 0B
            if parentId0 == parentId1:
                BaseFactory.log.info(context, "the first sas port " + leftEngPortId + " in card " + leftCard
                                     + " or port " + rightEngPortId + " in card " + rightCard
                                     + " existed in same controller " + parentId0 + ", check failed.")
                return False

        # 两边最后一个级联口的连接关系检查（应为未连接）
        lastLeftRel = leftConnRel[subrackNum - 1]
        lastRightRel = rightConnRel[1]  # 两个或以上的硬盘框,此时第二个框开始为反接，故最后一个端口在第二个框上
        if lastLeftRel["exp_peer"] != BaseFactory.const.INVALID_SAS_PORTID \
                or lastRightRel["exp_peer"] != BaseFactory.const.INVALID_SAS_PORTID:
            BaseFactory.log.info(context, "the last sas port " + lastLeftRel["exp_local"]
                                 + " in card " + lastLeftRel["card"] + " of disk enclosure " + str(subrackNum - 1)
                                 + " OR the last sas port " + lastRightRel["pri_local"]
                                 + " in card " + lastRightRel["card"] + " of disk enclosure " + str(1)
                                 + " connected to other port. check failed.")
            return False

        # 判断硬盘框环路是否为左边正接，右边反接
        for index in range(1, subrackNum):
            # 左侧连接关系检查（正接）
            lastLeftRel = leftConnRel[index - 1]
            curLeftRel = leftConnRel[index]
            if lastLeftRel["exp_peer"] != curLeftRel["pri_local"]:
                BaseFactory.log.info(context, "the sas port " + lastLeftRel["exp_local"]
                                     + " in card " + lastLeftRel["card"] + " of disk enclosure " + str(index - 1)
                                     + " is not connect to the sas port " + curLeftRel["pri_local"]
                                     + " in card " + curLeftRel["card"] + " of disk enclosure " + str(index)
                                     + ". check failed.")
                return False

            # 右侧连接关系检查（第一个框正接，后面的框反接）
            lastRightEnclosure = 0
            curRightEnclosure = 0
            if index > 1:  # 第二个框开始为反接
                lastRightRel = rightConnRel[index]
                curRightRel = rightConnRel[index - 1]
                lastRightEnclosure = index
                curRightEnclosure = index - 1
            else:  # 第一个框为正接
                lastRightRel = rightConnRel[0]
                curRightRel = rightConnRel[subrackNum - 1]
                lastRightEnclosure = 0
                curRightEnclosure = subrackNum - 1
            if lastRightRel["exp_peer"] != curRightRel["pri_local"]:
                BaseFactory.log.info(context, "the sas port " + lastRightRel["exp_local"]
                                     + " in card " + lastRightRel["card"] + " of disk enclosure " + str(
                    lastRightEnclosure)
                                     + " is not connect to the sas port " + curRightRel["pri_local"]
                                     + " in card " + curRightRel["card"] + " of disk enclosure " + str(
                    curRightEnclosure)
                                     + ". check failed.")
                return False

        # 所有的异常检查均通过，则确认组网为全正接，检查通过
        return True

    '''
    Function：获取SAS环路的连接类型
    params:
        context=工具上下文
        enginSasPortId=需要确定完整性的环路中的【正接（该端口所在的半边环路为正接）】SAS端口ID
        allPortRecs=所有的SAS端口信息，若为None表示要求函数内部自己查询
    Return: SAS环路类型：-1=检查出错或为非标准组网；0=无级联环路； 1=全正接；2=一边正接，一边反接；3=一边正接，另一边先正接一个框，其他框全部反接
    '''

    @staticmethod
    def getSasLoopType(context, enginSasPortId, allPortRecs=None):
        # 准备信息
        if None == allPortRecs:
            portInfos = Loop.getSasPortInfo(context)
            if portInfos == None or len(portInfos) == 0:
                return -1  # -1=检查出错
            allPortRecs = portInfos[0]

        # 如果指定的端口不为引擎（控制框）上的SAS端口，则返回检查出错
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, enginSasPortId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.ObjEnum.INTF_MODULE)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        if 0 == len(tmpRecs):
            BaseFactory.log.error(context,
                                  "the sas port " + enginSasPortId + " is not existed in engine. check failed.")
            return -1  # -1=检查出错

        # 如果指定的端口未连接，则返回无环路
        curPortRec = tmpRecs[0]
        runningStatus = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.SasPort.RUNNING_STATUS)
        if runningStatus != restData.Enum.RunningStatusEnum.LINK_UP:
            BaseFactory.log.error(context, "the sas port " + enginSasPortId + " is not link up. check failed.")
            return 0  # 0=无级联环路

        # 获取与enginSasPortId直接相连的级联端口信息
        firstPriPortId = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, firstPriPortId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        # 如果该端口不为级联端口，则返回检查出错
        curPortRec = tmpRecs[0]
        parentType = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.SasPort.PARENT_TYPE)
        if parentType != restData.Enum.ObjEnum.EXPBOARD:
            BaseFactory.log.error(context,
                                  "the peer port of sas port " + enginSasPortId + " is not EXPBOARD port. check failed.")
            return -1  # -1=检查出错

        # 构造从指定SAS端口（已连接）开始的硬盘框SAS环路连接顺序和方式
        connRel = Loop.getSasConnRelation(context, enginSasPortId, allPortRecs)

        # 判断SAS环路连接顺序是否为可使用的三种环路连接方式之一，若是则检查通过
        if len(connRel[0]) != len(connRel[1]):
            # 若硬盘框两边级联板的连接节点数不一致，则说明为非标准组网
            return -1
        elif len(connRel[0]) == 0 and len(connRel[1]) == 0:
            # 若未连接任何硬盘框，则说明无环路
            return 0
        elif True == Loop.isSasLoopRel_LF_RF(context, connRel[0], connRel[1], allPortRecs):
            # 若为全正接，则检查通过
            return 1
        elif True == Loop.isSasLoopRel_LF_RR(context, connRel[0], connRel[1], allPortRecs) \
                or True == Loop.isSasLoopRel_LF_RR(context, connRel[1], connRel[0], allPortRecs):
            # 若为一边正接；另一边反接，则检查通过
            return 2
        elif True == Loop.isSasLoopRel_LF_RFR(context, connRel[0], connRel[1], allPortRecs) \
                or True == Loop.isSasLoopRel_LF_RFR(context, connRel[1], connRel[0], allPortRecs):
            # 若为一边正接；另一边先正接一个框，随后全部反接，则检查通过
            return 3
        else:
            # 到此时，环路连接不为已知的三种方式，则说明为非标准组网
            return -1

    '''
    Function：检查系统中所有SAS环路的完整性
    params:
        context=工具上下文
    Return: 所有SAS环路是否完整。False=不完整；True=完整(系统中的所有SAS环路均正常连接)
    WARNING: 1403081432: 由于仅引擎上的SAS口中保存了与其相连的其他端口信息，级联板上的SAS端口的对端端口暂未赋值，故而，此处的检测方法暂无效。
                后续工作：增加端口的对端连接端口信息，后续推动其何如该功能，增加后，下面的检测方法将生效。
    '''

    @staticmethod
    def checkAllSasLoopIntegrity_UNUSE(context):
        BaseFactory.log.info(context, "enter checkAllSasLoopIntegrity.")
        # 获取检查所需的SAS端口信息
        portInfos = Loop.getSasPortInfo(context)
        allPortRecs = portInfos[0]
        aRecs = portInfos[1]
        bRecs = portInfos[2]

        # 如果AB控上的已连接端口数量不等（结构不对称），则直接检查不通过
        if len(aRecs) != len(bRecs):
            BaseFactory.log.error(context, "The LINK_UP sas port in double controller is not equal, check failed.")
            return False

        # 如果双控上无已连接端口，则检查通过
        if len(aRecs) == 0:  # 此时AB控的已连接端口数量相等
            BaseFactory.log.error(context, "The system has no LINK_UP sas port, check passed.")
            return True

        # 遍历所有SAS环路，确认环路是否完整，如有不完整则返回检查不通过
        loopNum = len(aRecs)
        metLF_RFR = False
        for index in range(0, loopNum):
            rec = aRecs[index]
            portId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.ID)
            loopType = Loop.getSasLoopType(context, portId, allPortRecs)
            location = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.LOCATION)
            if loopType < 0:
                BaseFactory.log.error(context,
                                      "The loop of engine sas port " + location + " is not integrity. check failed.")
                return False
            elif loopType == 3:  # 若环路类型为一边正接，另一边先正接再反接，则进行检测，保证最多仅存在一个该类环路
                if metLF_RFR == False:
                    BaseFactory.log.info(context, "The loop type of engine sas port " + location + " is LF_RFR.")
                    metLF_RFR = True
                else:
                    BaseFactory.log.error(context,
                                          "The loop type of engine sas port " + location + " is LF_RFR too, check failed.")
                    return False
            else:
                BaseFactory.log.info(context, "The loop type of engine sas port " + location + " is " + str(loopType))

        # 到这里，所有环路均完整，返回检查通过
        BaseFactory.log.error(context, "All loop of " + str(loopNum) + "th engine sas port is integrity. check passed.")
        return True

    '''
    Function：检查系统中所有SAS环路的完整性_临时方法，待checkAllSasLoopIntegrity有效后就更换
    params:
        context=工具上下文
    Return: 所有SAS环路是否完整。False=不完整；True=完整(系统中的所有SAS环路均正常连接)
    Algrithm: 算法原理：通过未连接端口数进行判断 （需结合组网图进行理解）
        1、先通过引擎上的连接端口数来计算出SAS环路的个数N；
        2、获取所有级联板上的未连接端口数量X和类型；
        3、标准：
            1）、引擎双控上的已连接端口数必须一致；
            2）、每个环路中有且仅有两个EXP端口未连接；故未连接的端口类型全部是EXP端口，且X=2N时，检查通过，否则不通过
            3）、每个环路中的第一个硬盘框的两个级联板不能同时连接到同一个控制器；
    ATTENTION: 若不同环路间混连时端口连接状态仍正常，或组网为非标准组网（如全正接），检查仍将通过，存在漏报可能
    '''

    @staticmethod
    def checkAllSasLoopIntegrity_TEMP_UNUSE(context):
        BaseFactory.log.info(context, "enter checkAllSasLoopIntegrity_TEMP_UNUSE.")
        # 获取检查所需的SAS端口信息
        portInfos = Loop.getSasPortInfo(context)
        allPortRecs = portInfos[0]
        aRecs = portInfos[1]
        bRecs = portInfos[2]

        # 1、如果AB控上的已连接端口数量不等（结构不对称），则直接检查不通过
        if len(aRecs) != len(bRecs):
            BaseFactory.log.error(context, "The LINK_UP sas port in double controller is not equal, check failed.")
            return False
        # 如果双控上无已连接端口，则检查通过
        if len(aRecs) == 0:  # 此时AB控的已连接端口数量相等
            BaseFactory.log.error(context, "The system has no LINK_UP sas port, check passed.")
            return True

        # 2、获取SAS环路数量、未连接EXP口数量、未连接PRI口数量
        loopNum = len(aRecs)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_DOWN)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.NAME,
                                                    restData.Enum.ConditionTypeEnum.EQ, "EXP")
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        downExpPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        downExpPortNum = len(downExpPortRecs)
        restUtil.Tlv2Rest.logRecList(context, downExpPortRecs)  # for test

        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.NAME,
                                                    restData.Enum.ConditionTypeEnum.EQ, "PRI")
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition3)
        downPriPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        downPriPortNum = len(downPriPortRecs)
        restUtil.Tlv2Rest.logRecList(context, downPriPortRecs)  # for test

        # 每个环路中有且仅有两个EXP端口未连接；故未连接的端口类型全部是EXP端口，且X=2N时，检查通过，否则不通过
        BaseFactory.log.info(context, "loopNum=" + str(loopNum) + ", downExpPortNum=" + str(downExpPortNum)
                             + ", downPriPortNum=" + str(downPriPortNum))
        if downPriPortNum != 0 \
                or loopNum * 2 != downExpPortNum:
            BaseFactory.log.error(context, "loopNum*2 != downExpPortNum, or downPriPortNum != 0. check failed.")
            return False

        # 3、每个环路中的第一个硬板框的两个级联板不能同时连接到同一个控制器
        for index in range(0, loopNum):
            rec = aRecs[index]
            # 获取当前端口所在的控制器
            localPortCntr = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.PARENT_ID)  # 0B.0
            localPortCntr = localPortCntr.split(".")[0]  # 0B
            # 获取与其相连的第一个级联框PRI端口信息
            alocation = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.LOCATION)
            peerPriPortId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, peerPriPortId)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            if len(tmpRecs) == 0:
                BaseFactory.log.error(context, "unexpected error: the peer sas port info of engine port "
                                      + alocation + " is not existed, check failed.")
                return False
            # 获取PRI端口所在级联板的冗余级联板上的PRI端口信息
            location = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.LOCATION)  # DAE000.B.PRI
            parentId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)  # 1.1
            subrackName = location.split(".")[0]  # DAE000
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.LOCATION,
                                                        restData.Enum.ConditionTypeEnum.LIKE, subrackName)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                        restData.Enum.ConditionTypeEnum.NE, parentId)
            condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.NAME,
                                                        restData.Enum.ConditionTypeEnum.EQ, "PRI")
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            if len(tmpRecs) == 0:
                BaseFactory.log.error(context, "the PRI sas port of redandent card of sas port "
                                      + location + " is not existed, check failed.")
                return False
            # 获取与冗余PRI端口连接的控制器SAS端口信息
            redPriPordId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                            restData.Hardware.SasPort.ID)  # 2164285440 in DAE000.A.PRI
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.CURRENT_PEER_PORT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, redPriPordId)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_TYPE,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.ObjEnum.INTF_MODULE)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            if len(tmpRecs) == 0:
                BaseFactory.log.error(context,
                                      "no engine sas port connect to the PRI sas port of redandent card of sas port "
                                      + location + " is not existed, check failed.")
                return False
            # 获取冗余路径所连的引擎端口所在的控制器
            redPortCntr = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.PARENT_ID)  # 0A.0
            redPortCntr = redPortCntr.split(".")[0]  # 0A
            # 若连接该环路第一个框的两个引擎SAS端口位于同一个控制器上，则检查不通过
            if localPortCntr == redPortCntr:
                blocation = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                             restData.Hardware.SasPort.LOCATION)  # DAE000.A.PRI
                BaseFactory.log.error(context, "the sas port " + location + " and it redandent port " + blocation
                                      + " connect to the same controller " + localPortCntr + ". check failed.")
                return False

        # 到这里，所有环路均完整，返回检查通过
        BaseFactory.log.error(context, "All loop of " + str(loopNum) + "th engine sas port is integrity. check passed.")
        return True

    '''
    Function：检查系统中指定级联板是否存在SAS冗余路径_临时方法（老方法），暂未使用
    params:
        context = 工具上下文
        expCardId = 待查询是否存在冗余路径的级联板ID
    Return: 指定级联板是否存在冗余路径。False=不存在；True=存在
    Algrithm: 算法原理：通过冗余接口板上PRI端口的连接状态进行判断，若冗余PRI端口存在且已连接，则仍为检查通过，否则不通过
    '''

    @staticmethod
    def checkSasLoopRedandent_TEMP_OLD_UNUSE(context, expCardId):
        BaseFactory.log.info(context, "enter checkSasLoopRedandent_TEMP, expCardId=" + expCardId)

        # 若无法获取到级联板下的端口信息，说明板子已拔出或未接入系统，检查通过
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, expCardId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context,
                                  "the sas port info of card:%s is not existed，the card may be out, check pass."
                                  % expCardId)
            return True

        # 若冗余级联板不存在或状态不正常，则检查不通过
        expEncId = FuncFactory.getFruParentEncId(context, restData.Enum.ObjEnum.EXPBOARD, expCardId)
        allBoardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, expEncId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.ID,
                                                    restData.Enum.ConditionTypeEnum.NE, expCardId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2, condition3)
        tmpRecs = restUtil.Tlv2Rest.filter(allBoardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs, "the normal redundant expboard of %s:" % expCardId)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no redandent and normal expboard of "
                                  + expCardId + " is existed, check failed.")
            return False

        # 若冗余级联板上的不存在已连接的PRI端口，则检查不通过
        redCardRec = tmpRecs[0]
        redCardId = restUtil.Tlv2Rest.getRecordValue(redCardRec, restData.Hardware.Expboard.ID)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, redCardId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.NAME,
                                                    restData.Enum.ConditionTypeEnum.EQ, "PRI")
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs, "the redundant linkup pri port of %s:" % expCardId)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no redandent and LINK_UP PRI port card of "
                                  + expCardId + " is existed, check failed.")
            return False

        # 返回检查通过
        BaseFactory.log.info(context, "the redundant sas path of %s is existed, check pass." % expCardId)
        return True

    '''
    Function：检查系统中指定级联板是否存在SAS冗余路径_临时方法，待checkSasLoopRedandent有效后就更换
    params:
        context = 工具上下文
        expCardId = 待查询是否存在冗余路径的级联板ID
    Return: 指定级联板是否存在冗余路径。False=不存在；True=存在
    Algrithm: 算法原理：通过冗余接口板上PRI端口的连接状态进行判断，若冗余PRI端口存在且已连接，则仍为检查通过，否则不通过
    '''

    @staticmethod
    def checkSasLoopRedandent_TEMP(context, expCardId):
        BaseFactory.log.info(context, "enter checkSasLoopRedandent_TEMP, expCardId=" + expCardId)
        # 获取所有的SAS端口信息
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)

        # 获取级联板所属的级联框信息
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, expCardId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "unexpected error: the sas port info of card "
                                  + expCardId + " is not existed, check failed.")
            return False
        location = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.LOCATION)  # DAE000.B.PRI
        subrackName = location.split(".")[0]  # DAE000

        # 若冗余级联板上的不存在已连接的PRI端口，则检查不通过
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.LIKE, subrackName)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.NE, expCardId)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.NAME,
                                                    restData.Enum.ConditionTypeEnum.EQ, "PRI")
        condition4 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3, condition4)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "no redandent and LINK_UP PRI port card of "
                                  + expCardId + " is existed, check failed.")
            return False
        else:
            BaseFactory.log.error(context, "the redandent and LINK_UP PRI port card of "
                                  + expCardId + " is existed, check passed.")
            return True

    '''
    Function：检查系统中指定级联板是否存在SAS冗余路径_临时方法，待checkSasLoopRedandent有效后就更换
    params:
        context = 工具上下文
        expCardId = 待查询是否存在冗余路径的级联板ID
    Return: 指定级联板是否存在冗余路径。False=不存在；True=存在
    Algrithm: 算法原理：若待换级联板故障或无连接，则检查通过；否则检查所属硬盘域下实际的端口连接数量和应该连接数量是否相等，不等则不通过；否则通过。存在漏报风险
    '''

    @staticmethod
    def checkSasLoopRedandent_TEMP_UNUSE(context, expCardId):
        BaseFactory.log.info(context, "enter checkSasLoopRedandent_TEMP, expCardId=" + expCardId)

        # 若待换级联板已故障或下电，则返回检查通过
        isFault = FuncFactory.isFruFault(context, restData.Enum.ObjEnum.EXPBOARD, expCardId)
        if True == isFault:
            BaseFactory.log.info(context, "the sas port info of card "
                                 + expCardId + " is fault or powered off, check passed.")
            return True

        # 获取所有的SAS端口信息，获取失败则返回不通过
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SAS_PORT)
        if None == allPortRecs:
            return False

        # 若待换级联板上无连接的端口，则检查通过
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, expCardId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        repCardLinkPortNum = len(tmpRecs)
        if repCardLinkPortNum == 0:
            BaseFactory.log.info(context, "the LINK_UP sas port info of card "
                                 + expCardId + " is not existed, check passed.")
            return True

        # 获取级联板所属的级联框name
        location = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.SasPort.LOCATION)  # DAE000.B.PRI
        subrackName = location.split(".")[0]  # DAE000

        # 获取所有框（硬盘框和控制框）的信息
        allEncRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        if None == allEncRecs:
            return

        # 获取存在待换级联板的硬盘框所属硬盘域的编号（SAS接口板上的一个端口ID）
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.NAME,
                                                    restData.Enum.ConditionTypeEnum.EQ, subrackName)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allEncRecs, conditionList)
        if len(tmpRecs) == 0:
            BaseFactory.log.error(context, "unexpected error: the enclosure of the sas expand board "
                                  + location + " is not existed, check failed.")
            return False
        domainId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.Enclosure.EXPANDER_PORT)

        # 获取当前域下所有硬盘框的ID列表和数量
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.EnclosureTypeEnum.EXP)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.EXPANDER_PORT,
                                                    restData.Enum.ConditionTypeEnum.EQ, domainId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allEncRecs, conditionList)
        domEncNum = len(tmpRecs)  # 硬盘框数量
        domEncIdList = []
        for index in range(0, domEncNum):
            domEncIdList.append(restUtil.Tlv2Rest.getRecordValue(tmpRecs[index],
                                                                 restData.Hardware.Enclosure.ID))

        # 获取当前域下所有硬盘框上的所有SAS接口卡
        allCardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        if None == allEncRecs:
            BaseFactory.log.error(context, "unexpected error: fail to get all EXPBOARD info, check failed.")
            return False
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Expboard.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, domEncIdList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allCardRecs, conditionList)
        domCardIdList = []
        for index in range(0, len(tmpRecs)):
            domCardIdList.append(restUtil.Tlv2Rest.getRecordValue(tmpRecs[index],
                                                                  restData.Hardware.Expboard.ID))

        # 获取当前域下所有已连接SAS端口的数量
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, domCardIdList)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SasPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        domLinkPortNum = len(tmpRecs)

        # 根据已连接的端口数量判断当前域下是否存在冗余链路（无法检查连接的正确性，存在漏报风险）
        '''
        #计算当前硬盘域中应连接的端口数量：此时，按级联板中已连接的端口数量和所处环路中位置的不同，可分为三种情况：
        #1、级联板中无已连接的端口。此种情况在上面已直接返回可更换；
        #2、级联板中有1个已连接端口。此种情况在级联板位于以下三种位置时可能出现：（140326-Question: 下面的三种情况无法区分，该算法不可行）
            1)、存在一个无需连接的下行口。needLinkPortNum = domEncNum * 2 * 2 - 2
            2)、与引擎连接的端口未连接。needLinkPortNum = domEncNum * 2 * 2 - 2 - 1
            3)、全与级联板连接的端口中有一个未连接。needLinkPortNum = domEncNum * 2 * 2 - 2 - 2
        #3、级联板中有2个已连接端口。此种情况仅在级联板上的端口全与其他级联板或引擎连接时出现。needLinkPortNum = domEncNum * 2 * 2 - 2
        '''
        # 每个硬盘框2个级联板，每个级联板2个端口，除去两个无需连接的下行口，再除去待换级联板上的未连接端口导致的未连接端口）
        needLinkPortNum = domEncNum * 2 * 2 - 2 - (2 - repCardLinkPortNum) * 2
        # 若当前域下应连接端口数量与实际连接数量不一致，则检查不通过
        if domLinkPortNum != needLinkPortNum:
            BaseFactory.log.error(context, "The LINK_UP port number is dismatched, check failed. domLinkPortNum="
                                  + str(domLinkPortNum) + ", needLinkPortNum=" + str(needLinkPortNum)
                                  + ", domEncNum=" + str(domEncNum) + ", repCardLinkPortNum=" + str(repCardLinkPortNum))
            return False

        # 所有异常情况均已排除，说明冗余链路存在，检查通过
        return True

    ________PCIE_CHECK_ZONE________ = None

    # 获取所有的PCIe交换机信息
    @staticmethod
    def getAllPCIeDswRecs(context):

        # 获取所有冗余管理板上的端口，并校验IP是否可用
        allEncRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.EnclosureTypeEnum.DSW)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        return restUtil.Tlv2Rest.filter(allEncRecs, conditionList)

    @staticmethod
    def getPCIeDswInfoList(context, key):
        """
        @summary: 获取所有的PCIe交换机信息列表
        @param key: 信息字段值。如, restData.Hardware.Enclosure.ID
        """
        allDswRecs = Loop.getAllPCIeDswRecs(context)
        infoList = []
        for dswRec in allDswRecs:
            dswInfo = restUtil.Tlv2Rest.getRecordValue(dswRec, key)
            infoList.append(dswInfo)
        return infoList

    @staticmethod
    def getPCIePortRecById(context, portId, allPortRecs=None):
        '获取PCIe端口信息'

        if None == allPortRecs:
            return FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.PCIE_PORT, portId)
        else:
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, portId)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            if len(tmpRecs) > 0:
                return tmpRecs[0]
            else:
                return None

    '''
    Function：检查指定的PCIe交换机上PCIe路径是否完整且正确
    params:
        context=工具上下文
        dswId=待检查的PCIe交换机ID，如DSW0
        allPortRecs=None：所有PCIe端口信息，默认为空
    Return: dswId上的PCIe路径是否完整：True / False
    '''

    @staticmethod
    def checkPCIePathIntegrityForDsw(context, dswId, allPortRecs=None):

        BaseFactory.log.info(context, "enter checkPCIePathIntegrityForDsw. dswId=" + dswId)

        # 获取所有的PCIe端口信息
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)

        # 获取交换机上的所有PCIe端口列表
        dswPortIdList = []
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, dswId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        for rec in tmpRecs:
            portId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.ID)
            dswPortIdList.append(portId)
        if len(dswPortIdList) == 0:  # 容错
            BaseFactory.log.error(context, "no ports of pcie dsw:%s existed." % dswId)
            return False

        # 判断所有引擎节点到交换机的PCIe路径是否正确
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.SUGGEST_PEER_PORT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, dswPortIdList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        sugCardPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        unmatchPortIdList = []
        linkedCntrIdList = []
        for rec in sugCardPortRecs:
            portId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.ID)
            curPeerPortId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.CURRENT_PEER_PORT_ID)
            sugPeerPortId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.SUGGEST_PEER_PORT_ID)
            if curPeerPortId != sugPeerPortId:
                unmatchPortIdList.append(portId)
            else:
                cntrRec = FuncFactory.getFruParentRecord(context, restData.Enum.ObjEnum.PCIE_PORT, portId,
                                                         restData.Enum.ObjEnum.CONTROLLER)
                if None != cntrRec:
                    cntrId = restUtil.Tlv2Rest.getRecordValue(cntrRec, restData.Hardware.Controller.ID)
                    linkedCntrIdList.append(cntrId)
                else:
                    BaseFactory.log.error(context, "unexpected error: can not get owning cntr of pcie port %s" % portId)
        BaseFactory.log.info(context,
                             "unmatchPortIdList=%s, linkedCntrIdList=%s" % (unmatchPortIdList, linkedCntrIdList))
        if len(unmatchPortIdList) > 0:
            BaseFactory.log.error(context, "current_peer_port_id and suggest_peer_port_id of ports %s that connected to \
                      pcie dsw:%s is inconsistant." % (",".join(unmatchPortIdList), dswId))
            return False

        # 检查是否交换机到所有正常控制器上均有连接
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Controller.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Controller.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.ONLINE)
        normalCtrlIdList = FuncFactory.getCntrIdList(context, condition0, condition1)
        if 0 == len(normalCtrlIdList):
            BaseFactory.log.error(context, "normalCtrlIdList is empty.")
            return False
        for cntrId in normalCtrlIdList:
            if cntrId not in linkedCntrIdList:
                BaseFactory.log.error(context,
                                      "linkedCntrIdList:%s not equal normalCtrlIdList:%s, one or more cntr not connected."
                                      % (",".join(linkedCntrIdList), ",".join(normalCtrlIdList)))
                return False
            else:
                pass

        # 检查通过
        BaseFactory.log.info(context, "the pcie path of dswId:%s is existed and correct, check passed." % dswId)
        return True

    @staticmethod
    def checkPCIePathIntegrityForCable(context, cardPortId, dswPortId, isCheckRedundcy):
        '''
        Function：检查指定线缆是否存在完整且正确的冗余PCIe路径
        params:
            context=工具上下文
            cardPortId=线缆的接口卡上端口
            dswPortId=线缆的交换机上端口
            isCheckRedundcy=是否为检查路径冗余。True=检查冗余路径，False=检查当前线缆所在路径
        Return: 线缆是否存在完整且正确的[当前/冗余]PCIe路径：True=存在；False=不存在
        '''

        BaseFactory.log.info(context, "enter checkRedandentPciePathForCable. cardPortId=%s, dswPortId=%s, \
                  isCheckRedundcy=%s" % (cardPortId, dswPortId, str(isCheckRedundcy)))

        # 获取控制框数量，若为单引擎，则检查通过
        encRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.EnclosureTypeEnum.CTRL)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(encRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
        encNum = len(tmpRecs)
        if encNum <= 1:
            return True

        # 获取所有的PCIe端口信息
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
        cardPortRec = Loop.getPCIePortRecById(context, cardPortId, allPortRecs)
        dswPortRec = Loop.getPCIePortRecById(context, dswPortId, allPortRecs)
        if None == cardPortRec or None == dswPortRec:
            BaseFactory.log.error(context, "the pcie port info of cardPortId:%s:%s or/and dswPortId:%s:%s is inexisted."
                                  % (cardPortId, str(cardPortRec), dswPortId, str(dswPortRec)))
            return False

        # 按检查类型进行分别处理
        curDswId = restUtil.Tlv2Rest.getRecordValue(dswPortRec, restData.Hardware.PciePort.PARENT_ID)
        if False == isCheckRedundcy:
            # 检查线缆所在交换机上的PCIe路径完整和正确性
            return Loop.checkPCIePathIntegrityForDsw(context, curDswId, allPortRecs)

        else:  # 检查线缆对应的冗余交换机上的PCIe路径完整和正确性
            # 获取冗余交换机（非dswPortRec所属的交换机）信息
            allEncRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.MODEL,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.EnclosureModelEnum.DSW_PCIe1U)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.ID,
                                                        restData.Enum.ConditionTypeEnum.NE, curDswId)
            condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.HEALTH_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.HealthStatusEnum.NORMAL)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3)
            tmpRecs = restUtil.Tlv2Rest.filter(allEncRecs, conditionList)
            if len(tmpRecs) <= 0:
                BaseFactory.log.error(context, "no normal redundant dsw of curdswId:%s existed." % curDswId)
                return False
            else:
                redDswId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.Enclosure.ID)
                return Loop.checkPCIePathIntegrityForDsw(context, redDswId, allPortRecs)

    '''
    Function：检查是否存在冗余PCIe交换机
    params:
        context=工具上下文
        dswId=待检查冗余的PCIe交换机ID，如DSW0
    Return: dswId是否存在可用的冗余交换机：True=存在；False=不存在
    '''

    @staticmethod
    def checkPcieSwitchRedandent(context, dswId):
        BaseFactory.log.info(context, "enter checkPcieSwitchRedandent. dswId=" + dswId)

        # 获取控制器数量
        ctrlRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.CONTROLLER)
        ctrlNum = len(ctrlRecs)

        # 获取所有的PCIe端口和冗余PCIe交换机已连接端口信息
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.NE, dswId)  # 非待换DSW端口
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.NLIKE, "ENG")  # 非引擎PCIe端口
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.NLIKE, "CTE")  # 非引擎PCIe端口
        condition4 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)  # 要求已连接

        productModel = contextUtil.getProductModel(context)
        isDoradoDev = baseUtil.isDoradoDev(productModel)
        if isDoradoDev:
            condition5 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.LOGIC_TYPE,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.PortLogicTypeEnum.HOST)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3, condition4,
                                                               condition5)
        else:
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3, condition4)

        redPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)

        restUtil.Tlv2Rest.logRecList(context, redPortRecs, "all LINK_UP pcie port under redundant dsw of %s" % dswId)

        # 要求每个控制器上的每个PCIe端口均要与冗余PCIe交换机有连接
        # 连接端口数量验证
        redPortNum = len(redPortRecs)
        if ctrlNum > redPortNum:  # 每个PCIe接口卡均与冗余交换机有一个连接（1卡*控制器数量/6U机头，每个接口卡均与任一交换机有连接）
            BaseFactory.log.error(context, "the LINK_UP port number of redandent switch is not matched. ctrlNum="
                                  + str(ctrlNum) + ", redPortNum=" + str(
                redPortNum) + ". ctrlNum != redPortNum，check failed.")
            return False

        # 端口连接正确性校验
        # 获取冗余交换机和PCIe交换机的连接关系
        intfPeerPortDict = {}  # 接口卡所连接的交换机端口列表所构成的字典
        intfPeerPortDict[""] = []  # 初始化未连接到接口卡的交换机端口列表
        for rec in redPortRecs:
            portId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.ID)
            portLoc = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.LOCATION)
            # 获取与该冗余端口连接的PCIe接口卡端口
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.CURRENT_PEER_PORT_ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, portId)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.LOCATION,
                                                        restData.Enum.ConditionTypeEnum.LIKEOR, ["ENG", "CTE"])
            condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            if 0 == len(tmpRecs):
                # 交换机端口未连接到引擎的PCIe接口卡上
                intfPeerPortDict[""].append(portLoc)
            else:  # 交换机端口已连接到引擎的PCIe接口卡上
                location = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0],
                                                            restData.Hardware.PciePort.LOCATION)  # ENG0.A3.P1
                locSecs = location.split(".")
                intfLoc = ".".join(locSecs[:-1])  # CTE0.R3.IOM0.P0 -> CTE0.R3.IOM0
                if intfLoc not in intfPeerPortDict.keys():
                    intfPeerPortDict[intfLoc] = [portLoc]
                else:  # 用一卡上的两个端口连接到同一交换机
                    intfPeerPortDict[intfLoc].append(portLoc)
        # 判断检查结果
        BaseFactory.log.info(context, "the link realationship between intf and dsw:%s is %s"
                             % (dswId, intfPeerPortDict))
        isPass = True
        if len(intfPeerPortDict[""]) > 0:
            BaseFactory.log.error(context, "no LINK_UP eng pcie port of redandent dsw ports:%s is existed."
                                  % intfPeerPortDict[""])
            isPass = False
        for (intfLoc, portLocList) in intfPeerPortDict.items():
            if len(portLocList) > 1 and "" != intfLoc:
                BaseFactory.log.error(context,
                                      "more than one redandent dsw pcie ports:%s connected to same pcie intf:%s"
                                      % (portLocList, intfLoc))
                isPass = False
        if True != isPass:
            BaseFactory.log.error(context, "check redundant pcie path of dsw:%s is fail for above reason." % dswId)
            return False
        else:
            BaseFactory.log.info(context, "check redundant pcie path of dsw:%s is normal, check passed." % dswId)
            return True

    '''
    Function：检查PCIe冗余路径
    params:
        context=工具上下文
        pcieCardId=待检查冗余的PCIe接口卡ID
        allCardRecs=所有接口卡 或 所有PCIe接口卡记录
        allPortRecs=所有PCIe端口记录
    Return: pcieCardId是否存在冗余接口卡：True=存在；False=不存在
    '''

    @staticmethod
    def checkPcieLoopRedandent(context, pcieCardId, allCardRecs=None, allPortRecs=None):
        BaseFactory.log.info(context, "enter checkPcieLoopRedandent. pcieCardId=" + pcieCardId)
        # 获取所有接口卡信息
        if None == allCardRecs:
            allCardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        # 获取所有PCIE端口信息
        if None == allPortRecs:
            allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)

        # 获取当前PCIe接口卡的信息
        pcieModules = [restData.Enum.IntfModelEnum.PCIe_2X5G, restData.Enum.IntfModelEnum.PCIe_2PORT]
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQOR,
                                                    pcieModules)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.ID,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    pcieCardId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        tmpRecs = restUtil.Tlv2Rest.filter(allCardRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
        if 0 == len(tmpRecs):
            BaseFactory.log.error(context, "the pcie card info of " + pcieCardId + " is not existed, check failed.")
            return False
        cardLocation = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.IntfModule.LOCATION)
        encLocation = cardLocation.split(".")[0]  # ENG1.A3 -> ENG1

        # 获取冗余PCIe接口卡上的已连接端口信息(同一引擎，不同接口卡，已连接端口)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.LIKE, encLocation)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.NE, pcieCardId)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2, condition3)
        redPortRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, redPortRecs)  # for test
        if len(redPortRecs) < 2:  # 冗余PCIe接口板上仅能有两个已连接端口
            BaseFactory.log.error(context, "the LINK_UP port number in redandent card of pcie card " + pcieCardId
                                  + " is " + str(len(redPortRecs)) + " less than 2. check failed.")
            return False

        # 获取交换机ID列表
        allDswIdList = Loop.getPCIeDswInfoList(context, restData.Hardware.Enclosure.ID)

        # 获取各冗余接口卡和交换机之间的连接关系
        intfDswListDict = {}  # 当前机头内接口卡所连接的交换机列表构成的字典
        intfDswListDict[""] = []
        for rec in redPortRecs:
            # 获取所连交换机端口的信息
            portId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.ID)
            portIntfId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.PARENT_ID)
            dswPortId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.PciePort.CURRENT_PEER_PORT_ID)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.ID,
                                                        restData.Enum.ConditionTypeEnum.EQ, dswPortId)
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs, "current peer port:%s of port:%s" % (dswPortId, portId))
            if 0 == len(tmpRecs):
                BaseFactory.log.error(context, "the LINK_UP dsw pcie port:%s is not existed." % dswPortId)
                continue
            # 构建各接口卡和交换机之间的连接关系
            peerDswId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.Hardware.PciePort.PARENT_ID)
            if peerDswId not in allDswIdList:
                # 记录未连接到交换机的接口卡端口ID
                intfDswListDict[""].append(portIntfId + "_" + portId)
            else:
                # 记录各接口卡所连接的交换机ID列表
                if portIntfId in intfDswListDict.keys() \
                        and peerDswId not in intfDswListDict[portIntfId]:
                    intfDswListDict[portIntfId].append(peerDswId)
                else:
                    intfDswListDict[portIntfId] = [peerDswId]

        # 判断是否存在一个到两个交换机均有连接的冗余接口卡，有则通过
        BaseFactory.log.info(context, "the realationship between redundant pcie intf of %s and dsw is %s"
                             % (pcieCardId, intfDswListDict))
        for (intfId, linkedDswIdList) in intfDswListDict.items():
            if "" != intfId and len(linkedDswIdList) == len(allDswIdList):
                BaseFactory.log.info(context, "find a redundant pcie intf:%s connected to dsws:%s, check pass."
                                     % (intfId, linkedDswIdList))
                return True

        # 如果没有任何一个接口卡连接到所有的PCIe交换机，则检查不通过
        BaseFactory.log.error(context,
                              "no redundant pcie intf of intf:%s connnect to all pcie dsw, check fail." % pcieCardId)
        return False

    '''
    Function：检查系统中所有PCIe环路是否完整
    params:
        context=工具上下文
    Return: 系统中所有PCIe环路是否完整：True=完整； False=不完整
    '''

    @staticmethod
    def checkAllPcieLoopIntegrity(context):
        BaseFactory.log.info(context, "enter checkAllPcieLoopIntegrity.")
        # 获取所有的框信息
        allEncRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        restUtil.Tlv2Rest.logRecList(context, allEncRecs)  # for test
        if None == allEncRecs:
            return False
        # 获取所有PCIE端口信息
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.PCIE_PORT)
        restUtil.Tlv2Rest.logRecList(context, allPortRecs)  # for test
        if None == allPortRecs:
            return False

        # 获取控制框数量
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.EnclosureTypeEnum.CTRL)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allEncRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
        encNum = len(tmpRecs)

        # 据控制框的数量分别进行判断
        if encNum == 1:
            # 若仅有一个控制框，则不存在已连接的PCIe端口时，检查通过，否则不通过
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            if len(tmpRecs) == 0:
                BaseFactory.log.info(context, "no LINK_UP pcie port existed in the single CNTR enc, check passed.")
                return True
            else:
                BaseFactory.log.error(context, "existd " + str(len(tmpRecs))
                                      + " LINK_UP pcie port in the single CNTR enc, check failed.")
                return False
        elif encNum > 1:
            # 若控制框为多个，则要求所有控制框上的PCIe接口卡均要正确连接
            # 获取所有PCIe接口卡信息
            allCardRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
            if None == allCardRecs:
                return False
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.IntfModelEnum.PCIe_2X5G)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            allCardRecs = restUtil.Tlv2Rest.filter(allCardRecs, conditionList)
            cardNum = len(allCardRecs)
            if encNum * 2 != cardNum:  # 每个控制框有且仅有两个PCIe接口板
                BaseFactory.log.error(context, "not standard pcie card conf(two card per enc), encNum=" + str(encNum)
                                      + ", cardNum=" + str(cardNum) + ". check failed.")
                return False

            # 若已连接的PCIe端口数量必须与PCIe接口板数量一致，则检查不通过
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.PciePort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            if len(tmpRecs) != cardNum * 2 * 2:  # N个PCIe接口板，交换机和引擎上各应有2N个端口，共2*2N个
                BaseFactory.log.error(context, "not standard pcie port conf(two port per card), cardNum=" + str(cardNum)
                                      + ", portNum=" + str(len(tmpRecs)) + ". check failed.")
                return False

            # 遍历所有PCIe接口卡，检查是否通过
            for index in range(0, cardNum):
                cardRec = allCardRecs[index]
                cardId = restUtil.Tlv2Rest.getRecordValue(cardRec, restData.Hardware.IntfModule.ID)
                if False == Loop.checkPcieLoopRedandent(context, cardId, allCardRecs, allPortRecs):
                    location = restUtil.Tlv2Rest.getRecordValue(cardRec, restData.Hardware.IntfModule.LOCATION)
                    BaseFactory.log.error(context, "the right redandent card of card " + location
                                          + " is not existed. check failed.")
                    return False

            # 返回通过
            BaseFactory.log.info(context, "all pcie loop in " + str(encNum) + " CNTR enc is integrite, check passed.")
            return True
        else:
            BaseFactory.log.error(context, "")
            return False

    ________MGMT_CHECK_ZONE________ = None

    '''
    Function：指定IPV4地址的IP是否可达（Ping通）
    params:
        ip=待检查IP
    Return: IP是否可达： True=可达； False=不可达
    '''

    @staticmethod
    def isIpReachable(ip):
        return PingUtils.pingHost(ip)  # @UndefinedVariable #pingHost存在，故屏蔽PyDev报错

    '''
    Function：指定ETH端口信息中的IP是否可达（Ping通）
    Method: 先查IP4，后查IP6，有可达IP便返回，无则返回None
    params:
        context=工具上下文
        ethPortRec=ETH端口信息
    Return: IP or None
    '''

    @staticmethod
    def getReachableIp(context, ethPortRec):

        # 入口参数检查
        if None == ethPortRec:
            BaseFactory.log.info(context, "the ethPortRec is none!!!")
            return None

        # 获取IPV4地址
        ipv4 = restUtil.Tlv2Rest.getRecordValue(ethPortRec, restData.Hardware.EthPort.IPV4_ADDR)
        if "" != ipv4 and True == Loop.isIpReachable(ipv4):
            return ipv4
        else:
            pass

        # 获取IPV6地址
        ipv6 = restUtil.Tlv2Rest.getRecordValue(ethPortRec, restData.Hardware.EthPort.IPV6_ADDR)
        if "" != ipv6 and True == Loop.isIpReachable(ipv6):
            return ipv6
        else:
            pass

        # 返回None
        return None

    '''
    Function：指定ID的ETH端口是否正常
    params:
        context=工具上下文
        portId=待检查的ETH端口Id
        rec=portId对应的端口的信息，不填或None时内部会自动查询
    Return: True=正常； False=不正常
    '''

    @staticmethod
    def isEthPortNormal(context, portId, rec=None):
        # 获取端口信息
        if None == rec:
            rec = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.ETH_PORT, portId)
            if None == rec:
                BaseFactory.log.error(context, "can not get the info of eth port " + portId + ". check failed.")
                return False
        # 端口必须为已连接
        runStatus = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.EthPort.RUNNING_STATUS)
        if runStatus != restData.Enum.RunningStatusEnum.LINK_UP:
            BaseFactory.log.error(context, "the running status of eth port " + portId + " is " + runStatus
                                  + ", not LINK_UP. check failed.")
            return False
        # 端口中必须存在能Ping通IP
        ipList = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.EthPort.IPV4_ADDR)
        location = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.EthPort.LOCATION)
        strIps = ipList.split(",")  # ipv4Addr可能包含多个IP地址，此时中间用逗号隔开
        metNormalIp = False
        # IP正常时，IP中仅有本端口IP或IP列表；
        for ip in strIps:
            if "" == ip or None == ip:
                continue  # IP为空时跳过
            if None == re.search(";", ip):  # 当IP发生漂移时，IP格式为"控制器ID;控制器IP"，中间用分号隔开
                # 仅判断正常IP是否可达，忽略漂移的IP
                metNormalIp = True
                if False == Loop.isIpReachable(ip):
                    # 正常IP不可达时，检查不通过
                    BaseFactory.log.error(context,
                                          "the ip " + ip + " of eth port " + location + " is not reachable. check failed.")
                    return False
                else:
                    BaseFactory.log.info(context, "the ip " + ip + " of eth port " + location + " is reachable.")
                    break
        if False == metNormalIp:  # 未配置正常IP时，检查不通过
            BaseFactory.log.error(context, "the normal ip of eth port " + location + " is not existed. check failed.")
            return False

        # 检查全通过，返回OK
        return True

    '''
    Function：检查指定ETH端口集合中的所有端口是否正常
    params:
        context=工具上下文
        portRecs=待检查的所有端口信息
    Return: True=正常； False=不正常
    '''

    @staticmethod
    def isEthPortsReachable(context, portRecs):
        # 入口参数检查
        if None == portRecs:
            BaseFactory.log.error(context, "the input recs is none. check failed.")
            return False

        # 遍历所有ETH端口，确认它们是否可达
        isPass = True
        recNum = len(portRecs)
        for index in range(0, recNum):
            rec = portRecs[index]
            portId = restUtil.Tlv2Rest.getRecordValue(rec, restData.Hardware.EthPort.ID)
            if False == Loop.isEthPortNormal(context, portId, rec):
                isPass = False

        # 返回检查结果
        return isPass

    '''
    Fcunction：检查系统中管理环路的完整性
    params:
        context=工具上下文
    Return: 管理环路是否完整。False=不完整；True=完整
    Algrithm: 算法原理：（需结合组网图进行理解）
        1、若控制框只有一个，则仅需该框上每个控制器上至少有一个MGMT口已连接，且能Ping通时，检查通过，否则不通过；
        2、若控制框上不止一个，则当所有控制框和DSW上的管理网口均正常连接时，检查通过，否则不通过
    ATTENTION: 当第一个引擎中一个管理网口连在其他交换机上，而内部通过环路又能访问到它时，将存在漏报。
    '''

    @staticmethod
    def checkAllMgmtCableIntegrity(context):
        BaseFactory.log.info(context, "enter checkAllMgmtCableIntegrity_TEMP.")
        # 获取所有的框信息
        allEncRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
        restUtil.Tlv2Rest.logRecList(context, allEncRecs)  # for test
        # 获取所有的ETH端口信息
        allPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        restUtil.Tlv2Rest.logRecList(context, allPortRecs)  # for test

        # 据控制框的数量分别进行判断
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Enclosure.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.EnclosureTypeEnum.CTRL)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allEncRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
        if len(tmpRecs) == 1:
            # 若控制框只有一个，则仅需该框上每个控制器上至少有一个MGMT口已连接，且能Ping通时，检查通过，否则不通过
            condition1A = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOCATION,
                                                         restData.Enum.ConditionTypeEnum.LIKE, "MGMTA")
            condition1B = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOCATION,
                                                         restData.Enum.ConditionTypeEnum.LIKE, "MGMTB")
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1A, condition2)
            tmpRecsA = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecsA)  # for test
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1B, condition2)
            tmpRecsB = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecsB)  # for test
            if len(tmpRecsA) >= 1 and Loop.isEthPortsReachable(context, tmpRecsA) == True \
                    and len(tmpRecsB) >= 1 and Loop.isEthPortsReachable(context, tmpRecsB) == True:
                BaseFactory.log.info(context, "double cntr in single engine existed LINK_UP mgmt port. check passed.")
                return True
            else:
                BaseFactory.log.info(context, "only mgmt port in cntr A(linked=" + str(len(tmpRecsA))
                                     + ") or cntr B(linked=" + str(len(tmpRecsB)) + ") is LINK_UP. check failed.")
                return False
        elif len(tmpRecs) > 1:
            engNum = len(tmpRecs)
            # 若控制框上不止一个，则当所有控制框和DSW上的管理网口均正常连接时，检查通过，否则不通过
            # DSW管理端口location: DSW1.MGMT.1; 控制器管理端口location: ENG1.MGMTB.1
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOCATION,
                                                        restData.Enum.ConditionTypeEnum.LIKE, "MGMT")
            condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
            tmpRecs = restUtil.Tlv2Rest.filter(allPortRecs, conditionList)
            restUtil.Tlv2Rest.logRecList(context, tmpRecs)  # for test
            # 需要连接的端口数量为：engNum个引擎，每个引擎4个端口；2个PCIe交换机，每个交换机2个端口
            needLinkPortNum = engNum * 4 + 2 * 2

            # 应连接的端口数量必须正常，且可达
            if needLinkPortNum == len(tmpRecs):
                # 搜索出引擎的管理网口
                engMgmtPortList = restUtil.Tlv2Rest.getMultiConditionValueList("MGMTA.0", "MGMTB.0")
                condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOCATION,
                                                            restData.Enum.ConditionTypeEnum.LIKEOR, engMgmtPortList)
                conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
                tmpRecs = restUtil.Tlv2Rest.filter(tmpRecs, conditionList)
                # 先保证引擎的管理网口能检测，维护网口和交换机管理网口后续再想办法
                if Loop.isEthPortsReachable(context, tmpRecs) == True:
                    BaseFactory.log.info(context, "all mgmt port 0 of engine are connected. check passed.")
                    return True
                else:
                    BaseFactory.log.info(context, "existed inreachable mgmt port 0 of engine. check failed.")
                    return False
            else:
                BaseFactory.log.info(context, "existed " + str(needLinkPortNum - len(tmpRecs))
                                     + " mgmt port of engine or dsw are NOT LINK_UP. check failed.")
                return False
        else:
            # 异常情况，报错
            BaseFactory.log.error(context, "no CTRL enclosure existed, not expected, check failed.")
            return False

    '''Function:获取指定控制器下的所有管理ETH口信息
    Notes:
    1、仅包含控制器下管理板上的端口，不包含交换机上的端口
    2、该方法对V3中共享管理板的情况不适用
    '''

    @staticmethod
    def getLinkedMgmtPortRecsForCntr(context, cntrId):
        BaseFactory.log.info(context, u"==========begin-getLinkedMgmtPortRecsForCntr==========")

        # 筛选出当前控制器下的管理板
        curCntrRec = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.CONTROLLER, cntrId)
        cntrLoc = restUtil.Tlv2Rest.getRecordValue(curCntrRec, restData.Hardware.Controller.LOCATION)
        enginInfo = cntrLoc.split(".")[0]
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.IntfModelEnum.ManagerBoard)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.LIKE, enginInfo)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, cntrId)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2, condition3)
        mgmtIntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
        if len(mgmtIntfRecs) == 0:
            BaseFactory.log.info(context, "the mgmt intf of cntr:%s is not existed." % cntrId)
            return None

        # 获取管理板上的已连接端口，并返回
        intfId = restUtil.Tlv2Rest.getRecordValue(mgmtIntfRecs[0], restData.Hardware.IntfModule.ID)
        allEthPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, intfId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQOR,
                                                    FuncFactory.FRUCONST.MGMT_PORT_ALL_LOGIC_TYPE_LIST)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        mgmtPortRecs = restUtil.Tlv2Rest.filter(allEthPortRecs, conditionList)

        # 返回管理端口
        if len(mgmtPortRecs) > 0:
            return mgmtPortRecs
        else:
            return None

    '''Function:获取非指定控制器下的所有管理ETH口信息（盘控一体适用）
    Notes:
    1、仅包含冗余控制器下管理板上的端口，不包含交换机上的端口
    2、该方法对V3中共享管理板的情况仍适用
    '''

    @staticmethod
    def getLinkedRedundantMgmtPortRecsForCntr_EncWithDisk(context, cntrId):

        # 获取所有冗余管理板上的端口，并校验IP是否可用
        allMgmtPortRecs = FuncFactory.getAllMgmtPortRecord(context)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.NE, cntrId)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        redMgmtPortRecs = restUtil.Tlv2Rest.filter(allMgmtPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, redMgmtPortRecs,
                                     "redundant LINK_UP port of encwithdisk cntrId:%s:" % cntrId)

        # 返回管理端口
        if len(redMgmtPortRecs) > 0:
            return redMgmtPortRecs
        else:
            return None
        return

    '''Function:获取非指定控制器下的所有管理ETH口信息（独立机头适用）
    Notes:
    1、仅包含冗余控制器下管理板上的端口，不包含交换机上的端口
    '''

    @staticmethod
    def getLinkedRedundantMgmtPortRecsForCntr_EncOnly_T(context, cntrId):

        # 筛选出冗余管理板（默认为框下冗余）
        curCntrRec = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.CONTROLLER, cntrId)
        cntrLoc = restUtil.Tlv2Rest.getRecordValue(curCntrRec, restData.Hardware.Controller.LOCATION)
        enginInfo = cntrLoc.split(".")[0]
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.MODEL,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.IntfModelEnum.ManagerBoard)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.LIKE, enginInfo)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.NE, cntrId)
        condition3 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2, condition3)
        if False == FuncFactory.isSingleEngine(context):  # 集群环境，冗余变为集群下冗余
            conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition2, condition3)
        redMgmtIntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, redMgmtIntfRecs, "redundant mgmt intfs of T cntrId:%s:" % cntrId)

        # 获取冗余管理板ID列表。若正常的冗余管理板不存在，则报错
        redIntfIdList = []
        for intfRec in redMgmtIntfRecs:
            intfId = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.Hardware.IntfModule.ID)
            if intfId not in redIntfIdList:
                redIntfIdList.append(intfId)
        if len(redIntfIdList) == 0:
            BaseFactory.log.info(context, "the redundant mgmt intf of cntr:%s is not existed." % cntrId)
            return None

        # 获取所有冗余管理板上的端口，并校验IP是否可用
        allMgmtPortRecs = FuncFactory.getAllMgmtPortRecord(context)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, redIntfIdList)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        redMgmtPortRecs = restUtil.Tlv2Rest.filter(allMgmtPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, redMgmtIntfRecs, "redundant mgmt Ports of T cntrId:%s:" % cntrId)

        # 返回管理端口
        if len(redMgmtPortRecs) > 0:
            return redMgmtPortRecs
        else:
            return None

    '''Function:获取非指定控制器下的所有管理ETH口信息（V3独立机头适用）
    Notes:
    1、仅包含冗余控制器下管理板上的端口，不包含交换机上的端口
    '''

    @staticmethod
    def getLinkedRedundantMgmtPortRecsForCntr_EncOnly_V3(context, cntrId):
        # V3系列机头为共享管理板，故控制器下的管理口冗余，直接返回所有可达的管理口即可。

        # 获取所有冗余管理板上的端口，并校验IP是否可用
        allMgmtPortRecs = FuncFactory.getAllMgmtPortRecord(context)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        redMgmtPortRecs = restUtil.Tlv2Rest.filter(allMgmtPortRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, redMgmtPortRecs, "redundant mgmt ports of V3 cntrId:%s:" % cntrId)

        # 返回管理端口
        if len(redMgmtPortRecs) > 0:
            return redMgmtPortRecs
        else:
            return None

    '''Function:获取非指定控制器下的所有管理ETH口信息
    Notes:
    1、仅包含冗余控制器下管理板上的端口，不包含交换机上的端口
    2、该方法对T和V3的所有管理板均适用
    '''

    @staticmethod
    def getLinkedRedundantMgmtPortRecsForCntr(context, cntrId):
        BaseFactory.log.info(context, u"==========begin-getUsableRedundantMgmtPortRecsForCntr==========")

        sysType = FuncFactory.getSystemProductType(context)
        if sysType in (BaseFactory.const.SYSMODEL["S2600T"], BaseFactory.const.SYSMODEL["S5500T"],
                       BaseFactory.const.SYSMODEL["5X00V3"]):  # 盘控一体设备
            return Loop.getLinkedRedundantMgmtPortRecsForCntr_EncWithDisk(context, cntrId)
        elif BaseFactory.const.SYSMODEL["T_ENGINE"] == sysType:  # T独立机头
            return Loop.getLinkedRedundantMgmtPortRecsForCntr_EncOnly_T(context, cntrId)
        elif sysType in FuncFactory.FRUCONST.V3_ENGIN_PRODUCT_TYPE_LIST\
                or sysType in [BaseFactory.const.SYSMODEL["V5_V6_2U_ENGINE"],
                               BaseFactory.const.SYSMODEL["V5_V6_4U_ENGINE"]]:
            return Loop.getLinkedRedundantMgmtPortRecsForCntr_EncOnly_V3(context, cntrId)
        else:
            BaseFactory.log.error(context, "ERROR: unsupported sysType:%s" % sysType)
            return None

    # 获取冗余控制器的可用管理IP
    # 该方法对V3中共享管理板的情况仍适用
    # 判断管理线缆冗余时，T独立机头的判断暂不用此借口，原接口isMgmtPathRedundantForCntr_TEngine更完善。
    @staticmethod
    def getUsableRedundantMgmtIpListForCntr(context, cntrId, OnlyNeedOne=False):
        BaseFactory.log.info(context, u"==========begin-getUsableRedundantMgmtIpListForCntr==========")

        # 初始化可用冗余IP为空列表
        usableIpList = []

        # 获取非cntrId下的管理端口信息，若不存在则返回空列表
        redMgmtPortRecs = Loop.getLinkedRedundantMgmtPortRecsForCntr(context, cntrId)
        if None == redMgmtPortRecs:
            return usableIpList

        for portRec in redMgmtPortRecs:
            ipv4 = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.IPV4_ADDR)
            if "" != ipv4:
                if True == Loop.isIpReachable(ipv4) and ipv4 not in usableIpList:
                    usableIpList.append(ipv4)
                    # 如果仅需要一个，则直接返回由一个可达IP（列表形式）
                    if True == OnlyNeedOne:
                        return usableIpList
                else:
                    pass
            else:
                pass

        # 返回结果
        return usableIpList

    # 获取已连接的PCIe交换机管理网口信息
    @staticmethod
    def getLinkedPCIeDswMgmtPortRecs(context):

        # 获取所有PCIe交换机ID列表
        dswIdList = []
        allDswEncRecs = Loop.getAllPCIeDswRecs(context)
        for dswRec in allDswEncRecs:
            dswId = restUtil.Tlv2Rest.getRecordValue(dswRec, restData.Hardware.Enclosure.ID)
            if dswId not in dswIdList:
                dswIdList.append(dswId)

        # 获取所有PCIe交换机上的已连接管理端口，并返回
        allEthPortRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, dswIdList)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.PortLogicTypeEnum.MNGT)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1, condition2)
        return restUtil.Tlv2Rest.filter(allEthPortRecs, conditionList)

    # 检查T机头的管理线路冗余
    @staticmethod
    def isMgmtPathRedundantForCntr_TEngine(context, cntrId):

        # 设备类型检查，不支持则返回不通过
        supportedSysTypes = [BaseFactory.const.SYSMODEL['T_ENGINE']]
        sysType = FuncFactory.getSystemProductType(context)
        if sysType not in supportedSysTypes:
            BaseFactory.log.error(context, "the sys type %d is not supported by list:%s"
                                  % (sysType, str(supportedSysTypes)))
            return False

        # 获取cntrId下的已连接管理端口信息，若不存在则通过检查
        cntrIntfPortRecs = Loop.getLinkedMgmtPortRecsForCntr(context, cntrId)
        if None == cntrIntfPortRecs:
            BaseFactory.log.info(context, "no linked port in mgmt intf of cntr:%s, check pass." % cntrId)
            return True

        # 获取非cntrId下的管理端口信息，若不存在则报错
        redMgmtIntfPortRecs = Loop.getLinkedRedundantMgmtPortRecsForCntr(context, cntrId)
        if None == redMgmtIntfPortRecs:
            BaseFactory.log.error(context, "no linked redundant mgmt intf port of cntr:%s, check fail." % cntrId)
            return False

        # 解析各管理端口是否满足冗余网线的需要
        cntrMgmtPortList = []
        cntrUsableMgmtPortList = []
        cntrMtncPortList = []
        for portRec in redMgmtIntfPortRecs:
            # 端口所在接口卡和控制器
            tmpIntfId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.PARENT_ID)
            tmpCntrId = ""
            portLoc = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.LOCATION)
            (isMgmt, isMainTenance) = FuncFactory.isMgmtOrMainTenance(sysType, portLoc)
            if False == isMgmt and False == isMainTenance:
                continue
            else:
                tmpCntrRec = FuncFactory.getFruParentRecord(context, restData.Enum.ObjEnum.INTF_MODULE,
                                                            tmpIntfId, restData.Enum.ObjEnum.CONTROLLER)
                tmpCntrId = restUtil.Tlv2Rest.getRecordValue(tmpCntrRec, restData.Hardware.Controller.ID)
            # 若管理口可达，则将其唯一地添加到对应的控制器下
            if True == isMgmt:
                cntrMgmtPortList.append(tmpCntrId)
                portIpv4 = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.IPV4_ADDR)
                if True == Loop.isIpReachable(portIpv4):
                    cntrUsableMgmtPortList.append(tmpCntrId)
            # 将维护口唯一地添加到对应的控制器下
            if True == isMainTenance:
                cntrMtncPortList.append(tmpCntrId)

        # 如无IP可达的冗余管理端口时不通过
        if len(cntrUsableMgmtPortList) == 0:
            BaseFactory.log.error(context, "no usable redundant mgmt port with reachable ip of cntr:%s \
                    is existed, check fail." % cntrId)
            return False

        # 据设备类型，判断冗余管理路径是否存在
        if True == FuncFactory.isSingleEngine(context):
            # 单引擎时，无可达的冗余管理端口时不通过。上面已检查，直接通过。
            return True

        else:  # 多引擎时，需检查组网结构是否正确
            # 仅检查连接状态的正确性，无法检查端口间连接是否正确，存在漏报风险
            # 获取管理板端口连接异常的接口卡数目
            unLinkMgmtPortNum = 0
            unLinkMntcPortNum = 0
            unLinkCntrIntfNum = 0
            redCntrIdList = FuncFactory.getCntrIdList(context).remove(cntrId)
            BaseFactory.log.error(context, "the T-engine's redCntrIdList=%s, cntrMgmtPortList=%s, \
                      cntrUsableMgmtPortList=%s, cntrMtncPortList=%s."
                                  % (redCntrIdList, cntrMgmtPortList, cntrUsableMgmtPortList, cntrMtncPortList))
            for tmpCntrId in redCntrIdList:
                isCntrIntfLinked = False
                if tmpCntrId not in cntrMgmtPortList:
                    unLinkMgmtPortNum += 1
                    isCntrIntfLinked = True
                if tmpCntrId not in cntrMtncPortList:
                    unLinkMntcPortNum += 1
                    isCntrIntfLinked = True
                if False == isCntrIntfLinked:
                    unLinkCntrIntfNum += 1

            # 存在控制器上无管理板或管理板上无连接时，不通过
            if unLinkCntrIntfNum > 0:
                BaseFactory.log.error(context, "exist %d redundant mgmt intf of cntr:%s no link. check fail"
                                      % (unLinkCntrIntfNum, cntrId))
                return False

            # 获取当前控制器下管理盘的连接状况
            isCurCntrMgmtPortLinked = False
            isCurCntrMntcPortLinked = False
            for portRec in cntrIntfPortRecs:
                portType = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.LOGIC_TYPE)
                if portType in FuncFactory.FRUCONST.MGMT_PORT_MGMT_LOGIC_TYPE_LIST:
                    isCurCntrMgmtPortLinked = True
                if portType in FuncFactory.FRUCONST.MGMT_PORT_MNTC_LOGIC_TYPE_LIST:
                    isCurCntrMntcPortLinked = True

            # 获取PCIE交换机上已连接的管理端口数量
            dswLinkPortRecs = Loop.getLinkedPCIeDswMgmtPortRecs(context)
            dswLinkPortNum = len(dswLinkPortRecs)

            '''据GE管理环路组网规则，判断组网冗余时需考虑下面的三种情况
            1、cntrId上管理板与外部管理网络相连时；
            2、cntrId上管理板与交换机的相连时；
            3、cntrId上管理板仅与其他管理板相连时。
            '''
            BaseFactory.log.info(context, "isCurCntrMgmtPortLinked=%s, isCurCntrMntcPortLinked=%s, \
                    dswLinkPortNum=%d, unLinkMgmtPortNum=%d, unLinkMntcPortNum=%d"
                                 % (isCurCntrMgmtPortLinked, isCurCntrMntcPortLinked,
                                    dswLinkPortNum, unLinkMgmtPortNum, unLinkMntcPortNum))
            isRedPathExisted = False
            if True == isCurCntrMgmtPortLinked and True == isCurCntrMntcPortLinked:
                # 控制器cntrId下的管理口和维护口均连接时，当所有其他管理和维护端口均连接时，则检查通过
                if 4 == dswLinkPortNum and 0 == unLinkMgmtPortNum and 0 == unLinkMntcPortNum:
                    isRedPathExisted = True
            elif True == isCurCntrMgmtPortLinked:
                # 控制器cntrId下仅管理口连接，维护口没连时，仅当下面两种情况时检查通过：
                # 1、与交换机不相邻的接口卡维护口未连，此时交换机管理口全连，冗余接口卡上维护口全连且一个管理端口未连时，检查通过；
                # 2、与交换机相邻的接口卡维护口未连，此时冗余接口卡上管理和维护口全连，交换机管理口有一个没连时，检查通过；
                if (4 == dswLinkPortNum and 1 == unLinkMgmtPortNum and 0 == unLinkMntcPortNum) or \
                        (3 == dswLinkPortNum and 0 == unLinkMgmtPortNum and 0 == unLinkMntcPortNum):
                    isRedPathExisted = True
            elif True == isCurCntrMntcPortLinked:
                # 控制器cntrId下仅维护口连接，管理口没连时，仅当下面两种情况时检查通过：
                # 1、与外部管理网口相连的管理口未连，此时其他所有管理和维护端口均连接时，检查通过；
                # 2、管理环路中间接口卡管理口未连，此时交换机管理口全连，冗余接口卡上管理口全连且一个维护端口未连时，检查通过；
                if (4 == dswLinkPortNum and 0 == unLinkMgmtPortNum and 0 == unLinkMntcPortNum) or \
                        (4 == dswLinkPortNum and 0 == unLinkMgmtPortNum and 1 == unLinkMntcPortNum):
                    isRedPathExisted = True
            else:  # 此种情况上面已处理，直接返回通过， 此处仅做容错处理
                isRedPathExisted = True

            # 返回结果
            BaseFactory.log.info(context, "the redundant mgmt path check result of cntr:%s is %s."
                                 % (cntrId, isRedPathExisted))
            return isRedPathExisted

    '''
    Function：检查指定控制器是否存在冗余管理路径
    params:
        context=工具上下文
        cntrId=控制器ID
    Return: 指定控制器是否存在冗余管理路径：True/False(错误信息已设置)
    Notes: T和V3的所有型号均支持
    '''

    @staticmethod
    def checkMgmtPathRedundantForCntr(context, cntrId):
        BaseFactory.log.info(context, u"==========begin-checkMgmtCableRedundantForCntr==========")

        # 据产品型号进行冗余判断
        isPass = False
        sysType = FuncFactory.getSystemProductType(context)
        if sysType in FuncFactory.FRUCONST.V3_ENGIN_PRODUCT_TYPE_LIST:
            BaseFactory.log.info(context, "the mgmt intf of V3 3U and 6U belong to enc, pass directly.")
            isPass = True

        elif sysType in (BaseFactory.const.SYSMODEL["S2600T"], BaseFactory.const.SYSMODEL["S5500T"],
                         BaseFactory.const.SYSMODEL["5X00V3"]):
            # V3控制框时，无可达冗余端口时不通过
            redMgmtIpList = Loop.getUsableRedundantMgmtIpListForCntr(context, cntrId, True)
            if len(redMgmtIpList) > 0:
                isPass = True

        elif sysType == BaseFactory.const.SYSMODEL['T_ENGINE']:
            # T机头时，要求所有冗余控制器均有接口卡，且接口卡上端口连接状态正确
            isPass = Loop.isMgmtPathRedundantForCntr_TEngine(context, cntrId)

        else:  # 其他型号暂不支持
            BaseFactory.log.error(context, "the sysType:%d of cntrid:%s is not supported." % (sysType, cntrId))
            isPass = False

        # 返回结果
        if False == isPass:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.PUBERR_REDT_MGMT_PATH_NOT_EXISTED)
        else:
            BaseFactory.result.setResultPass(context)
        return isPass

    # 18000V3标准组网下雨阵列连接的两个交换机端口
    MGMT_DSW_CTRL_PORTS = ["DSW0.MGMT.0", "DSW1.MGMT.1", ]
    # 18000V3标准组网下交换机相连的两个端口
    MGMT_DSW_DSW_PORTS = ["DSW1.MGMT.0", "DSW0.MGMT.1", ]

    # 18000V3管理板location所在子网末端交换机端口位置
    MGMT_DSW_PORT = {

        "SMM1": "DSW0.MGMT.0",
        "SMM0": "DSW1.MGMT.1",

    }

    MGMT_DSW_PORT_FOR_DORADO18000 = {

        "SMM1": "DSW1.MGMT.1",
        "SMM0": "DSW0.MGMT.0",

    }

    # 18000V3管理板location所在子网内部IP起始地址
    MGMT_BASEIP = {

        "SMM0": "172.16.193.%s",
        "SMM1": "172.16.192.%s",

    }

    # 18000V3内部IP末尾起始值
    MGMT_IP_TAIL_START = 200

    # 18000V3标准组网配置
    MGMT_PORT_CONFIG = {
        # 1引擎场景：
        "1": {
            "CTE0.SMM0.MGMT1": "SVP.P4",
            "CTE0.SMM1.MGMT1": "SVP.P3",
        },
        # 2引擎场景：
        "2": {
            "CTE0.SMM0.MGMT1": "CTE1.SMM0.MGMT2",
            "CTE0.SMM0.MGMT2": "DSW1.MGMT.1",
            "CTE1.SMM0.MGMT1": "SVP.P4",

            "CTE0.SMM1.MGMT1": "SVP.P3",
            "CTE0.SMM1.MGMT2": "CTE1.SMM1.MGMT1",
            "CTE1.SMM1.MGMT2": "DSW0.MGMT.0",

            "DSW0.MGMT.1": "DSW1.MGMT.0",

        },
        # 3引擎场景：
        "3": {
            "CTE0.SMM0.MGMT1": "CTE1.SMM0.MGMT2",
            "CTE0.SMM0.MGMT2": "DSW1.MGMT.1",
            "CTE1.SMM0.MGMT1": "CTE2.SMM0.MGMT2",
            "CTE2.SMM0.MGMT1": "SVP.P4",

            "CTE0.SMM1.MGMT1": "SVP.P3",
            "CTE0.SMM1.MGMT2": "CTE1.SMM1.MGMT1",
            "CTE1.SMM1.MGMT2": "CTE2.SMM1.MGMT1",
            "CTE2.SMM1.MGMT2": "DSW0.MGMT.0",

            "DSW0.MGMT.1": "DSW1.MGMT.0",

        },
        # 4引擎场景：
        "4": {
            "CTE0.SMM0.MGMT1": "CTE1.SMM0.MGMT2",
            "CTE0.SMM0.MGMT2": "DSW1.MGMT.1",
            "CTE1.SMM0.MGMT1": "CTE2.SMM0.MGMT2",
            "CTE2.SMM0.MGMT1": "CTE3.SMM0.MGMT2",
            "CTE3.SMM0.MGMT1": "SVP.P4",

            "CTE0.SMM1.MGMT1": "SVP.P3",
            "CTE0.SMM1.MGMT2": "CTE1.SMM1.MGMT1",
            "CTE1.SMM1.MGMT2": "CTE2.SMM1.MGMT1",
            "CTE2.SMM1.MGMT2": "CTE3.SMM1.MGMT1",
            "CTE3.SMM1.MGMT2": "DSW0.MGMT.0",

            "DSW0.MGMT.1": "DSW1.MGMT.0",
        }
    }
    # 18000V3标准组网配置
    MGMT_PORT_CONFIG_DORADO18000 = {
        "CTE0.SMM0.MGMT2": "CTE1.SMM0.MGMT1",
        "CTE1.SMM0.MGMT2": "DSW0.MGMT.0",
        "DSW0.MGMT.1": "DSW1.MGMT.0",

        "DSW1.MGMT.1": "CTE0.SMM1.MGMT2",
        "CTE0.SMM1.MGMT1": "CTE1.SMM1.MGMT2",
    }

    # DORADO5000V3 NVMe标准组网配置
    DORADO5000_NVME_MGMT_PORT_CONFIG = {
        "4": {
            "CTE1.B.MGMT1": "CTE0.B.MGMT0",
            "CTE0.B.MGMT1": "DSW1.MGMT.1",
            "DSW1.MGMT.0": "DSW0.MGMT.1",
            "DSW0.MGMT.0": "CTE1.A.MGMT1",
            "CTE1.A.MGMT0": "CTE0.A.MGMT1",
        }
    }

    # DORADOV3中低端标准组网配置（不同控制器数量）
    DORADO_LOW_MIDDLE_MGMT_PORT_CONFIG = {
        "Dorado3000 V3": {
            "4": {
                "CTE1.B.MAINTENANCE": "CTE0.B.MGMT",
                "CTE0.B.MAINTENANCE": "DSW1.MGMT.1",
                "DSW1.MGMT.0": "DSW0.MGMT.1",
                "DSW0.MGMT.0": "CTE1.A.MAINTENANCE",
                "CTE1.A.MGMT": "CTE0.A.MAINTENANCE",
            },
        },
        "Dorado5000 V3": {
            "4": {
                "CTE1.B.MAINTENANCE": "CTE0.B.MGMT",
                "CTE0.B.MAINTENANCE": "DSW1.MGMT.1",
                "DSW1.MGMT.0": "DSW0.MGMT.1",
                "DSW0.MGMT.0": "CTE1.A.MAINTENANCE",
                "CTE1.A.MGMT": "CTE0.A.MAINTENANCE",
            },
        },
        "Dorado6000 V3": {
            "4": {
                "CTE1.SMM1.MAINTENANCE": "CTE0.SMM1.MGMT",
                "CTE0.SMM1.MAINTENANCE": "DSW1.MGMT.1",
                "DSW1.MGMT.0": "DSW0.MGMT.1",
                "DSW0.MGMT.0": "CTE1.SMM0.MAINTENANCE",
                "CTE1.SMM0.MGMT": "CTE0.SMM0.MAINTENANCE",
            },
            "6": {
                "CTE2.SMM1.MAINTENANCE": "CTE1.SMM1.MGMT",
                "CTE1.SMM1.MAINTENANCE": "CTE0.SMM1.MGMT",
                "CTE0.SMM1.MAINTENANCE": "DSW1.MGMT.1",
                "DSW1.MGMT.0": "DSW0.MGMT.1",
                "DSW0.MGMT.0": "CTE2.SMM0.MAINTENANCE",
                "CTE2.SMM0.MGMT": "CTE1.SMM0.MAINTENANCE",
                "CTE1.SMM0.MGMT": "CTE0.SMM0.MAINTENANCE",
            },
            "8": {
                "CTE3.SMM1.MAINTENANCE": "CTE2.SMM1.MGMT",
                "CTE2.SMM1.MAINTENANCE": "CTE1.SMM1.MGMT",
                "CTE1.SMM1.MAINTENANCE": "CTE0.SMM1.MGMT",
                "CTE0.SMM1.MAINTENANCE": "DSW1.MGMT.1",
                "DSW1.MGMT.0": "DSW0.MGMT.1",
                "DSW0.MGMT.0": "CTE3.SMM0.MAINTENANCE",
                "CTE3.SMM0.MGMT": "CTE2.SMM0.MAINTENANCE",
                "CTE2.SMM0.MGMT": "CTE1.SMM0.MAINTENANCE",
                "CTE1.SMM0.MGMT": "CTE0.SMM0.MAINTENANCE",
            },

        },
    }

    # dorado设备不同标准组网下与管理主机端口相连的端口
    MGMT_PORT_CONFIG_DORADO5000_NVME_HOST = {
        "2": ["CTE0.A.MGMT0", "CTE0.B.MGMT0"],
        "4": ["CTE0.A.MGMT0", "CTE1.B.MGMT0"],
    }

    MGMT_PORT_CONFIG_DORADO_HOST = {
        "dorado_high_end": {
            "2": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0"],
            "4": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0"],
            "6": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0", "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0"],
            "8": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0", "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0"],
        },
        "kunpeng_high_end": {
            "2": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0"],
            "4": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0"],
            "6": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0", "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0"],
            "8": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0", "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0"],
        }
    }

    '''
    Function：检查管理网口是否可达

    params:
        context=工具上下文
        mgmtRec=管理口
    Return: 指定管理网口是否能ping通：True/False
    '''

    @staticmethod
    def isMgmtPortReachable(context, mgmtRec):
        try:
            portLoc = restUtil.Tlv2Rest.getRecordValue(mgmtRec, restData.Hardware.EthPort.LOCATION)
            portIpv4 = restUtil.Tlv2Rest.getRecordValue(mgmtRec, restData.Hardware.EthPort.IPV4_ADDR)
            if "" != portIpv4 and True == Loop.isIpReachable(portIpv4):
                BaseFactory.log.info(context, "the mgmt port %s(%s) is reachable, redundant host link existed."
                                     % (portLoc, portIpv4))
                return True

            portIpv6 = restUtil.Tlv2Rest.getRecordValue(mgmtRec, restData.Hardware.EthPort.IPV6_ADDR)
            if "" != portIpv6 and True == Loop.isIpReachable(portIpv6):
                BaseFactory.log.info(context, "the mgmt port %s(%s) is reachable, redundant host link existed."
                                     % (portLoc, portIpv6))
                return True

        except Exception as e:  # Ping出错不处理
            BaseFactory.log.error(context, "Ping exception: %s" % e)

        return False

    @staticmethod
    def isMgmtPortStatusNormal(context, mgmtRec):
        """检查指定管理口的状态是否正常（间接检查端口是否冗余）
        
        :param context:
        :param mgmtRec:
        :return:
        """
        try:
            portLoc = restUtil.Tlv2Rest.getRecordValue(mgmtRec, restData.Hardware.EthPort.LOCATION)
            healSta = restUtil.Tlv2Rest.getRecordValue(mgmtRec, restData.Hardware.EthPort.HEALTH_STATUS)
            runSta = restUtil.Tlv2Rest.getRecordValue(mgmtRec, restData.Hardware.EthPort.RUNNING_STATUS)
            if healSta != restData.Enum.HealthStatusEnum.NORMAL and runSta != restData.Enum.RunningStatusEnum.LINK_UP:
                BaseFactory.log.info(context,
                                     "the mgmt port:%(portLoc)s status:%(healSta)s, %(runSta)s is not normal."
                                     % {'portLoc': portLoc, 'healSta': healSta, 'runSta': runSta})
                return False
        except Exception as e:
            BaseFactory.log.error(context, "Check mgt port status exception: %s" % e)
        return True

    '''
    Function：获取对应的子网   SMM0->SMM1，SMM1->SMM0   
    '''

    @staticmethod
    def getAnotherSubnet(context, mgmtPlane):

        if mgmtPlane.__contains__("0"):
            return mgmtPlane.replace("0", "1")
        else:
            return mgmtPlane.replace("1", "0")

    ________IPSCALEOUT_CHECK_ZONE________ = None

    '''
    Function：获取指定IP scale-out接口卡信息
    params:
        context=工具上下文
        intfId=接口卡信息
    Return: 接口卡的的信息
    Attention 1: 该方法仅能用于IP scale-out接口卡，在控制器离线后至复位前这段时间使用
    Attention 2: 查询信息中，当接口卡信息有效时，会返回信息；若接口卡信息无法获取，则返回信息中将健康和运行状态设置为UNKNOWN
    '''

    @staticmethod
    def getIpScaleOutIntfInfo(context, intfId):
        # 参数检查
        if None == intfId or "" == intfId:
            BaseFactory.log.error(context, "the intfId:%s is invalid." % intfId)
            return None

        # 查询信息
        param0 = (restData.PublicAttributes.TYPE, restData.Enum.ObjEnum.INTF_MODULE)
        param1 = (restData.PublicAttributes.ID, intfId)
        paramlist = restUtil.Tlv2Rest.getParamList(param0, param1)
        rest = contextUtil.getRest(context)
        rec = restUtil.Tlv2Rest.execCmd(rest, restData.TlvCmd.GET_INTF_MODULE_STATUS, paramlist, False)

        # 设置返回值
        if None == rec:
            fruInfo = restUtil.Tlv2Rest.getStr(context, restData.EnumStr.StrObjEnum,
                                               restData.Enum.ObjEnum.INTF_MODULE) + "(ID:" + str(intfId) + ")"
            BaseFactory.log.error(context, u"获取信息失败。请确认" + fruInfo + u"是否存在。")
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.FUNC_GET_INFO_Y_FAIL, None, fruInfo)
        return rec

    '''
    Function：获取所有IP Scale Out端口信息列表
    params:
        context=工具上下文
    Return: 所有IP Scale Out端口信息列表
    '''

    @staticmethod
    def getAllIpScaleOutPortList(context, conditions=None):
        allEthPortList = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.PortLogicTypeEnum.IP_SCALE_OUT)
        conditionArr = []
        if conditions:
            if isinstance(conditions, list):
                conditionArr = conditions.append(condition0)
            else:
                conditionArr = [condition0, conditions]
        else:
            conditionArr.append(condition0)
        return restUtil.Tlv2Rest.filter(allEthPortList, conditionArr)

    '''
    Function：获取所有连接正确的IP Scale Out端口信息列表
    params:
        context=工具上下文
    Return: 所有连接正确的IP Scale Out端口信息列表
    '''

    @staticmethod
    def getLinkRightIpScaleOutPortList(context):
        allEthPortList = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.ETH_PORT)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.PortLogicTypeEnum.IP_SCALE_OUT)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.LINK_UP)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
        return restUtil.Tlv2Rest.filter(allEthPortList, conditionList)

    '''
    Function：获取所有IP Scale Out用途的光模块
    params:
        context=工具上下文
        allFibremoudleRecs=系统中所有光模块记录
    Return: 所有IP Scale Out用途的光模块记录
    '''

    @staticmethod
    def getIpScaleOutFibreModuleList(context, allFibremoudleRecs=None):
        # 获取所有IP Scale-out端口的location
        portLocList = []
        tmpRecs = Loop.getAllIpScaleOutPortList(context)
        for fruRec in tmpRecs:
            loc = restUtil.Tlv2Rest.getRecordValue(fruRec, restData.Hardware.EthPort.LOCATION)
            if loc not in portLocList:
                portLocList.append(loc)

        # 筛选出所有IP Scale-out光模块（光模块和其所在端口的locaiton相同）
        if None == allFibremoudleRecs:
            allFibremoudleRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SFP_OPTICAL_TRANSCEIVER)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.SfpOpticalTransceiver.LOCATION,
                                                    restData.Enum.ConditionTypeEnum.EQOR, portLocList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        tmpRecs = restUtil.Tlv2Rest.filter(allFibremoudleRecs, conditionList)

        return tmpRecs

    '''
    Function：获取所有包含IP Scale Out端口的接口卡ID列表
    params:
        context=工具上下文
    Return: 所有真实连接的IP Scale Out交换机ID组成的列表
    '''

    @staticmethod
    def getIpScaleOutIntfIdList(context):
        # 获取所有与IP Scale Out交换机相连的ETH口信息
        intfLinkPortList = Loop.getAllIpScaleOutPortList(context)

        # 获取接口卡ID列表并返回
        intfIdList = []
        for portRec in intfLinkPortList:
            # 获取端口所属交换机ID，若ID有效，则记录
            intfId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.PARENT_ID)
            if intfId not in intfIdList:
                intfIdList.append(intfId)

        BaseFactory.log.info(context, "the ip scale-out intf id list is %s" % intfIdList)
        return intfIdList

    @staticmethod
    def getIpScaleOutIntfRecs(context):
        """获取所有包含IP Scale Out端口的接口卡ID列表

        :param context:
        :return:
        """

        fruList = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        intfIdList = Loop.getIpScaleOutIntfIdList(context)
        # 判断下电的卡是否为IP Scale Out卡
        intf_id_list = Loop.get_intf_id_on_powered_off(fruList)
        intfIdList.extend(intf_id_list)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.ID,
                                                    restData.Enum.ConditionTypeEnum.EQOR, intfIdList)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        return restUtil.Tlv2Rest.filter(fruList, conditionList)

    @staticmethod
    def get_intf_id_on_powered_off(fru_list):
        """
            获取已下电的接口卡
            :param fru_list:
            :return:
            """
        intf_id_list = []
        for fru_record in fru_list:
            running_status = restUtil.Tlv2Rest.getRecordValue(
                fru_record, restData.PublicAttributes.RUNNING_STATUS)
            intf_id = restUtil.Tlv2Rest.getRecordValue(
                fru_record, restData.PublicAttributes.ID)
            model = restUtil.Tlv2Rest.getRecordValue(
                fru_record, restData.Hardware.IntfModule.MODEL
            )
            if running_status == 2:
                continue
            if intf_id in intf_id_list:
                continue
            if model in restData.ip_scale_out_models:
                intf_id_list.append(intf_id)
        return intf_id_list

    @staticmethod
    def getIpScaleOutSwitchIdList(context, intfLinkPortList=None):
        """获取所有真实连接的IP Scale Out交换机ID

        :param context:工具上下文
        :param intfLinkPortList:
        :return: 所有真实连接的IP Scale Out交换机ID组成的列表
        """
        # 获取所有与IP Scale Out交换机相连的ETH口信息
        if None == intfLinkPortList:
            intfLinkPortList = Loop.getAllIpScaleOutPortList(context)

        # 获取交换机ID列表并返回
        dswIdList = []
        for portRec in intfLinkPortList:
            # 获取端口所属交换机ID，若ID有效，则记录
            dswId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.DSW_ID)
            if BaseFactory.const.INVALID_IPSCALEOUT_DSWID != dswId and dswId not in dswIdList:
                dswIdList.append(dswId)

        BaseFactory.log.info(context, "all existed dswId of ip scale-out port: %s" % dswIdList)
        return dswIdList

    '''
    Function：检查指定的IpScaleOut交换机上交换组网路径是否完整且正确
    params:
        context=工具上下文
        dswId=待检查的IpScaleOut交换机ID，如DSW0
        allPortRecs=None：所有ETH端口信息，默认为空
    Return: dswId上的IpScaleOut交换组网路径是否完整：True / False
    '''

    @staticmethod
    def checkIpScaleOutPathIntegrityForDsw(context, dswId):
        BaseFactory.log.info(context, "enter checkIpScaleOutPathIntegrityForDsw. dswId=" + dswId)

        # 获取所有与该交换机连接正确的ETH口
        allRightPortRecs = Loop.getLinkRightIpScaleOutPortList(context)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.DSW_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, dswId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        intfPortList = restUtil.Tlv2Rest.filter(allRightPortRecs, conditionList)

        # 遍历所有与交换机连接的ETH口，获取所有正确连接的控制器ID列表
        linkedCntrIdList = []
        for portRec in intfPortList:
            portId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.ID)
            cntrRec = FuncFactory.getFruParentRecord(context, restData.Enum.ObjEnum.ETH_PORT,
                                                     portId, restData.Enum.ObjEnum.CONTROLLER)
            if None != cntrRec:
                cntrId = restUtil.Tlv2Rest.getRecordValue(cntrRec, restData.Hardware.Controller.ID)
                linkedCntrIdList.append(cntrId)
            else:
                BaseFactory.log.error(context,
                                      "unexpected error: can not get owning cntr of ipscaleout port %s" % portId)
        BaseFactory.log.info(context, "linkedCntrIdList of dswId:%s is %s" % (dswId, linkedCntrIdList))

        ##检查是否交换机到所有正常控制器上均有连接
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Controller.HEALTH_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.HealthStatusEnum.NORMAL)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.Controller.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.ONLINE)
        normalCtrlIdList = FuncFactory.getCntrIdList(context, condition0, condition1)
        for cntrId in normalCtrlIdList:
            if cntrId not in linkedCntrIdList:
                BaseFactory.log.error(context,
                                      "linkedCntrIdList:%s NOT EQUAL normalCtrlIdList:%s, one or more cntr not connected."
                                      % (",".join(linkedCntrIdList), ",".join(normalCtrlIdList)))
                return False
            else:
                pass

        # 检查通过
        BaseFactory.log.info(context, "the ipscaleout path of dswId:%s is existed and correct, check passed." % dswId)
        return True

    '''
    Function：检查指定的IpScaleOut端口是否存在冗余IP scale-out路径
    params:
        context=工具上下文
        portId=待检查的IpScaleOut端口ID
    Return: 指定的IpScaleOut端口是否存在冗余IP scale-out路径
    '''

    @staticmethod
    def checkIpScaleOutPathRedundantForEthPort(context, portId, allIpScaleOutPortRecs=None):
        BaseFactory.log.info(context, "enter checkIpScaleOutPathRedundantForEthPort. portId=" + portId)

        # 获取端口相关信息
        if None == allIpScaleOutPortRecs:
            allIpScaleOutPortRecs = Loop.getAllIpScaleOutPortList(context)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, portId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
        tmpRecs = restUtil.Tlv2Rest.filter(allIpScaleOutPortRecs, conditionList)
        curPortRec = tmpRecs[0]
        location = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.EthPort.LOCATION)
        parentType = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.EthPort.PARENT_TYPE)
        parentId = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.EthPort.PARENT_ID)

        # 如果该端口未连接或连接不正确，则直接检查通过
        linkStatus = restUtil.Tlv2Rest.getRecordValue(curPortRec, restData.Hardware.EthPort.RUNNING_STATUS)
        if linkStatus != restData.Enum.RunningStatusEnum.LINK_UP:
            BaseFactory.log.info(context,
                                 "the port:{} is NOT LINK_UP:{}, check "
                                 "pass.".format(portId, linkStatus))
            BaseFactory.result.setResultPass(context)
            return True

        # 获取端口所在控制器下的所有ETH接口卡ID列表(预防后续一个控制器上多个接口卡用于Scale-out组网的情况)
        tmpRec = FuncFactory.getFruParentRecord(context, parentType, parentId,
                                                restData.Enum.ObjEnum.CONTROLLER)
        ownCntrId = restUtil.Tlv2Rest.getRecordValue(tmpRec, restData.Hardware.Controller.ID)
        allIntfRecs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.INTF_MODULE)
        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, ownCntrId)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        cntrIntfRecs = restUtil.Tlv2Rest.filter(allIntfRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, cntrIntfRecs, "intf id list of port-owned cntr %s" % ownCntrId)
        allCntrIntfIdList = []
        for intfRec in cntrIntfRecs:
            intfId = restUtil.Tlv2Rest.getRecordValue(intfRec, restData.Hardware.IntfModule.ID)
            if intfId not in allCntrIntfIdList:
                allCntrIntfIdList.append(intfId)
            else:
                pass

        # 获取当前控制器下的冗余IPScaleOut端口（冗余路径）信息
        condition0 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.EthPort.PARENT_ID,
            restData.Enum.ConditionTypeEnum.EQOR,
            allCntrIntfIdList)
        condition1 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.EthPort.RUNNING_STATUS,
            restData.Enum.ConditionTypeEnum.EQ,
            restData.Enum.RunningStatusEnum.LINK_UP)
        condition2 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.EthPort.LOCATION,
            restData.Enum.ConditionTypeEnum.NE,
            location)
        conditionList = restUtil.Tlv2Rest.getConditionList(
            condition0, condition1, condition2)
        otherLinkedPortRecs = restUtil.Tlv2Rest.filter(allIpScaleOutPortRecs,
                                                       conditionList)
        restUtil.Tlv2Rest.logRecList(context, otherLinkedPortRecs, "redundant cable port of %s:" % location)

        # 若冗余端口存在，则表示冗余路径存在，检查通过，否则不通过
        redPortNum = len(otherLinkedPortRecs)
        switchIdList = Loop.getIpScaleOutSwitchIdList(context)
        if 0 == len(switchIdList):  # 直连组网
            if redPortNum < 3:  # 必须存在三个冗余端口连接，否则报错
                BaseFactory.log.error(context,
                                      "direct link. the redundant ip scale-out path(num:%d) of port:%s is INEXISTED."
                                      % (redPortNum, location))
                BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.IPSCALEOUT_CABLE_X_RED_PATH_INEXIST,
                                                      location)
                return False
        else:  # 交换组网
            if redPortNum < 1:  # 必须存在一个冗余端口连接，无冗余则报错
                BaseFactory.log.error(context,
                                      "dsw link. the redundant ip scale-out path(num:%d) of port:%s is INEXISTED since no red linked port."
                                      % (redPortNum, location))
                BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.IPSCALEOUT_CABLE_X_RED_PATH_INEXIST,
                                                      location)
                return False
            else:  # 存在冗余时，需判断冗余端口上的IP scale-out路径是否完整
                isRedExisted = False
                for portRec in otherLinkedPortRecs:
                    tmpPortId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.ID)
                    tmpDswId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.DSW_ID)
                    if True == Loop.checkIpScaleOutPathIntegrityForDsw(context, tmpDswId):
                        BaseFactory.log.info(context,
                                             "the ip scale-out path of port:%s's owned dsw is integrity." % tmpPortId)
                        isRedExisted = True
                        break
                    else:
                        BaseFactory.log.info(context,
                                             "the ip scale-out path of port:%s's owned dsw is NOT integrity." % tmpPortId)
                # 如果所有冗余端口上均不存在完整路径，则检查不通过
                if False == isRedExisted:
                    BaseFactory.log.error(context,
                                          "dsw link. the redundant ip scale-out path(num:%d) of port:%s is INEXISTED since no integerity dsw link."
                                          % (redPortNum, location))
                    BaseFactory.result.setResultFailByKey(context,
                                                          FuncFactory.LangKey.IPSCALEOUT_CABLE_X_RED_PATH_INEXIST,
                                                          location)
                    return False

        # 检查通过
        BaseFactory.log.info(context, "the redundant ip scale-out path of port:%s is EXISTED." % location)
        BaseFactory.result.setResultPass(context)
        return True

    @staticmethod
    def checkDirectConnectRedundantPath(otherLinkedPortRecs, location):
        '''
        @summary: ipscaleOut直连组网（检查冗余路径是否存在）
        @return: True 存在冗余
            False 不存在冗余
        '''
        portLoc = location.split(".")[-1]
        redPortLoc = config.IpScaleOutDirectConnectRedundantPortPair.get(portLoc, None)
        if redPortLoc is None:
            return False

        redundantPortLocation = location.replace(portLoc, redPortLoc)
        for port in otherLinkedPortRecs:
            if redundantPortLocation == restUtil.Tlv2Rest.getRecordValue(port, restData.Hardware.EthPort.LOCATION):
                return True
        return False

    @staticmethod
    def isIpScaleOutPort(context, location):
        '''
        @summary:  取得IPScaleOut端口location列表
        @param context:上下文
        @return: IPScaleOut端口location列表
        '''
        fruList = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.SFP_OPTICAL_TRANSCEIVER)
        ipscaleoutRecs = Loop.getIpScaleOutFibreModuleList(context, fruList)
        ipscaleoutLocList = []
        for tmpRec in ipscaleoutRecs:
            loc = restUtil.Tlv2Rest.getRecordValue(tmpRec, restData.Hardware.SfpOpticalTransceiver.LOCATION)
            ipscaleoutLocList.append(loc)

        return location in ipscaleoutLocList

    '''
    Function：检查指定的IpScaleOut接口卡是否存在冗余的交换组网路径
    params:
        context=工具上下文
        cntrId=待检查的IpScaleOut接口卡所在的控制器ID
        intfId=待检查的IpScaleOut接口卡ID
    Return: intfId是否存在冗余的IpScaleOut交换组网路径
    '''

    @staticmethod
    def checkIpScaleOutPathRedundantForIntf(context, cntrId, intfId):
        BaseFactory.log.info(context, "enter checkIpScaleOutPathRedundantForIntf. cntrId=%s, intfId=%s"
                             % (cntrId, intfId))

        # 获取冗余控制器ID
        tmpRecs = FuncFactory.getUsableRedCntr(context, cntrId)
        if None == tmpRecs:
            BaseFactory.log.info(context, "the redundant cntr of intf:%s's owned cntr:%s is INEXISTED."
                                 % (intfId, cntrId))
            return False
        redCntrId = restUtil.Tlv2Rest.getRecordValue(tmpRecs[0], restData.PublicAttributes.ID)

        # 获取冗余控制器上的IpScaleOut接口卡信息
        fruList = Loop.getIpScaleOutIntfRecs(context)
        condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.PARENT_ID,
                                                    restData.Enum.ConditionTypeEnum.EQ, redCntrId)
        condition2 = restUtil.Tlv2Rest.getCondition(restData.Hardware.IntfModule.RUNNING_STATUS,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.RunningStatusEnum.RUNNING)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition1, condition2)
        fruList = restUtil.Tlv2Rest.filter(fruList, conditionList)
        restUtil.Tlv2Rest.logRecList(context, fruList, "redundant intf cards:")

        # 如果冗余接口卡不存在，则报错；否则检查其上的交换组网链路是否完整
        if len(fruList) > 0:
            isRedExisted = False
            for redIntfRec in fruList:
                redIntfId = restUtil.Tlv2Rest.getRecordValue(redIntfRec, restData.PublicAttributes.ID)
                if True == Loop.checkIpScaleOutPathIntegrityForIntf(context, redIntfId):
                    BaseFactory.log.info(context, "the redIntfId:%s existed redundant path." % redIntfId)
                    isRedExisted = True
                    break
                else:
                    pass
            # 如果所有冗余接口卡下均无冗余路径，则检查不通过
            if False == isRedExisted:
                BaseFactory.log.error(context,
                                      "the redundant intf path of intfId:%s is not integerity. check fail." % intfId)
                return False
        else:
            BaseFactory.log.error(context, "no redundant intf of intfId:%s existed. check fail." % intfId)
            return False

        # 存在冗余路径，检查通过
        BaseFactory.log.info(context, "the redundant path of intf %s is existed and correct. check pass." % intfId)
        return True

    @staticmethod
    def getIpScaleOutPortForIntf(context, intfId):
        # 参数检查
        if None == intfId or "" == intfId:
            BaseFactory.log.error(context, "the intfId:%s is invalid." % intfId)
            return None

        # 查询接口卡下的端口信息并返回
        param0 = (restData.PublicAttributes.TYPE, restData.Enum.ObjEnum.ETH_PORT)
        param1 = (restData.PublicAttributes.PARENT_TYPE, restData.Enum.ObjEnum.INTF_MODULE)
        param2 = (restData.PublicAttributes.PARENT_ID, intfId)
        paramlist = restUtil.Tlv2Rest.getParamList(param0, param1, param2)
        rest = contextUtil.getRest(context)
        # TODO
        portRecs = restUtil.Tlv2Rest.execCmd(rest, restData.TlvCmd.GET_ALL_PORTS_BY_INTF_SLOT, paramlist)
        restUtil.Tlv2Rest.logRecList(context, portRecs, "all ports under intfId %s" % intfId)

        condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.LOGIC_TYPE,
                                                    restData.Enum.ConditionTypeEnum.EQ,
                                                    restData.Enum.PortLogicTypeEnum.IP_SCALE_OUT)
        conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
        portRecs = restUtil.Tlv2Rest.filter(portRecs, conditionList)
        restUtil.Tlv2Rest.logRecList(context, portRecs, "all ip scale-out ports under intfId %s" % intfId)

        return portRecs

    '''
    Function：检查指定的IpScaleOut接口卡上交换组网路径是否完整且正确
    params:
        context=工具上下文
        intfId=待检查的IpScaleOut接口卡ID
    Return: intfId上的IpScaleOut交换组网路径是否完整：True / False
    '''

    @staticmethod
    def checkIpScaleOutPathIntegrityForIntf(context, intfId):
        BaseFactory.log.info(context, "enter checkIpScaleOutPathIntegrityForIntf. intfId=" + intfId)

        # 获取所有属于该接口卡的连接正确的IP Scale-out端口信息
        # 直接通过接口卡的专属接口进行获取，以兼容更换的控制器离线后无法获取端口信息的问题

        DEFAULT_TIMEOUT = 300  # 超时时间：秒
        startTime = time.time()
        tmpException = None
        curIntfPortRecs = None
        while True:
            # 检查是否超时
            if time.time() - startTime > DEFAULT_TIMEOUT:
                # 超时时，如果存在异常则抛出，否则报错
                if None != tmpException:
                    raise tmpException  # @IGNORE:E0702
                else:
                    BaseFactory.log.error(context,
                                          "the link right less than 2, check fail.")
                    return False

            # 检查接口卡是否恢复正常
            try:
                tmpException = None
                # 调用专用查询接口，获取接口卡信息
                curIntfPortRecs = Loop.getIpScaleOutPortForIntf(context, intfId)
                if len(curIntfPortRecs) < 2:
                    # 未查到卡上全部2个端口信息
                    time.sleep(60)
                else:
                    condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                                restData.Enum.ConditionTypeEnum.EQ,
                                                                restData.Enum.RunningStatusEnum.LINK_UP)
                    conditionList = restUtil.Tlv2Rest.getConditionList(condition0)
                    rightPortRecs = restUtil.Tlv2Rest.filter(curIntfPortRecs, conditionList)
                    restUtil.Tlv2Rest.logRecList(context, rightPortRecs, "link right ports under card %s:" % intfId)
                    redPortNum = len(rightPortRecs)
                    if redPortNum < 2:
                        BaseFactory.log.error(context,
                                              "the num of link right ports is %d, that less than 2, sleep 60s." % redPortNum)
                        time.sleep(60)
                    else:
                        break
            except Exception as ex:
                tmpException = ex
                # 60秒后重试
                time.sleep(60)

        # 依据组网类型分别检查交换组网路径的完整性
        allDswIdList = Loop.getIpScaleOutSwitchIdList(context, curIntfPortRecs)
        if len(allDswIdList) > 0:  # 交换机组网
            # 交换机数量不为2个时，检查不通过
            if len(allDswIdList) != 2:
                BaseFactory.log.error(context,
                                      "allDswIdList=%s, the dsw num is not equal 2, check fail." % allDswIdList)
                return False

            # 获取所有已连接的交换机ID列表
            linkedDswIdList = []
            for portRec in rightPortRecs:
                dswId = restUtil.Tlv2Rest.getRecordValue(portRec, restData.Hardware.EthPort.DSW_ID)
                if str(FuncFactory.FRUCONST.IP_SCALE_OUT_PORT_LINK_INVALID) != dswId and \
                        dswId not in linkedDswIdList:
                    linkedDswIdList.append(dswId)
                else:
                    pass

            # 若存在交换机未连接，则报错
            for dswId in allDswIdList:
                if dswId not in linkedDswIdList:
                    BaseFactory.log.error(context,
                                          "allDswIdList=%s, linkedDswIdList=%s, not all dsw linked by red intf, check fail."
                                          % (str(allDswIdList), str(linkedDswIdList)))
                    return False
                else:
                    pass

        else:  # 直连组网，无交换机
            # 直连组网时，要求接口卡上的全部端口均要连接正确（兼容2端口和4端口场景）
            required_link_port_num = 4 if len(curIntfPortRecs) > 2 else 2
            if redPortNum < required_link_port_num:
                BaseFactory.log.error(context,
                                      "the linked right port num of red intf is %d, that less than 4, check fail."
                                      % redPortNum)
                return False
            else:
                pass

        # 检查通过
        BaseFactory.log.info(context,
                             "the ipscaleout path of intfId:%s is existed and correct, check passed." % intfId)
        return True

    # IP scale-out集群下的管理网线完整性判断
    # 集群环境时，当整个集群中至少有两条管理网线连接且可达，即可认为完整。
    @staticmethod
    def checkMgmtCableIntegrityForIPscaleoutCluster(context):

        # 轮询判断完整性
        beginTime = time.time()
        while True:
            # 获取集群中已连接的管理口
            ethPorts = FuncFactory.getAllMgmtPortRecord(context)
            condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                                        restData.Enum.ConditionTypeEnum.EQ,
                                                        restData.Enum.RunningStatusEnum.LINK_UP)
            conditionList = restUtil.Tlv2Rest.getConditionList(condition1)
            ethPorts = restUtil.Tlv2Rest.filter(ethPorts, conditionList)
            restUtil.Tlv2Rest.logRecList(context, ethPorts, "all LINK_UP mgmt ports as follows:")

            # 获取集群中IP可达的管理口IP
            usableIpList = []
            for portRec in ethPorts:
                curIp = Loop.getReachableIp(context, portRec)
                if None != curIp and curIp not in usableIpList:
                    usableIpList.append(curIp)
                else:
                    pass

            # 判断管理网线是否完整
            BaseFactory.log.info(context, "multi enc: usableIpList=%s" % usableIpList)
            if len(usableIpList) >= FuncFactory.FRUCONST.IP_SCALE_OUT_MGMT_CABLE_MIN_NUM:
                break
            else:  # 到超时时，若集群的有效管理网线数量仍小于2，则返回错误
                if time.time() - beginTime < 90:
                    time.sleep(5)
                    continue
                BaseFactory.result.setResultFailByKey(context,
                                                      FuncFactory.LangKey.CABMGMT_IP_CLUSTER_MUST_CONTAINS_TWO_NORMAL_MGMT_CABLE)
                return

        # 检查通过
        BaseFactory.result.setResultPass(context)
        return

    @staticmethod
    def filterNeedLinkSasPortDict(sortedAllSasPortRecs, needLinkSasPortDict):
        sasPortRecsLocation = []
        filterNeedLinkSasPortDict = needLinkSasPortDict
        for sasPortRec in sortedAllSasPortRecs:
            startPortLoc = restUtil.Tlv2Rest.getRecordValue(sasPortRec, restData.Hardware.SasPort.LOCATION)
            sasPortRecsLocation.append(startPortLoc)
        for needLinkSasPort in needLinkSasPortDict.keys():
            if needLinkSasPort not in sasPortRecsLocation:
                filterNeedLinkSasPortDict.pop(needLinkSasPort)
        return filterNeedLinkSasPortDict

    @staticmethod
    def reversalDict(dict):
        for (key, value) in dict.items():
            dict.setdefault(value, key)
        return dict

    @staticmethod
    def get_normal_fru_by_type(context, fru_type):
        """获取正常的备件

        :param context: 上下文
        :param fru_type: 备件类型
        :return:
        """
        fru_infos = FuncFactory.getFruListInfo(context, fru_type)
        condition_0 = restUtil.Tlv2Rest.getCondition(
            restData.PublicAttributes.HEALTH_STATUS,
            restData.Enum.ConditionTypeEnum.EQ,
            restData.Enum.HealthStatusEnum.NORMAL)
        condition_1 = restUtil.Tlv2Rest.getCondition(
            restData.PublicAttributes.RUNNING_STATUS,
            restData.Enum.ConditionTypeEnum.EQ,
            restData.Enum.RunningStatusEnum.ONLINE)
        conditions = restUtil.Tlv2Rest.getConditionList(
            condition_0, condition_1)
        normal_fru_infos = restUtil.Tlv2Rest.filter(
            fru_infos, conditions)
        return normal_fru_infos

    @staticmethod
    def is_connect_with_all_fru(ports_connect_dsw, normal_parent_type_fru):
        """检查端口是否与所有控制器或者控制框相连

        :param ports_connect_dsw: 与交换机相连的端口
        :param normal_parent_type_fru: 控制器或者交换机列表
        :return:
        """
        for fru_info in normal_parent_type_fru:
            fru_location = restUtil.Tlv2Rest.getRecordValue(
                fru_info, restData.PublicAttributes.LOCATION)
            flag = False
            for port_info in ports_connect_dsw:
                port_location = restUtil.Tlv2Rest.getRecordValue(
                    port_info, restData.PublicAttributes.LOCATION)
                if port_location.startswith(fru_location):
                    flag = True
                    break
            if not flag:
                return False
        return True

    @staticmethod
    def is_connect_correct(context, ports_connect_dsw):
        """检查端口是否正确连接

        :param context: 环境变量
        :param ports_connect_dsw: 与交换机相连的端口
        :return:
        """
        rest = contextUtil.getRest(context)
        alarm_infos = restUtil.CommonRest.get_alarms_by_period(rest)
        ALARM_ID_LIST = ["64424902697", "64424902698"]
        for alarm_info in alarm_infos:
            alarm_id = restUtil.CommonRest.getRecordValue(
                alarm_info, restData.RestCfg.Alarm.EVENTID)
            alarm_parmas = restUtil.CommonRest.getRecordValue(
                alarm_info, restData.RestCfg.Alarm.EVENTPARAM)
            if alarm_id in ALARM_ID_LIST:
                for port_info in ports_connect_dsw:
                    port_location = restUtil.Tlv2Rest.getRecordValue(
                        port_info, restData.PublicAttributes.LOCATION)
                    if port_location in alarm_parmas:
                        return False
        return True

    @staticmethod
    def is_link_normal_for_dsw(context, dsw_id):
        """检查交换机的链路是否正常

        :param context: 环境变量
        :param dsw_id: 交换机ID
        :return:
        """
        BaseFactory.log.info(
            context, "is_link_normal_for_dsw: " + dsw_id)
        # 获取所有与该交换机连接正确的ETH口
        all_right_port_recs = Loop.getLinkRightIpScaleOutPortList(context)
        condition1 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.EthPort.DSW_ID,
            restData.Enum.ConditionTypeEnum.EQ, dsw_id)
        conditions = restUtil.Tlv2Rest.getConditionList(condition1)
        ports_connect_dsw = restUtil.Tlv2Rest.filter(
            all_right_port_recs, conditions)
        # 没有与交换机连接的ETH口 说明交换机链路有问题
        if not ports_connect_dsw:
            return False

        # 检查端口正常性
        if not checkRedundantSwitch\
                .check_port_for_all_type(context, all_right_port_recs,
                                         ports_connect_dsw):
            return False

        # 检查是否有关于ETH口的告警
        if not Loop.is_connect_correct(context, ports_connect_dsw):
            return False

        return True
