# -*- coding: UTF-8 -*-
import time

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import config
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

PERSIST_START_CHECK_TIME = "START_CHECK_TIME"  # 健康状态开始检查的时间


def execute(context, **kwargs):
    """IP级联模块状态检查
    检查级联模块的健康状态是否正常。

    :param context(dict): python执行上下文
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """

    start_time = time.time()

    try:
        BaseFactory.log.info(context, u"==========begin-expBoard-postcheck-checkHealthStatus==========")
        expModuleId = kwargs.get("expModuleId", "") if kwargs else ""
        if expModuleId:
            FuncFactory.isReplacedFruNormal(context, restData.Enum.ObjEnum.EXPBOARD, expModuleId)
            return
        else:
            do_check(context, start_time)

    except Exception as ex:
        raise ex


def do_check(context, start_time):
    recs = None
    while time.time() - start_time < config.IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS:
        show_ui(context, start_time, config.IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS)
        allFruList = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.EXPBOARD)
        recs = list(filter(lambda rec:
                           not checkExpStatus(rec), allFruList))
        if not recs:
            show_ui(context, start_time, config.IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS)
            BaseFactory.result.setResultPass(context)
            return
        time.sleep(30)
    process_abnormal(context, recs, start_time)


def process_abnormal(context, recs, start_time):
    fruInfo = restUtil.Tlv2Rest.getStr(context, restData.EnumStr.StrObjEnum,
                                       restData.Enum.ObjEnum.EXPBOARD)
    locations = list(map(
        lambda rec: restUtil.Tlv2Rest.getRecordValue(
            rec, restData.PublicAttributes.LOCATION), recs))
    if locations:
        fruInfo = "%s(%s)" % (fruInfo, ",".join(locations))
    show_ui(context, start_time, config.IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS)
    BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.EXPBOARD_ABNORMAL, fruInfo)


def show_ui(context, startTime, totalTime):

    '''
    @summary: 界面剩余时间展示
    @param context: 上下文对象
    @param startTime: 开始时间
    @param totalTime: 总时间
    '''

    useTime = time.time() - startTime
    curProgressPer = int((useTime / (totalTime)) * 100)
    remainTime = int(totalTime - useTime)

    if curProgressPer < 0 or curProgressPer > 100:
        curProgressPer = 100
    if remainTime < 0:
        remainTime = 0
    if curProgressPer == 100:
        remainTime = 0
    context["curProgressPer"] = curProgressPer
    context["remainTime"] = remainTime
    return


def checkExpStatus(rec):

    '''
    @summary: 检查级联板状态
    @param rec:
    '''

    healthStat = restUtil.Tlv2Rest.getRecordValue(rec, restData.PublicAttributes.HEALTH_STATUS)
    runningStat = restUtil.Tlv2Rest.getRecordValue(rec, restData.PublicAttributes.RUNNING_STATUS)
    if healthStat != restData.Enum.HealthStatusEnum.NORMAL or runningStat != restData.Enum.RunningStatusEnum.RUNNING:
        return False
    return True
