﻿# -*- coding: UTF-8 -*-
import time

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.common.conf.productConfig import PORTS_TOTAL_TIME_SECS
from cbb.common.conf.productConfig import LOOP_CHECK_PORTS_TIME_SECS
from cbb.frame.base import funcUtils
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil


# 前端端口保存key值
ALL_FRONT_PORTS = "allFrontPorts"

# 检查的前端端口
FRONT_PORTS_LIST = [
    restData.Enum.ObjEnum.ETH_PORT,
    restData.Enum.ObjEnum.FC_PORT,
]

FRONT_PORTS_LIST_FOR_COMPUTE = [
    restData.Enum.ObjEnum.ETH_PORT,
]


@funcUtils.fakeProgress(PORTS_TOTAL_TIME_SECS)
def execute(context, **kwargs):
    """前端端口状态收集
    获取前端端口状态信息

    :param context: python执行上下文
    :param kwargs: 可变参数dict
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """
    if kwargs.get("preCheck", False):
        currentInteLinkedPort = getAllCurFrontPorts(context)

        BaseFactory.log.info(context,
                             "frontPortsInfo :%s" % str(
                                 currentInteLinkedPort))
        BaseFactory.persist.setModule(context,
                                      ALL_FRONT_PORTS,
                                      currentInteLinkedPort)
        BaseFactory.result.setResultPass(context)
        return
    else:
        BaseFactory.log.info(context, "====Check Font Port==== begin")

        linkedPortsBefore = BaseFactory.persist.getModule(context,
                                                          ALL_FRONT_PORTS)
        BaseFactory.log.info(context,
                             "allFrontPorts before :"
                             "%s" % str(linkedPortsBefore))

        # 更换前已连接但更换后未连接的端口位置
        linkDownPortsLocation = []
        start_time = time.time()
        while (time.time() - start_time) <= LOOP_CHECK_PORTS_TIME_SECS:
            linkedPorts = getAllCurFrontPorts(context)
            BaseFactory.log.info(context,
                                 "allFrontPorts after :%s" % str(linkedPorts))

            linkDownPortsLocation = [portId for portId in linkedPortsBefore
                                     if portId not in linkedPorts]
            # 更换前后端口状态一直，直接通过
            if not linkDownPortsLocation:
                BaseFactory.result.setResultPass(context)
                BaseFactory.log.info(context,
                                     "====Check Font Port==== pass end")
                return
            # 否则睡眠5秒继续轮询端口信息
            time.sleep(5)

        # 轮询超时端口都未一直，则不通过
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.FRONTINTF_PORT_CHECK_CONSISTENT,
            ", ".join(linkDownPortsLocation))
        BaseFactory.log.info(context, "====Check Font Port==== fail end")
        return


def getAllCurFrontPorts(context):
    """获取当前所有linkup的前端端口location

    :param context:
    :return:
    """
    currentInteLinkedPort = []
    front_port_list = FRONT_PORTS_LIST
    if baseUtil.is_computing_dev(contextUtil.getProductModel(context)):
        front_port_list = FRONT_PORTS_LIST_FOR_COMPUTE
    for objType in front_port_list:
        linkedPortRecs = getPort(context, objType)
        locs = map(lambda x: restUtil.Tlv2Rest.getRecordValue(
            x, restData.PublicAttributes.LOCATION), linkedPortRecs)
        if locs:
            currentInteLinkedPort.extend(locs)
    return currentInteLinkedPort


def getPort(context, type):
    """获取linkup的前端端口记录

    :param context:
    :param type:
    :return:
    """
    ports = FuncFactory.getFruListInfo(context, type)
    condition0 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.EthPort.LOGIC_TYPE,
        restData.Enum.ConditionTypeEnum.EQOR,
        [restData.Enum.PortLogicTypeEnum.HOST,
         restData.Enum.PortLogicTypeEnum.SWITCH,
         restData.Enum.PortLogicTypeEnum.FRONT_CONTAINER_CARD])
    condition1 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.EthPort.RUNNING_STATUS,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.RunningStatusEnum.LINK_UP)
    conditions = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
    ports = restUtil.Tlv2Rest.filter(ports, conditions)
    return ports if ports else []
