﻿# -*- coding: UTF-8 -*-
import time

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common.LoopCheckFactory import Loop
from cbb.common.conf.productConfig import PORTS_TOTAL_TIME_SECS
from cbb.common.conf.productConfig import LOOP_CHECK_PORTS_TIME_SECS
from cbb.frame.base import funcUtils
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

ALL_NORMAL_IPSCALEOUT_PORT = "allNormalIPScaleoutPort"

# 不通过的错误提示
ERR_MSG_LANG_KEY =\
    FuncFactory.LangKey.IPSCALEOUT_INTF_INCONSITANT_IPSCALEOUT_PORT_INFO


@funcUtils.fakeProgress(PORTS_TOTAL_TIME_SECS)
def execute(context, preCheck=True):
    """检查IP Scale out端口状态更换前后是否一致

    :param context: python执行上下文
    :param preCheck: True - 更换前检查  False - 更换后检查
    :return:
    """
    # 更换前备份信息
    if preCheck:
        # ip scaleout端口信息
        normalPortbefore = getCurrentIPScaleoutPort(context)
        BaseFactory.log.info(context,
                             "list of normal ip scaleout "
                             "port:%s" % str(normalPortbefore))
        BaseFactory.persist.setModule(context,
                                      ALL_NORMAL_IPSCALEOUT_PORT,
                                      normalPortbefore)
        BaseFactory.result.setResultPass(context)
        return
    # 更换后比对信息
    else:
        BaseFactory.log.info(context,
                             "====Check Normal ip scaleout port==== begin")
        ipScaleoutPortBefore = BaseFactory.persist.getModule(
            context, ALL_NORMAL_IPSCALEOUT_PORT)
        BaseFactory.log.info(context,
                             "normal ip scaleout port before "
                             "is :%s" % str(ipScaleoutPortBefore))

        start_time = time.time()
        while (time.time() - start_time) <= LOOP_CHECK_PORTS_TIME_SECS:
            # 更换后端口信息
            normalPortCur = getCurrentIPScaleoutPort(context)
            BaseFactory.log.info(context,
                                 "normal ip scaleout port after "
                                 "is :%s" % str(normalPortCur))

            # 检查一致性
            abnormalPorts = [portId for portId in ipScaleoutPortBefore
                             if portId not in normalPortCur]
            # 端口一致，则通过
            if not abnormalPorts:
                BaseFactory.result.setResultPass(context)
                BaseFactory.log.info(context,
                                     "===Check ip scaleout port=== pass end")
                return
            # 否则睡眠5秒继续轮询端口信息
            time.sleep(5)

        # 轮询超时端口都未linkup，则不通过
        BaseFactory.result.setResultFailByKey(context, ERR_MSG_LANG_KEY)
        BaseFactory.log.info(context,
                             "====Check ip scaleout port==== fail end")
        return


def getCurrentIPScaleoutPort(context):
    """获取当前系统中linkup的IP-Scaleout端口id

    :param context:
    :return:
    """
    condition = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.EthPort.RUNNING_STATUS,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.RunningStatusEnum.LINK_UP)
    recs = Loop.getAllIpScaleOutPortList(context, condition)
    return map(lambda x: restUtil.Tlv2Rest.getRecordValue(
        x, restData.PublicAttributes.ID), recs)
