﻿# -*- coding: UTF-8 -*-
import time

import compute_storage_common
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import LoopCheckFactory
from cbb.common.conf.productConfig import CABLE_CONNCT_ALM_EVENT_IDS, \
    CABLE_CONNCT_ALM_EVENT_IDS_FOR_NAS, compare_dorado_version, DORADO_NAS
from cbb.common.conf.productConfig import AlarmLevel
from cbb.common.dev import utils
from cbb.frame.base import funcUtils
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest.restUtil import CommonRest
from cbb.frame.rest.restUtil import Tlv2Rest
from cbb.frame.rest import restData
from cbb.business.operate.fru.common import common


# 总进度时间
CHECK_ALRAM_TIME = 200

# 检查scale-out线缆告警总进度时间
CHECK_SCALE_OUT_ALARM_TIME_SECS = 390
# scale-out线缆告警等待上报时间
SCALE_OUT_ALARM_WAIT_TIME_SECS = 360


def execute(context, preCheck=True, alarm_clear_time=3 * 60):
    """查询所有告警信息，比较更换前后告警一致性

    :param context(dict): python上下文
    :param preCheck(bool): True-更换前检查 False-更换后检查
    :param alarm_clear_time(int): 更换线缆时告警清除的时间，交换机需要7分钟；其他3分钟
    :return:
    """
    try:
        common.threadUpProcess(context, alarm_clear_time + 20)
        lang = contextUtil.getLang(context)
        cli = contextUtil.getCli(context)
        rest = contextUtil.getRest(context)
        # 更换前备份信息
        if preCheck:
            # 获取系统中的所有告警
            BaseFactory.log.info(context, "record alarm info.")
            sysDate, __ = cliUtil.getSystemDate(cli, lang)
            alarm_records = CommonRest.get_alarms_by_period(rest)
            alarms = FuncFactory.get_alarms_from_rest_record(alarm_records)
            if baseUtil.is_computing_dev(contextUtil.getProductModel(context)):
                alarms = compute_storage_common.get_compute_storage_alarms(context)
            contextUtil.setItem(context, "sysAlarms", alarms)
            contextUtil.setItem(context, "preSystemDate", sysDate)
            BaseFactory.log.info(context, "sysAlarms before:%s" % str(alarms))
            BaseFactory.result.setResultPass(context)
            return
        # 更换后比对信息
        else:
            BaseFactory.log.info(context, "check alarm consistence")
            if utils.skipAlarmCheck():
                contextUtil.handleSuccess(context)
                BaseFactory.log.info(context, "Skip alarm check.")
                return

            # 更换前信息
            systemAlarmsBefore = contextUtil.getItem(context, "sysAlarms")
            if not systemAlarmsBefore:
                systemAlarmsBefore = []

            # 检查更换后告警
            startSysDate = contextUtil.getItem(context, "preSystemDate")
            checkAlarmConsistence(context, startSysDate, systemAlarmsBefore)
            if BaseFactory.result.isResultFail(context):
                loopCheckAlarm(context, startSysDate, systemAlarmsBefore, alarm_clear_time)
                return

            # 否则正常通过。
            BaseFactory.result.setResultPass(context)
            return
    except Exception as ex:
            raise ex
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)


@funcUtils.fakeProgress(CHECK_SCALE_OUT_ALARM_TIME_SECS)
def checkScaleOutAlarms(context, post_check=False):
    """检查ScaleOut线缆告警。

    :param context: 上下文
    :param post_check: 是否是更换后检查
    :return:
    """
    # 如果为单引擎，则直接通过
    if FuncFactory.isSingleEngine(context):
        BaseFactory.result.setResultPass(context)
        return True
    # 更换后需要睡眠360秒等待告警上报
    if post_check:
        time.sleep(SCALE_OUT_ALARM_WAIT_TIME_SECS)
    rest = contextUtil.getRest(context)
    alarm_records = CommonRest.get_alarms_by_period(rest)
    alarms = FuncFactory.get_alarms_from_rest_record(alarm_records)
    is_dorado_nas = compare_dorado_version(contextUtil.getCurVersion(context),
                                           DORADO_NAS)
    cable_connect_alm = CABLE_CONNCT_ALM_EVENT_IDS_FOR_NAS \
        if is_dorado_nas[0] and is_dorado_nas[1] \
        else CABLE_CONNCT_ALM_EVENT_IDS
    cable_alarms = [alarm for alarm in alarms
                    if alarm[0] in cable_connect_alm]
    BaseFactory.log.info(context, "All cable alarms:%s" % cable_alarms)
    # 不存在线缆连接告警，通过
    if not cable_alarms:
        BaseFactory.result.setResultPass(context)
        return True

    # 获取到所有的IP-Scaleout端口列表
    scale_out_ports = LoopCheckFactory.Loop.getAllIpScaleOutPortList(context)
    scale_out_ports_loc = list(map(lambda rec: Tlv2Rest.getRecordValue(
        rec, restData.PublicAttributes.LOCATION), scale_out_ports))
    BaseFactory.log.info(context, "Scale-out ports:%s" % scale_out_ports_loc)

    # 过滤所有线缆连接告警，如果告警参数中有IP-Scaleout端口，则为IP-Scaleout告警
    scale_out_alarms = []
    for scale_out_port_loc in scale_out_ports_loc:
        for cable_alarm in cable_alarms:
            if scale_out_port_loc in cable_alarm[1]:
                scale_out_alarms.append(cable_alarm)

    # 存在IP-Scaleout告警，不通过
    if scale_out_alarms:
        BaseFactory.log.info(context,
                             "Scale-out alarms:%s" % scale_out_alarms)
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.SYS_EXIST_SCALE_OUT_ALMS)
        return False

    BaseFactory.result.setResultPass(context)
    return True


def loopCheckAlarm(context, startSysDate, systemAlarmsBefore,
                   alarm_clear_time):
    startTime = time.time()
    while True:
        if time.time() - startTime > alarm_clear_time:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.SYS_ALARM_CHECK_CONSISTENT)
            return
        time.sleep(10)
        checkAlarmConsistence(context, startSysDate, systemAlarmsBefore)

        if not BaseFactory.result.isResultFail(context):
            return


def checkAlarmConsistence(context, startSysDate, systemAlarmsBefore):
    """检查更换后告警一致

    :param context: 上下文
    :param startSysDate: 告警状态收集的时间
    :param systemAlarmsBefore: 更换前告警
    :return:
    """
    lang = contextUtil.getLang(context)
    cli = contextUtil.getCli(context)
    rest = contextUtil.getRest(context)
    endSysDate, __ = cliUtil.getSystemDate(cli, lang)
    begin_timestamp = get_timestamp(startSysDate)
    end_timestamp = get_timestamp(endSysDate)
    alarm_records = CommonRest.get_alarms_by_period(
        rest, begin_timestamp, end_timestamp)
    alarms = FuncFactory.get_alarms_from_rest_record(alarm_records)
    if baseUtil.is_computing_dev(contextUtil.getProductModel(context)):
        alarms = compute_storage_common.get_compute_storage_alarms(context, begin_timestamp, end_timestamp)
    BaseFactory.log.info(context, "sysAlarms after:%s" % str(alarms))
    if not alarms:
        BaseFactory.result.setResultPass(context)
        return

    new_alarms = []
    for alarm in alarms:
        if alarm not in systemAlarmsBefore:
            new_alarms.append(alarm)
    BaseFactory.log.info(context, "new alarms:%s" % str(new_alarms))

    if new_alarms:
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.SYS_ALARM_CHECK_CONSISTENT)
        return

    BaseFactory.result.setResultPass(context)


def get_timestamp(time_str):
    """将时间字符串转换为时间戳

    :param time_str: 时间格式为 2017-7-19/12:00:00
    :return:
    """
    time_array = time.strptime(time_str, "%Y-%m-%d/%H:%M:%S")
    timestamp = int(time.mktime(time_array))
    return timestamp
