# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
from cbb.business.operate.checkitems import check_required_hot_patch
from cbb.business.operate.fru.common import commonFunction
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil

# 用于无解决补丁时需要拦截的场景，补丁版本比较必不通过
NO_FIX_PATCH = "SPH999"

# 补丁检查配置，参见cbb.business.operate.checkitems.check_required_hot_patch
HOT_PATCH_VER_LIST = [
    {
        "product_version": "6.0.0",  # 软件版本
        "required_patch": "SPH11",  # 要求的补丁
        "product_series": "Dorado",  # 型号系列
        "product_models": []
    },
    {
        "product_version": "6.0.1",  # 软件版本
        "required_patch": "SPH10",  # 要求的补丁
        "product_series": "Dorado",  # 型号系列
        "product_models": []
    },
    {
        "product_version": "6.0.RC1",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
]

IP_SCALE_HOT_PATCH_VER_LIST = [
    {
        "product_version": "6.0.1",  # 软件版本
        "required_patch": "SPH10",  # 要求的补丁
        "product_series": "Dorado",  # 型号系列
        "product_models": []
    }
]


def execute(context, fru_type=''):
    """补丁版本检查

    :param context: 上下文
    :param fru_type fru类型
    :return:
    """
    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    risk_version_dict = IP_SCALE_HOT_PATCH_VER_LIST \
        if fru_type == 'ipScaleOutIntf' else HOT_PATCH_VER_LIST
    try:
        # 检查补丁是否符合要求
        flag, dev_version, dev_patch, dev_model, required_patch = \
            check_required_hot_patch.execute(context, risk_version_dict)
        # 补丁版本满足要求，通过
        if flag:
            contextUtil.handleSuccess(context)
            logger.logPass()
            return

        result_dict = {
            "flag": False,
            "errMsg": commonFunction.getRes(lang, "patch.ver.check.fail"),
        }

        # 没有补丁，需要进行高危弹框提示
        if not required_patch or required_patch == NO_FIX_PATCH:
            result_dict["suggestion"] = commonFunction.getRes(
                lang, "replacement.exist.risk")
            # 如果选择取消，即检查不通过，框架会马上自动重新执行一次，
            # 防止二次弹框，增加had_dialog标记，记录是否已经弹过框
            if contextUtil.getItem(context, "had_dialog"):
                # 自动重试之后将标记置为False，防止手动重新执行时不再弹框
                contextUtil.setItem(context, "had_dialog", False)
            else:
                dialogUtil = context.get('dialogUtil')
                rec = dialogUtil.showWarningDialog(commonFunction.getRes(
                    lang, "patch.ver.warning.tips"))
                if rec:
                    logger.logInfo("Confirm to ignore the risks.")
                    contextUtil.handleSuccess(context)
                    logger.logPass()
                    return
                # 选择取消后会自动重试，设置已经弹框的标记
                contextUtil.setItem(context, "had_dialog", True)
        # 有对应补丁的，无弹框
        else:
            result_dict["suggestion"] = commonFunction.getRes(
                lang, "patch.ver.not.meet", required_patch)

        contextUtil.handleFailure(context, result_dict)
        logger.logNoPass("Hot patch version check failed.")
        return
    except Exception as ex:
        contextUtil.handleException(context, ex)
        logger.logException(ex)
        return
