# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
from cbb.business.operate.checkitems.check_scan_status import CheckScanStatus
from cbb.business.operate.fru.common import common
from cbb.frame.base import baseUtil
from cbb.frame.base.constants import CheckStatus
from cbb.frame.context import contextUtil


def execute(context):
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        result_dict = {"flag": False, "errMsg": "", "suggestion": ""}
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)

        check = CheckScanStatus(lang, cli, logger)
        result_flag, _, err_msg = check.run()
        # 检查通过
        if result_flag == CheckStatus.PASS:
            contextUtil.handleSuccess(context)
            logger.logPass()
            return
        # 检查不通过
        elif result_flag == CheckStatus.NOTPASS:
            result_dict["errMsg"] = err_msg
            result_dict["suggestion"] = baseUtil.getPyResource(
                lang, "check.scan.status.fail.sug")
        # 未完成检查
        else:
            result_dict["errMsg"], result_dict["suggestion"] = \
                common.getMsg(lang, "common.exception")
        contextUtil.handleFailure(context, result_dict)
        logger.logNoPass(err_msg)
        return
    except Exception as ex:
        logger.logException(ex)
        contextUtil.handleException(context, ex)
        return
