﻿# -*- coding: UTF-8 -*-
import json

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import common
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil


def init_data(context, select_id):
    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(contextUtil.getLogger(context), __file__)
    try:
        disks = json.loads(context.get(select_id))
        ret_data = {}

        loc_list = []
        sn_list = []
        type_list = []
        cp_list = []
        barcode_list = []
        for d in disks:
            loc_list.append(d.get("location"))
            sn_list.append(d.get("serialNumber"))
            type_list.append(d.get("diskType"))
            cp_list.append(d.get("capacity"))
            barcode_list.append(d.get("barcode"))

        ret_data["location"] = ",".join(loc_list)
        ret_data["serialNumber"] = ",".join(sn_list)
        ret_data["diskType"] = ",".join(type_list)
        ret_data["capacity"] = ",".join(cp_list)
        ret_data["barcode"] = ",".join(barcode_list)
        ret_data["status"] = FuncFactory.getFruReplStatusDesc(context, False)
        context["retData"] = BaseFactory.json.toStr(ret_data)

        contextUtil.setResult(context, True, "", "")
        return
    except Exception as ex:
        logger.error("Init replace data error:%s" % str(ex))
        msg, sug = common.getMsg(lang, "execute.error")
        contextUtil.setResult(context, True, msg, sug)
        return


def confirm(context, select_id):
    logger = baseUtil.getLogger(contextUtil.getLogger(context), __file__)
    loc_list = []
    sel_disks = json.loads(context.get(select_id))
    logger.info("sel_disks:%s" % str(sel_disks))
    for disk in sel_disks:
        loc_list.append(disk.get("location"))
    logger.info("loc_list:%s" % str(loc_list))
    context["confirmMsg"] = BaseFactory.lang.getDesc(context, FuncFactory.
                                                     LangKey.
                                                     CONFIRM_REPLACE_DONE_DISK,
                                                     ",".join(loc_list))
    contextUtil.setResult(context, True, "", "")
    return
