# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import constants
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil


def execute(context, all_port_recs):
    """更换线缆，生成始端端口-对端端口信息,
        适用于SAS端口、ETH端口，其他类型端口自行调试
    :param context:
    :param all_port_recs:
    :return:
    """
    BaseFactory.log.info(context, u"Start to init column data.")
    ui_tab = []
    has_record_ports = []
    bayConfigClustType = get_network_model(context)
    # 遍历所有端口，生成端口显示列表数据
    for portRec in all_port_recs:
        ui_row = dict()
        # 端口逻辑类型
        logic_type = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.Hardware.EthPort.LOGIC_TYPE)
        is_ip_scaleout = \
            logic_type == restData.Enum.PortLogicTypeEnum.IP_SCALE_OUT

        # 始端端口位置
        ui_row["startPortLoc"] = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.LOCATION)
        ui_row["location"] = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.LOCATION)
        # 记录已处理过的端口，避免A-B,B-A重复处理
        if ui_row["startPortLoc"] in has_record_ports:
            continue
        has_record_ports.append(ui_row["startPortLoc"])

        ui_row["startPortId"] = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.ID)

        run_status = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.RUNNING_STATUS)
        ui_row["startPortIntRunStatus"] = run_status
        ui_row["startPortRunStatus"] = restUtil.Tlv2Rest.getStr(
            context, restData.EnumStr.StrRunningStatusEnum, run_status)

        ui_row["startPortHealStatus"] = restUtil.Tlv2Rest.getStr(
            context, restData.EnumStr.StrHealthStatusEnum,
            restUtil.Tlv2Rest.getRecordValue(
                portRec, restData.PublicAttributes.HEALTH_STATUS))

        ui_row["startPortParentId"] = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.PARENT_ID)

        ui_row["startPortParentType"] = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.PARENT_TYPE)
        # 端口类型
        port_type = restUtil.Tlv2Rest.getRecordValue(
            portRec, restData.PublicAttributes.TYPE)
        ui_row["startPortType"] = port_type

        # 对端端口记录
        cur_peer_port_recs = get_peer_port_rec(portRec, port_type,
                                               all_port_recs)
        BaseFactory.log.info(context,
                             "curPeerPortLoc is : %s" % cur_peer_port_recs)

        if len(cur_peer_port_recs) == 0:
            # 对端端口ID为无效值，对端端口未连接
            peer_run_status = None
            ui_row["curPeerPortId"] = ""
            ui_row["curPeerPortLoc"] = constants.INVALID_LOC
            ui_row["curPeerPortParentId"] = ""
            ui_row["curPeerPortParentType"] = ""
            ui_row["curPeerPortHealStatus"] = ""
            ui_row["curPeerPortIntRunStatus"] = ""
            ui_row["curPeerPortRunStatus"] = ""
        else:
            ui_row["curPeerPortLoc"] = restUtil.Tlv2Rest.getRecordValue(
                cur_peer_port_recs[0], restData.PublicAttributes.LOCATION)
            has_record_ports.append(ui_row["curPeerPortLoc"])

            ui_row["curPeerPortId"] = restUtil.Tlv2Rest.getRecordValue(
                cur_peer_port_recs[0], restData.PublicAttributes.ID)

            ui_row["curPeerPortParentId"] = restUtil.Tlv2Rest.getRecordValue(
                cur_peer_port_recs[0], restData.PublicAttributes.PARENT_ID)

            ui_row["curPeerPortParentType"] = str(
                restUtil.Tlv2Rest.getRecordValue(
                    cur_peer_port_recs[0],
                    restData.PublicAttributes.PARENT_TYPE))

            ui_row["curPeerPortHealStatus"] = restUtil.Tlv2Rest.getStr(
                context, restData.EnumStr.StrHealthStatusEnum,
                restUtil.Tlv2Rest.getRecordValue(
                    cur_peer_port_recs[0],
                    restData.PublicAttributes.HEALTH_STATUS))

            peer_run_status = restUtil.Tlv2Rest.getRecordValue(
                cur_peer_port_recs[0],
                restData.PublicAttributes.RUNNING_STATUS)
            ui_row["curPeerPortIntRunStatus"] = peer_run_status
            ui_row["curPeerPortRunStatus"] = restUtil.Tlv2Rest.getStr(
                context,
                restData.EnumStr.StrRunningStatusEnum,
                peer_run_status)

        ui_row["visible"] = "false"
        ui_row["intCableRunStatus"] = restData.Enum. \
            RunningStatusEnum.LINK_UP
        ui_row["cableRunStatus"] = restUtil.Tlv2Rest.getStr(
            context,
            restData.EnumStr.StrRunningStatusEnum,
            restData.Enum.RunningStatusEnum.LINK_UP)

        # 普通线缆任意一端未连接，则认为未连接
        common_cable_link_down = not is_ip_scaleout and (
                run_status != restData.Enum.RunningStatusEnum.LINK_UP or
                peer_run_status != restData.Enum.RunningStatusEnum.LINK_UP)
        # IP-scaleout线缆必须是状态未连接
        ip_scaleout_cable_link_down = is_ip_scaleout and (
                run_status != restData.Enum.RunningStatusEnum.LINK_UP)
        if common_cable_link_down or ip_scaleout_cable_link_down:
            ui_row["intCableRunStatus"] = restData.Enum. \
                RunningStatusEnum.LINK_DOWN
            ui_row["cableRunStatus"] = restUtil.Tlv2Rest.getStr(
                context,
                restData.EnumStr.StrRunningStatusEnum,
                restData.Enum.RunningStatusEnum.LINK_DOWN)
            ui_row["visible"] = "true"
        # IP-scaleout线缆 末端端口应该为交换机
        if is_ip_scaleout and bayConfigClustType == 1:
            dsw_id = restUtil.Tlv2Rest.getRecordValue(
                portRec, restData.Hardware.EthPort.DSW_ID)
            ui_row["curPeerPortLoc"] = dsw_id \
                if dsw_id != BaseFactory.const.INVALID_IPSCALEOUT_DSWID \
                else constants.INVALID_LOC
        ui_tab.append(ui_row)

    # 返回结果
    return ui_tab


def get_network_model(context):
    """
    获取组网方式（6.0.0和6.0.1不支持该接口，默认为-1）
    @param context: 上下文
    @return: 组网方式
    """
    try:
        # 获取组网方式
        tlv = contextUtil.getTlv(context)
        bay_config_record = tlvUtil.readXnetInfo(tlv)
        bay_config_cluster_type = tlvUtil.getBayConfigClustType(bay_config_record)
        BaseFactory.log.info(context, "netModel is : {}".format(bay_config_cluster_type))
    except Exception as e:
        BaseFactory.log.info(context, "failed to get net model:{}".format(e))
        bay_config_cluster_type = -1
    return bay_config_cluster_type


def get_peer_port_rec(start_port_rec, port_type, all_port_recs):
    """ 根据端口类型，获取对端端口记录

    :param start_port_rec: 始端端口记录
    :param port_type: 端口类型
    :param all_port_recs: 所有端口记录
    :return:
    """
    if port_type == restData.Enum.ObjEnum.ETH_PORT:
        cur_peer_port_loc = restUtil.Tlv2Rest.getRecordValue(
            start_port_rec, restData.Hardware.EthPort.CURRENT_PEER_PORT)
        condition = restUtil.Tlv2Rest.getCondition(
            restData.PublicAttributes.LOCATION,
            restData.Enum.ConditionTypeEnum.EQ,
            cur_peer_port_loc)
    else:
        cur_peer_port_id = restUtil.Tlv2Rest.getRecordValue(
            start_port_rec, restData.Hardware.SasPort.CURRENT_PEER_PORT_ID)
        condition = restUtil.Tlv2Rest.getCondition(
            restData.PublicAttributes.ID,
            restData.Enum.ConditionTypeEnum.EQ,
            cur_peer_port_id)

    condition_list = restUtil.Tlv2Rest.getConditionList(condition)
    cur_peer_port_recs = restUtil.Tlv2Rest.filter(all_port_recs,
                                                  condition_list)
    return cur_peer_port_recs
