﻿# -*- coding: UTF-8 -*-
from cbb.frame.rest import restData

# 场景化key
SCENE_KEY = "toolScene"
SCENE_FRU_EVALUATION = "fruEvaluation"

# 流程配置key
FRU_EVAL_ITEMS = "FRU_EVAL_ITEMS"  # 备件更换评估配置
FRU_FULL_ITEMS = "FRU_FULL_ITEMS"  # 备件更换全流程配置

# 前端端口类型
FRONT_END_PORT_OBJ = [restData.RestCfg.OBJ.FC_PORT, restData.RestCfg.OBJ.ETH_PORT]

IpScaleOutDirectConnectRedundantPortPair = {
    "P0": "P1",
    "P1": "P0",
    "P2": "P3",
    "P3": "P2"
}

# 高端4U4C独立机头控制框电源冗余关系
RED_POWER_HIGH_END = {
    "PSU0": "PSU1",
    "PSU1": "PSU0",
    "PSU2": "PSU3",
    "PSU3": "PSU2"
}

# TODO 高端适应号待修改
DORADO_18000_PORT_CTR_DICT = {
    "B": ["L0.IOM0", "L1.IOM0", "L2.IOM0", "L3.IOM0", "L4.IOM0", "L5.IOM0"],
    "A": ["R0.IOM0", "R1.IOM0", "R2.IOM0", "R3.IOM0", "R4.IOM0", "R5.IOM0"],
    "D": ["L0.IOM1", "L1.IOM1", "L2.IOM1", "L3.IOM1", "L4.IOM1", "L5.IOM1"],
    "C": ["R0.IOM1", "R1.IOM1", "R2.IOM1", "R3.IOM1", "R4.IOM1", "R5.IOM1"]
}

# TODO 高端适应号待修改
DORADO18000_EXP_SLOT_DICT = {
    'DAE000.A': 'CTE0.R0.IOM0',
    'DAE000.B': 'CTE0.L0.IOM0',

    'DAE020.A': 'CTE0.R0.IOM0',
    'DAE020.B': 'CTE0.L0.IOM0',

    'DAE040.A': 'CTE0.R1.IOM0',
    'DAE040.B': 'CTE0.L1.IOM0',

    'DAE060.A': 'CTE0.R1.IOM0',
    'DAE060.B': 'CTE0.L1.IOM0',

    'DAE008.A': 'CTE0.R2.IOM0',
    'DAE008.B': 'CTE0.L2.IOM0',

    'DAE028.A': 'CTE0.R2.IOM0',
    'DAE028.B': 'CTE0.L2.IOM0',

    'DAE048.A': 'CTE0.R4.IOM0',
    'DAE048.B': 'CTE0.L4.IOM0',

    'DAE068.A': 'CTE0.R4.IOM0',
    'DAE068.B': 'CTE0.L4.IOM0',

    'DAE080.A': 'CTE0.R0.IOM1',
    'DAE080.B': 'CTE0.L0.IOM1',

    'DAE0A0.A': 'CTE0.R0.IOM1',
    'DAE0A0.B': 'CTE0.L0.IOM1',

    'DAE0C0.A': 'CTE0.R1.IOM1',
    'DAE0C0.B': 'CTE0.L1.IOM1',

    'DAE0E0.A': 'CTE0.R1.IOM1',
    'DAE0E0.B': 'CTE0.L1.IOM1',

    'DAE088.A': 'CTE0.R2.IOM1',
    'DAE088.B': 'CTE0.L2.IOM1',

    'DAE0A8.A': 'CTE0.R2.IOM1',
    'DAE0A8.B': 'CTE0.L2.IOM1',

    'DAE0C8.A': 'CTE0.R4.IOM1',
    'DAE0C8.B': 'CTE0.L4.IOM1',

    'DAE0E8.A': 'CTE0.R4.IOM1',
    'DAE0E8.B': 'CTE0.L4.IOM1',
}

# 键[1]表示框类型，键[2]表示框高（只针对控制框有效），键[3]表示是否为高密框，值表示更换时间
POWER_TIME_LIMIT_CONFIG = {
    ("CTRL", "2", "--"): "3",  # 2U控制框电源为3分钟
    ("CTRL", "3", "--"): "5",  # 3U控制框电源5分钟
    ("CTRL", "6", "--"): "5",  # 6U控制框电源5分钟
    ("EXP", "--", "--"): "3",  # 硬盘框电源3分钟
    ("EXP", "--", "high-density"): "5",  # 高密硬盘框5分钟
}
# 键[1]表示框类型，键[2]表示框高（只针对控制框有效），键[3]表示是否为高密框，值表示更换时间
BBU_TIME_LIMIT_CONFIG = {
    ("CTRL", "2", "--"): "3",  # 2U控制框BBU为3分钟
    ("CTRL", "3", "--"): "5",  # 3U控制框BBU5分钟
    ("CTRL", "6", "--"): "5",  # 6U控制框BBU5分钟
}
# 键[1]表示框类型，键[2]表示框高（只针对控制框有效），键[3]表示是否为高密框，值表示更换时间
FAN_TIME_LIMIT_CONFIG = {
    ("CTRL", "2", "--"): "3",  # 2U控制框风扇为3分钟
    ("CTRL", "3", "--"): "5",  # 3U,6U控制框风扇5分钟
    ("CTRL", "6", "--"): "5",  # 3U,6U控制框风扇5分钟
    ("EXP", "--", "--"): "5",  # 硬盘框风扇5分钟
    ("EXP", "--", "high-density"): "2",  # 高密框风扇2分钟
    ("DSW", "--", "--"): "2",  # 数据交换机2分钟
}

# 前段接口卡SmartIO工作模式（runMode）切换超时时间
SMARTIOC_WORK_MODEL_CHANGE_TIMEOUT = 300

# FRU升级超时时间字典（单位：秒）
FRU_UPGRADE_TIME_DICT = {
    "backEndInterface": 10 * 60,
    "frontEndInterface": 10 * 60,
    "pcieInterface_high_end": 60 * 60,
    "pcieInterface_low_end": 40 * 60,
    "expressACC": 12 * 60,
    "otherInterface": 10 * 60,
}

ARM_LOWDEVICE_MODEL_LIST = ["2600 V3", "2600F V3", "2100 V3", "2200 V3",
                            "2600 V3 for Video", "5110 V5", "5110F V5",
                            "5100K V5", "5200K V5", "5210 V5", "5210F V5",
                            "5300 V5"]

# PCIe接口卡类型
PCIE_INFO_MODEL_LIST = [restData.Enum.IntfModelEnum.PCIe_2X5G, restData.Enum.IntfModelEnum.PCIe_2PORT]

NOT_SUPPORT_MANAGEBORAD_TIME_VERSION = ["V300R001C00"]

NEED_CHECK_INTERNAL_PRODUCT_MODEL_VERSION = "V300R001C21"
NEED_CHK_DISK_NOT_SUPPORT_BY_MULTI_STREAM_ALM_VER = "V300R002C00"

MGMT_PORT_ALARM_ID = "0xF00060007"


class InternalProductModel():
    DORADO6000E_V3 = "Dorado6000E_V3"
    DORADO6000_V3 = "Dorado6000_V3"


##--------New Frame--------
FRU_MODULE_LIST = ["diskenclosure", "ctrlenclosure", "disk", "controller", "xpu", "cable", "intfmodule", "ipscaleout",
                   "box", "other"]

SYS_VERSION = "SYS_VERSION"


class TaskStatus():
    RUNNING = "running"
    FINISHED = "finished"


COMMON_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process.xml"}],
            "icon": "diskenclosure.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process.xml"}],
            "icon": "ctrlenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process.xml"}],
            "icon": "disk.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process.xml"}],
            "icon": "controller.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process.xml"},
                {"conf": "cableMgmt/process.xml"}
            ],
            "icon": "cable.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process.xml"},
                {"conf": "backEndIntf/process.xml"},
                {"conf": "expressAcc/process.xml"},
                {"conf": "otherIntf/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "ipscaleout": {

        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "fibremodule/process.xml"},
                {"conf": "memory/process.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "memory/evalProcess/process.xml"},
            ],
            "icon": "other.png",
        },
    }
}

LOW_END_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
    }

}

HIGH_END_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_18000V3.xml"},
                {"conf": "cableMgmt/process_18000V3.xml"},
                {"conf": "cablePCIe/process_18000V3.xml"},
                {"conf": "cableSas/process_18000V3.xml"},
            ],
            "icon": "cable.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_18000V3.xml"},
                {"conf": "backEndIntf/process_18000V3.xml"},
                {"conf": "pcieIntf/process_18000V3.xml"},
                {"conf": "expressAcc/process_18000V3.xml"},
                {"conf": "otherIntf/process_18000V3.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_18000V3.xml"},
                {"conf": "bbu/process_18000V3.xml"},
                {"conf": "fan/process_18000V3.xml"},
                {"conf": "expBoard/process_18000V3.xml"},
                {"conf": "manageBoard/process_18000V3.xml"},
                {"conf": "fibremodule/process_18000V3.xml"},
                {"conf": "pcieSwitch/process_18000V3.xml"},
                {"conf": "manageFanCtrlBoard/process_18000V3.xml"},
                {"conf": "memory/process_18000V3.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_18000V3.xml"}],
            "icon": "controller.png",
        },
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process_18000V3.xml"}],
            "icon": "diskenclosure.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_18000V3.xml"}],
            "icon": "ctrlenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_18000V3.xml"}],
            "icon": "disk.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_18000V3.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "memory/evalProcess/process_18000V3.xml"},
            ],
            "icon": "other.png",
        },
    }
}

SINGLE_MODEL_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_2800single.xml"},
                {"conf": "cableMgmt/process_2800single.xml"},
            ],
            "icon": "cable.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_2800single.xml"},
                {"conf": "backEndIntf/process_2800single.xml"},
                {"conf": "otherIntf/process_2800single.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process.xml"},
                {"conf": "expBoard/process_2800single.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "fibremodule/process_2800single.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_2800single.xml"}],
            "icon": "controller.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/"
                              "process_2800single.xml"}],
            "icon": "controller.png",
        },
    }
}

ARM_SINGLE_MODEL_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_arm_single.xml"},
                {"conf": "cableMgmt/process_2800single.xml"},
            ],
            "icon": "cable.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_arm_single.xml"},
                {"conf": "backEndIntf/process_2800single.xml"},
                {"conf": "otherIntf/process_arm_single.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process.xml"},
                {"conf": "expBoard/process_2800single.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "fibremodule/process_2800single.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_arm_single.xml"}],
            "icon": "controller.png",
        },
    },
    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/"
                              "process_arm_single.xml"}],
            "icon": "controller.png",
        },
    }
}

ARM_2810_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_arm_2810.xml"},
                {"conf": "cableMgmt/process.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_arm_2810.xml"}],
            "icon": "controller.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_arm_2810.xml"}],
            "icon": "ctrlenclosure.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_arm_2810.xml"},
                {"conf": "backEndIntf/process.xml"},
                {"conf": "otherIntf/process_arm_2810.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process_arm_2810.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "backEndFibremodule/process.xml"},
                {"conf": "frontEndFibremodule/process_arm_2810.xml"},
                {"conf": "memory/process_arm_2810.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
    },
    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_arm_2810.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process_arm_2810.xml"},
                {"conf": "memory/evalProcess/process_arm_2810.xml"},
            ],
            "icon": "other.png",
        },
    }
}

ARM_DEV_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_arm.xml"},
                {"conf": "cableMgmt/process.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_arm.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_arm.xml"},
                {"conf": "backEndIntf/process.xml"},
                {"conf": "otherIntf/process_arm.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "backEndFibremodule/process.xml"},
                {"conf": "frontEndFibremodule/process.xml"},
                {"conf": "memory/process_arm.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_arm.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process.xml"},
                {"conf": "memory/evalProcess/process_arm.xml"},
            ],
            "icon": "other.png",
        },
    }
}

ARM_DEV_C71_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_arm.xml"},
                {"conf": "cableMgmt/process.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
                {"conf": "ipScaleOutSwitch/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_arm.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_arm.xml"},
                {"conf": "backEndIntf/process.xml"},
                {"conf": "otherIntf/process_arm.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "backEndFibremodule/process.xml"},
                {"conf": "frontEndFibremodule/process.xml"},
                {"conf": "memory/process_arm.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_arm.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process.xml"},
                {"conf": "memory/evalProcess/process_arm.xml"},
            ],
            "icon": "other.png",
        },
    }
}

DORADO_DEV_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_dorado.xml"},
                {"conf": "cableMgmt/process_dorado.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
                {"conf": "ipScaleOutSwitch/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_dorado.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_dorado.xml"},
                {"conf": "backEndIntf/process_dorado.xml"},
                {"conf": "otherIntf/process_dorado.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_dorado.xml"},
                {"conf": "bbu/process_dorado.xml"},
                {"conf": "fan/process_dorado.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "backEndFibremodule/process_dorado.xml"},
                {"conf": "frontEndFibremodule/process_dorado.xml"},
                {"conf": "memory/process_dorado.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_dorado.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_dorado.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process_dorado.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process_dorado.xml"},
                {"conf": "memory/evalProcess/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
    }
}

AI_BIG_CLUSTERS_DEV_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_A800.xml"},
                {"conf": "cableMgmt/process_A800.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_A800.xml"},
                {"conf": "ipScaleOutFibremodule/process_A800.xml"},
                {"conf": "ipScaleOutCable/process_A800.xml"},
                {"conf": "ipScaleOutSwitch/process_A800.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_A800.xml"}],
            "icon": "disk.png",
        },
        "controller": {
            "conf": [
                {"conf": "controller/process_A800.xml"},
                {"conf": "systemDisk/process_A800.xml"}
            ],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_A800.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "box": {
            "conf": [
                {"conf": "boxDisk/process_A800.xml"},
                {"conf": "boxIntf/process_A800.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_A800.xml"},
                {"conf": "bbu/process_A800.xml"},
                {"conf": "fan/process_A800.xml"},
                {"conf": "manageBoard/process_A800.xml"},
                {"conf": "frontEndFibremodule/process_A800.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_A800.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [
                {"conf": "controller/evalProcess/process_A800.xml"},
                {"conf": "systemDisk/evalProcess/process_A800.xml"}
            ],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process_A800.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "box": {
            "conf": [
                {"conf": "boxDisk/evalProcess/process_A800.xml"},
            ],
            "icon": "interfaceModule.png",
        },
    }
}

# 计算型存储
OCEAN_STOR_COMPUTING_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process.xml"},
                     {"conf": "diskdrawer/process_compute.xml"}],
            "icon": "diskenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_compute.xml"}],
            "icon": "disk.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_compute.xml"},
                {"conf": "cableMgmt/process_compute.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "xpu": {
            "conf": [{"conf": "xpu/process_compute.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_dorado.xml"},
                {"conf": "bbu/process_compute.xml"},
                {"conf": "fan/process_compute.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "frontEndFibremodule/process_compute.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_compute.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "xpu": {
            "conf": [{"conf": "xpu/eval_process/process_compute.xml"}],
            "icon": "controller.png",
        },
    }
}

DORADO_18000V3_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process_18000V3.xml"}],
            "icon": "diskenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_18000V3.xml"}],
            "icon": "disk.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_dorado_18000.xml"},
                {"conf": "cableMgmt/process_18000V3.xml"},
                {"conf": "cableSas/process_18000V3.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado_18000V3.xml"},
                {"conf": "ipScaleOutFibremodule/process_18000V3.xml"},
                {"conf": "ipScaleOutCable/process_18000.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_dorado_18000.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_dorado_18000.xml"},
                {"conf": "backEndIntf/process_18000V3.xml"},
                {"conf": "otherIntf/process_dorado_18000.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_18000V3.xml"},
                {"conf": "bbu/process_18000V3.xml"},
                {"conf": "fan/process_18000V3.xml"},
                {"conf": "expBoard/process_18000V3.xml"},
                {"conf": "manageBoard/process_18000V3.xml"},
                {"conf": "backEndFibremodule/process_18000V3.xml"},
                {"conf": "frontEndFibremodule/process_dorado_18000.xml"},
                {"conf": "manageFanCtrlBoard/process_18000V3.xml"},
                {"conf": "memory/process_dorado_18000.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_18000V3.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/"
                              "process_dorado_18000.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/"
                         "process_dorado_18000V3.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "memory/evalProcess/process_dorado_18000.xml"},
            ],
            "icon": "other.png",
        },
    }
}

DORADO_612_HIGH_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process_18000V3.xml"}],
            "icon": "diskenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_18000V3.xml"}],
            "icon": "disk.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_dorado_18000.xml"},
                {"conf": "cableMgmt/process_18000V3.xml"},
                {"conf": "cableSas/process_18000V3.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado_18000V3.xml"},
                {"conf": "ipScaleOutFibremodule/process_18000V3.xml"},
                {"conf": "ipScaleOutCable/process_18000.xml"},
                {"conf": "ipScaleOutSwitch/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_dorado_18000.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_dorado_18000.xml"},
                {"conf": "backEndIntf/process_18000V3.xml"},
                {"conf": "otherIntf/process_dorado_18000.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_18000V3.xml"},
                {"conf": "bbu/process_18000V3.xml"},
                {"conf": "fan/process_18000V3.xml"},
                {"conf": "expBoard/process_18000V3.xml"},
                {"conf": "manageBoard/process_18000V3.xml"},
                {"conf": "backEndFibremodule/process_18000V3.xml"},
                {"conf": "frontEndFibremodule/process_dorado_18000.xml"},
                {"conf": "manageFanCtrlBoard/process_18000V3.xml"},
                {"conf": "memory/process_dorado_18000.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_18000V3.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/"
                              "process_dorado_18000.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/"
                         "process_dorado_18000V3.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "memory/evalProcess/process_dorado_18000.xml"},
            ],
            "icon": "other.png",
        },
    }
}

OCEAN_PROTECT_HIGH_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [
                {"conf": "diskEnclosure/process_arm_highend_no_graph.xml"}],
            "icon": "diskenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_arm_highend_no_graph.xml"}],
            "icon": "disk.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_oceanprotect_high.xml"},
                {"conf": "cableMgmt/process_oceanprotect_high.xml"},
                {"conf": "cableSas/process_arm_highend_no_graph.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_arm_highend_no_graph.xml"},
                {"conf": "ipScaleOutFibremodule/process_arm_highend_no_"
                         "graph.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_oceanprotect_high.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_oceanprotect_high.xml"},
                {"conf": "backEndIntf/process_arm_highend_no_graph.xml"},
                {"conf": "otherIntf/process_arm_highend_no_graph.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_arm_highend_no_graph.xml"},
                {"conf": "bbu/process_arm_highend_no_graph.xml"},
                {"conf": "fan/process_arm_highend_no_graph.xml"},
                {"conf": "expBoard/process_arm_highend_no_graph.xml"},
                {"conf": "manageBoard/process_oceanprotect_high.xml"},
                {"conf": "backEndFibremodule/process_arm_highend_no_"
                         "graph.xml"},
                {"conf": "frontEndFibremodule/process_oceanprotect_high.xml"},
                {"conf": "memory/process_oceanprotect_high.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [
                {"conf": "controllerEnclosure/process_oceanprotect_high.xml"}
            ],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_oceanprotect_high.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/"
                         "process_arm_highend_no_graph.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "memory/evalProcess/process_oceanprotect_high.xml"},
            ],
            "icon": "other.png",
        },
    }
}

OCEAN_PROTECT_MID_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_oceanprotect_mid.xml"},
                {"conf": "cableMgmt/process_oceanprotect_mid.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [
                {"conf": "controller/process_oceanprotect_mid.xml"}
            ],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_oceanprotect_mid.xml"},
                {"conf": "backEndIntf/process_dorado.xml"},
                {"conf": "otherIntf/process_dorado.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_dorado.xml"},
                {"conf": "bbu/process_dorado.xml"},
                {"conf": "fan/process_oceanprotect_mid.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process_oceanprotect_mid.xml"},
                {"conf": "backEndFibremodule/process_dorado.xml"},
                {"conf": "frontEndFibremodule/process_oceanprotect_mid.xml"},
                {"conf": "memory/process_oceanprotect_mid.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_oceanprotect_mid.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_oceanprotect_mid.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process_dorado.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process_oceanprotect_mid.xml"},
                {"conf": "memory/evalProcess/process_oceanprotect_mid.xml"},
            ],
            "icon": "other.png",
        },
    }
}

KUNPENG_HIGH_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process_18000V3.xml"}],
            "icon": "diskenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_18000V3.xml"}],
            "icon": "disk.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_18000V3.xml"},
                {"conf": "cableMgmt/process_18000V3.xml"},
                {"conf": "cableSas/process_18000V3.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_18000V3.xml"},
                {"conf": "ipScaleOutFibremodule/process_18000V3.xml"},
                {"conf": "ipScaleOutCable/process_18000.xml"},
                {"conf": "ipScaleOutSwitch/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_18000V3.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_18000V3.xml"},
                {"conf": "backEndIntf/process_18000V3.xml"},
                {"conf": "otherIntf/process_18000V3.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_18000V3.xml"},
                {"conf": "bbu/process_18000V3.xml"},
                {"conf": "fan/process_18000V3.xml"},
                {"conf": "expBoard/process_18000V3.xml"},
                {"conf": "manageBoard/process_18000V3.xml"},
                {"conf": "backEndFibremodule/process_18000V3.xml"},
                {"conf": "frontEndFibremodule/process_18000V3.xml"},
                {"conf": "manageFanCtrlBoard/process_18000V3.xml"},
                {"conf": "memory/process_18000V3.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_18000V3.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_18000V3.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process_18000V3.xml"},
            ],
            "icon": "interfaceModule.png",
        },
    }
}

KUNPENG_HIGH_NO_GRAPH_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [
                {"conf": "diskEnclosure/process_arm_highend_no_graph.xml"}],
            "icon": "diskenclosure.png",
        },
        "disk": {
            "conf": [{"conf": "disk/process_arm_highend_no_graph.xml"}],
            "icon": "disk.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_arm_highend_no_graph.xml"},
                {"conf": "cableMgmt/process_arm_highend_no_graph.xml"},
                {"conf": "cableSas/process_arm_highend_no_graph.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_arm_highend_no_graph.xml"},
                {"conf": "ipScaleOutFibremodule/process_arm_highend_no_"
                         "graph.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
                {"conf": "ipScaleOutSwitch/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_arm_highend_no_graph.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_arm_highend_no_graph.xml"},
                {"conf": "backEndIntf/process_arm_highend_no_graph.xml"},
                {"conf": "otherIntf/process_arm_highend_no_graph.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_arm_highend_no_graph.xml"},
                {"conf": "bbu/process_arm_highend_no_graph.xml"},
                {"conf": "fan/process_arm_highend_no_graph.xml"},
                {"conf": "expBoard/process_arm_highend_no_graph.xml"},
                {"conf": "manageBoard/process_arm_highend_no_graph.xml"},
                {"conf": "backEndFibremodule/process_arm_highend_no_"
                         "graph.xml"},
                {"conf": "frontEndFibremodule/process_arm_highend_no_"
                         "graph.xml"},
                {"conf": "manageFanCtrlBoard/process_arm_highend_no_"
                         "graph.xml"},
                {"conf": "memory/process_arm_highend_no_graph.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [
                {"conf": "controllerEnclosure/process_arm_highend_no_"
                         "graph.xml"}
            ],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/"
                              "process_arm_highend_no_graph.xml"}],
            "icon": "controller.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/"
                         "process_arm_highend_no_graph.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "memory/evalProcess/process_arm_highend_no_graph.xml"},
            ],
            "icon": "other.png",
        },
    }
}

FOR_6800V5_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process.xml"},
                {"conf": "bbu/process.xml"},
                {"conf": "fan/process.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "fibremodule/process.xml"},
                {"conf": "manageFanCtrlBoard/process_6800V5.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
    },

    FRU_EVAL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/evalProcess/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
    }
}

FOR_2210_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "other": {
            "conf": [
                {"conf": "power/process_2210.xml"},
                {"conf": "bbu/process_2210.xml"},
                {"conf": "fan/process_2210.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "fibremodule/process.xml"},
                {"conf": "memory/process_arm.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        }
    },
    FRU_EVAL_ITEMS: {
        "other": {
            "conf": [
                {"conf": "bbu/evalProcess/process_2210.xml"},
                {"conf": "memory/evalProcess/process_arm.xml"},
            ],
            "icon": "other.png",
        }
    },
}

FOR_DORADO_2000_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_2210.xml"},
                {"conf": "bbu/process_2210.xml"},
                {"conf": "fan/process_2210.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "frontEndFibremodule/process_dorado.xml"},
                {"conf": "memory/process_dorado.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        }
    },
    FRU_EVAL_ITEMS: {
        "other": {
            "conf": [
                {"conf": "bbu/evalProcess/process_2210.xml"},
                {"conf": "memory/evalProcess/process_dorado.xml"},
            ],
            "icon": "other.png",
        }
    },
}

FOR_OCEAN_PROTECT_X3000_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_oceanprotect_x3000.xml"}],
            "icon": "ctrlenclosure.png",
        },
        "other": {
            "conf": [
                {"conf": "power/process_2210.xml"},
                {"conf": "bbu/process_oceanprotect_x3000.xml"},
                {"conf": "fan/process_2210.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "frontEndFibremodule/process_oceanprotect_mid.xml"},
                {"conf": "memory/process_oceanprotect_mid.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        }
    },
    FRU_EVAL_ITEMS: {
        "other": {
            "conf": [
                {"conf": "bbu/evalProcess/process_2210.xml"},
                {"conf": "memory/evalProcess/process_oceanprotect_mid.xml"},
            ],
            "icon": "other.png",
        }
    },
}

MICRO_1300_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_micro.xml"},
                {"conf": "cableMgmt/process_micro.xml"},
            ],
            "icon": "cable.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_micro_1300.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_micro.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/process_micro_1300.xml"},
                {"conf": "frontEndFibremodule/process_micro.xml"},
                {"conf": "memory/process_micro.xml"},
                {"conf": "power/process_dorado.xml"},
                {"conf": "bbu/process_dorado.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_micro_1300.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_micro_1300.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process_micro_1300.xml"},
                {"conf": "memory/evalProcess/process_micro.xml"},
            ],
            "icon": "other.png",
        },
    }
}

MICRO_DEV_PROCESS_ITEMS = {
    FRU_FULL_ITEMS: {
        "diskenclosure": {
            "conf": [{"conf": "diskEnclosure/process.xml"}],
            "icon": "diskenclosure.png",
        },
        "cable": {
            "conf": [
                {"conf": "cableFrontEnd/process_micro.xml"},
                {"conf": "cableMgmt/process_micro.xml"},
                {"conf": "cableSas/process.xml"},
            ],
            "icon": "cable.png",
        },
        "ipscaleout": {
            "conf": [
                {"conf": "ipScaleOutIntf/process_dorado.xml"},
                {"conf": "ipScaleOutFibremodule/process.xml"},
                {"conf": "ipScaleOutCable/process.xml"},
                {"conf": "ipScaleOutSwitch/process.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "controller": {
            "conf": [{"conf": "controller/process_micro.xml"}],
            "icon": "controller.png",
        },
        "intfmodule": {
            "conf": [
                {"conf": "frontEndIntf/process_micro.xml"},
                {"conf": "backEndIntf/process_micro.xml"},
                {"conf": "otherIntf/process_dorado.xml"},
            ],
            "icon": "interfaceModule.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/process_micro.xml"},
                {"conf": "frontEndFibremodule/process_micro.xml"},
                {"conf": "memory/process_micro.xml"},
                {"conf": "power/process_dorado.xml"},
                {"conf": "bbu/process_dorado.xml"},
                {"conf": "expBoard/process.xml"},
                {"conf": "manageBoard/process.xml"},
                {"conf": "backEndFibremodule/process_dorado.xml"},
                {"conf": "riskPower/process_dorado.xml"},
            ],
            "icon": "other.png",
        },
        "ctrlenclosure": {
            "conf": [{"conf": "controllerEnclosure/process_micro.xml"}],
            "icon": "ctrlenclosure.png",
        }
    },

    FRU_EVAL_ITEMS: {
        "controller": {
            "conf": [{"conf": "controller/evalProcess/process_micro.xml"}],
            "icon": "controller.png",
        },
        "other": {
            "conf": [
                {"conf": "fan/evalProcess/process_micro.xml"},
                {"conf": "memory/evalProcess/process_micro.xml"},
            ],
            "icon": "other.png",
        },
    }
}


CHECK_DEFAULT_PERIOD = 3  # 检查项默认检查周期（秒）
CTRL_POWERON_TIME = 6000  # 控制器上电超时时间（秒）
CTRL_FRU_WAIT_TIME = 40  # 控制器正常后，其他FRU等待接入时间（秒）

# 单链路告警上报超时时间
SINGLE_LINKED_OUTTIME = 150
# IP级联模块超时时间
IP_DISK_ENC_POST_CHECK_TIME_OUT_SECS = 1800
# SAS级联模块超时时间
SAS_DISK_ENC_POST_CHECK_TIME_OUT_SECS = 420
# 级联模块SES超时时间
EXP_BOARD_SES_OUTTIME = 600
# 系统下电命令超时时间120s
CMD_POWEROFF_TIMEOUT = 120

# 检查主机多链路告警的等待时间
HOST_MULT_PATH_ALARM_CHECK_TIME_LIMIT = 120
HOST_MULT_PATH_ALARM_CHECK_TIME_INTEVAL = 30

# 检查仲裁链路超时时间
QUORUM_LINK_CHECK_TIMEOUT = 90

ALARM_SAS = {
    # REST:    "eventParam":"0,CTE0,PSU 0"
    #  位置：       "location":"FrameType=0,FrameID=CTE0,PowerID=PSU 0",
    # TLV: 单链路告警：8(STRING)=1,DAE100,A,210235980610E9000200
    # 第一个参数是要取那个key的值，第二个参数是取到该值后用逗号split后取哪个index的值。
    # rest和TLV基本都对得上
    # 错误码：singleLinked = "0x000F00CE002A"
    "64438009898": {"obj": restData.RestCfg.Alarm.EVENTPARAM, "checkIndex": [1, 2]},

    # SAS线缆连接错误告警：1,DAE000,0,B,EXP,210235980810F4000130
    # 错误码：errorLinked = "0x000F00D00016"
    "64438140950": {"obj": restData.RestCfg.Alarm.EVENTPARAM, "checkIndex": [1, 3]},
}

ALARM_REPLICATION = {
    "4028366849": {},  # 0x000F01C0001远程复制异常断开
    "4028366850": {},  # 0x000F01C0002远程复制不可用
    "4028366851": {},  # 0x000F01C0003远程复制主Lun数据回滚失败
    "4028366852": {},  # 0x000F01C0004远程复制从Lun数据回滚失败
    "35248799154220": {},  # 0x200F0027002C远程复制同步失败
    "64427065400": {},  # 0x000F00270038远程复制异常断开
    "64427065401": {},  # 0x000F00270039远程复制不可用
    "64427065402": {},  # 0x000F0027003A远程复制自动启同步失败
    "17656613109899": {},  # 0x100F0027008B远程复制从Lun数据回滚失败
    "4041277441": {},  # 0x000F0E10001复制链路断开
    "64439189524": {},  # 0x000F00E00014没有备用链路
    "64439189525": {},  # 0x000F00E00015阵列间链路连接数达到规格
    "64439189526": {}  # 0x000F00E00016
}
# 主机多路径不冗余告警
ALARM_HOST_MULT_PATH_ULTRA_PATH = {
    # 0x100F0015001C
    "17656611930140": {},
    # V5R7C70之后版本 0x100F0015001C变为0x100F0015003B
    "17656611930171": {},
    # 0x000F0015001D
    "64425885725": {},
    # V5R7C70之后版本 0x000F0015001D变为0x000F00150032
    "64425885746": {},
    # 0xF00150027
    "64425885735": {},
    # 0xF00150028
    "64425885736": {},
    # 0xF00150029
    "64425885737": {},
    # 0xF0015002A
    "64425885738": {},
    # 0x000F00150024
    "64425885732": {},
    # 0x000F00150025
    "64425885733": {}
}

# TODO: confirm alarm。
ALARM_HOST_MULT_PATH_OTHER = {
    # 链路故障、不稳定-过滤端口号ID
    "64425885722": {"obj": restData.RestCfg.Alarm.EVENTPARAM, "checkIndex": [4, 6]},  # 0x000F0015001A
    "64425885723": {"obj": restData.RestCfg.Alarm.EVENTPARAM, "checkIndex": [4, 6]},  # 0x000F0015001B
}
ALARM_HOST_MULT_PATH_REDANT_CTRL = {
    # 没有冗余链路-过滤 控制器ID
    # 0x000F00150019
    "64425885721": {
        "obj": restData.RestCfg.Alarm.EVENTPARAM,
        "checkIndex": [2, 3]
    },
    # V5R7C70之后版本 0x000F00150019变为0x000F00150034
    "64425885748": {
        "obj": restData.RestCfg.Alarm.EVENTPARAM,
        "checkIndex": [2, 3]
    },
}

MIN_REMAIN_TIME = 10  # 最小剩余时间

# 默认进度刷新间隔时间3s
INTERVAL_TIME = 3
# 进度条刷新开始标识和结束标识
PROCESS_STATE_CHECKING = "checking"
PROCESS_UPGRADE_FINISHED = "finished"

DORADO_18000V3_SMB0_SAS_PORT_DICT = {
    'DAE000.A.P0': 'CTE0.R0.IOM0.P0',
    'DAE000.A.P1': 'CTE0.R0.IOM0.P1',
    'DAE000.B.P0': 'CTE0.L0.IOM0.P0',
    'DAE000.B.P1': 'CTE0.L0.IOM0.P1',

    'DAE020.A.P0': 'CTE0.R0.IOM0.P2',
    'DAE020.A.P1': 'CTE0.R0.IOM0.P3',
    'DAE020.B.P0': 'CTE0.L0.IOM0.P2',
    'DAE020.B.P1': 'CTE0.L0.IOM0.P3',

    'DAE040.A.P0': 'CTE0.R1.IOM0.P0',
    'DAE040.A.P1': 'CTE0.R1.IOM0.P1',
    'DAE040.B.P0': 'CTE0.L1.IOM0.P0',
    'DAE040.B.P1': 'CTE0.L1.IOM0.P1',

    'DAE060.A.P0': 'CTE0.R1.IOM0.P2',
    'DAE060.A.P1': 'CTE0.R1.IOM0.P3',
    'DAE060.B.P0': 'CTE0.L1.IOM0.P2',
    'DAE060.B.P1': 'CTE0.L1.IOM0.P3',

    'DAE008.A.P0': 'CTE0.R2.IOM0.P0',
    'DAE008.A.P1': 'CTE0.R2.IOM0.P1',
    'DAE008.B.P0': 'CTE0.L2.IOM0.P0',
    'DAE008.B.P1': 'CTE0.L2.IOM0.P1',

    'DAE028.A.P0': 'CTE0.R2.IOM0.P2',
    'DAE028.A.P1': 'CTE0.R2.IOM0.P3',
    'DAE028.B.P0': 'CTE0.L2.IOM0.P2',
    'DAE028.B.P1': 'CTE0.L2.IOM0.P3',

    'DAE048.A.P0': 'CTE0.R4.IOM0.P0',
    'DAE048.A.P1': 'CTE0.R4.IOM0.P1',
    'DAE048.B.P0': 'CTE0.L4.IOM0.P0',
    'DAE048.B.P1': 'CTE0.L4.IOM0.P1',

    'DAE068.A.P0': 'CTE0.R4.IOM0.P2',
    'DAE068.A.P1': 'CTE0.R4.IOM0.P3',
    'DAE068.B.P0': 'CTE0.L4.IOM0.P2',
    'DAE068.B.P1': 'CTE0.L4.IOM0.P3',

    'DAE080.A.P0': 'CTE0.R0.IOM1.P0',
    'DAE080.A.P1': 'CTE0.R0.IOM1.P1',
    'DAE080.B.P0': 'CTE0.L0.IOM1.P0',
    'DAE080.B.P1': 'CTE0.L0.IOM1.P1',

    'DAE0A0.A.P0': 'CTE0.R0.IOM1.P2',
    'DAE0A0.A.P1': 'CTE0.R0.IOM1.P3',
    'DAE0A0.B.P0': 'CTE0.L0.IOM1.P2',
    'DAE0A0.B.P1': 'CTE0.L0.IOM1.P3',

    'DAE0C0.A.P0': 'CTE0.R1.IOM1.P0',
    'DAE0C0.A.P1': 'CTE0.R1.IOM1.P1',
    'DAE0C0.B.P0': 'CTE0.L1.IOM1.P0',
    'DAE0C0.B.P1': 'CTE0.L1.IOM1.P1',

    'DAE0E0.A.P0': 'CTE0.R1.IOM1.P2',
    'DAE0E0.A.P1': 'CTE0.R1.IOM1.P3',
    'DAE0E0.B.P0': 'CTE0.L1.IOM1.P2',
    'DAE0E0.B.P1': 'CTE0.L1.IOM1.P3',

    'DAE088.A.P0': 'CTE0.R2.IOM1.P0',
    'DAE088.A.P1': 'CTE0.R2.IOM1.P1',
    'DAE088.B.P0': 'CTE0.L2.IOM1.P0',
    'DAE088.B.P1': 'CTE0.L2.IOM1.P1',

    'DAE0A8.A.P0': 'CTE0.R2.IOM1.P2',
    'DAE0A8.A.P1': 'CTE0.R2.IOM1.P3',
    'DAE0A8.B.P0': 'CTE0.L2.IOM1.P2',
    'DAE0A8.B.P1': 'CTE0.L2.IOM1.P3',

    'DAE0C8.A.P0': 'CTE0.R4.IOM1.P0',
    'DAE0C8.A.P1': 'CTE0.R4.IOM1.P1',
    'DAE0C8.B.P0': 'CTE0.L4.IOM1.P0',
    'DAE0C8.B.P1': 'CTE0.L4.IOM1.P1',

    'DAE0E8.A.P0': 'CTE0.R4.IOM1.P2',
    'DAE0E8.A.P1': 'CTE0.R4.IOM1.P3',
    'DAE0E8.B.P0': 'CTE0.L4.IOM1.P2',
    'DAE0E8.B.P1': 'CTE0.L4.IOM1.P3',
}

DORADO_18000V3_SMB0_SINGLEPATH_DICT = {
    'DAE000.A.P0': 'CTE0.R0.IOM0.P0',
    'DAE000.B.P0': 'CTE0.L0.IOM0.P0',

    'DAE020.A.P0': 'CTE0.R0.IOM0.P1',
    'DAE020.B.P0': 'CTE0.L0.IOM0.P1',

    'DAE040.A.P0': 'CTE0.R1.IOM0.P0',
    'DAE040.B.P0': 'CTE0.L1.IOM0.P0',

    'DAE060.A.P0': 'CTE0.R1.IOM0.P1',
    'DAE060.B.P0': 'CTE0.L1.IOM0.P1',

    'DAE080.A.P0': 'CTE0.R0.IOM1.P0',
    'DAE080.B.P0': 'CTE0.L0.IOM1.P0',

    'DAE0A0.A.P0': 'CTE0.R0.IOM1.P1',
    'DAE0A0.B.P0': 'CTE0.L0.IOM1.P1',

    'DAE0C0.A.P0': 'CTE0.R1.IOM1.P0',
    'DAE0C0.B.P0': 'CTE0.L1.IOM1.P0',

    'DAE0E0.A.P0': 'CTE0.R1.IOM1.P1',
    'DAE0E0.B.P0': 'CTE0.L1.IOM1.P1',
}

MGMT_PORT_CONFIG_FOR_DORADO = {
    "3U":
        {"2":  # 2引擎场景：
            {
                "plane0":
                    {
                        "CTE0.SMM0.MAINTENANCE": "CTE1.SMM0.MGMT",
                        "CTE1.SMM0.MAINTENANCE": "DSW0.MGMT.0",

                        "CTE1.SMM0.MGMT": "CTE0.SMM0.MAINTENANCE",
                    },
                "plane1":
                    {
                        "CTE0.SMM1.MGMT": "CTE1.SMM1.MAINTENANCE",
                        "CTE0.SMM1.MAINTENANCE": "DSW1.MGMT.1",

                        "CTE1.SMM1.MAINTENANCE": "CTE0.SMM1.MGMT",
                    }
            },
            "3":  # 3引擎场景：
                {
                    "plane0":
                        {
                            "CTE0.SMM0.MAINTENANCE": "CTE1.SMM0.MGMT",
                            "CTE1.SMM0.MAINTENANCE": "CTE2.SMM0.MGMT",
                            "CTE2.SMM0.MAINTENANCE": "DSW0.MGMT.0",

                            "CTE1.SMM0.MGMT": "CTE0.SMM0.MAINTENANCE",
                            "CTE2.SMM0.MGMT": "CTE1.SMM0.MAINTENANCE",
                        },
                    "plane1":
                        {
                            "CTE0.SMM1.MGMT": "CTE1.SMM1.MAINTENANCE",
                            "CTE1.SMM1.MGMT": "CTE2.SMM1.MAINTENANCE",
                            "CTE0.SMM1.MAINTENANCE": "DSW1.MGMT.1",

                            "CTE1.SMM1.MAINTENANCE": "CTE0.SMM1.MGMT",
                            "CTE2.SMM1.MAINTENANCE": "CTE1.SMM1.MGMT",
                        }
                },
            "4":  # 4引擎场景：
                {
                    "plane0":
                        {
                            "CTE0.SMM0.MAINTENANCE": "CTE1.SMM0.MGMT",
                            "CTE1.SMM0.MAINTENANCE": "CTE2.SMM0.MGMT",
                            "CTE2.SMM0.MAINTENANCE": "CTE3.SMM0.MGMT",
                            "CTE2.SMM0.MAINTENANCE": "DSW0.MGMT.0",

                            "CTE1.SMM0.MGMT": "CTE0.SMM0.MAINTENANCE",
                            "CTE2.SMM0.MGMT": "CTE1.SMM0.MAINTENANCE",
                            "CTE3.SMM0.MGMT": "CTE2.SMM0.MAINTENANCE",
                        },
                    "plane1":
                        {
                            "CTE0.SMM1.MGMT": "CTE1.SMM1.MAINTENANCE",
                            "CTE1.SMM1.MGMT": "CTE2.SMM1.MAINTENANCE",
                            "CTE2.SMM1.MGMT": "CTE3.SMM1.MAINTENANCE",
                            "CTE0.SMM1.MAINTENANCE": "DSW1.MGMT.1",

                            "CTE1.SMM1.MAINTENANCE": "CTE0.SMM1.MGMT",
                            "CTE2.SMM1.MAINTENANCE": "CTE1.SMM1.MGMT",
                            "CTE3.SMM1.MAINTENANCE": "CTE2.SMM1.MGMT",
                        }
                },
        },
    "6U":
        {"2":  # 2引擎场景：
            {
                "plane0":
                    {
                        "CTE0.SMM0.MGMT1": "SVP.P4",
                        "CTE0.SMM0.MGMT2": "CTE1.SMM0.MGMT1",
                        "CTE1.SMM0.MGMT2": "DSW1.MGMT.1",
                    },
                "plane1":
                    {
                        "CTE0.SMM1.MGMT1": "CTE1.SMM1.MGMT2",
                        "CTE0.SMM1.MGMT2": "DSW0.MGMT.0",
                        "CTE1.SMM1.MGMT1": "SVP.P3",
                    }
            },
        }
}

FRU_NOT_ALLOW_ALARM_LIST = [
    # 0x200F022E0011 兼容性告警
    "35248833167377",
    # 0xF00CF0070 类型不一致告警
    "64438075504",
    # 0xF00D10044 接口模块型号不支持告警
    "64438206532",
    # 0xF0D10008 接口模块无法识别
    "4040228872",
    # 0xF00D1004D 管理板不支持
    "64438206541",
]

CONTROLLER_NOT_ALLOW_ALARM_LIST = [
    # 0xF0CF0005 控制器之间通信异常告警
    "4040097797",
    # 0xF00CF005F 控制器故障告警
    "64438075487",
    # 0xF00CF0091 控制器UCE故障：旧告警
    "64438075537",
    # 0xF00CF0097 控制器UCE故障：新告警
    "64438075543",
]


class Overtime:
    SAS_CABLE_ALARM_TIMEOUT = 6 * 60


class IntervalTime:
    DEFAULT_INTERVAL = 2
