﻿# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

'''
根据类型获取接口卡已连接的端口记录
'''
def execute(context, intfTye, selectKey=""):
    selFruRow = BaseFactory.json.toDict(context.get(selectKey))
    fruId = selFruRow["id"]
    BaseFactory.log.info(context, "tool hl:" + str(selFruRow))

    tmpRecs = FuncFactory.getFruListInfo(context, intfTye)

    condition0 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.PARENT_ID,
                                         restData.Enum.ConditionTypeEnum.EQ,
                                         fruId)
    condition1 = restUtil.Tlv2Rest.getCondition(restData.Hardware.EthPort.RUNNING_STATUS,
                                         restData.Enum.ConditionTypeEnum.EQ,
                                         restData.Enum.RunningStatusEnum.LINK_UP)

    conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
    linkedPortRecs = restUtil.Tlv2Rest.filter(tmpRecs, conditionList)

    #打印结果
    restUtil.Tlv2Rest.logRecList(context, linkedPortRecs, "%s of front intf:%s" % (intfTye, fruId))

    return linkedPortRecs
