
class ProductBaseAdapter(object):
    def __init__(self, context):
        self.context = context

    def is_support(self):
        raise NotImplementedError

    def get_support_switch(self):
        raise NotImplementedError

    def get_switch_config(self, switch_ver):
        raise NotImplementedError

    def get_support_interface(self):
        raise NotImplementedError

    def get_expansion_spec(self, ctrl_num):
        raise NotImplementedError

    def get_logger(self):
        return self.context.get("logger")

    def get_doc_link(self, param):
        raise NotImplementedError

    def get_interface_result(self, interface_key, param):
        raise NotImplementedError
