# coding:utf-8

from cbb.frame.base import globalvar
from cbb.business.product.product_adapter_base import ProductBaseAdapter
from utils import Products


def init_product_adapter(context):

    logger = context.get("logger")
    config_files = ("product_dorado_6_1_2.py", )
    if not is_support_product_adapter(context):
        logger.info("not support product adapter.")
        return

    for config_file in config_files:
        logger.info("check product adapter: {}".format(config_file))
        if "__init__" in config_file:
            continue
        config_file_name = config_file.replace(".py", "")
        node_file = __import__(
            "cbb.business.product.adapter." + config_file_name,
            fromlist="cbb.business.product.adapter")
        product_class = getattr(node_file, "ProductAdapter")
        product_adapter = product_class(context)
        if product_adapter.is_support():
            logger.info("user product adapter:{}".format(config_file_name))
            globalvar.set_value("product_adapter", product_adapter)


def is_support_product_adapter(context):
    from cbb.frame.dsl import adapter
    from cbb.frame.adapter.replace_adapter import compare_version
    from cbb.frame.adapter.replace_adapter import is_digital_ver
    product_mode = adapter.get_dev_type(context)
    product_version = adapter.get_dev_version(context)
    if not is_digital_ver(product_version):
        return Products.compareVersion(product_version, "V700R001C00") >= 0
    if "dorado" in product_mode.lower():
        return compare_version(product_version, "6.1.2RC1") >= 0
    return True


def get_product_adapter():
    product_adapter = globalvar.get_value("product_adapter", "")
    if isinstance(product_adapter, ProductBaseAdapter):
        return product_adapter
    return product_adapter
