# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

CACHE_256GB = "256GB"  # 控制器内存大小：256GB
CACHE_512GB = "512GB"  # 控制器内存大小：512GB
CACHE_1T = "1T"  # 控制器内存大小：1T
# 2P型号控制器内存大小
CACHE_2P_256GB = "2P_256GB"
CACHE_2P_512GB = "2P_512GB"
CACHE_2P_1T = "2P_1T"

# 控制器编码字典
# 控制器内存大小: （C+控制器编码， C控制器编码）
CTRL_6810_BOM = {
    CACHE_256GB: ("02353TUX", "02352WLT"),
    CACHE_512GB: ("02353TUY", "02352WLV"),
    CACHE_1T: ("02353TVA", "02352WLW"),
}

CTRL_6800_BOM = {
    CACHE_256GB: ("02353VHE", "02352WLY"),
    CACHE_512GB: ("02353VHF", "02352WMB"),
    CACHE_1T: ("02353VHG", "02352WMD"),
}

CTRL_6810F_BOM = {
    CACHE_256GB: ("02353VHT", "02352WMF"),
    CACHE_512GB: ("02353VHU", "02352WMH"),
    CACHE_1T: ("02353VHV", "02352WMN"),
}

CTRL_18510_BOM = {
    CACHE_256GB: ("02353TTW", "02352WVK"),
    CACHE_512GB: ("02353TTX", "02352WVN"),
    CACHE_1T: ("02353TTY", "02352WVQ"),
}

CTRL_18500_BOM = {
    CACHE_256GB: ("02353TRN", "02352WWC"),
    CACHE_512GB: ("02353TRM", "02352WVY"),
    CACHE_1T: ("02353TRL", "02352WVU"),
}

CTRL_18510F_BOM = {
    CACHE_256GB: ("02354AFL", "02352WSQ"),
    CACHE_512GB: ("02354AFM", "02352WST"),
    CACHE_1T: ("02354AFN", "02352WSV"),
}

CTRL_18810_BOM = {
    CACHE_512GB: ("02353TUB", "02353ASR"),
    CACHE_1T: ("02353TUA", "02353ASQ"),
}

CTRL_18810F_BOM = {
    CACHE_512GB: ("02354AFP", "02353ATM"),
    CACHE_1T: ("02354AFQ", "02353ATN"),
}

CTRL_18800_BOM = {
    CACHE_512GB: ("02353TRP", "02353ASS"),
    CACHE_1T: ("02353TRQ", "02353AST"),
}

CTRL_DORADO_6800_BOM = {
    CACHE_256GB: ("02353SYT", "02352XRT", "02354JMC"),
    CACHE_512GB: ("02353SYU", "02352XRU", "02354JMD"),
    CACHE_1T: ("02353SYV", "02352XRV", "02354JME"),
    CACHE_2P_256GB: ("02354JMC",),
    CACHE_2P_512GB: ("02354JMD",),
    CACHE_2P_1T: ("02354JME",),
}

CTRL_DORADO_8000_BOM = {
    CACHE_256GB: ("02353TAN", "02352XRN"),
    CACHE_512GB: ("02353TAP", "02352XRP"),
    CACHE_1T: ("02353RUF", "02352XRQ"),
}

CTRL_DORADO_18000_BOM = {
    CACHE_256GB: ("02353TJB", "02352WWK"),
    CACHE_512GB: ("02353TJC", "02352WWM"),
    CACHE_1T: ("02353TJD", "02352WWP"),
}

CTRL_DORADO_18500_BOM = {
    CACHE_256GB: ("02353RVH", "02352WYP", "02354JLL"),
    CACHE_512GB: ("02353TJE", "02352WYQ", "02354JLM"),
    CACHE_1T: ("02353RVQ", "02352WYR", "02354JLN"),
    CACHE_2P_256GB: ("02354JLL",),
    CACHE_2P_512GB: ("02354JLM",),
    CACHE_2P_1T: ("02354JLN",),
}

CTRL_DORADO_18800K_BOM = {
    CACHE_512GB: ("02353UMQ", "02353KQX"),
    CACHE_1T: ("02353UMN", "02353KRB"),
}

CTRL_DORADO_18800_BOM = {
    CACHE_512GB: ("02353TJE", "02352WYQ"),
    CACHE_1T: ("02353RVQ", "02352WYR"),
}


# 各型号控制框与控制器的bom配套关系
# （C+框BOM, C框BOM）：（C+控制器BOM，C控制器BOM）
ENCLOSURE_TO_CTRL = {
    "2810 V5": {
        (("02353XWC",), ("02353KXP",)): ("", ""),
    },
    "5310 V5": {
        (("02353XWB", "02353XWA"), ("02353GUH", "02353GUG")): ("", ""),
        (("02353XVY", "02353XVW", "02353XVT", "02353XVQ"),
         ("02352TLS", "02352TDN", "02352TDQ", "02352TDM")): ("", ""),
        (("02353XVX", "02353XVU", "02353XVR", "02353XVP"),
         ("02352XJE", "02352XHV", "02352TDP", "02352SCG")): ("", ""),
        (("02353TXX", "02353XQE"), ("",)): ("", ""),
    },
    "5300 V5": {
        (("02353YKG",), ("02353MTJ",)): ("", ""),
        (("02353XVN", "02353XVM"), ("02353SAH", "02353RYV")): ("", ""),
        (("02353XVL", "02353XVH", "02353XVB", "02353XUY"),
         ("02353MVY", "02353MVW", "02352XEX", "02352XEN")): ("", ""),
        (("02353XVJ", "02353XVF", "02353XVA", "02353XUX"),
         ("02353MVX", "02353MVT", "02352XET", "02352XEJ")): ("", ""),
    },
    "5300K V5": {
        (("",), ("02353QGA", "02353QGC")): ("", ""),
        (("",), ("02353QGE", "02353QGF")): ("", ""),
    },
    "5500K V5": {
        (("",), ("02353JLY", "02353KXH", "02353KXL")): ("", ""),
        (("",), ("02353KXJ", "02353KXK", "02353KXM")): ("", ""),
    },
    "5310F V5": {
        (("02353YSR",), ("",)): ("", ""),
        (("02353YSS",), ("",)): ("", ""),
    },
    "5510 V5": {
        (("02353QPH", "02353TSX", "02353TTA",
          "02353UTP", "02353UTQ", "02353UTS"),
         ("02352TRM", "02352TSA", "02353CQT",)): ("", ""),
        (("02353QPF", "02353TSY", "02353QPK",
          "02353UTL", "02353UTN", "02353UTR"),
         ("02353AUQ", "02353AUW", "02353CQS",)): ("", ""),
        (("02353VWC",), ("",)): ("", ""),
    },
    "5500 V5": {
        (("02353TQC", "02353TQD", "02353TQH",
          "02353TQL", "02353TQM", "02353TQP"),
         ("02352VVC", "02352VVD", "02353CTN",
          "02353MQU", "02353MQV", "02353MRC")): ("", ""),
        (("02353TQE", "02353TQF", "02353TQG",
          "02353TQJ", "02353TQK", "02353TQN"),
         ("02353AUT", "02353AVA", "02353CTL",
          "02353MQS", "02353MQT", "02353MRB")): ("", ""),
    },
    "5510F V5": {
        (("02353UEF", "02353QNX"), ("02353BAV", "02353BBL")): ("", ""),
        (("02353UEJ", "02353UEL"), ("02353BBB", "02353BBP")): ("", ""),
        (("02353VWE",), ("",)): ("", ""),
    },
    "5610 V5": {
        (("02353TSR", "02353QPC", "02353TSW",
          "02353USW", "02353USY", "02353UTA"),
         ("02352SCE", "02352USM", "02353CQU")): ("", ""),
        (("02353TST", "02353TSV", "02353QNV",
          "02353UST", "02353USU", "02353USV"),
         ("02353AVE", "02353AWM", "02353CQV",)): ("", ""),
    },
    "5600 V5": {
        (("02353TPM", "02353TPP", "02353TPS",
          "02353TPY", "02353TQA", "02353TQB"),
         ("02352VMN", "02352VMR", "02353CTH",
          "02353MRJ", "02353MRK", "02353MRN")): ("", ""),
        (("02353TPQ", "02353TPR", "02353TPT",
          "02353TPU", "02353TPV", "02353TPW"),
         ("02353AVH", "02353AWQ", "02353CTK",
          "02353MRD", "02353MRE", "02353MRH")): ("", ""),
    },
    "5610F V5": {
        (("02353UEM", "02353UEP"), ("02353BAL", "02353BAQ")): ("", ""),
        (("02353UEN", "02353UER"), ("02353BAM", "02353BAR")): ("", ""),
    },
    "5810 V5": {
        (("02353TTC", "02353QNY", "02353QNT",
          "02353UTT", "02353UTV", "02353UTX"),
         ("02352SCB", "02353AWW", "02353CQW")): ("", ""),
    },
    "5800 V5": {
        (("02353TQQ", "02353TQR", "02353TQS",
          "02353TQT", "02353TQU", "02353TQV"),
         ("02353AWT", "02353AWX", "02353CSN",
          "02353MRP", "02353MRQ", "02353MRT")): ("", ""),
    },
    "5810F V5": {
        (("02353UET", "02353UEV"), ("02352TVG", "02353AXB")): ("", ""),
    },
    "6810 V5": {
        (("02353TUM", "02353TUU"), ("02352TMA", "02352WKE")):
            CTRL_6810_BOM.get(CACHE_256GB),
        (("02353TUS", "02353TUV", "02353UTY", "02353UUE"),
         ("02352WJW", "02352WKF")): CTRL_6810_BOM.get(CACHE_512GB),
        (("02353TUT", "02353TUW", "02353UUB", "02353UUF"),
         ("02352WJX", "02352WKG")): CTRL_6810_BOM.get(CACHE_1T),
    },
    "6800 V5": {
        (("02353TSE", "02353TSF"), ("02352VPN", "02352VQE")):
            CTRL_6800_BOM.get(CACHE_256GB),
        (("02353TSG", "02353TSJ", "02353TSL", "02353TSN"),
         ("02352WLF", "02352WLL", "02353NDL", "02353NDP")):
            CTRL_6800_BOM.get(CACHE_512GB),
        (("02353TSH", "02353TSK", "02353TSM", "02353TSQ"),
         ("02352WLG", "02352WLM", "02353NDN", "02353NDR")):
            CTRL_6800_BOM.get(CACHE_1T),
    },
    "6810F V5": {
        (("02353UEW", "02353UFF"), ("02352WJT", "02352WLC")):
            CTRL_6810F_BOM.get(CACHE_256GB),
        (("02353UFA", "02353UFL"), ("02352WKP", "02352WLX")):
            CTRL_6810F_BOM.get(CACHE_256GB),
        (("02353UEX", "02353UFH"), ("02352WJU", "02352WLD")):
            CTRL_6810F_BOM.get(CACHE_512GB),
        (("02353UFC", "02353UFN"), ("02352WKR", "02352WMC")):
            CTRL_6810F_BOM.get(CACHE_512GB),
        (("02353UEY", "02353UFJ"), ("02352WKL", "02352WLE")):
            CTRL_6810F_BOM.get(CACHE_1T),
        (("02353UFD", "02353UFP"), ("02352WKU", "02352WME")):
            CTRL_6810F_BOM.get(CACHE_1T),
    },
    "18510 V5": {
        (("02353TTJ", "02353TTR"), ("02352WMG", "02352WSL")):
            CTRL_18510_BOM.get(CACHE_256GB),
        (("02353TTK", "02353TTQ"), ("02352WRW", "02352WSJ")):
            CTRL_18510_BOM.get(CACHE_512GB),
        (("02353TTL", "02353TTS"), ("02352WRY", "02352WSP")):
            CTRL_18510_BOM.get(CACHE_1T),
        (("02353TTM", "02353TTT"), ("02352WSB", "02352WSR")):
            CTRL_18510_BOM.get(CACHE_1T),
        (("02353TTN", "02353TTU"), ("02352WSC", "02352WSU")):
            CTRL_18510_BOM.get(CACHE_512GB),
        (("02353TTP", "02353TTV"), ("02352WSE", "02352WSW")):
            CTRL_18510_BOM.get(CACHE_256GB),
        (("02353WRM", "02353WRS"), ("",)): CTRL_18510_BOM.get(CACHE_256GB),
        (("02353WRN", "02353WRR"), ("",)): CTRL_18510_BOM.get(CACHE_512GB),
        (("02353WRQ", "02353WRT"), ("",)): CTRL_18510_BOM.get(CACHE_1T),
    },
    "18500 V5": {
        (("02353TQX", "02353TRE"), ("02352WUJ", "02352WUS")):
            CTRL_18500_BOM.get(CACHE_256GB),
        (("02353TQY", "02353TRF"), ("02352WUK", "02352WUV")):
            CTRL_18500_BOM.get(CACHE_512GB),
        (("02353TRA", "02353TRG"), ("02352WUL", "02352WUX")):
            CTRL_18500_BOM.get(CACHE_1T),
        (("02353TRB", "02353TRH"), ("02352WUM", "02352WVA")):
            CTRL_18500_BOM.get(CACHE_1T),
        (("02353TRC", "02353TRJ"), ("02352WUN", "02352WVC")):
            CTRL_18500_BOM.get(CACHE_512GB),
        (("02353TRD", "02353TRK"), ("02352WUQ", "02352WVE")):
            CTRL_18500_BOM.get(CACHE_256GB),
        (("02353WRC", "02353WRJ"), ("",)): CTRL_18500_BOM.get(CACHE_256GB),
        (("02353WRF", "02353WRK"), ("",)): CTRL_18500_BOM.get(CACHE_512GB),
        (("02353WRG", "02353WRL"), ("",)): CTRL_18500_BOM.get(CACHE_1T),
    },
    "18510F V5": {
        (("02353UFR", "02353UGC"), ("02352WPK", "02352WPY")):
            CTRL_18510F_BOM.get(CACHE_256GB),
        (("02353UFU", "02353UGD"), ("02352WPM", "02352WQB")):
            CTRL_18510F_BOM.get(CACHE_512GB),
        (("02353UFV", "02353UGF"), ("02352WPN", "02352WQC")):
            CTRL_18510F_BOM.get(CACHE_1T),
        (("02353UFX", "02353UGH"), ("02352WPT", "02352WQE")):
            CTRL_18510F_BOM.get(CACHE_256GB),
        (("02353UFY", "02353UGJ"), ("02352WPV", "02352WQF")):
            CTRL_18510F_BOM.get(CACHE_512GB),
        (("02353UGA", "02353UGL"), ("02352WPX", "02352WQH")):
            CTRL_18510F_BOM.get(CACHE_1T),
    },
    "18810 V5": {
        (("02353RLW", "02353TUG"), ("02353ASU", "02353ASY")):
            CTRL_18810_BOM.get(CACHE_512GB),
        (("02353TUD", "02353TUH"), ("02353ASV", "02353ATA")):
            CTRL_18810_BOM.get(CACHE_1T),
        (("02353TUE", "02353TUJ"), ("02353ASW", "02353ATB")):
            CTRL_18810_BOM.get(CACHE_512GB),
        (("02353TUF", "02353TUL"), ("02353ASX", "02353ATC")):
            CTRL_18810_BOM.get(CACHE_1T),

        (("02353XMN", "02353XMQ"), ("",)): CTRL_18810_BOM.get(CACHE_512GB),
        (("02353XMP", "02353XMR"), ("",)): CTRL_18810_BOM.get(CACHE_1T),
    },
    "18800 V5": {
        (("02353TRR", "02353TRV"), ("02353ATD", "02353ATH")):
            CTRL_18800_BOM.get(CACHE_512GB),
        (("02353TRS", "02353TRW"), ("02353ATE", "02353ATJ")):
            CTRL_18800_BOM.get(CACHE_1T),
        (("02353TRT", "02353TRX"), ("02353ATF", "02353ATK")):
            CTRL_18800_BOM.get(CACHE_512GB),
        (("02353TRU", "02353TRY"), ("02353ATG", "02353ATL")):
            CTRL_18800_BOM.get(CACHE_1T),

        (("02353XMS", "02353XMU"), ("",)): CTRL_18800_BOM.get(CACHE_512GB),
        (("02353XMT", "02353XMV"), ("",)): CTRL_18800_BOM.get(CACHE_1T),
    },

    "18810F V5": {
        (("02353UGM", "02353UGT"), ("02353ATR", "02353AUA")):
            CTRL_18810F_BOM.get(CACHE_512GB),
        (("02353UGN", "02353UGU"), ("02353ATS", "02353AUB")):
            CTRL_18810F_BOM.get(CACHE_1T),
        (("02353UGQ", "02353UGV"), ("02353ATT", "02353AUE")):
            CTRL_18810F_BOM.get(CACHE_512GB),
        (("02353UGR", "02353UGW"), ("02353ATW", "02353AUF")):
            CTRL_18810F_BOM.get(CACHE_1T),
    },
    "OCEANSTOR DORADO 3000 V6": {
        (("02353TXG", "02353TXN"), ("02353BBF", "02353MRW")): ("", ""),
        (("02353TXM",), ("02353NVW",)): ("", ""),
        (("02353UYJ", "02353UYH"), ("02353ULD", "02353ULE")): ("", ""),
    },
    "OCEANSTOR DORADO 5000 V6": {
        (("02353TJK",), ("02353PBY",)): ("", ""),
        (("02353TJL",), ("02353PCA",)): ("", ""),
        (("02353TJM",), ("02353PCB",)): ("", ""),
        (("02353TJN",), ("02353PCC",)): ("", ""),
        (("02353SYQ", "02353WWQ"), ("02352VUT",)): ("", ""),
        (("02353SYP", "02353WWP"), ("02352VUU",)): ("", ""),
        (("02353SYS", "02353TJG"), ("02352VUV", "02353MQG")): ("", ""),
        (("02353SYR", "02353TJF"), ("02352VUW", "02353MQF")): ("", ""),
        (("02353SSV", "02353TJJ"), ("02353AUJ", "02353MQN")): ("", ""),
        (("02353SSQ", "02353TJH"), ("02353AUK", "02353MQM")): ("", ""),
    },
    "OCEANSTOR DORADO 8000 V6": {
        (("02353RSJ", "02353RSY", "02354JMJ", "02354JMM"), ("02352XNV", "02352XQP")):
            CTRL_DORADO_8000_BOM.get(CACHE_256GB),
        (("02353SYX", "02353TAE", "02353XLH", "02353XLF", "02354JMK", "02354JMN"),
         ("02352XPC", "02352XQS")):
            CTRL_DORADO_8000_BOM.get(CACHE_512GB),
        (("02353SYY", "02353TAF", "02353XLJ", "02353XLG", "02354JML", "02354JMP"),
         ("02352XPE", "02352XQV")):
            CTRL_DORADO_8000_BOM.get(CACHE_1T),
        (("02353TAA", "02353TAG", "02354JMV", "02354JMY"), ("02352XPH", "02352XQX")):
            CTRL_DORADO_8000_BOM.get(CACHE_256GB),
        (("02353RSU", "02353TAH", "02353TAS", "02353TAQ", "02354JMW", "02354JNA"),
         ("02352XPK", "02352XRC", "02353NDU", "02353NDS")):
            CTRL_DORADO_8000_BOM.get(CACHE_512GB),
        (("02353RSV", "02353TAJ", "02353TAT", "02353TAR", "02354JMX", "02354JNB"),
         ("02352XPP", "02352XRG", "02353NDV", "02353NDT")):
            CTRL_DORADO_8000_BOM.get(CACHE_1T),
        (("02353TAB", "02353TAK"), ("02352XPR", "02352XRJ")):
            CTRL_DORADO_8000_BOM.get(CACHE_256GB),
        (("02353TAC", "02353TAL", "02353TAW", "02353TAU"),
         ("02352XQJ", "02352XRK", "02353NDY", "02353NDW")):
            CTRL_DORADO_8000_BOM.get(CACHE_512GB),
        (("02353TAD", "02353TAM", "02353TAX", "02353TAV"),
         ("02352XQL", "02352XRL", "02353NEA", "02353NDX")):
            CTRL_DORADO_8000_BOM.get(CACHE_1T),
    },
    "OCEANSTOR DORADO 18000 V6": {
        (("02353THK", "02353THS"), ("02352WUW", "02352WVM")):
            CTRL_DORADO_18000_BOM.get(CACHE_256GB),
        (("02353RVB", "02353THT"), ("02352WUY", "02352WVP")):
            CTRL_DORADO_18000_BOM.get(CACHE_512GB),
        (("02353THL", "02353THU"), ("02352WVB", "02352WVR")):
            CTRL_DORADO_18000_BOM.get(CACHE_1T),
        (("02353THM", "02353THV"), ("02352WVD", "02352WVT")):
            CTRL_DORADO_18000_BOM.get(CACHE_256GB),
        (("02353THN", "02353RVD"), ("02352WVF", "02352WVW")):
            CTRL_DORADO_18000_BOM.get(CACHE_512GB),
        (("02353RVC", "02353THW"), ("02352WVG", "02352WWA")):
            CTRL_DORADO_18000_BOM.get(CACHE_1T),
        (("02353THP", "02353THX"), ("02352WVH", "02352WWD")):
            CTRL_DORADO_18000_BOM.get(CACHE_256GB),
        (("02353THQ", "02353THY"), ("02352WVJ", "02352WWE")):
            CTRL_DORADO_18000_BOM.get(CACHE_512GB),
        (("02353THR", "02353TJA"), ("02352WVL", "02352WWG")):
            CTRL_DORADO_18000_BOM.get(CACHE_1T),
    },
    "OCEANSTOR DORADO 5300 V6": {
        (("02353UBF", "02353YNV"), ("02353GUC",)): ("", ""),
        (("02353UYG", "02353UYF"), ("02353ULF", "02353ULG")): ("", ""),
    },
    "OCEANSTOR DORADO 5500 V6": {
        (("02353TJW", "02353UUX"), ("02353GSV",)): ("", ""),
        (("02353TJX", "02353UUY"), ("02353GSW",)): ("", ""),
        (("02353TJY", "02353WWR"), ("02353GSX",)): ("", ""),
        (("02353TKA", "02353UVA"), ("02353GSY",)): ("", ""),
        (("02353TKB", "02353UVB"), ("02353GTA",)): ("", ""),
        (("02353TKC", "02353WWT"), ("02353GTB",)): ("", ""),
    },
    "OCEANSTOR DORADO 6800 V6": {
        (("02353TLR", "02353TLF", "02354JLV", "02354JLY"), ("02353GVQ", "02353GVL")):
            CTRL_DORADO_6800_BOM.get(CACHE_256GB),
        (("02353TLS", "02353TLL", "02354JLW", "02354JMA"), ("02353GVR", "02353GVM")):
            CTRL_DORADO_6800_BOM.get(CACHE_512GB),
        (("02353TLT", "02353TLA", "02354JLX", "02354JMB"), ("02353GVS", "02353GVP")):
            CTRL_DORADO_6800_BOM.get(CACHE_1T),
        (("02353TLM", "02353TKY", "02354JLP", "02354JLS"), ("02353GVW", "02353GVT")):
            CTRL_DORADO_6800_BOM.get(CACHE_256GB),
        (("02353TLP", "02353TKW", "02354JLQ", "02354JLT"), ("02353GVX", "02353GVU")):
            CTRL_DORADO_6800_BOM.get(CACHE_512GB),
        (("02353TLQ", "02353TKU", "02354JLR"), ("02353GVY", "02353GVV")):
            CTRL_DORADO_6800_BOM.get(CACHE_1T),
        (("02353TMA", "02353TLW"), ("02353HGJ", "02353HGF")):
            CTRL_DORADO_6800_BOM.get(CACHE_1T),
        (("02353TLY", "02353TLV"), ("02353HGL", "02353HGG")):
            CTRL_DORADO_6800_BOM.get(CACHE_512GB),
        (("02353TLX", "02353TLU"), ("02353HGM", "02353HGH")):
            CTRL_DORADO_6800_BOM.get(CACHE_256GB),
    },
    "OCEANSTOR DORADO 18500 V6": {
        (("02353TMG", "02353TMN", "02354JLK"), ("02353GWU", "02353GXD")):
            CTRL_DORADO_18500_BOM.get(CACHE_1T),
        (("02353TMM", "02353TMF", "02354JLF", "02354JLJ"), ("02353GXC", "02353GWV")):
            CTRL_DORADO_18500_BOM.get(CACHE_512GB),
        (("02353TML", "02353TME", "02354JLE", "02354JLH"), ("02353GXB", "02353GWW")):
            CTRL_DORADO_18500_BOM.get(CACHE_256GB),
        (("02353TMK", "02353TMD", "02354JLA", "02354JLD"), ("02353GWX", "02353GWR")):
            CTRL_DORADO_18500_BOM.get(CACHE_1T),
        (("02353TMJ", "02353TMC", "02354JLC"), ("02353GWY", "02353GWS")):
            CTRL_DORADO_18500_BOM.get(CACHE_512GB),
        (("02353TMH", "02353TMB", "02354JKX", "02354JLB"), ("02353GXA", "02353GWT")):
            CTRL_DORADO_18500_BOM.get(CACHE_256GB),
        (("02353TMU", "02353TMR"), ("02353HHM", "02353HHJ")):
            CTRL_DORADO_18500_BOM.get(CACHE_1T),
        (("02353TMT", "02353TMQ"), ("02353HHN", "02353HHK")):
            CTRL_DORADO_18500_BOM.get(CACHE_512GB),
        (("02353TMS", "02353TMP"), ("02353HHP", "02353HHL")):
            CTRL_DORADO_18500_BOM.get(CACHE_256GB),
    },
    "OCEANSTOR DORADO 18800 V6": {
        (("02353TND", "02353TNB"), ("02353GXF", "02353GXM")):
            CTRL_DORADO_18800_BOM.get(CACHE_1T),
        (("02353TNC", "02353TNA"), ("02353GXE", "02353GXL")):
            CTRL_DORADO_18800_BOM.get(CACHE_512GB),
        (("02353TMY", "02353TMW"), ("02353GXG", "02353GXJ")):
            CTRL_DORADO_18800_BOM.get(CACHE_1T),
        (("02353TMX", "02353TMV"), ("02353GXH", "02353GXK")):
            CTRL_DORADO_18800_BOM.get(CACHE_512GB),
        (("02353TNH", "02353TNF"), ("02353HHS", "02353HHQ")):
            CTRL_DORADO_18800_BOM.get(CACHE_1T),
        (("02353TNG", "02353TNE"), ("02353HHT", "02353HHR")):
            CTRL_DORADO_18800_BOM.get(CACHE_512GB),
    },
    "OCEANSTOR DORADO 18800K V6": {
        (("02353UML", "02353UMJ"), ("02353KQV", "02353KQT")):
            CTRL_DORADO_18800K_BOM.get(CACHE_512GB),
        (("02353UMM", "02353UMK"), ("02353KQW", "02353KQU")):
            CTRL_DORADO_18800K_BOM.get(CACHE_1T),
    },
}
