# coding: utf-8
from cbb.common.query.hardware.utils import getFruGivenTypeAndConditions
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.cli import cliUtil


def getLinkedUpPortsInfo(context, portTypeEnumTuple, location=None):
    """获取LinkUp状态的端口信息

    :param context:
    :param portTypeEnumTuple 端口类型Tuple，支持同时获取多个类型的端口信息
    :return:
    """
    linkedPortInfo = {}
    portTypeNameDict = {
        restData.Enum.ObjEnum.ETH_PORT: 'ETH',
        restData.Enum.ObjEnum.FC_PORT: 'FC',
    }

    for portTypeEnum in portTypeEnumTuple:
        portTypeName = portTypeNameDict.get(portTypeEnum, '')
        portsInfoDict = getFruGivenTypeAndConditions(context, portTypeEnum, location,
                                                     restData.Enum.RunningStatusEnum.LINK_UP)
        linkedPortInfo[portTypeName] = portsInfoDict

    return linkedPortInfo


def get_back_end_port(ports, logic_type):
    """从端口记录中筛选所有后端端口

    :param ports: 端口记录列表
    :param logic_type: 端口逻辑类型
    :return:
    """

    condition = restUtil.Tlv2Rest.getCondition(
        logic_type,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.PortLogicTypeEnum.EXP)
    conditionList = restUtil.Tlv2Rest.getConditionList(condition)
    ports = restUtil.Tlv2Rest.filter(ports, conditionList)
    return ports if ports else []


def get_bond_port(cli, lang):
    """获取show bond_port返回信息

    :param cli: cli链接
    :param lang: 语言
    :return:
    """
    # 执行命令获取回显
    cmd = "show bond_port"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return False, cli_ret, err_msg

    # 处理回显 获取回显字典列表
    bond_port_info_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    return True, bond_port_info_list, err_msg


def get_logical_port(cli, lang):
    """获取show logical_port返回信息

    :param cli: cli链接
    :param lang: 语言
    :return:
    """
    # 执行命令获取回显
    cmd = "show logical_port general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return False, cli_ret, err_msg

    # 处理回显 获取回显字典列表
    logical_port_info_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    return True, logical_port_info_list, err_msg
