# -*- coding: UTF-8 -*-
from cbb.frame.adapter.cliService import CliService
from cbb.frame.adapter.restService import RestAdapter, RestService
from cbb.frame.adapter.tlvService import TlvAdapter, TlvService
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil


def getAdapter(dataDict):
    """
    根据设备类型及版本号获取对应的接口类型（rest和tlv）
    """
    logger = contextUtil.getLogger(dataDict)
    devVersion = contextUtil.getCurVersion(dataDict)
    devType = contextUtil.getDevType(dataDict)
    logger.info("Enter protocol factory.devType=%s, "
                "devVersion=%s" % (devType, devVersion))
    if baseUtil.isSupportRest(devType, devVersion):
        logger.info("user rest adapter.")
        return RestAdapter(dataDict)
    else:
        logger.info("user tlv adapter.")
        return TlvAdapter(dataDict)


def getCliService(dataDict):
    """ 获取cli连接服务 """
    return CliService(dataDict)


def getTlvService(dataDict):
    """ 获取TLV连接服务 """
    return TlvService(dataDict)


def getRestService(dataDict):
    """ 获取rest连接服务 """
    return RestService(dataDict)
