# -*- coding: UTF-8 -*-
import threading
import time

from cbb.frame.context import contextUtil


class RefreshProgress(threading.Thread):
    def __init__(self, context, callback):
        threading.Thread.__init__(self)
        self.context = context
        self.logger = contextUtil.getLogger(context)
        self.__running = threading.Event()
        self.__running.set()
        self.speedSteps = [(10, 80), (15, 99)]
        self.totalTime = 15
        self.setProgress = callback.setProgress
        self.stopRefresh = callback.stopRefresh

    def setSpeedSteps(self, steps):
        """
        设置进度刷新的步长
        :param steps: 进度刷新的步长
        :return: 无
        """
        self.speedSteps = steps
        self.totalTime = self.speedSteps[-1][0]

    def stop(self):
        """
        停止进度刷新，并设置当前进度为100%
        :return: 无
        """
        self.__running.clear()
        self.setProgress(100, 0)

    def computeCurrentProgress(self, time):
        """
        计算当前进度
        :param time: 已经消耗的时间
        :return: 当前进度
        """
        currentProgress = 0
        lastArea = (0, 0)
        for speedStep in self.speedSteps:
            if time < speedStep[0]:
                currentProgress += time * ((speedStep[1] - lastArea[1]) *
                                           1.0 / (speedStep[0] - lastArea[0]))
                return currentProgress
            else:
                time -= speedStep[0]
                currentProgress = speedStep[1]
            lastArea = speedStep
        return currentProgress

    def run(self):
        """
        启动进度刷新
        :return:无
        """
        currentPro = 0
        self.setProgress(currentPro, self.totalTime)

        startTime = time.clock()
        expendTime = 0
        while self.__running.isSet() and not self.stopRefresh():
            expendTime = time.clock() - startTime
            currentPro = self.computeCurrentProgress(expendTime)
            self.remainTime = self.totalTime - expendTime
            self.remainTime = 5 if self.remainTime < 5 else self.remainTime
            currentPro = 99 if currentPro > 99 else currentPro
            self.setProgress(currentPro, self.remainTime)
            time.sleep(2)
        self.logger.info("the item actual expend time=%s" % expendTime)
        return

    def addRemainTime(self, second):
        """
        增加进度剩余时间
        :param second: 增加的剩余时间
        :return: 无
        """
        self.remainTime += second
