#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2020~ All rights reserved.

import traceback

from com.huawei.ism.tool.obase.connection import SftpTransporter
from com.huawei.ism.tool.obase.exception import ToolException


class CliUtil(object):

    @classmethod
    def get_ssh(cls, dev_obj):
        return dev_obj.get("SSH")

    @classmethod
    def get_logger(cls, dev_obj):
        return dev_obj.get('logger')

    @classmethod
    def check_cli_connect(cls, dev_obj, reconnect=True):
        """
        检查cli连接是否正常
            1.检查回文是否正常返回
            2.检查是否有退出storage模式
        :param dev_obj: 设备
        :param reconnect: True:异常情况自动重连，False:不自动重连
        :return: True:正常
                 False:异常
        """
        cmd = "show system general"
        ssh = cls.get_ssh(dev_obj)
        logger = cls.get_logger(dev_obj)
        logger.info("Info collect check cli connect")
        try:
            ret = ssh.execCmd(cmd)
            if reconnect and ret.find('Storage:~') > -1:
                cls.reconnect_ssh(dev_obj)
        except (ToolException, Exception):
            logger.error("Info collect conn is not alive: {}".format(
                unicode(traceback.format_exc())))
            if reconnect:
                cls.reconnect_ssh(dev_obj)

    @classmethod
    def reconnect_ssh(cls, dev_obj):
        ssh = cls.get_ssh(dev_obj)
        logger = cls.get_logger(dev_obj)
        logger.info("Info collect reconnect cli")
        sftp_string = "SFTP"
        try:
            ssh.reConnect()
            sftp = dev_obj.get(sftp_string)
            if sftp is not None:
                sftp.close()
            sftp = SftpTransporter(ssh)
            dev_obj[sftp_string] = sftp
        except (ToolException, Exception):
            logger.error("Info collect cli reconnect error: {}".format(
                unicode(traceback.format_exc())))
