# -*- coding: UTF-8 -*-

#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from cbb.frame.cli.cliFactory import CliConnection
from cbb.frame.cli.cli_helper import enter_target_mode, exit_to_developer_from_diagnose
import java.lang.Exception as jException

"""
屏蔽掉SVP内外差异，获取ctrl的连接
contextUtil.getCliCommon()-从上下文获取连接
contextUtil.getCli()--先从python的缓存中获取连接，没有就新建
contextUtil.get_new_cli()--先从python的缓存中获取连接，没有就新建
get_ctrl_cli() -针对高端设备， 返回控制器的连接。
针对需要多个连接的场景的使用方式：
遍历控制器使用连接的方式：
sftp_controller

"""


def get_ctrl_cli(context, cli=None, allow_not_admin=False):
    """获取到控制器的连接，支持以设备IP+sn作为缓存

    :param context: 上下文对象
    :param cli: 原始cli
    :param allow_not_admin: 是否允许获取到处于非admin状态的连接
    :return:
    """
    logger = context.get("logger")
    if baseUtil.has_svp_module(context):
        logger.info("get_ctrl_cli has svp.")
        return get_conn_for_svp(context, cli, allow_not_admin)
    else:
        logger.info("get_ctrl_cli no svp")
        return get_available_conn(context, cli, allow_not_admin)


def get_available_conn(context, cli=None, allow_not_admin=False):
    dev_obj = contextUtil.getDevObj(context)
    logger = context.get("logger")
    if cli:
        return CliConnection.get_available_con(cli, logger, allow_not_admin)
    ip = dev_obj.get("ip")
    sn = dev_obj.get("sn")
    conn_key = contextUtil.CLI_CONNECTION + ip + sn + context.get("conn_sn_suffix", "")
    conn = contextUtil.getItem(context, conn_key)
    logger.info("conn_key={}".format(conn_key))
    if conn is None:
        logger.info("conn is None")
        conn = contextUtil.createCliConnection(context, ip, set_item=False)
        conn = CliConnection.get_available_con(conn, logger, allow_not_admin)
        contextUtil.setItem(context, conn_key, conn)
    else:
        conn = CliConnection.get_available_con(conn, logger, allow_not_admin)
    return conn


def get_conn_for_svp(context, cli, allow_not_admin=False):
    dev_obj = contextUtil.getDevObj(context)
    logger = context.get("logger")
    ip = dev_obj.get("ip")
    sn = dev_obj.get("sn")
    conn_key = contextUtil.CLI_CONNECTION + ip + sn + "_ctrl" + \
        context.get("conn_sn_suffix", "")
    conn = contextUtil.getItem(context, conn_key)
    logger.info("conn_key={}".format(conn_key))
    if conn is None:
        logger.info("conn is None")
        # svp场景，首次创建连接要求连接到normal的控制器
        conn = create_available_conn_for_svp(
            context, logger, cli, False)
        contextUtil.setItem(context, conn_key, conn)
    else:
        conn = CliConnection.get_available_con(conn, logger, allow_not_admin)
    return conn


def create_available_conn_for_svp(
        context, logger, cli=None, allow_not_admin=False):
    """
    高端SVP环境获取控制器的cli连接
    """
    # 有svp 先获取控制器的ip 然后创建连接到该ip的连接
    if not cli:
        logger.info("no cli, get conn by context")
        cli = get_available_conn(context)

    # 检查cli是否可以进入debug
    if enter_target_mode(cli, "diagnose", "en")[0]:
        logger.info("current cli can enter debug mode.")
        exit_to_developer_from_diagnose(cli, "en")
        return cli
    lang = contextUtil.getLang(context)
    flag, controller_ip_list = cliUtil.get_controller_ip_list(cli, lang)
    if flag:
        # 返回第一个成功连接的控制器
        for controller_ip in controller_ip_list:
            ctrl_cli = contextUtil.createCliConnection(context, controller_ip, set_item=False)
            try:
                CliConnection.check_connect(ctrl_cli, logger, allow_not_admin)
            except (Exception, jException):
                close_cli(controller_ip, ctrl_cli, logger)
                continue
            if ctrl_cli:
                logger.info("init cli connection successfully")
                return ctrl_cli
    return cli


def close_cli(controller_ip, ctrl_cli, logger):
    if ctrl_cli:
        ctrl_cli.close()
    logger.info('%s connect failed, continue.' % controller_ip)
