# coding:utf-8
"""
数据库相关配置
@version: Toolkit V200R006C00
@time: 2019/11/08
@file: sqlite_config.py
@function:
@modify:
"""
import os

# 是否已创建数据库，用于区分双活场景requirecheck.py中已创建，
# preinspect.py中重复创建的问题。
SQLITE_DB_CREATED_FLAG = "sqlite_db_created_flag"

# 默认数据库路径SmartKitxxx\tools\xxtool\temp
DIR_RELATIVE_CMD = ".\\temp"
SQLITE_DB_ABS_PATH = os.path.abspath(DIR_RELATIVE_CMD)

# 数据库存放目录，方便回收删除
SQLITE_DB_ABS_PATH_DEV_DIR = "sqlite_db"

# 默认数据库文件名
SQLITE_DEFAULT_DB_NAME = "array_info_data.db"

DEFAULT_CREATE_TABLE_SQL = "CREATE TABLE if not exists " \
                           "[table_array_info](" \
                           "[conn_type] VARCHAR2(5) NOT NULL DEFAULT ssh," \
                           "[sn] VARCHAR2 NOT NULL, " \
                           "[view_mode] VARCHAR2 DEFAULT Admin, " \
                           "[controller_id] VARCHAR2(3), " \
                           "[cmd] VARCHAR2 NOT NULL, " \
                           "[result_flag] VARCHAR2 DEFAULT True," \
                           "[result_echo] VARCHAR2 DEFAULT echo, " \
                           "[result_error_msg] VARCHAR2);"

DEFAULT_DROP_TABLE_SQL = "drop table if exists table_array_info;"

# 数据库连接缓存key
SQLITE_CONN_DICT = "SQLITE_CONN_DICT{0}"
SQLITE_CONN_DB_PATH = "SQLITE_CONN_DB_PATH"
SQLITE_CONN = "SQLITE_CONN"


class DBConfig:
    class Column:
        # 数据库列名
        ARRAY_CONN_TRYPE = "conn_type"
        ARRAY_SN = "sn"
        ARRAY_VIEW_MODE = "view_mode"
        ARRAY_CTRL = "controller_id"
        ARRAY_COMMAND = "cmd"
        ARRAY_RES_FLAG = "result_flag"
        ARRAY_RES_CLI_RET = "result_echo"
        ARRAY_RES_ERR_MSG = "result_error_msg"

    class ConnType:
        SSH = "SSH"
        REST = "REST"
