# -*- coding: UTF-8 -*-
import expparser
from cbb.frame.dsl.common import DslException, ReturnException
from cbb.frame.dsl import adapter
import traceback
from cbb.frame.dsl.operator.operator_factory import (
    get_data_source_operators,
    get_parser_operators
)


class DslContext:
    def __init__(self, context=None):

        # 每个操作符执行完成后，将结果记录到last_data，给下个环节使用
        self.last_data = None

        # 执行命令等操作符需要记录命令回显作为原始信息
        self.origin_info = []

        # 用于接收dsl函数的第2个及之后的参数
        self.args = None

        # 用于接收dsl的字典参数
        self.kwargs = None

        # 脚本原始的上下文
        self.context = context

        # 匹配到的日志数据
        self.matched_data = {}


class Dsl:
    def __init__(self, dsl_context):
        self.dsl_context = dsl_context
        self.origin_info = []
        self.logger = adapter.get_logger(dsl_context.context)

    def dsl(self, express, *args, **kwargs):
        """
        执行一条dsl命令
        :param express: dsl 表达式
        :return:
        """
        self.logger.info("run dsl {}".format(express))
        self.dsl_context.args = args
        self.dsl_context.kwargs = kwargs
        exec_section = get_data_source_operators(self.dsl_context)
        parse_section = get_parser_operators(self.dsl_context)
        pattern = exec_section + expparser.ZeroOrMore(parse_section)
        try:
            pattern.parseString(express)
        except expparser.ParseException:
            self.logger.error("dsl parse error:" + traceback.format_exc())
            raise DslException("parse.expected")
        except ReturnException as ex:
            self.logger.error("return exception")
            return ex.get_ret()

        except Exception:
            self.logger.error("dsl general error:" + traceback.format_exc())
            raise DslException("not.expected")
        finally:
            self.origin_info = self.dsl_context.origin_info or []

        return self.dsl_context.last_data

    def get_matched_data(self):
        return self.dsl_context.matched_data
