#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import re
import expparser
from cbb.frame.dsl import adapter
from cbb.frame.dsl.base_operator import BaseOperator


def _escape_character(matched):
    return '&lt;{}&gt;'.format(matched.group('value'))


class ExecLogDsl(BaseOperator):
    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)
        self.context = dsl_context.context
        self.matched_data = dsl_context.matched_data
        self.dsl_context = dsl_context

    def get(self):
        parse_key = expparser.Literal("exec_log").setResultsName("type")
        a = expparser.CharsNotIn("'")
        b = expparser.Suppress("'")
        cmd_section = expparser.Combine(b + expparser.OneOrMore(a) + b).setResultsName("cause_id")
        pattern = parse_key + cmd_section
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))
        self.logger.info("cause_id={}".format(toks.cause_id))
        log_type = 'DEFAULT'
        if "log_type" in self.dsl_context.kwargs:
            log_type = self.dsl_context.kwargs.get("log_type")
        flag, match_info, self.matched_data \
            = adapter.exec_log_dsl(self.context, toks.cause_id, log_type)
        self.dsl_context.matched_data = self.matched_data
        self.logger.info("match info={}".format(self.dsl_context.matched_data))
        self.dsl_context.origin_info.append("exec_log " + toks.cause_id)

        if flag:
            self.dsl_context.origin_info.append("match info:")
            # Prevent out-of-bounds array
            match_info_list_length = min(len(match_info), len(self.matched_data))
            for index in expparser.range(match_info_list_length):
                self.dsl_context.origin_info.append(
                    '<label style="background:#cce9ff9e;cursor:pointer;">%s</label>\n%s'
                    % (self.matched_data[index].get('filePath'),
                       expparser.re.sub('\<(?P<value>(?!label|/).*?)\>', _escape_character, match_info[index])))
        else:
            self.dsl_context.origin_info.append("no match info")
        return flag
