# -*- coding: UTF-8 -*-
from expparser import Literal
from cbb.frame.dsl.base_operator import BaseOperator
from cbb.frame.dsl import adapter
from cbb.frame.dsl import offline_adapter


class ExecOnAllOfMiniSysDsl(BaseOperator):
    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)

    def get(self):
        """
        exec_launch_fail_on_all_of_mini_sys {}
        在开工失败场景下执行小系统命令
        :return:
        """
        key = Literal("exec_launch_fail_on_all_of_mini_sys").setResultsName("type")
        pattern = key
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))

        # 参数只能通过context带进去，执行结果放在context中返回
        self.dsl_context.context["ctrl_results"] = {}
        self.dsl_context.context["args"] = self.dsl_context.args
        if self.dsl_context.context.get("diagnoseType") == "offline":
            return offline_adapter.exec_on_all(self.dsl_context)
        return adapter.exec_on_all_of_mini_sys(self.dsl_context)
