# -*- coding: UTF-8 -*-
import os
import sys
import traceback


def format_traceback():
    new_extracted_list = []
    etype, value, tb = sys.exc_info()
    extracted_list = traceback.extract_tb(tb)
    for item in extracted_list:
        filename, lineno, name, line = item
        filename = os.path.basename(filename)
        new_extracted_list.append((filename, lineno, name, line))

    return "".join(traceback.format_list(new_extracted_list) + traceback.format_exception_only(etype, value))


class Logger(object):
    """
    日志类
    """

    def __init__(self, loggerInstance, pyFileName):
        self.loggerInstance = loggerInstance
        self.pyFileName = pyFileName

    def logExecCmd(self, cmd):
        """打印执行的CLI命令

        :param cmd: CLI命令
        :return:
        """
        self.loggerInstance.info("[Inspection][%s][exec_cmd][%s]" % (self.pyFileName, cmd))
        return

    def logPass(self):
        """检查通过时的输出

        :return:
        """
        self.loggerInstance.info("[Inspection][%s][pass]" % self.pyFileName)
        return

    def logNoPass(self, errMsg):
        """检查不通过时的输出

        :param errMsg: 检查不通过时的消息
        :return:
        """
        self.loggerInstance.info("[Inspection][%s][no_pass][%s]" % (self.pyFileName, errMsg))
        return

    def logException(self, exception):
        """检查异常时的输出

        :param exception:异常消息
        :return:
        """
        trace = format_traceback()
        self.loggerInstance.error("[Inspection][%s][exception][arguements:%s]" % (self.pyFileName, str(exception.args)))
        self.loggerInstance.error("[Inspection][%s][exception][traceback:%s]" % (self.pyFileName, str(trace)))
        return

    def logSysAbnormal(self):
        """系统异常时的输出

        :return:
        """
        self.logNoPass("system abnormal")
        return

    def logInfo(self, info):
        """
        打印定位，调试信息

        :param info: 定位，调试信息
        :return:
            True: 打印成功
            False: 打印失败
        """
        # noinspection PyBroadException
        try:
            self.loggerInstance.info("[Inspection][%s][info][%s]" % (self.pyFileName, info))
        except Exception:
            return False
        return True

    def logWarning(self, waringMsg):
        """检查结果为建议优化时输出

        :param waringMsg: 告警信息
        :return:
        """
        self.loggerInstance.info("[Inspection][%s][warning][%s]" % (self.pyFileName, waringMsg))
        return

    def logError(self, errorMsg):
        """检查结果为建议优化时输出

        :param errorMsg: 错误信息
        :return:
        """
        self.loggerInstance.error("[Inspection][%s][error][%s]" % (self.pyFileName, errorMsg))
        return
