# -*- coding: UTF-8 -*-
from cbb.frame.tlv import tlvDataType

TYPE_UINT = 0  # 无符号整形
TYPE_STR = 1  # 字符串
TYPE_ENUM = 2  # 枚举(Fru的type字段需用这种类型)

PUB_ATTR = {
    'type': {'index': 0, 'type': tlvDataType.DATA_TYPE_ENUM},
    'id': {'index': 1, 'type': tlvDataType.DATA_TYPE_STRING},
    'name': {'index': 2, 'type': tlvDataType.DATA_TYPE_STRING},
    'parentType': {'index': 3, 'type': tlvDataType.DATA_TYPE_ENUM},
    'parentID': {'index': 4, 'type': tlvDataType.DATA_TYPE_STRING},
    'parentName': {'index': 5, 'type': tlvDataType.DATA_TYPE_STRING},
    'location': {'index': 6, 'type': tlvDataType.DATA_TYPE_STRING},
    'healthStatus': {'index': 7, 'type': tlvDataType.DATA_TYPE_ENUM},
    'runningStatus': {'index': 8, 'type': tlvDataType.DATA_TYPE_ENUM},
    'queryCondition': {'index': 15, 'type': tlvDataType.DATA_TYPE_STRING},
    'model': {'index': 64, 'type': tlvDataType.DATA_TYPE_ENUM},
    'current_peer_port_id': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},
    'suggest_peer_port_id': {'index': 66, 'type': tlvDataType.DATA_TYPE_STRING},

    # For controller expansion flow.
    'totalCtrlNumAfterCtrlExpansion': {'index': 64, 'type': tlvDataType.DATA_TYPE_SIGN_INT},
    'baseIpAddr0': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},
    'baseIpAddr1': {'index': 66, 'type': tlvDataType.DATA_TYPE_STRING},
    'newCtrSn': {'index': 67, 'type': tlvDataType.DATA_TYPE_JSON},
    'curCtrlExpStep': {'index': 68, 'type': tlvDataType.DATA_TYPE_ENUM},
    'curCtrlExpStepRemainTime': {'index': 69, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrlExpState': {'index': 70, 'type': tlvDataType.DATA_TYPE_ENUM},
    'errorCode': {'index': 72, 'type': tlvDataType.DATA_TYPE_ARRAY},
}

CMD = {
    'GET': 55834574848,  # 查询单个对象
    'GET_BATCH_NEXT': 55834624000,  # 批量查询对象
    'GET_CURRENT_ALARM': 55847747648,  # 查询当前告警
    'MODIFY': 55834583040,  # 修改对象
    'OM_MSG_OP_UPD_EXECUTE': 8599117931,  # 通知执行一个升级流程，查询CPU利用率等信息
    'CHECK_IBC_PASSWORD': 55847747746,  # 检查IBC密码是否为默认密码
    'EXPANSION_AD_PROCESS': 56908316701,  # IP Scale Out扩容,启停AD模块
    'EXPANSION_AD_NOTIFY': 56908316702,  # IP Scale Out扩容,下发是否扩容配置
    'EXPANSION_GET_BOARDS': 56908316703,  # IP Scale Out扩容,查询框和节点
    'EXPANSION_GET_ROUTE_INFO': 56908316704,  # IP Scale Out扩容,查询路由信息
    'EXPANSION_AD_FORWARD': 56908316705,  # IP Scale Out扩容,AD模块转发
    'READ_IP_CLUST_BASE_INFO': 56908316706,  # IP Scale Out扩容,获取基地址IP\组网类型\端口ID\交换机ID等
    'MODIFY_IP_CLUST_BASE_INFO': 56908316707,  # IP Scale Out扩容,修改配置文件基本信息
    'GET_EXPANSION_BAY_ID': 55848009729,  # IP Scale Out扩容,获取配置文件控制器数量
    'MODIFY_BAY_CONFIG': 55848009732,  # IP Scale Out扩容,修改控制器数量和柜ID
    'MODIFY_EXPAND_BAY': 55848017920,  # IP Scale Out扩容,修改控制器数量
    'CHANGE_BMC_INFO': 56908316708,  # 修改BMC信息
    'CAPACITY_EXPAND': 55848009730,  # 执行扩容
    'QUERY_EXP_CTRL_INFO': 59594907864,  # 查询扩控流程信息
    'SYS_CLEAR_CONFIG': 55847747678,  # 清除集群配置
    'STOP_FEED': 3080266,  # 重启待扩容引擎
    'GET_BACK_END_CONCURRENT': 55848140806,  # 查询控制器后端并发数
    'MODIFY_INNER_IP': 55847747743,  # 修改内部IP
    'CHECK_INNER_IP': 55861559297,  # 内部ip配置前冲突
    'OM_MSG_OP_LST_VER': 8599109735,  # 查询版本信息
    'INHERIT_CLUSTER_MGT_IP': 59594907750,  # 继承集群管理口IP。
    'GET_INTERNAL_DEVICE_INFO': 59594907789,  # 查询内部设备信息(Dorado V3R1C21版本开始新增，用于区分普通版和增强版)
    'SET_SCALEOUT_DISK_ENCLOSURE_NUM': 59594907811,  # 设置扩容硬盘框数量
    'DISABLE_MGMT_PORT_FORWARD': 59594907818,  # 关闭菊花链组网中头尾管理网口转发功能
    "ADD_INNER_MGMT_IP": 59594907819,  # 添加内部管理IP
    "TEST_MGMT_NETWORK_CABLE": 59594907820,  # 测试管理网络线缆连接的正确性
    'INTF_MODULE_POWER_OFF': 55848271874,  # 下电
    "GET_DISK_CERTIFICATE": 59594908143,  # 查询新扩控硬盘认证证书
    "CHECK_DISK_CERTIFICATE": 59594908144,  # 检查新扩控硬盘认证证书
    "OM_MSG_OP_GET_PACKAGE_UPLOADPATH": 8599109754,  # 查询升级包上传路径
}

OM_OBJ_E = {
    "ENCLOSURE": 206,
    "CONTROLLER": 207,
    "INTF_MODULE": 209,
    "ETH_PORT": 213,
    "SYSTEM": 201,
    "BAY": 205,
    "MEMORY": 237,
    "FAN": 211,
    "DISK": 10,
    "BACKUP_POWER": 210,
    "POWER": 23,
    "EXPBOARD": 208,
    "SAS_PORT": 214,
    "FC_PORT": 212,
    "SERIAL_PORT": 215,
    "PCIE_PORT": 233,
    "SFP_OPTICAL_TRANSCEIVER": 234,
    "FCoE_PORT": 252,
    "FAN_CTRL_MODULE": 306,
    'DEVICE_GLOBAL_CONF': 439,
    "IB_PORT": 16500,
    "DISKPOOL": 266,
    "TASK_RESTRICT_STATE": 57610,
    'EXPANSION_FLOW': 16575,
}

PID = {
    (CMD['CHECK_IBC_PASSWORD'], 0): 1006,
    (CMD['CHANGE_BMC_INFO'], 0): 47,
    (CMD['GET'], OM_OBJ_E['SYSTEM']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['ENCLOSURE']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['DISK']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['PCIE_PORT']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['ETH_PORT']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['INTF_MODULE']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['CONTROLLER']): 47,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['MEMORY']): 47,
    (CMD['GET_CURRENT_ALARM'], 0): 49,
    (CMD['OM_MSG_OP_UPD_EXECUTE'], 0): 1009,
    (CMD['MODIFY'], OM_OBJ_E['ENCLOSURE']): 47,
    (CMD['MODIFY'], OM_OBJ_E['BAY']): 47,
    (CMD['MODIFY'], OM_OBJ_E['ETH_PORT']): 47,
    (CMD['MODIFY_BAY_CONFIG'], OM_OBJ_E['BAY']): 47,
    (CMD['MODIFY_IP_CLUST_BASE_INFO'], 0): 48,
    (CMD['READ_IP_CLUST_BASE_INFO'], 0): 48,
    (CMD['SYS_CLEAR_CONFIG'], 0): 962,
    (CMD['STOP_FEED'], 0): 47,
    (CMD['MODIFY_INNER_IP'], 0): 47,
    (CMD['CHECK_INNER_IP'], 0): 47,
    (CMD['GET_INTERNAL_DEVICE_INFO'], 0): 48,
    (CMD['DISABLE_MGMT_PORT_FORWARD'], 0): 48,
    (CMD['ADD_INNER_MGMT_IP'], 0): 48,
    (CMD['TEST_MGMT_NETWORK_CABLE'], 0): 48,  # V6以外版本扩控前线缆检测使用此PID
    (CMD['TEST_MGMT_NETWORK_CABLE'], "V6"): 501,  # V6扩控前线缆检测使用此PID
    (CMD['OM_MSG_OP_LST_VER'], 0): 1009,
    (CMD['GET_BATCH_NEXT'], OM_OBJ_E['DISKPOOL']): 47,
    (CMD['GET_DISK_CERTIFICATE'], 0): 270,
    (CMD['CHECK_DISK_CERTIFICATE'], 0): 270,
}

BMC_CHANGE_MODE_E = {
    'change': 0,
    'delete': 1,
    'set': 2,
    'sync': 3,
}

# 用于区分Dorado V6不同设备形态
PRODUCT_MODE_E_DORADO = {
    811: "Dorado5000_V6_SAS",  # dorado5000 V6 SAS
    812: "Dorado5000_V6_NVMe",  # dorado5000 V6 NVMe
    813: "Dorado6000_V6_SAS",  # dorado6000 V6 SAS
    814: "Dorado6000_V6_NVMe",  # dorado6000 V6 NVMe
    815: "Dorado8000_V6_SAS",  # dorado8000 V6 SAS
    816: "Dorado8000_V6_NVMe",  # dorado8000 V6 NVMe
    817: "Dorado18000_V6_SAS",  # dorado18000 V6 SAS
    818: "Dorado18000_V6_NVMe",  # dorado18000 V6 NVMe
    819: "Dorado3000_V6_SAS",  # dorado3000 V6 SAS
    820: "Dorado3000_V6_IPSAS",  # dorado3000 V6 IP SAS
    821: "Dorado5000_V6_IPSAS",  # dorado5000 V6 IP SAS
    822: "Dorado6000_V6_IPSAS",  # dorado6000 V6 IP SAS
    823: "Dorado8000_V6_IPSAS",  # dorado8000 V6 IP SAS
    824: "Dorado18000_V6_IPSAS",  # dorado18000 V6 IP SAS
}

PRODUCT_MODE_E = {
    0: 'V1500',  # V1500/V1500
    1: 'V1800',  # V1800/V1800
    2: 'S2100',  # S2100/S2100
    3: 'S2300',  # S2300/S2300
    4: 'S5100',  # S5100/S5100
    5: 'S5300',  # S5300/S5300
    6: 'S5500',  # S5500/S5500
    7: 'S5600',  # S5600/S5600
    8: 'VIS',  # VIS/VIS
    9: 'S2600',  # S2600/S2600
    10: 'S6800E',  # S6800E/S6800E
    11: 'V1500N',  # V1500N/V1500N
    12: 'S2300E',  # S2300E/S2300E
    13: 'COMMON',  # COMMON(插框混用)/COMMON
    15: 'N8000',  # N8000/N8000
    16: 'S6900',  # S6900/S6900
    17: 'S3900',  # S3900/S3900
    18: 'S5500T',  # S5500T/S5500T
    19: 'S5600T',  # S5600T/S5600T
    20: 'S6800T',  # S6800T/S6800T
    21: 'S6900_M100',  # S6900-M100/S6900-M100
    22: 'S3900_M200',  # S3900-M200/S3900-M200
    23: 'S3900_M300',  # S3900-M300/S3900-M300
    24: 'S5900_M100',  # S5900-M100/S5900-M100
    25: 'S8100',  # S8100/S8100
    26: 'S5800T',  # S5800T/S5800T
    27: 'V1600N',  # V1600N/V1600N
    28: 'S5900_M200',  # S5900-M200/S5900-M200
    29: 'N8001',  # N8001/N8001
    30: 'S2600T',  # S2600T/S2600T
    31: 'S8000_I',  # S8000-I/S8000-I
    32: 'Dorado5100',  # Dorado5100/Dorado5100
    33: 'T3200',  # T3200/T3200
    34: 'T3500',  # T3500/T3500
    35: 'N8000-R710',  # N8000-R710/N8000-R710
    36: 'N8000-C2',  # N8000-C2/N8000-C2
    40: 'N8000-C2-SYMC',  # N8000-C2-SYMC/N8000-C2-SYMC
    41: 'VTL',  # VTL/VTL
    42: 'S2900',  # S2900/S2900
    43: 'S2200T',  # S2200T/S2200T
    44: 'Dorado2100 G2',  # Dorado2100 G2/Dorado2100 G2
    45: 'VIS 6000',  # VIS 6000/VIS 6000
    46: 'HVS85T',  # HVS85T/HVS85T
    47: 'HVS88T',  # HVS88T/HVS88T
    48: '9000',  # 9000/9000
    49: 'T3200 G2',  # T3200 G2/T3200 G2
    50: 'T3500 G2',  # T3500 G2/T3500 G2
    51: 'T3200 G3',  # T3200 G3/T3200 G3
    52: 'T3500 G3',  # T3500 G3/T3500 G3
    53: 'S5700',  # S5700/S5700
    54: 'CE6800',  # CE6800/CE6800
    55: 'CE12800',  # CE12800/CE12800
    56: 'HVS_18800F',  # HVS的纯SSD盘版本/18800F
    57: 'HVS_18500',  # HVS的18500型号/18500
    58: 'HVS_18800',  # HVS的18800型号/18800
    60: 'SSS',  # SSS/SSS
    61: '6800 V3',  # 中低端V3/6800V3-6U-2/4C
    62: '6900 V3',  # 中低端V3/6900V3-6U-4C
    63: '5600 V3',  # 中低端V3/5600V3-3U2C
    64: '5800 V3',  # 中低端V3/5800V3-3U2C
    65: 'T3200 MINI',  # T3200/T3200/9000 C01版本(建行项目新增)
    66: 'WUSHAN_SQL',  # WUSHAN_SQL/WUSHAN_SQL/9000 C10版本
    67: 'WUSHAN_HD',  # WUSHAN_HD/WUSHAN_HD/9000 C10版本
    68: '5500 V3',  # 5500 V3/5500 V3/2U盘控一体 5500 V3
    69: '2600 V3',  # 2600 V3/2600 V3/2U盘控一体 2600 V3
    82: '2600 V3 for Video',  # 2600 V3 for Video
    70: '5300 V3',  # 5300 V3/5300 V3/2U盘控一体 5300 V3
    71: '2800 V3',  # 2800 V3/2800 V3/2U盘控一体 2800 V3
    72: '18500 V3',  # 18500 V3/18500 V3/6U高端
    73: '18800 V3',  # 18800 V3/18800 V3/6U高端
    78: '2200 V3',  # 2200 V3 2UARM
    79: '5100 V3',  # 5100 V3 2UARM
    84: '2600F V3',  # V3/2U盘控一体
    85: '5500F V3',  # V3/2U盘控一体
    86: '5600F V3',  # 中低端V3/3U2C
    87: '5800F V3',  # 中低端V3/3U2C
    88: '6800F V3',  # 中低端V3/6U-2/4C
    89: '18500F V3',  # V3/6U高端
    90: '18800F V3',  # V3/6U高端
    401: 'N5000',  # N5000/N5000
    800: 'VIS8200',  # VIS8200/VIS8200
    801: 'VIS8400',  # VIS8400/VIS8400
    802: 'VIS8600',  # VIS8600/VIS8600
    803: 'VIS8800',  # VIS8800/VIS8800
    805: 'Dorado5000 V3',  # dorado V3 2U设备
    806: 'Dorado6000 V3',  # dorado V3 3U设备
    807: 'Dorado18000 V3',  # dorado V3 6U设备
    811: "OceanStor Dorado 5000 V6",  # dorado5000 V6 SAS
    812: "OceanStor Dorado 5000 V6",  # dorado5000 V6 NVMe
    813: "OceanStor Dorado 6000 V6",  # dorado6000 V6 SAS
    814: "OceanStor Dorado 6000 V6",  # dorado6000 V6 NVMe
    815: "OceanStor Dorado 8000 V6",  # dorado8000 V6 SAS
    816: "OceanStor Dorado 8000 V6",  # dorado8000 V6 NVMe
    817: "OceanStor Dorado 18000 V6",  # dorado18000 V6 SAS
    818: "OceanStor Dorado 18000 V6",  # dorado18000 V6 NVMe
    819: "OceanStor Dorado 3000 V6",  # dorado3000 V6 SAS
    820: "Dorado3000 V6",  # dorado3000 V6 IP SAS
    821: "OceanStor Dorado 5000 V6",  # dorado5000 V6 IP SAS
    822: "OceanStor Dorado 6000 V6",  # dorado6000 V6 IP SAS
    823: "OceanStor Dorado 8000 V6",  # dorado8000 V6 IP SAS
    824: "OceanStor Dorado 18000 V6",  # dorado18000 V6 IP SAS
    825: "OceanStor Dorado 5300 V6",
    826: "OceanStor Dorado 5500 V6",
    827: "OceanStor Dorado 5600 V6",
    828: "OceanStor Dorado 5800 V6",
    829: "OceanStor Dorado 6800 V6",
    830: "OceanStor Dorado 18500 V6",
    831: "OceanStor Dorado 18800 V6",
    832: "OceanStor Dorado 18800K V6",

    833: 'OceanStor 5310',
    834: 'OceanStor 5510',
    835: 'OceanStor 5610',
    836: 'OceanStor 6810',
    837: 'OceanStor 18510',
    838: 'OceanStor 18810',
    839: 'OceanStor Dorado 5600K V6',
    840: 'OceanStor 18500K',
    843: 'OceanStor 5810-HS',
    844: 'OceanStor 5300K',
    845: 'OceanStor 5500K',
    846: 'OceanStor Micro 1300',
    847: 'OceanStor Micro 1500',
    860: 'OceanDisk 1600',
    848: 'OceanStor 2910',
    849: 'OceanStor 5320',
    850: 'OceanStor 5510S',
    851: "OceanStor Dorado 2000",
    852: "OceanProtect X3000",
    853: "OceanStor 2200",
    854: "OceanStor 2220",
    855: "OceanStor 2600",
    857: "OceanStor 5120",
    858: "OceanStor 5210",
    859: "OceanStor 5220",
    861: "OceanStor 2620",
    862: 'OceanDisk 1500T',
    863: 'OceanDisk 1600T',
    864: 'OceanDisk 1300',
    865: 'OceanDisk 1500',
    866: 'OceanDisk 1610',
    867: 'OceanDisk 1610T',

    900: "OceanStor Dorado 5000",  # dorado5000 SAS
    901: "OceanStor Dorado 5000",  # dorado5000 NVMe
    902: "OceanStor Dorado 6000",  # dorado6000 SAS
    903: "OceanStor Dorado 6000",  # dorado6000 NVMe
    904: "OceanStor Dorado 8000",  # dorado8000 SAS
    905: "OceanStor Dorado 8000",  # dorado8000 NVMe
    906: 'OceanStor Dorado 18000',  # dorado18000 SAS
    907: 'OceanStor Dorado 18000',  # dorado18000 NVMe
    908: 'OceanStor Dorado 3000',
    909: 'OceanStor Dorado 5000',  # dorado5000 IP SAS
    910: 'OceanStor Dorado 6000',  # dorado6000 IP SAS
    911: 'OceanStor Dorado 8000',  # dorado8000 IP SAS
    912: 'OceanStor Dorado 18000',  # dorado18000 IP SAS
    913: 'OceanStor Dorado 5300',
    914: 'OceanStor Dorado 5500',
    915: 'OceanStor Dorado 5600',
    917: 'OceanStor Dorado 6800',
    918: 'OceanStor Dorado 18500',
    919: 'OceanStor Dorado 18800',
    920: 'OceanStor Dorado 18800K',
    921: 'OceanStor Dorado 5600K',
    922: "OceanStor Dorado 2100",
    923: "OceanStor 5310 Capacity Flash",
    924: "OceanStor 5510 Capacity Flash",
    925: "OceanStor Dorado 2020",
    926: "OceanStor A300",
    927: "OceanStor A800",

    92: "2800 V5",
    116: "5110 V5",
    117: "5110F V5",
    118: "5210 V5",
    119: "5210F V5",
    120: "5310 V5",
    121: "5310F V5",
    122: "5510 V5",
    123: "5510F V5",
    124: "5610 V5",
    125: "5610F V5",
    126: "5810 V5",
    127: "5810F V5",
    128: "6810 V5",
    129: "6810F V5",
    130: "18510 V5",
    131: "18510F V5",
    132: "18810 V5",
    133: "18810F V5",
    137: "2810 V5",

    93: "5300 V5",
    94: "5300F V5",
    95: "5500 V5",
    96: "5500F V5",
    97: "5600 V5",
    98: "5600F V5",
    99: "5800 V5",
    100: "5800F V5",
    101: "6800 V5",
    102: "6800F V5",
    103: "18500 V5",
    104: "18500F V5",
    105: "18800 V5",
    106: "18800F V5",
    107: "5500 V5 Elite",

    134: "5210 V5 Enhanced",
    135: "5210F V5 Enhanced",
    139: "5110 V5 Enhanced",
    140: "5110F V5 Enhanced",
    141: "2600 V5",
    143: "2210",
    144: "5120 V5",
    145: "5220 V5",
    147: "2220",
    1200: "OceanProtect X8000",
    1201: "OceanProtect X9000",
    1202: "OceanProtect A8000",
    1203: "OceanProtect A9000",
    1205: "OceanProtect X6000",
    1206: "OceanProtect X8000K",
    1207: "OceanProtect X9000K",
    1209: "OceanProtect E8000",
}

HEALTH_STATUS_E = {
    'UNKNOWN': 0,  # 未知/--
    'NORMAL': 1,  # 正常/Normal
    'FAULT': 2,  # 故障/Fault
    'PRE_FAIL': 3,  # 即将故障/Pre-Fail
    'PART_BROKEN': 4,  # 部分损坏/partially broken
    'DEGRADE': 5,  # 降级/Degraded
    'HAS_BAD_BLOCK': 6,  # 有坏块/Bad sectors found
    'HAS_ERR_CODE': 7,  # 有误码/Bit errors found
    'CONSISTENT': 8,  # 一致/Consistent
    'INCONSISTENT': 9,  # 不一致/Inconsistent
    'BUSY': 10,  # 繁忙/Busy
    'POWER_NO_INPUT': 11,  # 无输入/No input
    'POWER_NOT_ENOUGH': 12,  # 电量不足/Low battery
    'SINGLE_LINK_FAULT': 13  # 单链路故障/Single link fault
}

RUNNING_STATUS_E = {
    'UNKNOWN': 0,  # 未知/--
    'NORMAL': 1,  # 正常/Normal
    'RUNNING': 2,  # 运行/Running
    'NOT_RUNNING': 3,  # 未运行/Not running
    'NOT_EXIST': 4,  # 不存在/Not existed
    'HIGH_TEMPERATURE_SLEEP': 5,  # 高温休眠/Sleep in high temperature
    'STARTING': 6,  # 正在启动/Starting
    'POWER_FAILURE_PROTECTING': 7,  # 掉电保护/Power failure protection
    'SLEEPING': 8,  # 休眠/Spin down

    'SPINGUP': 9,  # 已启动/Started
    'LINK_UP': 10,  # 已连接/Link Up
    'LINK_DOWN': 11,  # 未连接/Link Down
    'POWER_ON': 12,  # 正在上电/Powering on
    'POWER_OFF': 13,  # 已下电/Powered off
    'PRE_COPY': 14,  # 预拷贝/Precopy
    'COPYBACK': 15,  # 回拷/Copyback
    'RECONSTRUCTION': 16,  # 重构/Reconstruction
    'EXPANSION': 17,  # 扩容/Expansion
    'NOT_FORMAT': 18,  # 未格式化/Unformatted
    'FORMATTING': 19,  # 正在格式化/Formatting
    'UNMAPPING': 20,  # 未映射/Unmapped
    'INITIAL_SYNCHRONIZING': 21,  # 正在初始同步/Initial synchronizing
    'CONSISTENT': 22,  # 数据一致/Consistent
    'SYNCHRONIZING': 23,  # 正在同步/Synchronizing
    'SYNCHRONIZED': 24,  # 已同步/Synchronized
    'NOT_SYNCHRONIZED': 25,  # 未同步/Unsynchronized
    'SPLIT': 26,  # 已分裂/Splited
    'ONLINE': 27,  # 在线/Online
    'OFFLINE': 28,  # 离线/Offline
    'LOCKED': 29,  # 已锁定/Locked
    'ENABLE': 30,  # 已启用/Enabled
    'DISABLED': 31,  # 已禁用/Disabled
    'LEVELING': 32,  # 正在均衡/balancing
    'TO_BE_RECOVERD': 33,  # 待恢复/To be recovered
    'INTERRUPTED': 34,  # 异常断开/Interrupted
    'INVALID': 35,  # 失效/Invalid
    'NOSTART': 36,  # 新创建/Not start
    'QUEUING': 37,  # 正在排队/Queuing
    'STOP': 38,  # 已停止/Stopped
    'COPYING': 39,  # 正在拷贝/Copying
    'COMPLETED': 40,  # 拷贝完成/Completed
    'PAUSE': 41,  # 暂停/Paused
    'REVSYNCHRONIZING': 42,  # 正在反向同步/Reverse synchronizing
    'ACTIVATED': 43,  # 已激活/Activated
    'ROLLBACK': 44,  # 正在回滚/Restore
    'INACTIVATED': 45,  # 未激活/Inactive
    'IDLE': 46,  # 等待/Idle
    'POWERING_OFF': 47,  # 正在下电/Powering off
    'CHARGING': 48,  # 正在充电/Charging
    'CHARGED': 49,  # 充电完成/Charging completed
    'DISCHARGING': 50,  # 正在放电/Discharging
    'UPGRADING': 51,  # 正在升级/Upgrading
    'POWER_LOST': 52,  # 掉电中/Power Lost
    'INITIALIZING': 53,  # 初始化中/Initializing
    'APPLY_CONFIG_CHANGE': 54,  # 正在应用变更/Apply Change
    'ONLINE_DISABLE': 55,  # 在线禁用/online disable
    'OFFLINE_DISABLE': 56,  # 离线禁用/Offline disable
    'ONLINE_FROZEN': 57,  # 在线冻结/online frozen
    'OFFLINE_FROZEN': 58,  # 离线冻结/offline frozen
    'CLOSED': 59,  # 已关闭/closed
    'REMOVING': 60,  # (节点)删除中/removing
    'INSERVICE': 61,  # 服务中/in service
    'OUTOFSERVICE': 62,  # 退出服务/out of service
    'ERASEMENT_RUNNING_NORMAL': 63,  # 正在销毁/Running normal
    'ERASEMENT_RUNNING_FAIL': 64,  # 销毁失败/Running fail
    'ERASEMENT_RUNNING_SUCCESS': 65,  # 销毁成功/Running success
    'SUCCESS': 66,  # 任务执行成功/Running success
    'FAILED': 67,  # 任务执行失败/Running failed
    'WAITING': 68,  # 任务正在等待/Waiting
    'CANCELLING': 69,  # 任务正在取消/Cancelling
    'CANCELLED': 70,  # 任务已取消/Cancelled
    'RUNNING_PREPARE_SYNC': 71,  # 在线|即将灾备同步/About to synchronize
    'RUNNING_SYNCHRONINING': 72,  # 在线|正在灾备同步/Synchronizing data
    'RUNNING_SYNC_FAILED': 73,  # 在线|灾备同步失败/Failed to synchronize
    'MIGRATION_FAULT': 74,  # 迁移故障/MIGRATION_FAULT
    'MiGRATING': 75,  # 迁移中/MiGRATING
    'MIGRATION_COMPLETED': 76  # 迁移完成/MIGRATION_COMPLETED
}

PORT_LOGIC_TYPE_E = {
    'HOST': 0,  # 主机端口/业务端口
    'EXP': 1,  # 级联端口
    'MNGT': 2,  # 管理端口
    'INNER': 3,  # 内部端口
    'MAINTENANCE': 4,  # 维护端口
    'MNGT_SRV': 5,  # 管理/业务混合口
    'MAINTENANCE_SRV': 6,  # 维护/业务混合口
    'BACKUP_MGR': 7,  # 备份管理网口
    'PRODUCT_STORAGE': 8,  # 生产存储网口
    'BACKUP_STORAGE': 9,  # 备份存储网口
    'ETH_NOT_CONFIG': 10  # 未配置角色网口
}

ENCLOSURE_TYPE_E = {
    'EXP': 0,  # 级联框（硬盘框）
    'CTRL': 1,  # 控制框
    'DSW': 2,  # 数据交换机
    'MSW': 3,  # 管理交换机
    'SVP': 4  # 管理服务器
}

INTF_MODEL_E = {
    'FC_4X4G': 1,  # 4x4G FC接口模块/4x4G FC Interface Module
    'FC_2X4G': 2,  # 2x4G FC接口模块/2x4G FC Interface Module
    'GE_RJ45_2X': 3,  # 2xGE 电接口模块/2xGE Electrical Interface Module
    'SASI_4X': 4,  # 4xSAS I 接口模块/4xSAS I Interface Module
    'FC_4X4G_EXPAND': 5,  # Swapped FC接口模块/Swapped FC Interface Module
    'ETH10G_2': 6,  # 2x10GE 光接口模块/2x10GE Optical Interface Module
    'FC_1X8G': 7,  # 1x8G FC光接口模块/1x8G FC Optical Interface Module
    'FC_2X8G': 8,  # 2x8G FC光接口模块/2x8G FC Optical Interface Module
    'SASII_2X': 9,  # 2xSAS II电接口模块/2xSAS II Electrical Interface Module
    'SASII_4X': 10,  # 4xSAS II电接口模块/4xSAS II Electrical Interface Module
    'Combo_2FCx2GE': 11,  # 2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
    'iSCSI_4X': 12,  # 4xGE 电接口模块/4xGE Electrical Interface Module
    'FC_4X8G': 13,  # 4x8G FC光接口模块/4x8G FC Optical Interface Module
    'MINISAS_4X': 16,  # 4xmini-SAS接口模块/4x mini-SAS Interface Module
    'FCoE_4X': 21,  # 4x10G FCoE光接口模块/4x10G Optical Interface Module
    'SASA_2X6G': 22,  # 2x6G SASA接口模块/2x6G SASA Interface Module
    'SASB_2X6G': 23,  # 2x6G SASB接口模块/2x6G SASB Interface Module
    'ManagerBoard': 24,  # 管理板/Management Board
    'TOE': 25,  # 4x10GE接口模块/4x10GE Interface Module
    'PCIe_4X5G': 26,  # 4x5Gbps PCIe接口模块/4x5Gbps PCIe Interface Module
    "PCIe_2X5G": 26,  # 2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
    'FCoE_2X': 27,  # 2x10G FCoE光接口模块/2x10G Optical Interface Module
    'iSCSI_4XGE': 28,  # 4xGE Optical Interface Module/4xGE光接口模块
    'FC_2X16G': 29,  # 2x16G FC Optical Interface Module    2x16G FC光接口模块
    'SAS_4X12G': 30,  # 4x12SAS QSFP Interface Module    4x12G SAS光电接口模块
    'iSCSI_4X10': 31,  # 4x10GE Electrical Interface Module    4x10GE 电接口模块
    'IOC_4XSMART': 37,
    'PCIe_2X': 44,  # PCIE3.0接口模块
    "IOC_4X32G_X16_FC": 65,  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X16
    "IOC_4X32G_X8_FC": 66,  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X8
    "IOC_2X100G_X16_ETH": 67,  # 2 端口 100Gb ETH I/O模块（QSFP28）X16
    "IOC_2X100G_X8_ETH": 68,  # 2 端口 100Gb ETH I/O模块（QSFP28）X8
    "ETH_2X10G": 71,  # 4端口 10Gb ETH I/O模块
    "TOE_FE_4X10G_ETH_MODULE_HC": 2364,  # 4端口 TOE FE 10Gb ETH 前端SmartIO容器卡 C+
    "TOE_FE_4X25G_ETH_MODULE_HC": 2365,  # 4端口 TOE FE 25Gb ETH 前端SmartIO容器卡 C+
    "TOE_FE_ELEC_4X10G_ETH_MODULE_HC": 2366,  # 4端口 TOE FE ELEC 10Gb SmartIO电口容器卡 C+
    "ROCE_FE_4X25G_ROCE_MODULE_HC": 2367,  # 4端口 TOE FE 25Gb ROCE模式 SmartIO容器后端卡 C+
    "CPLUS_FE_4X8G_FC_MODULE_LC": 2368,  # 4端口 FE 8Gb FC 前端SmartIO容器卡 C+
    "CPLUS_FE_4X16G_FC_MODULE_LC": 2369,  # 4端口 FE 16Gb FC 前端SmartIO容器卡 C+
    "CPLUS_FE_4X32G_FC_MODULE_LC": 2370,  # 4端口 FE 32Gb FC 前端SmartIO容器卡 C+
}

CONFIG_MODEL_E = {
    'SINGLE_CTRL': 0,  # Single-Controller/单控
    'MULTI_CTRL': 1,  # Multi-Controller/多控
}

POWER_TYPE_E = {
    'DC': 0,  # 直流电源
    'AC': 1,  # 交流电源
}

ENCLOSURE = {
    "name": {"index": 2, "type": tlvDataType.DATA_TYPE_STRING},
    "model": {"index": 64, "type": tlvDataType.DATA_TYPE_ENUM},
    "logicType": {"index": 65, "type": tlvDataType.DATA_TYPE_ENUM},
    "serialNum": {"index": 68, "type": tlvDataType.DATA_TYPE_STRING},
    "macAddress": {"index": 69, "type": tlvDataType.DATA_TYPE_STRING},
    "height": {"index": 70, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "expanderDepth": {"index": 71, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "expanderPort": {"index": 72, "type": tlvDataType.DATA_TYPE_STRING},
    "switch": {"index": 73, "type": tlvDataType.DATA_TYPE_ENUM},
    "healthStatus": {"index": 7, "type": tlvDataType.DATA_TYPE_STRING},
    "runningStatus": {"index": 8, "type": tlvDataType.DATA_TYPE_STRING}
}

CONTROLLER = {
    'sesVer': {'index': 69, 'type': tlvDataType.DATA_TYPE_STRING},
    'memorySize': {'index': 74, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'elabel': {'index': 67, 'type': tlvDataType.DATA_TYPE_STRING},
}

INTF_MODULE = {
    'id': {'index': 1, 'type': tlvDataType.DATA_TYPE_STRING},
    'location': {'index': 6, 'type': tlvDataType.DATA_TYPE_STRING},
    'healthStatus': {'index': 7, 'type': tlvDataType.DATA_TYPE_ENUM},
    'runningStatus': {'index': 8, 'type': tlvDataType.DATA_TYPE_ENUM},
    'model': {'index': 64, 'type': tlvDataType.DATA_TYPE_ENUM},
    'lightStatus': {'index': 69, 'type': tlvDataType.DATA_TYPE_ENUM},
    'runMode': {'index': 71, 'type': tlvDataType.DATA_TYPE_ENUM},
    'servicemode': {'index': 74, 'type': tlvDataType.DATA_TYPE_ENUM},
}


class IntfModelEnum():
    '''
    Description: Type 条件类型，供生成TLV命令记录条件用（命名类似于Shell比较运算符）
    '''
    FC_4X4G = 1  # 4x4G FC接口模块/4x4G FC Interface Module
    FC_2X4G = 2  # 2x4G FC接口模块/2x4G FC Interface Module
    GE_RJ45_2X = 3  # 2xGE 电接口模块/2xGE Electrical Interface Module
    SASI_4X = 4  # 4xSAS I 接口模块/4xSAS I Interface Module
    FC_4X4G_EXPAND = 5  # Swapped FC接口模块/Swapped FC Interface Module
    ETH10G_2 = 6  # 2x10GE 光接口模块/2x10GE Optical Interface Module
    FC_1X8G = 7  # 1x8G FC光接口模块/1x8G FC Optical Interface Module
    FC_2X8G = 8  # 2x8G FC光接口模块/2x8G FC Optical Interface Module
    SASII_2X = 9  # 2xSAS II电接口模块/2xSAS II Electrical Interface Module
    SASII_4X = 10  # 4xSAS II电接口模块/4xSAS II Electrical Interface Module
    Combo_2FCx2GE = 11  # 2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
    iSCSI_4X = 12  # 4xGE 电接口模块/4xGE Electrical Interface Module
    FC_4X8G = 13  # 4x8G FC光接口模块/4x8G FC Optical Interface Module
    MINISAS_4X = 16  # 4xmini-SAS接口模块/4x mini-SAS Interface Module
    FCoE_4X = 21  # 4x10G FCoE光接口模块/4x10G Optical Interface Module
    SASA_2X6G = 22  # 2x6G SASA接口模块/2x6G SASA Interface Module
    SASB_2X6G = 23  # 2x6G SASB接口模块/2x6G SASB Interface Module
    ManagerBoard = 24  # 管理板/Management Board
    TOE = 25  # 4x10GE接口模块/4x10GE Interface Module
    PCIe_2X5G = 26  # 2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
    FCoE_2X = 27  # 2x10G FCoE光接口模块/2x10G Optical Interface Module
    iSCSI_4XGE = 28  # 4xGE Optical Interface Module/4xGE光接口模块
    FC_2X16G = 29  # 2x16G FC Optical Interface Module/2x16G FC光接口模块
    SAS_4X12G = 30  # 4x12SAS QSFP Interface Module/4x12G SAS光电接口模块
    iSCSI_4X10 = 31  # 4x10GE Electrical Interface Module/4x10GE 电接口模块
    IB_2x40G = 32  # 2x40GE Infiniband Interface Module/2x40GE IB接口模块
    IB_2x56G = 33  # 2x56GE Infiniband Interface Module/2x56GE IB接口模块
    GE_RJ45_4X = 34  # 4xGE Electrical Interface Module/4xGE 电接口模块
    AccerationEngineCard = 35  # Express Module(ACC Acceration engine)/重删压缩加速卡
    IOC_4X10G_RJ45 = 36  # 4x10GE Electrical Interface Module/4x10GE 电接口模块
    IOC_4XSMART = 37  # 4xSMART Optical Interface Module/4xSmart 光接口模块
    IOC_8X8G_FC = 38  # 8x8G FC Optical Interface Module/8x8G FC光接口模块
    IOC_4X8G_FC = 39  # 4x8G FC Optical Interface Module/4x8G FC光接口卡
    IOC_4X16G_FC = 40  # 4x16G FC Optical Interface Module/4x16G FC光接口卡
    SAS_12PORT_BACKEND_MODULE = 41  # 12 port 4*12Gb SAS Back-End Interconnect I/O Module/12端口4*12Gb SAS后端全互联IO模块
    PCIe_2PORT = 44  # PCIe接口模块/2 port PCIe Interface Module
    PCIe_2PORT_BACK = 55  # 2 port PCIe Interface Module/2接口PCIe接口模块',
    IOC_8X16G_FC = 58  # 8x16G FC Optical Interface Module/8x16G FC光接口卡
    IOC_4X32G_X16_FC = 65  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X16
    IOC_4X32G_X8_FC = 66  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X8
    IOC_2X100G_X16_FC = 67  # 2 端口 100Gb ETH I/O模块（QSFP28）X16
    IOC_2X100G_X8_FC = 68  # 2 端口 100Gb ETH I/O模块（QSFP28）X8
    IOC_4X10G_X8_FC = 71  # 4 端口 10Gb ETH I/O模块（QSFP28）X8
    TOE_FE_4X10G_ETH_MODULE_HC = 2364  # 4端口 TOE FE 10Gb ETH 前端SmartIO容器卡 C+
    TOE_FE_4X25G_ETH_MODULE_HC = 2365  # 4端口 TOE FE 25Gb ETH 前端SmartIO容器卡 C+
    TOE_FE_ELEC_4X10G_ETH_MODULE_HC = 2366  # 4端口 TOE FE ELEC 10Gb SmartIO电口容器卡 C+
    ROCE_FE_4X25G_ROCE_MODULE_HC = 2367  # 4端口 TOE FE 25Gb ROCE模式 SmartIO容器后端卡 C+
    CPLUS_FE_4X8G_FC_MODULE_LC = 2368  # 4端口 FE 8Gb FC 前端SmartIO容器卡 C+
    CPLUS_FE_4X16G_FC_MODULE_LC = 2369  # 4端口 FE 16Gb FC 前端SmartIO容器卡 C+
    CPLUS_FE_4X32G_FC_MODULE_LC = 2370  # 4端口 FE 32Gb FC 前端SmartIO容器卡 C+


POWER = {
    'powerType': {'index': 65, 'type': tlvDataType.DATA_TYPE_ENUM},
}

SYSTEM = {
    'healthStatus': {'index': 7, 'type': tlvDataType.DATA_TYPE_ENUM},
    'runningStatus': {'index': 8, 'type': tlvDataType.DATA_TYPE_ENUM},
    'productMode': {'index': 64, 'type': tlvDataType.DATA_TYPE_ENUM},
    'productVersion': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},
    'config_model': {'index': 101, 'type': tlvDataType.DATA_TYPE_ENUM},
    'patchVersion': {'index': 106, 'type': tlvDataType.DATA_TYPE_STRING},
    'product_oem_model': {'index': 110, 'type': tlvDataType.DATA_TYPE_STRING},
    # 产品型号字符串，区分海外和国内
    "product_model_string": {"index": 112,
                             "type": tlvDataType.DATA_TYPE_STRING},
    # V6 数字版本号
    "pointRelease": {"index": 113, "type": tlvDataType.DATA_TYPE_STRING},

    # V7设备真实软件版本
    "software_version": {"index": 153, "type": tlvDataType.DATA_TYPE_STRING},
    # SN
    "SN": {"index": 1, "type": tlvDataType.DATA_TYPE_STRING}
}

DEVICE_GLOBAL_CONF = {
    'frameCascadeMode': {
        'index': 68, 'type': tlvDataType.DATA_TYPE_UNSIGN_32INT
    },
    'smartFrameCascadeMode': {
        'index': 101, 'type': tlvDataType.DATA_TYPE_UNSIGN_32INT
    },
}

INTERNAL_DEVICE_INFO = {
    'oldNodeNum': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'internalProductModel': {'index': 64, 'type': tlvDataType.DATA_TYPE_STRING},
    'cpuModelInfo': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},
    'cpuNumber': {'index': 66, 'type': tlvDataType.DATA_TYPE_STRING},
    'isOverseas': {'index': 77, 'type': tlvDataType.DATA_TYPE_BOOL},
}

SFP_OPTICAL_TRANSCEIVER = {
    'speed': {'index': 68, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT}
}

IP_CLUST_BASE_INFO = {
    'baseIpAddr': {'index': 0, 'type': tlvDataType.DATA_TYPE_STRING},
    'netMode': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctraPortID1': {'index': 2, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctraDswID1': {'index': 3, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctraPortID2': {'index': 4, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctraDswID2': {'index': 5, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctraPortID3': {'index': 6, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctraDswID3': {'index': 7, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctraPortID4': {'index': 8, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctraDswID4': {'index': 9, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrbPortID1': {'index': 10, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrbDswID1': {'index': 11, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrbPortID2': {'index': 12, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrbDswID2': {'index': 13, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrbPortID3': {'index': 14, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrbDswID3': {'index': 15, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrbPortID4': {'index': 16, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrbDswID4': {'index': 17, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrcPortID1': {'index': 18, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrcDswID1': {'index': 19, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrcPortID2': {'index': 20, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrcDswID2': {'index': 21, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrcPortID3': {'index': 22, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrcDswID3': {'index': 23, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrcPortID4': {'index': 24, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrcDswID4': {'index': 25, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrdPortID1': {'index': 26, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrdDswID1': {'index': 27, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrdPortID2': {'index': 28, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrdDswID2': {'index': 29, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrdPortID3': {'index': 30, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrdDswID3': {'index': 31, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'ctrdPortID4': {'index': 32, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'ctrdDswID4': {'index': 33, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

CHECK_IBC_PASSWORD = {
    'passwordChanged': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'keyPairChanged': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

MEMORY = {
    'capacity': {'index': 65, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
}

BAY = {
    'type': {'index': 0, 'type': tlvDataType.DATA_TYPE_ENUM},
    'id': {'index': 1, 'type': tlvDataType.DATA_TYPE_STRING},
    'name': {'index': 2, 'type': tlvDataType.DATA_TYPE_STRING},
    'location': {'index': 6, 'type': tlvDataType.DATA_TYPE_STRING},
    'model': {'index': 64, 'type': tlvDataType.DATA_TYPE_ENUM},
    'newID': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},
    'contrlTotal': {'index': 68, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'isIpScaleOut': {'index': 69, 'type': tlvDataType.DATA_TYPE_BOOL},
    'isExpansionController': {'index': 70, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

EXPANSION_AD_FORWARD_DEFINE = {
    'enclosureSN': {'index': 1000, 'type': tlvDataType.DATA_TYPE_STRING},
    'controllerID': {'index': 1001, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'pid': {'index': 1002, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'cmd': {'index': 1003, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'obj': {'index': 1004, 'type': tlvDataType.DATA_TYPE_ENUM},
}

EXPANSION_GET_BOARDS_DEFINE = {
    'enclosureSN': {'index': 0, 'type': tlvDataType.DATA_TYPE_STRING},
    'controllerID': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

EXPANSION_AD_PROCESS_DEFINE = {
    'status': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 0：启动 1：停止
    'successNum': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 启动或停止时返回网管成功个数
}

EXPANSION_AD_NOTIFY_DEFINE = {
    'status': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 0：开局部署 1：扩容
    'result': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 0：失败 1：成功
}

EXPANSION_GET_ROUTE_INFO_DEFINE = {
    'srcEnclosureSN': {'index': 0, 'type': tlvDataType.DATA_TYPE_STRING},
    'srcControllerID': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'srcPortMacAddr': {'index': 2, 'type': tlvDataType.DATA_TYPE_STRING},
    'desEnclosureSN': {'index': 3, 'type': tlvDataType.DATA_TYPE_STRING},
    'desControllerID': {'index': 4, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'desPortMacAddr': {'index': 5, 'type': tlvDataType.DATA_TYPE_STRING},
}

ETH_PORT = {
    'logicType': {'index': 64, 'type': tlvDataType.DATA_TYPE_ENUM},
    'macAddress': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},
    'ipv4Addr': {'index': 71, 'type': tlvDataType.DATA_TYPE_STRING},
    'ipv4Mask': {'index': 72, 'type': tlvDataType.DATA_TYPE_STRING},
    'ipv4Gateway': {'index': 73, 'type': tlvDataType.DATA_TYPE_STRING},
    'ipv6Addr': {'index': 74, 'type': tlvDataType.DATA_TYPE_STRING},
    'ipv6Mask': {'index': 75, 'type': tlvDataType.DATA_TYPE_STRING},
    'ipv6Gateway': {'index': 76, 'type': tlvDataType.DATA_TYPE_STRING},
    'lightStatus': {'index': 85, 'type': tlvDataType.DATA_TYPE_ENUM},
    'speed': {'index': 84, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'interfaceModelType': {'index': 94, 'type': tlvDataType.DATA_TYPE_ENUM},
}

CMO_ALARM_INFO_E = {
    'CMO_ALARM_TYPE': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_ALARM_ID': {'index': 1, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},
    'CMO_ALARM_LEVEL': {'index': 2, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_ALARM_CLEAR_TIME': {'index': 5, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_ALARM_RECOVERY_TIME': {'index': 6, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_ALARM_COUNT': {'index': 9, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_ALARM_PARMETER': {'index': 8, 'type': tlvDataType.DATA_TYPE_STRING},
}

BMC_INFO_DEFINE = {
    'flag': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

STOP_FEED_DEFINE = {
    'bitMap': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

INHERIT_CLUSTER_MGT_IP_DEFINE = {
    'oldNodeNum': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

CMO_NOTIFY_EXC_UPGRADE_DEFINE = {
    'CMO_EXE_UPD_MSGTYPE': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_EXE_UPD_NIDLIST': {'index': 1, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_ACTIVETYPE': {'index': 2, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_EXE_UPD_BAKPATH': {'index': 3, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_EXENODETYPE': {'index': 4, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_EXEFLOW': {'index': 5, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_EXEFLOWSEGMENT': {'index': 6, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_EXEATOM': {'index': 7, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_SYNCPAR': {'index': 8, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXE_UPD_PKG_TYPE': {'index': 9, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
    'CMO_EXC_DIAG_CMD': {'index': 12, 'type': tlvDataType.DATA_TYPE_STRING},
    'CMO_EXC_NODE_CFG': {'index': 13, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},
}

SAS_PORT = {
    "logicType": {"index": 64, "type": tlvDataType.DATA_TYPE_ENUM},
    "runSpeed": {"index": 65, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "current_peer_port_id": {"index": 75, "type": tlvDataType.DATA_TYPE_STRING},
    "suggest_peer_port_id": {"index": 76, "type": tlvDataType.DATA_TYPE_STRING},
    "lightStatus": {"index": 77, "type": tlvDataType.DATA_TYPE_ENUM},
}

PCIE_PORT = {
    "pcieSpeed": {"index": 64, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "current_peer_port_id": {"index": 65, "type": tlvDataType.DATA_TYPE_STRING},
    "suggest_peer_port_id": {"index": 66, "type": tlvDataType.DATA_TYPE_STRING},
    "lightStatus": {"index": 69, "type": tlvDataType.DATA_TYPE_ENUM},
    "dswId": {"index": 76, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "dswPortIndex": {"index": 77, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "ctrlId": {"index": 78, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
    "suggestEngineId": {"index": 79, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
}


ENCLOSURE_MODEL = {
    0: "CTRL_BMC",  # BMC控制框/
    1: "CTRL_SAS2U_12",  # 2U SAS 12盘主控框/
    2: "CTRL_SAS2U_24",  # 2U SAS 24盘主控框/
    16: "EXPSAS2U_12",  # 2U SAS 12盘级联框/
    17: "EXPSAS2U_24",  # 2U SAS 24盘级联框/
    18: "EXPSAS4U",  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框
    19: "EXPFC",  # 4U FC 24盘级联框/
    20: "DSW_PCIe1U",  # 1U PCIe数据交换机/
    21: "EXPSAS4U_75",  # 4U SAS 75盘级联框/
    22: "SVP",  # SVP/SVP Controller Enclosure
    97: "CTRL_6U",  # 6U 4控独立机头/
    96: "CTRL_3U",  # 3U 2控独立机头/
    23: "CTRL_12GSAS_2U12_EAR",  # 2U 12GSAS 12盘主控框/
    24: "EXPSAS2U_25",  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框/
    25: "EXPSAS4U_24_NEW",  # 4U SAS 24盘3.5寸磁盘框（新）/
    26: "CTRL_12GSAS_2U25_EAR",  # 2U 12GSAS 25盘主控框/
    39: "EXP_12G_SAS_4U_75",  # 12G 4U SAS 75盘 3.5寸级联框/
    40: "CTRL_12GSAS_2U25_EAR_12GLINK",  # 2U 12G SAS 25盘主控框/
    65: "SSD_12G_2U_25_DISKS_ENCLOSURE",  # 2U 12G SSD 2.5寸框/
    66: "CTRL_12GSAS_4U24_EAR_12GLINK",  # 4U 12G SAS 24盘主控框/
    67: "EXP_SAS2U_25",  # 2U SAS 25盘位 2.5英寸 硬盘框/
    69: "EXP_SAS4U_24",  # 4U SAS 24盘位 3.5英寸 硬盘框/
    99: "CTRL_NVMe2U_24",  # 2U NVMe 2.5寸主控框/
    101: "EXP2U_JBOF",  # 2U JBOF硬盘框/
    112: "CTRL_4U_4C",  # 4U 四控 控制框/
    113: "CTRL_SAS2U_2C_25_MID",  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    114: "CTRL_SAS2U_2C_12_MID",  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    115: "CTRL_NVMe2U_2C_36",  # 2U 双控 NVMe 36盘位 控制框/
    116: "CTRL_SAS2U_2C_25_LOW",  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    117: "CTRL_SAS2U_2C_12_LOW",  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    118: "EXP_IPSAS_2U_25",  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
    119: "EXP_IPSAS_2U_12",  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
    120: "EXP_IPNVMe_2U_36"  # 2U IP NVMe 36盘位 硬盘框/
}

ENCLOSURE_MODEL_E = {
    'CTRL_BMC': 0,  # BMC控制框/
    'CTRL_SAS2U_12': 1,  # 2U SAS 12盘主控框/
    'CTRL_SAS2U_24': 2,  # 2U SAS 24盘主控框/
    'EXPSAS2U_12': 16,  # 2U SAS 12盘级联框/
    'EXPSAS2U_24': 17,  # 2U SAS 24盘级联框/
    'EXPSAS4U': 18,  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框
    'EXPFC': 19,  # 4U FC 24盘级联框/
    'DSW_PCIe1U': 20,  # 1U PCIe数据交换机/
    'EXPSAS4U_75': 21,  # 4U SAS 75盘级联框/
    'SVP': 22,  # SVP/SVP Controller Enclosure
    'CTRL_6U': 97,  # 6U 4控独立机头/
    'CTRL_3U': 96,  # 3U 2控独立机头/
    'EXPSAS2U_25': 24,  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框/
    'EXPSAS4U_24_NEW': 25,  # 4U SAS 24盘3.5寸磁盘框（新）/
    'CTRL_12GSAS_2U25_EAR': 26,  # 2U 12GSAS 25盘主控框/
    'CTRL_12GSAS_2U12_EAR': 23,  # 2U 12GSAS 12盘主控框/
    'SSD_12G_2U_25_DISKS_ENCLOSURE': 65,  # 2U 12G SSD 2.5寸框/
    'CTRL_12GSAS_4U24_EAR_12GLINK': 66,  # 4U 12G SAS 24盘主控框/
    'EXP_SAS2U_25': 67,  # 2U SAS 25盘位 2.5英寸 硬盘框
    'EXP_SAS4U_24': 69,  # 4U SAS 24盘位 3.5英寸 硬盘框
    'EXP_12G_SAS_4U_75': 39,  # 12G 4U SAS 75盘 3.5寸级联框/
    'CTRL_12GSAS_2U25_EAR_12GLINK': 40,  # 2U 12G SAS 25盘主控框/
    'CTRL_NVMe2U_24': 99,  # 2U NVMe 2.5寸主控框/
    'EXP2U_JBOF': 101, # 2U JBOF硬盘框/
    'CTRL_4U_4C': 112, # 4U 四控 控制框/
    'CTRL_SAS2U_2C_25_MID': 113,  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    'CTRL_SAS2U_2C_12_MID': 114,  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    'CTRL_NVMe2U_2C_36': 115,  # 2U 双控 NVMe 36盘位 控制框/
    'CTRL_SAS2U_2C_25_LOW': 116,  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    'CTRL_SAS2U_2C_12_LOW': 117,  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    'EXP_IPSAS_2U_25': 118,  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
    'EXP_IPSAS_2U_12': 119,  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
    'EXP_IPNVMe_2U_36': 120,  # 2U IP NVMe 36盘位 硬盘框/
}


ENCLOSURE_TYPE = {
    0: "EXP",  # 级联框（硬盘框）/
    1: "CTRL",  # 控制框/
    2: "DSW",  # 数据交换机/
    3: "MSW",  # 管理交换机/
    4: "SVP"  # 管理服务器/
}

EXPBOARD_TYPE = {
    0: "SAS",
    1: "FC",
    5: "PCIe",
}

INTF_MODEL = {
    1: "FC_4X4G",  # 4x4G FC接口模块/4x4G FC Interface Module
    2: "FC_2X4G",  # 2x4G FC接口模块/2x4G FC Interface Module
    3: "GE_RJ45_2X",  # 2xGE 电接口模块/2xGE Electrical Interface Module
    4: "SASI_4X",  # 4xSAS I 接口模块/4xSAS I Interface Module
    5: "FC_4X4G_EXPAND",  # Swapped FC接口模块/Swapped FC Interface Module
    6: "ETH10G_2",  # 2x10GE 光接口模块/2x10GE Optical Interface Module
    7: "FC_1X8G",  # 1x8G FC光接口模块/1x8G FC Optical Interface Module
    8: "FC_2X8G""FC_2X8G",  # 2x8G FC光接口模块/2x8G FC Optical Interface Module
    9: "SASII_2X",  # 2xSAS II电接口模块/2xSAS II Electrical Interface Module
    10: "SASII_4X",  # 4xSAS II电接口模块/4xSAS II Electrical Interface Module
    11: "Combo_2FCx2GE",  # 2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
    12: "iSCSI_4X",  # 4xGE 电接口模块/4xGE Electrical Interface Module
    13: "FC_4X8G",  # 4x8G FC光接口模块/4x8G FC Optical Interface Module
    16: "MINISAS_4X",  # 4xmini-SAS接口模块/4x mini-SAS Interface Module
    21: "FCoE_4X",  # 4x10G FCoE光接口模块/4x10G Optical Interface Module
    22: "SASA_2X6G",  # 2x6G SASA接口模块/2x6G SASA Interface Module
    23: "SASB_2X6G",  # 2x6G SASB接口模块/2x6G SASB Interface Module
    24: "ManagerBoard",  # 管理板/Management Board
    25: "TOE",  # 4x10GE接口模块/4x10GE Interface Module
    26: "PCIe_2X5G",  # 2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
    27: "FCoE_2X",  # 2x10G FCoE光接口模块/2x10G Optical Interface Module
    28: "iSCSI_4XGE",  # 4xGE Optical Interface Module/4xGE光接口模块
    29: "FC_2X16G",  # 2x16G FC Optical Interface Module    2x16G FC光接口模块
    30: "SAS_4X12G",  # 4x12SAS QSFP Interface Module    4x12G SAS光电接口模块
    31: "iSCSI_4X10",  # 4x10GE Electrical Interface Module    4x10GE 电接口模块
    32: "IB_2x40G",  # 2x40GE Infiniband Interface Module    2x40GE IB接口模块
    33: "IB_2x56G",  # 2x56GE Infiniband Interface Module    2x56GE IB接口模块
    34: "GE_RJ45_4X",  # 4xGE Electrical Interface Module    4xGE 电接口模块
    35: "AccerationEngineCard",  # Express Module（ACC，Acceration engine）    重删压缩加速卡
    36: "IOC_4X10G_RJ45",  # 4x10GE Electrical Interface Module    4x10GE 电接口模块
    37: "IOC_4XSMART",  # 4xSMART Optical Interface Module    4xSMART 光接口模块
    38: "IOC_8X8G_FC",  # 8x8G FC Optical Interface Module    8x8G FC光接口模块
    39: "IOC_4X8G_FC",  # 4x8G FC Optical Interface Module    4x8G FC光接口卡
    40: "IOC_4X16G_FC",  # 4x16G FC Optical Interface Module    4x16G FC光接口卡
    41: "SAS_12PORT_BACKEND_MODULE",  # 12 port 4*12Gb SAS Back-End Interconnect I/O Module     12端口4*12Gb SAS后端全互联IO模块
    44: "PCIe_2PORT",  # 2 port PCIe Interface Module||2接口PCIe接口模块
    # todo: to be merged.
    44: "pcie_2X",  # from exp.
    55: "PCIe_2PORT_BACK",  # 2 port PCIe Interface Module/2接口PCIe接口模块'
    58: "IOC_8X16G_FC",  # 8x16G FC Optical Interface Module    8x16G FC光接口卡
    65: "IOC_4X32G_X16_FC",  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X16
    66: "IOC_4X32G_X8_FC",  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X8
    67: "IOC_2X100G_X16_ETH",  # 2 端口 100Gb ETH I/O模块（QSFP28）X16
    68: "IOC_2X100G_X8_ETH",  # 2 端口 100Gb ETH I/O模块（QSFP28）X8
    71: "ETH_2X10G",  # 4端口 10Gb ETH I/O模块
}


DISK_TYPE_E = {
    'FC': 0,  # FC/FC
    'SAS': 1,  # SAS/SAS
    'SATA': 2,  # SATA/SATA
    'SSD': 3,  # SSD/SSD
    'NL_SAS': 4,  # NL_SAS/NL_SAS
    'SLC_SSD': 5,  # SLC SSD/SLC SSD
    'MLC_SSD': 6,  # MLC SSD/MLC SSD
    'FC_SED': 7,  # FC_SED/FC_SED
    'SAS_SED': 8,  # SAS_SED/SAS_SED
    'SATA_SED': 9,  # SATA_SED/SATA_SED
    'SSD_SED': 10,  # SSD_SED/SSD_SED
    'NL_SAS_SED': 11,  # NL_SAS_SED/NL_SAS_SED
    'SLC_SSD_SED': 12,  # SLC_SSD_SED/SLC_SSD_SED
    'MLC_SSD_SED': 13,  # MLC_SSD_SED/MLC_SSD_SED
    'NVME_SSD': 14,  # NVME_SSD/NVME_SSD
    'NVME_SSD_SED': 16,  # NVME_SSD_SED/NVME_SSD_SED
    'SCM': 17,  # SCM
    'SCM_SED': 18,  # SCM_SED/SCM_SED
}

ENCLOSURE_HEIGHT = {
    "CTRL_SAS2U_12": 1,  # 2U SAS 12盘主控框/
    "CTRL_SAS2U_24": 2,  # 2U SAS 24盘主控框/
    "EXPSAS2U_12": 2,  # 2U SAS 12盘级联框/
    "EXPSAS2U_24": 2,  # 2U SAS 24盘级联框/
    "EXPSAS4U": 4,  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框/
    "EXPFC": 4,  # 4U FC 24盘级联框/
    "DSW_PCIe1U": 1,  # 1U PCIe数据交换机/
    "EXPSAS4U_75": 4,  # 4U SAS 75盘级联框/
    "SVP": 1,  # SVP/SVP Controller Enclosure
    "CTRL_6U": 6,  # 6U 4控独立机头/
    "CTRL_3U": 3,  # 3U 2控独立机头/
    "EXPSAS2U_25": 2,  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框/
    "EXPSAS4U_24_NEW": 4,  # 4U SAS 24盘3.5寸磁盘框（新）/
    "CTRL_12GSAS_2U25_EAR": 2,  # 2U 12GSAS 25盘主控框/
    "CTRL_12GSAS_2U12_EAR": 2,  # 2U 12GSAS 12盘主控框/
    "SSD_12G_2U_25_DISKS_ENCLOSURE": 2,  # 2U 12G SSD 2.5寸框/
    "CTRL_12GSAS_4U24_EAR_12GLINK": 4,  # 4U 12G SAS 24盘主控框/
    "EXP_12G_SAS_4U_75": 4,  # 12G 4U SAS 75盘 3.5寸级联框/
    "CTRL_12GSAS_2U25_EAR_12GLINK": 2,  # 2U 12G SAS 25盘主控框/
    "EXP_SAS2U_25": 2,  # 2U SAS 25盘位 2.5英寸 硬盘框/
    "EXP_SAS4U_24": 4,  # 4U SAS 24盘位 3.5英寸 硬盘框/
    "CTRL_NVMe2U_24": 2,  # 2U NVMe 2.5寸主控框/
    "EXP2U_JBOF": 2,  # 2U JBOF硬盘框/
    "CTRL_4U_4C": 4,  # 4U 四控 控制框/
    "CTRL_SAS2U_2C_25_MID": 2,  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    "CTRL_SAS2U_2C_12_MID": 2,  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    "CTRL_NVMe2U_2C_36": 2,  # 2U 双控 NVMe 36盘位 控制框/
    "CTRL_SAS2U_2C_25_LOW": 2,  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    "CTRL_SAS2U_2C_12_LOW": 2,  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    "EXP_IPSAS_2U_25": 2,  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
    "EXP_IPSAS_2U_12": 2,  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
    "EXP_IPNVMe_2U_36": 2,  # 2U IP NVMe 36盘位 硬盘框/
}

EXPBOARD = {
    "model": {"index": 64, "type": tlvDataType.DATA_TYPE_ENUM},  # 型号, enum
    "logicVer": {"index": 65, "type": tlvDataType.DATA_TYPE_STRING},  # 逻辑版本, string
    "pcbVer": {"index": 66, "type": tlvDataType.DATA_TYPE_STRING},  # PCB版本, string
    "sesVer": {"index": 67, "type": tlvDataType.DATA_TYPE_STRING},  # SES版本, string
    "elabel": {"index": 68, "type": tlvDataType.DATA_TYPE_STRING},  # 电子标签, string
    "lightStatus": {"index": 70, "type": tlvDataType.DATA_TYPE_ENUM},  # 定位灯, enum
}


UPGRADE_PKGTYPE_E = {
    'UPGRADE_PKGTYPE_TYPE_SYS': 1,  # 系统软件包
    'UPGRADE_PKGTYPE_TYPE_COLD_PATCH': 2,  # 冷补丁
    'UPGRADE_PKGTYPE_TYPE_HOT_PATCH': 3  # 热补丁
}


DISK = {
    'diskType': {'index': 64, 'type': tlvDataType.DATA_TYPE_ENUM},  # 硬盘类型, enum
    'sectors': {'index': 65, 'type': tlvDataType.DATA_TYPE_U64LONG_TYPE},  # 扇区数量, uint64
    'sectorSize': {'index': 67, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 扇区大小, uint32
    'healthStatus': {'index': 7, 'type': tlvDataType.DATA_TYPE_ENUM},
}


HOST_LINK = {
    'TYPE': {"index": 0, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},  # ,
    'ID': {"index": 1, "type": tlvDataType.DATA_TYPE_STRING},  # ,
    'HEALTHSTATUS': {"index": 7, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},  # ,
    'RUNNINGSTATUS': {"index": 8, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},  # ,
    'INITIATOR_TYPE': {"index": 64, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},  # , enum
    'INITIATOR_ID': {"index": 65, "type": tlvDataType.DATA_TYPE_STRING},  # , string
    'INITIATOR_PORT_WWN': {"index": 66, "type": tlvDataType.DATA_TYPE_STRING},  # , string
    'TARGET_TYPE': {"index": 68, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},  # , enum
    'TARGET_ID': {"index": 69, "type": tlvDataType.DATA_TYPE_STRING},  # , string
    'TARGET_PORT_WWN': {"index": 70, "type": tlvDataType.DATA_TYPE_STRING},  # , string
    'CTRL_ID': {"index": 73, "type": tlvDataType.DATA_TYPE_STRING}  # , string
}


CONTROLLER_IO = {
    'id': {'index': 0, 'type': tlvDataType.DATA_TYPE_STRING},  # 控制器ID, string
    'frontEndIO': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 前端并发, uint32
    'frontEndLimit': {'index': 2, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 前端并发的上限值, uint32
    'portType': {'index': 3, 'type': tlvDataType.DATA_TYPE_ENUM},  # 后端端口类型, enum
    'portID': {'index': 4, 'type': tlvDataType.DATA_TYPE_STRING},  # 后端端口ID, string
    'backEndIO': {'index': 5, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 后端并发, uint32
    'backEndLimit': {'index': 6, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT}  # 后端并发的上限值, uint32
}

CONTROLLER_INNER_IP = {
    'innterIpNet0Addr': {'index': 0, 'type': tlvDataType.DATA_TYPE_STRING},
    'innterIpNet1Addr': {'index': 1, 'type': tlvDataType.DATA_TYPE_STRING},
    'mask_0': {'index': 2, 'type': tlvDataType.DATA_TYPE_STRING},
    'mask_1': {'index': 3, 'type': tlvDataType.DATA_TYPE_STRING},
    'gateway_0': {'index': 4, 'type': tlvDataType.DATA_TYPE_STRING},
    'gateway_1': {'index': 5, 'type': tlvDataType.DATA_TYPE_STRING},
}

CMO_CR_VER_INFO_S = {
    'CMO_VER_PACKAGE_TYPE': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 要查询的升级包类型, uint32
    'CMO_VER_RESULT': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 查询结果, uint32
    'CMO_VER_NODE_ID': {'index': 1, 'type': tlvDataType.DATA_TYPE_UNSIGN_INT},  # 节点ID, uint32
    'CMO_VER_NODE_NAME': {'index': 2, 'type': tlvDataType.DATA_TYPE_STRING},  # 节点名称, string
    'CMO_VER_NODE_IP': {'index': 3, 'type': tlvDataType.DATA_TYPE_STRING},  # 节点IP, string
    'CMO_VER_CUR_VERSION': {'index': 4, 'type': tlvDataType.DATA_TYPE_STRING},  # 当前运行的包版本号, string
    'CMO_VER_SAVED_VERSION': {'index': 5, 'type': tlvDataType.DATA_TYPE_STRING},  # 设备当前保存的可回退版本号, string
    'CMO_VER_NODE_TYPE': {'index': 6, 'type': tlvDataType.DATA_TYPE_STRING},  # 节点类型, string
    'CMO_VER_CUR_VERSION_FOR_USER': {'index': 7, 'type': tlvDataType.DATA_TYPE_STRING},  # 设备当前的Spc版本信息, string
}

IMPORT_CONFIG_DATA = {
    'CMO_FORCE_CLEAR_DB_FLAG': {'index': 4, 'type': tlvDataType.DATA_TYPE_BOOL},  # 强制清除配置标志
}

FORCE_CLEAR_DB_FLAG = {
    'NOT_FORCE_CLEAR_DB': 0,  # 不是强制清除配置
    'FORCE_CLEAR_DB': 1,  # 强制清除配置
}

SCALEOUT_DISK_ENC_NUM = {
    "diskEnclosureNum": {"index": 64, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
}

SCALE_OUT = {
    'OLD_NODE_NUM': {'index': 0, 'type': tlvDataType.DATA_TYPE_UNSIGN_32INT},  # 集群扩控前节点数
    'INTERNAL_PRODUCT_MODEL': {'index': 64, 'type': tlvDataType.DATA_TYPE_STRING},  # 内部产品型号
    'CPU_MODEL_INFO': {'index': 65, 'type': tlvDataType.DATA_TYPE_STRING},  # CPU型号信息
    'CPU_NUMBER': {'index': 66, 'type': tlvDataType.DATA_TYPE_SIGN_INT},  # CPU核数量
    'BAY_ID': {'index': 67, 'type': tlvDataType.DATA_TYPE_UNSIGN_32INT},  # 框号
    'NEW_NODE_NUM': {'index': 68, 'type': tlvDataType.DATA_TYPE_UNSIGN_32INT},  # 集群扩控后节点数
    'BASE_IP_ADD_1': {'index': 69, 'type': tlvDataType.DATA_TYPE_STRING},  # IP基址1
    'BASE_IP_ADD_2': {'index': 70, 'type': tlvDataType.DATA_TYPE_STRING},  # IP基址2
    'CABLE_INFO': {'index': 71, 'type': tlvDataType.DATA_TYPE_JSON},  # 线缆链接信息
    'CABLE_TEST_RESULT': {'index': 72, 'type': tlvDataType.DATA_TYPE_UNSIGN_32INT},  # 线缆检测结果
    'NET_WORK_MODE': {'index': 73, 'type': tlvDataType.DATA_TYPE_ENUM},  # 组网方式
}

CABLE_TEST_RESULT_FLAG = {
    'PASS': '0',  # 通过
    'NOTPASS': '1',  # 不通过
}

RESTROCTST_TASK = {
    "RESTROCTST_CTRL_ID": {"index": 1, "type": tlvDataType.DATA_TYPE_STRING},
    "RESTROCTST_STATE": {"index": 64, "type": tlvDataType.DATA_TYPE_BOOL},
}

# 硬盘认证证书
DISK_CERTIFICATE = {
    # 证书标签
    "LABEL_OF_CERTIFICATE": {
        "index": 1, "type": tlvDataType.DATA_TYPE_STRING
    },
    # 证书内容
    "CONTENT_OF_CERTIFICATE": {
        "index": 2, "type": tlvDataType.DATA_TYPE_STRING
    },
    # 证书检查结果
    "RESULT": {
        "index": 3, "type": tlvDataType.DATA_TYPE_UNSIGN_32INT
    },
    "PASS": 1,  # 通过
    "NOTPASS": 0,  # 不通过
}

# 告警级别枚举
CMO_ALARM_LEVEL_E = {
    "suggestive": "2",
    "warning": "3",
    "secondary": "4",
    "important": "5",
    "urgent": "6",
    "fatal": "7",
    "eliminated": "8"
}

# 升级检查返回结果字典定义
UPD_CHECK_RESULT = {
    "CHECK_SOFTWARE_RESERVED_MEMORY": {
        "TimeOut": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.reserved.memory.notpass", "status": False},
        "False": {"msg": "check.reserved.memory.pass", "status": True},
    },
    "CHECK_SOFTWARE_SYSCOMPATIBLE": {
        "TimeOut": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.syssoftware.compatible.notpass",
                  "status": False},
        "True": {"msg": "check.syssoftware.compatible.pass", "status": True},
    },
    "CHECK_SOFTWARE_FIRMWARE_COMPATIBLE": {
        "TimeOut": {"msg": "check.result.timeout", "status": False},
        "success": {"msg": "check.fwversion.compatible.pass", "status": True},
        "fail": {"msg": "check.fwversion.compatible.notpass", "status": False},
    },
    "CHECK_SOFTWARE_SYSSTATUS": {
        "TimeOut": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.system.status.pass", "status": True},
        "False": {"msg": "check.system.status.notpass", "status": False},
    },
    "CHECK_SOFTWARE_SYSRESOURCE": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.system.resource.notpass", "status": False},
        "True": {"msg": "check.system.resource.pass", "status": True},
    },
    "CHECK_SOFTWARE_VERSIONCONSISTANCE": {
        "timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.version.consistance.notpass", "status": False},
        "True": {"msg": "check.version.consistance.pass", "status": True},
    },
    "CHECK_SOFTWARE_SYSPRESSURE": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.system.pressure.notpass", "status": False},
        "False": {"msg": "check.system.pressure.pass", "status": True},
    },
    "CHECK_SOFTWARE_DOUBLECTRL": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.double.controller.notpass", "status": False},
        "True": {"msg": "check.double.controller.pass", "status": True},
    },
    "CHECK_SOFTWARE_XNETPRESSURE": {
        "TimeOut": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.xnet.pressure.pass", "status": True},
        "True": {"msg": "check.xnet.pressure.notpass", "status": False},
    },
    "CHECK_SOFTWARE_SYS_CONFIGLOG": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.system_config.log.notpass", "status": False},
        "True": {"msg": "check.system_config.log.pass", "status": True},
    },
    "CHECK_SOFTWARE_CFG_CONFIGLOG": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.system_config.log.notpass", "status": False},
        "True": {"msg": "check.system_config.log.pass", "status": True},
    },
    "CHECK_SOFTWARE_FRONT_PRESSURE": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.front.pressure.notpass", "status": False},
        "True": {"msg": "check.front.pressure.pass", "status": True},
    },
    "CHECK_SOFTWARE_SYSALARM": {
        "TimeOut": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.system.alarm.notpass", "status": False},
        "False": {"msg": "check.system.alarm.pass", "status": True},
    },
    "CHECK_SOFTWARE_VMMACHINE_SHUTDWON": {
        0: {"msg": "check.vm.machine.shutdown.pass", "status": True},
        1: {"msg": "check.vm.machine.shutdown.notpass", "status": False},
        2: {"msg": "check.result.timeout", "status": False},
        4: {"msg": "check.vm.machine.shutdown.pass", "status": True},
    },
    "CHECK_SOFTWARE_PROTOCOL": {
        "True": {"msg": "check.protocol.pass", "status": True},
        "False": {"msg": "check.protocol.notpass", "status": False},
        "TimeOut": {"msg": "check.result.timeout", "status": False},
    },
    "CHECK_HARDWARE_BBUPOWER": {
        "Timeout": {"msg": "check.hardware.BBUPower.timeout", "status": False},
        "True": {"msg": "check.hardware.BBUPower.pass", "status": True},
        "False": {"msg": "check.hardware.BBUPower.notpass", "status": False},
        "input command error": {"msg": "check.hardware.BBUPower.pass",
                                "status": True},
    },
    "CHECK_HARDWARE_PCIE_LINKSTATUS": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.hardware.PCIESingleLink.pass", "status": True},
        "False": {"msg": "check.hardware.PCIESingleLink.notpass",
                  "status": False},
    },
    "CHECK_DISK_USAGE": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.disk.usage.notpass", "status": False},
        "True": {"msg": "check.disk.usage.pass", "status": True},
    },
    "CHECK_DISK_SLOWDISK": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.disk.slow.notpass", "status": False},
        "False": {"msg": "check.disk.slow.pass", "status": True},
        "unsupported command": {"msg": "check.disk.slow.pass", "status": True},
    },
    "CHECK_DISK_LINKSTATUS": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.disk.singlelink.notpass", "status": False},
        "False": {"msg": "check.disk.singlelink.pass", "status": True},
        "unsupported command": {"msg": "check.disk.singlelink.pass",
                                "status": True},
    },
    "CHECK_DISK_ISDISKDIAGNOSE": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.disk.isDiskInDiagnose.notpass",
                 "status": False},
        "False": {"msg": "check.disk.isDiskInDiagnose.pass", "status": True},
        "Erasing": {"msg": "check.disk.isDiskInDiagnose.erasing.notpass",
                    "status": False},
    },
    "CHECK_SERVICE_DISKDOMAINSTATUS": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "False": {"msg": "check.diskdomain.status.notpass", "status": False},
        "True": {"msg": "check.diskdomain.status.pass", "status": True},
    },
    "CHECK_SERVICE_EXTLUN_LINKSTATUS": {
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "True": {"msg": "check.extlunlink.status.notpass", "status": False},
        "False": {"msg": "check.extlunlink.status.pass", "status": True},
    },
    "CHECK_SOFTWARE_FRONTLINK": {
        "True": {"msg": "check.frontlink.pass", "status": True},
        "False": {"msg": "check.frontlink.notpass", "status": False},
        "Timeout": {"msg": "check.result.timeout", "status": False},
        "input command error": {"msg": "check.frontlink.pass", "status": True},
        "HostId": {"msg": "check.frontlink.notpass.hostId", "status": False},
    },
    # 系统后台任务抑制状态检查
    "CHECK_SOFTWARE_RESTRICTSTATE": {
        1: {"msg": "check.restrictstate.notpass", "status": False},
        0: {"msg": "check.restrictstate.pass", "status": True},
    },
}

UPD_MSG_E = {
    "EXE_UPD_MSGTYPE": 0,
    "EXE_UPD_NIDLIST": "",
    "EXE_UPD_ACTIVETYPE": 0,
    "EXE_UPD_BAKPATH": "",
    "EXE_UPD_EXENODETYPE": "",
    "EXC_NODE_CFG": 1,
    "CMO_EXC_CHECKTYPE": 0,
    "CMO_EXC_ISINNER": 0,
}

CMO_UPD_EXECUTE_DEFINE = {
    "NODE_ID": {"index": 0, "type": tlvDataType.DATA_TYPE_STRING},
    "RESULT": {"index": 1, "type": tlvDataType.DATA_TYPE_STRING},
    # 前端链路冗余检查，主机ID字段
    "HOST_ID": {"index": 2, "type": tlvDataType.DATA_TYPE_STRING},
    # 系统后台任务抑制状态检查
    "RESTROCTST_CTRL_ID": {"index": 1, "type": tlvDataType.DATA_TYPE_STRING},
    "RESTROCTST_STATE": {"index": 64, "type": tlvDataType.DATA_TYPE_BOOL},
    "CONTROLLER_ID": {"index": 65, "type": tlvDataType.DATA_TYPE_STRING},
    "CONTROLLER_NUM": {"index": 66, "type": tlvDataType.DATA_TYPE_UNSIGN_INT},
}

# 升级前检查发送给升级模块的命令,其中id表示通知升级模块要在那个节点执行,1:在集群主上执行,2:在所有节点执行
UPD_CMD_DEFINE = {
    "CHECK_SOFTWARE_RESERVED_MEMORY": {"cmd": "sys ismemusedup", "id": 2},
    # 检查系统预留内存
    "CHECK_SOFTWARE_SYSCOMPATIBLE": {"cmd": "upd syscompatiblecheck", "id": 2},
    # 检查系统版本兼容性
    "CHECK_SOFTWARE_FIRMWARE_COMPATIBLE": {"cmd": "upg checkfwverinfo",
                                           "id": 2},  # 检查固件版本兼容性
    "CHECK_SOFTWARE_SYSSTATUS": {"cmd": "sys issysnormal", "id": 1},  # 检查系统故障
    "CHECK_SOFTWARE_SYSRESOURCE": {"cmd": "upd sysresourcecheck", "id": 2},
    # 检查系统资源
    "CHECK_SOFTWARE_VERSIONCONSISTANCE": {"cmd": "upd issameversion", "id": 2},
    # 检查控制器版本是否一致
    "CHECK_SOFTWARE_SYSPRESSURE": {"cmd": "sys issystembusy", "id": 1},
    # 检查系统运行压力
    "CHECK_SOFTWARE_DOUBLECTRL": {"cmd": "sys isalldoublectrl", "id": 2},
    # 检查引擎是否为双控
    "CHECK_SOFTWARE_XNETPRESSURE": {"cmd": "xnet checkpressure", "id": 2},
    # 检查Xnet压力
    "CHECK_SOFTWARE_SYS_CONFIGLOG": {"cmd": "sys showcfglog", "id": 1},
    # 检查系统配置LOG
    "CHECK_SOFTWARE_CFG_CONFIGLOG": {"cmd": "cfg showcfglog", "id": 1},
    # Dorado版本，检查系统配置LOG
    "CHECK_SOFTWARE_FRONT_PRESSURE": {"cmd": "ioperf iobandwidth 5", "id": 2},
    # 检查系统前端压力
    "CHECK_SOFTWARE_SYSALARM": {"cmd": "upg UrgentAlm", "id": 1},  # 检查系统告警
    "CHECK_SOFTWARE_PROTOCOL": {"cmd": "proto upgrade precheck", "id": 2},
    # 系统文件共享服务检查

    "CHECK_HARDWARE_BBUPOWER": {"cmd": "upg checkbbupower", "id": 2},
    # 检查BBU电量是否充足
    "CHECK_HARDWARE_PCIE_LINKSTATUS": {"cmd": "upd checkpcielink", "id": 1},
    # PCIe链路检查

    "CHECK_DISK_USAGE": {"cmd": "upd diskusagecheck", "id": 2},  # 检查磁盘利用率
    "CHECK_DISK_SLOWDISK": {"cmd": "ld checkdiskslow", "id": 1},  # 检查慢盘
    "CHECK_DISK_LINKSTATUS": {"cmd": "ld checksinglelink", "id": 2},  # 检查磁盘单链路
    "CHECK_DISK_ISDISKDIAGNOSE": {"cmd": "sddebug checkdiag", "id": 2},
    # 检查磁盘单链路

    "CHECK_SERVICE_DISKDOMAINSTATUS": {"cmd": "pmgr isallpoolcanupgrade",
                                       "id": 2},  # 检查硬盘域状态
    "CHECK_SERVICE_EXTLUN_LINKSTATUS": {"cmd": "ld checkextlunsinglelink",
                                        "id": 1},  # 检查外部LUN链路状态

    "CHECK_SOFTWARE_VMMACHINE_SHUTDWON": {"CMO_EXC_CHECKTYPE": 0,
                                          "CMO_EXC_ISINNER": 0},  # 所有虚拟机是否关闭检测
    "CHECK_SOFTWARE_FRONTLINK": {"cmd": "upg checkhostpath", "id": 2},  # 前端链路冗余检查
}
