/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
 */


function filter(value, tag) {
    var emptyInfo = $('#end').hide();
    var allNodes = $(tag + "[type=filterRow]")
    allNodes.hide();
    if ("" == value) {
        allNodes.show();
        emptyInfo.hide();
        return;
    }
    var targetNodes = $(tag + "[filterValue*='" + value + "']");
    if (targetNodes.length == 0) {
        emptyInfo.show();
        return;
    }
    targetNodes.show()
}

function isIE() {
    var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串
    var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器
    var isIE11 = userAgent.indexOf('Trident') > -1 && userAgent.indexOf("rv:11.0") > -1;
    return isIE || isIE11;
}

function isEdge() {
    var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串
    var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器
    var isEdge = userAgent.indexOf("Edge") > -1 && !isIE; //判断是否IE的Edge浏览器
    return isEdge;
}

function setFilterValue(value) {
    if (isIE()) {
        window.status = value;
    } else if (isEdge()) {
        window.top.name = value;
    } else {
        if (typeof (sessionStorage) != "undefined") {
            sessionStorage.setItem("filterValue", value);
        }
    }
}

function getFilterValue() {
    if (isIE()) {
        return window.status;
    } else if (isEdge()) {
        return window.top.name;
    } else {
        if (typeof (sessionStorage) != "undefined") {
            var value = sessionStorage.getItem("filterValue");
            if (!value) {
                return "";
            } else {
                return value;
            }
        }

        return "";
    }
}