#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
"""
@time: 2024/05/23
@file: check_bbu_back_for_cpu_off.py
@function: 检查BIOS的BbuBackForCpuOff是否为Enabled（融合）或Disabled（块）
"""

import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish.redfish_util import get_all_bios_info

PY_JAVA_ENV = py_java_env
BIOS_KEY = "BbuBackForCpuOff"


def check_status_ok_in_convergence(current_mapping_version, bios_value):
    return "convergence" in current_mapping_version and (bios_value in ("Enabled", "Enable"))


def check_status_ok_in_block(current_mapping_version, bios_value):
    return "block" in current_mapping_version and (bios_value in ("Disabled", "Disable"))


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)

    try:
        bios_info, resource = get_all_bios_info(login_info, logger)
        value = bios_info.get(BIOS_KEY)
        mapping_version = context_util.get_mapping_version(PY_JAVA_ENV)
        logger.info("The dev BbuBackForCpuOff value: {}, mapping_version: {}".format(value, mapping_version))
        if not value:
            return ResultFactory.create_pass(resource, entity.create_msg("bbu.backup.for.cpu.off.no.value"))
        if check_status_ok_in_convergence(mapping_version, value) or check_status_ok_in_block(mapping_version, value):
            return ResultFactory.create_pass(resource)
        # 没有这个配置项或者，融合场景不是Enabled，块场景不是Disabled，直接报错。
        return ResultFactory.create_not_pass(resource, entity.create_msg("bbu.backup.for.cpu.off.not.requirements"))
    except DeployException as de:
        logger.error("check bios BbuBackForCpuOff exception : {}".format(de.message))
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
