#!/usr/bin/env python
# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import re
from Common.base import context_util
from Common.base import entity
from Common.base.constant import MsgKey
from Common.base.context_util import get_mapping_attribute, get_mapping_attribute_url
from Common.base.entity import Compare
from Common.base.entity import CheckCommon
from Common.protocol import ssh_util

PY_JAVA_ENV = py_java_env

IMD_DRIVER_VERSION_KEY = "IDM_driver_version"


def execute(task):
    return CheckIDMDriverVersion(task).check()


class CheckIDMDriverVersion(CheckCommon):
    def __init__(self, task):
        self.deploy_node = context_util.get_deploy_node(PY_JAVA_ENV)
        self.not_support_msg = entity.create_msg(MsgKey.NOT_INVOLVE)
        self._mapping_version = ""
        self._mapping_url = ""
        super(CheckIDMDriverVersion, self).__init__(task)

    def check_version(self):
        version_match = True
        self._logger.info("start to check nvme driver vision.")
        if not context_util.contain_need_check_key(PY_JAVA_ENV, [IMD_DRIVER_VERSION_KEY]):
            self._logger.info("not found nvme driver mapping version")
            return version_match
        idm_version = self.get_idm_driver_version()
        self.deploy_node.putVersion(IMD_DRIVER_VERSION_KEY, idm_version)
        if not idm_version:
            err_msg = entity.create_msg("no.associated.driver.exist").format("IDM")
            version_match = False
            self.deploy_node.putVersion(IMD_DRIVER_VERSION_KEY, "--")
        else:
            err_msg = entity.create_msg("idm.driver.current.version").format(idm_version)
            if Compare.compare_digital_version(idm_version, self._mapping_version) < 0:
                version_match = False
        self.set_version_match(version_match)
        self._err_msgs.append(err_msg)
        return version_match

    def set_version_match(self, version_match):
        if not version_match:
            self.deploy_node.putResult(IMD_DRIVER_VERSION_KEY, context_util.get_not_pass_key())

    def obtain_match_versions(self):
        self._mapping_version = get_mapping_attribute(PY_JAVA_ENV, IMD_DRIVER_VERSION_KEY)
        self._mapping_url = get_mapping_attribute_url(PY_JAVA_ENV, IMD_DRIVER_VERSION_KEY)

    def get_match_msg(self):
        if not self._mapping_version:
            self._mapping_version = self.not_support_msg
            self.deploy_node.putVersion(IMD_DRIVER_VERSION_KEY, self.not_support_msg)
        url_msg = entity.build_url_error_msg(self._mapping_url, entity.create_msg(
            "idm.driver.version.mapping.match").format(self._mapping_version))
        return entity.create_source_file_msg(PY_JAVA_ENV, url_msg)

    def get_idm_driver_version(self):
        ssh_ret = ssh_util.exec_ssh_cmd_nocheck(PY_JAVA_ENV, "rpm -qa |grep idm")
        self._ssh_rets.append(ssh_ret)
        match = re.search(r"euler-(.*?).aarch64", ssh_ret)
        return match.group(1) if match else ""
