#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

"""
@time: 2023/05/25
@file: check_product_compatibility.py
@function:
"""

from Common.base import context_util
from Common.base import entity
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish import redfish_util

from com.huawei.ism.tool.distributeddeploy.logic.config import ProductStrategy

PY_JAVA_ENV = py_java_env


def execute(task):
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    logger = entity.create_logger(__file__)
    origin_infos = []
    err_msgs = []
    try:
        product_unique_id, resource_info = redfish_util.get_product_unique_id(login_info, logger)
        origin_infos.append(resource_info)
        if not product_unique_id:
            return ResultFactory.create_not_pass(origin_infos, entity.create_msg("query.product.model.failed"))
        logger.info("product_unique_id: {}".format(product_unique_id))
        platform_id = ProductStrategy.INS.getPlatformIdByServerUid(product_unique_id, "")
        logger.info("platform_id: {}".format(platform_id))
        context_util.set_platform_id(PY_JAVA_ENV, platform_id)
        if ProductStrategy.INS.isSupport(product_unique_id):
            return ResultFactory.create_pass(origin_infos, entity.create_msg("progress.finish"))

        return ResultFactory.create_not_pass(origin_infos,
                                             entity.create_msg("product.not.support").format(product_unique_id))
    except DeployException as e:
        origin_infos.append(e.origin_info)
        logger.error(e.message)
        err_msgs.append(e.err_msg)
        return ResultFactory.create_not_pass(origin_infos, err_msgs)