#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
"""
@time: 2023/5/26
@file: check_secure_boot.py
@function:
"""
from Common.base import context_util, entity
from Common.base.constant import Platform
from Common.base.entity import DeployException, ResultFactory
from Common.protocol.redfish import redfish_util

PY_JAVA_ENV = py_java_env
original_infos = list()


def execute(task):
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    logger = entity.create_logger(__file__)

    try:
        # 专有硬件不涉及
        if Platform.is_proprietary_hardware_dev(context_util.get_platform_id(PY_JAVA_ENV)):
            return ResultFactory.create_pass(entity.create_msg("secure.boot.enabled.proprietary.hardware"))
        # 1880RAID卡机型，无需关注安全启动，其他的机型需要关闭)
        if check_raid_type_is_1880(login_info, logger):
            return ResultFactory.create_pass(original_infos, entity.create_msg("secure.boot.1880.raid.ignore"))
        # 非1880RAID卡机型，要求安全启动为关闭，如果查询结果是开启，则报不通过。
        # 部分ibmc版本设置安全启动为Disabled时key变为OemSecureBoot，需要兼容
        bios_info, resource = redfish_util.get_all_bios_info(login_info, logger)
        original_infos.append(resource)
        if bios_info.get("OemSecureBoot") == "Enabled" or bios_info.get("SecureBoot") == "Enabled":
            return ResultFactory.create_not_pass(original_infos, entity.create_msg("secure.boot.enabled"))
        return ResultFactory.create_pass(original_infos)
    except DeployException as e:
        logger.error(e.message)
        return ResultFactory.create_not_pass(e.origin_info, e.message)


def check_raid_type_is_1880(login_info, logger):
    raid_model_types, original_info = redfish_util.get_storage_raid_model_type_attributes(login_info, logger)
    original_infos.append(original_info)
    # 方案1：通过类型B80121进行判断
    # 方案2：通过名称SP686C&SP186进行判断
    for raid_model_type in raid_model_types:
        raid_model = raid_model_type.get("Model")
        raid_type = raid_model_type.get("Type")
        logger.info("current raid id:{}, model:{}, type:{}".format(raid_model_type.get("ID"), raid_model, raid_type))
        if raid_type == "B80121" or "SP686C" in raid_model or "SP186" in raid_model:
            return True
    return False
