#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.

"""
@time: 2020/06/08
@file: bmc_ip_config.py
@function:
"""
import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.factory.deploy_factory import DeployFactory
from Common.base.entity import DeployException
from Common.protocol.redfish import redfish_util

LOGGER = entity.create_logger(__file__)


def execute(task):
    java_py_env = task.getJythonContext()
    login_info = context_util.get_login_info(java_py_env)
    error_msgs = []
    try:
        mapping_ver_desc = context_util.get_mapping_version_desc(java_py_env)
        if mapping_ver_desc:
            error_msgs.append(entity.create_msg("current.mapping.ver").format(mapping_ver_desc))
        update_node_sn(error_msgs, java_py_env, login_info)
        dev_uid, resource = DeployFactory(java_py_env, login_info, LOGGER).get_product_unique_id()
        error_msgs.append(entity.create_msg("node.uid").format(dev_uid))
        if is_support_dev(dev_uid, java_py_env):
            return ResultFactory.create_pass(resource, error_msgs)
        error_msgs.append(entity.create_msg("server.version.not.support"))
        return ResultFactory.create_not_pass(resource, error_msgs)
    except DeployException as ex:
        LOGGER.error(str(traceback.format_exc()))
        LOGGER.error("Get product unique id failed: {}".format(ex.message))
        return ResultFactory.create_not_pass(ex.origin_info, ex.err_msg)


def update_node_sn(error_msgs, java_py_env, login_info):
    try:
        sn = redfish_util.get_node_sn(login_info, LOGGER)
        node_sn = context_util.get_node_sn(java_py_env)
        if node_sn and sn != node_sn:
            error_msgs.append(entity.create_msg("node.sn.not.same").format(sn, node_sn))
        context_util.update_node_sn(java_py_env, sn)
    except DeployException as e:
        LOGGER.error("get node sn failed:{}".format(e))


def is_support_dev(dev_uid, java_py_env):
    products = context_util.get_products(java_py_env)
    for platformId, product in products.items():
        dev_type_2_unique_ids = product.getDevType2UniqueIds()
        LOGGER.info("product unique ids: {}".format(dev_type_2_unique_ids))
        for dev_type, unique_ids in dev_type_2_unique_ids.items():
            if dev_uid in unique_ids:
                context_util.set_platform_id(java_py_env, platformId)
                return True
    return False
