#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/17
@file: check_sp_version.py
@function:
@modify:
"""

import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish import redfish_util

PY_JAVA_ENV = py_java_env


def execute(task):
    logger = entity.create_logger(__file__)
    show_msgs = list()
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    mapping_sp_version = context_util.get_mapping_attribute(
        PY_JAVA_ENV, "sp_version")
    match_msg = entity.create_msg("sp.mapping.version").format(mapping_sp_version)
    origin_infos = list()
    try:
        info = redfish_util.get_sp_server_info(login_info, logger)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
    origin_infos.append(str(info))
    if "Version" not in info or "APPVersion" not in info.get("Version"):
        show_msgs.append(entity.create_msg("get.sp.version.failed"))
        show_msgs.append(match_msg)
        return ResultFactory.create_not_pass(origin_infos, show_msgs)
    sp_version = info.get("Version").get("APPVersion")
    logger.info("SP Version: {}".format(sp_version))
    version_match = True
    if entity.Compare.compare_digital_version(sp_version, mapping_sp_version) < 0:
        version_match = False
    show_msgs.append(entity.create_msg("sp.current.version").format(sp_version))
    show_msgs.append(match_msg)
    return ResultFactory.create_pass(origin_infos, show_msgs) if version_match else ResultFactory.create_not_pass(
        origin_infos, show_msgs)
