#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2024. All rights reserved.
"""
@time: 2020/12/26
@file: config_bbu_nv_size.py
@function:
"""
from Common.base import context_util, entity
from Common.base.entity import DeployException, ResultFactory

from Common.protocol.redfish.redfish_util import get_all_bios_info
from Common.service import bios_config_util

BIOS_KEY = "BbuNvSize"
V6_BIOS_KEY = "BbuNvMemSize"

# "{}.{}".format(配套版本, 平台)
VERSION_2_BIOS_SHOULD_VALUE = {
    "8.1.0.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.1.0.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.1.1.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.1.1.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.1.2.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.1.2.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "nfv.dedicated.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "nfv.dedicated.3.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "nfv.dedicated.5.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "nfv.dedicated.6.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.1.2.convergence.x86_v6":
        {
            "key": V6_BIOS_KEY,
            "value": "16G"
        },
    "8.1.3.convergence.x86_v6":
        {
            "key": V6_BIOS_KEY,
            "value": "16G"
        },
    "8.1.3.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.1.3.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.1.5.convergence.x86_v6":
        {
            "key": V6_BIOS_KEY,
            "value": "16G"
        },
    "8.1.5.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.1.5.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.1.6.convergence.x86_v6":
        {
            "key": V6_BIOS_KEY,
            "value": "16G"
        },
    "8.1.6.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.1.6.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.2.0.convergence.x86_v6":
        {
            "key": V6_BIOS_KEY,
            "value": "16G"
        },
    "8.2.0.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.2.0.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.2.0L15Y01.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.2.0L15Y01.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.2.1.convergence.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "16G"
        },
    "8.2.1.block.TaiShan V2":
        {
            "key": BIOS_KEY,
            "value": "Disable"
        },
    "8.2.1.convergence.x86_v6":
        {
            "key": V6_BIOS_KEY,
            "value": "16G"
        }
}


def execute(task):
    java_py_env = task.getJythonContext()
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(java_py_env)
    bios_should_info = VERSION_2_BIOS_SHOULD_VALUE.get("{}.{}".format(
        context_util.get_mapping_version(java_py_env),
        context_util.get_platform_id(java_py_env)))
    if not bios_should_info:
        raise DeployException('bios info not found')
    # BIOS设置
    bios_info, resource = get_all_bios_info(login_info, logger)
    if "Yes" == bios_info.get("BBUDisable", "No"):
        return ResultFactory.create_pass(resource)
    return bios_config_util.config_bios_info(java_py_env, bios_should_info['key'],
                                             bios_should_info['value'])
