#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

"""
@time: 2023/5/24
@file: config_bmc_boot_sequence.py
@function:
"""

from Common.base import context_util
from Common.base import entity
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish import redfish_util
from Common.service.acpi_spcr_service import AcpiSpcrService

PY_JAVA_ENV = py_java_env
BOOT_TYPE_ORDER = {
    "BootTypeOrder2": "PXE",
    "BootTypeOrder3": "Others",
    "BootTypeOrder1": "DVDROMDrive",
    "BootTypeOrder0": "HardDiskDrive"
}


def execute(task):
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    logger = entity.create_logger(__file__)

    try:
        AcpiSpcrService(PY_JAVA_ENV).open_spcr(need_reboot=False)
        # 如果重启读取顺序不是优先硬盘,将bios重启顺序设为默认
        bios_boot_type_order_0, resource = redfish_util.get_one_bios_item_info(login_info, "BootTypeOrder0", logger)
        if bios_boot_type_order_0 != "HardDiskDrive":
            redfish_util.set_some_bios_info(login_info, BOOT_TYPE_ORDER, logger)
        # 设置bios重启模式为光驱模式
        origin_info = redfish_util.set_bios_boot_cd_target(login_info, logger)
        return ResultFactory.create_pass(origin_info)
    except DeployException as e:
        logger.error(e.message)
        return ResultFactory.create_not_pass(e.origin_info, entity.create_msg("config.bmc.boot.sequence.failed"))
