#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2020-2024. All rights reserved.

"""
@time: 2020/06/08
@file: bmc_ip_config.py
@function:
"""
import traceback
from Business.adaptor.java_adaptor import get_sn_mapping_ip_task
from Common.base import context_util
from Common.base import entity
from Common.base.constant import MsgKey
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish import redfish_util
from Common.protocol.redfish.entity.http import HttpClient
from Common.util import modify_bmc_pwd_util

SnMappingIpTask = get_sn_mapping_ip_task()


def execute(task):
    java_py_env = task.getJythonContext()
    logger = entity.create_logger(__file__)
    dev_node = context_util.get_deploy_node(java_py_env)
    dev_sn = dev_node.getSn()
    if not dev_sn:
        return ResultFactory.create_pass(err_msg=entity.create_msg(
            MsgKey.NOT_INVOLVE))
    task.updateProgress(10, entity.create_msg("finding.local.link.ip"))

    local_link_ip = None
    while SnMappingIpTask.getInstance().isSearching():
        if SnMappingIpTask.getInstance().hadSearchIp(dev_sn):
            local_link_ip = SnMappingIpTask.getInstance().getSearchedIp(dev_sn)
            break

    if not local_link_ip:
        if not SnMappingIpTask.getInstance().hadSearchIp(dev_sn):
            return ResultFactory.create_not_pass(err_msg=entity.create_msg(
                "finding.local.link.ip.failed"))
        local_link_ip = SnMappingIpTask.getInstance().getSearchedIp(dev_sn)
    task.updateProgress(35)
    login_info = context_util.get_login_info(java_py_env)
    login_info.ip = local_link_ip
    ip_address = context_util.get_target_bmc_ip_address(java_py_env)
    task.updateProgress(50, entity.create_msg("being.config.bmc.ip"))
    task.updateProgress(65)
    origin_infos = list()
    err_msgs = list()
    try:
        had_modify_default_pwd = redfish_util.modify_bmc_default_password(java_py_env, logger, login_info.ip)
        if not had_modify_default_pwd:
            dev_type = dev_node.getDevType()
            result, origin_info, err_msg = modify_bmc_pwd_util.handle_dev_modify_bmc_new_password(login_info, dev_type)
            origin_infos.append(origin_info)
            if not result:
                err_msgs.append(err_msg)
        origin_infos.append(redfish_util.set_bmc_ip(login_info, ip_address, None, logger))
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        origin_infos.append(de.origin_info)
        err_msgs.append(de.err_msg)
        # 修改默认密码失败时，尝试释放缓存链接
        HttpClient.release_session(login_info, logger)

    return ResultFactory.create_pass(origin_infos, entity.create_msg(
        "progress.finish")) if len(err_msgs) == 0 else ResultFactory.create_not_pass(origin_infos, err_msgs)
