#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
"""
@time: 2024/5/6
@file: config_bmc_power_off.py
@function:
"""
import time

from Common.base import context_util, entity
from Common.base.entity import DeployException, ResultFactory
from Common.protocol.redfish import redfish_util

PY_JAVA_ENV = py_java_env


def execute(task):
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    logger = entity.create_logger(__file__)

    try:
        entity.AutoBrushProgressTask(task, 1200).start()
        # 下电后检查服务器状态，超时时间20分钟
        system_infos = ""
        for idx in range(40):
            system_infos = redfish_util.get_systems_info(login_info, logger)
            if system_infos and system_infos.get("PowerState") == "Off":
                return ResultFactory.create_pass(str(system_infos))
            # 每隔2分钟，调用一次强制下电接口
            if idx % 4 == 0:
                redfish_util.set_power_state(login_info, "ForceOff", logger)
            time.sleep(30)
        return ResultFactory.create_not_pass(system_infos, entity.create_msg("server.power.off.error"))
    except DeployException as de:
        logger.error(de.message)
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
