#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
"""
@time: 2024/5/6
@file: config_bmc_power_on.py
@function:
"""
import time

from Common.base import context_util, entity
from Common.base.entity import DeployException, ResultFactory
from Common.protocol.redfish import redfish_util

PY_JAVA_ENV = py_java_env
origin_infos = list()


def execute(task):
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    logger = entity.create_logger(__file__)

    try:
        entity.AutoBrushProgressTask(task, 600).start()
        system_infos = redfish_util.get_systems_info(login_info, logger)
        origin_infos.append(str(system_infos))
        # 非下电状态，报错
        if not system_infos or system_infos.get("PowerState") != "Off":
            return ResultFactory.create_not_pass(origin_infos, entity.create_msg("server.power.on.state.error"))
        # 上电服务器
        origin_infos.append(redfish_util.set_power_state(login_info, "On", logger))
        # 上电后检查服务器状态，超时时间10分钟
        for _ in range(20):
            system_infos = redfish_util.get_systems_info(login_info, logger)
            if system_infos and system_infos.get("PowerState") == "On":
                origin_infos.append(str(system_infos))
                return ResultFactory.create_pass(origin_infos)
            time.sleep(30)
        return ResultFactory.create_not_pass(origin_infos, entity.create_msg("server.power.on.error"))
    except DeployException as de:
        logger.error(de.message)
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
