#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/08/02
@file: config_host_name.py
@function:
"""
import traceback
from Common.protocol import ssh_util
from Common.base.entity import DeployException
from Common.base import context_util
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.factory.deploy_factory import DeployFactory

PY_JAVA_ENV = py_java_env


def execute(task):
    logger = entity.create_logger(__file__)
    config_hostname_name = context_util.get_config_os_name(PY_JAVA_ENV)
    if not config_hostname_name:
        return ResultFactory.create_pass()
    ssh_rets = list()

    login_info = context_util.get_login_info(PY_JAVA_ENV)
    try:
        # 修改BMC主机名
        ssh_rets.append(DeployFactory(PY_JAVA_ENV, login_info, logger).modify_bmc_host_name(config_hostname_name))
        # 修改OS主机名
        cmd = 'echo -e "{}" > /etc/hostname'.format(config_hostname_name)
        ssh_ret = ssh_util.exec_ssh_cmd_disable_invalid(PY_JAVA_ENV, cmd)
        ssh_rets.append(ssh_ret)
        # 同步到磁盘
        ssh_ret = ssh_util.exec_ssh_cmd_disable_invalid(PY_JAVA_ENV, "sync")
        ssh_rets.append(ssh_ret)
        return ResultFactory.create_pass(ssh_rets)
    except DeployException as e:
        logger.error("config name failed: {}".format(e.message))
        logger.error(str(traceback.format_exc()))
        ssh_rets.append(e.origin_info)
        return ResultFactory.create_not_pass(ssh_rets, e.err_msg)
