# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from Common.base import entity, context_util
from Common.base.entity import DeployException, ResultFactory
from Common.protocol.redfish.entity.resource_client import ManagerResourceClient
from Common.util import deal_none_key_util


def execute(task):
    param = task.getParam().getAlarmService()
    if not param:
        return ResultFactory.create_pass(origin_info=entity.create_msg('not.support'))
    return AlarmService(task.getJythonContext()).patch_info(param)


class AlarmService(object):
    SYS_LOG_PATH = "/SyslogService"

    def __init__(self, context):
        self._login_info = context_util.get_login_info(context)
        self._client = ManagerResourceClient(self._login_info, entity.create_logger(__file__))
        self._resource_path = None

    def get_info(self):
        return self._client.request_get(self._resource_path).resource

    def patch_info(self, alarm_param):
        if not alarm_param:
            return ResultFactory.create_pass()
        try:
            self._resource_path = self._client.get_assign_resource_path() + \
                                  AlarmService.SYS_LOG_PATH
            origin_info = self._client.request_patch(self._resource_path, self._build_patch_param(alarm_param)).resource
            return ResultFactory.create_pass(origin_info=origin_info)
        except DeployException as exception:
            return ResultFactory.create_not_pass(origin_info=exception.origin_info, err_msg=exception.err_msg)

    def _build_patch_param(self, alarm_param):
        patch_param = {"MessageFormat": alarm_param.getMessageFormat(),
                       "ServerIdentitySource": alarm_param.getServerIdentitySource(),
                       "AlarmSeverity": alarm_param.getAlarmSeverity(),
                       "TransmissionProtocol": alarm_param.getTransmissionProtocol(),
                       "AuthenticateMode": alarm_param.getAuthenticateMode(),
                       "ServiceEnabled": alarm_param.getServiceEnabled()}
        sys_log_server = []
        for server in alarm_param.getSyslogServers():
            sys_log_server.append(self._build_server(server))
        patch_param["SyslogServers"] = sys_log_server
        deal_none_key_util.deal_none_key(patch_param)
        if patch_param.get("MessageFormat") == "RFC3164":
            patch_param.pop('ServerIdentitySource', "")
        if not patch_param.get("AlarmSeverity"):
            patch_param["AlarmSeverity"] = None
        return patch_param

    def _build_server(self, server):
        server_param = {
            "Address": server.getAddress(),
            "LogType": self._build_log_type(server),
            "Enabled": server.getEnabled()
        }
        if server.getPort() and server.getPort() != 0:
            server_param["Port"] = server.getPort()
        return server_param

    def _build_log_type(self, server):
        log_type = []
        for input_type in server.getLogType():
            log_type.append(input_type)
        return log_type
