# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.
from Common.base import entity, context_util
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish.entity.resource_client import ManagerResourceClient


def execute(task):
    timezone = task.getParam().getTimezone()
    if not timezone:
        return ResultFactory.create_pass(origin_info=entity.create_msg('not.support'))
    return Timezone(task.getJythonContext()).patch_info(timezone)


class Timezone(object):
    def __init__(self, context):
        self._login_info = context_util.get_login_info(context)
        self._client = ManagerResourceClient(self._login_info, entity.create_logger(__file__))
        self._err_msg = []

    def get_info(self):
        resource = self._client.get_assign_resource_info()
        return resource.get("DateTimeLocalOffset", "")

    def patch_info(self, timezone):
        try:
            response = self._client.patch_manager_info({"DateTimeLocalOffset": timezone})
            return ResultFactory.create_pass(origin_info=response)
        except DeployException as de:
            return ResultFactory.create_not_pass(de.origin_info, entity.create_msg("config.ibmc.timezone.fail"))

    def get_err_msg(self):
        return self._err_msg
