#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.

"""
@time: 2020/08/07
@file: config_jbod_strategy.py
@function:
"""
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.base import context_util
from Common.protocol import ssh_util
from Common.base.entity import DeployException
from Common.protocol.redfish import redfish_util
from Common.base.constant import MsgKey

PY_JAVA_ENV = py_java_env
NO_NEED_TURN_ON_RAID_TYPE = ["3008", "3908", "SP186-M-8i"]


def execute(task):
    logger = entity.create_logger(__file__)
    try:
        need_turn_on, ssh_ret = need_turn_on_jbod()
        if not need_turn_on:
            return ResultFactory.create_pass(ssh_ret, err_msg=entity.create_msg("not.support"))
    except DeployException as de:
        logger.error(de.message)
        if de.may_info_miss():
            task.openAutoRetry()
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)

    login_info = context_util.get_login_info(PY_JAVA_ENV)
    original_infos = [ssh_ret]
    try:
        original_infos.append(redfish_util.modify_storage_attribute(
            login_info, "JBODState", True, logger))
        return ResultFactory.create_pass(original_infos)
    except DeployException as de:
        logger.error("Get http failed: {}".format(de.message))
        original_infos.append(de.origin_info)
        return ResultFactory.create_not_pass(
            original_infos, entity.create_msg(MsgKey.HTTP_ERROR))


def need_turn_on_jbod():
    raid_card_type, ssh_ret = ssh_util.get_raid_card_type(PY_JAVA_ENV)
    if not raid_card_type:
        return False, ssh_ret
    return (raid_card_type not in NO_NEED_TURN_ON_RAID_TYPE), ssh_ret
