#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2024. All rights reserved.
"""
@time: 2020/12/26
@file: config_numaen_strategy.py
@function:
"""
import traceback

from Common.base import context_util
from Common.base import entity
from Common.base.constant import MsgKey
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish.redfish_util import get_all_bios_info, \
    set_one_bios_info

PY_JAVA_ENV = py_java_env
BIOS_KEY = "NUMAEn"
BIOS_KEY_COMPATIBLE = "NumaEn"

# "{}.{}".format(配套版本, 平台)
VERSION_2_BIOS_SHOULD_VALUE = {
    "8.1.0.convergence.TaiShan V2": "Enabled",
    "8.1.0.convergence.x86_64": "Disabled",
    "8.1.0.block.TaiShan V2": "Enabled",
    "8.1.0.block.x86_64": "Enabled",
    "8.1.1.convergence.TaiShan V2": "Enabled",
    "8.1.1.convergence.x86_64": "Disabled",
    "8.1.1.block.TaiShan V2": "Enabled",
    "8.1.1.block.x86_64": "Enabled",
    "8.1.2.convergence.TaiShan V2": "Enabled",
    "8.1.2.convergence.x86_64": "Disabled",
    "8.1.2.block.TaiShan V2": "Enabled",
    "8.1.2.block.x86_64": "Enabled",
    "nfv.dedicated.TaiShan V2": "Enabled",
    "nfv.dedicated.3.TaiShan V2": "Enabled",
    "nfv.dedicated.5.TaiShan V2": "Enabled",
    "nfv.dedicated.6.TaiShan V2": "Enabled",
    "8.1.2.convergence.x86_v6": "Disabled",
    "8.1.2.block.x86_v6": "Disabled",
    "8.1.3.convergence.x86_v6": "Disabled",
    "8.1.3.convergence.x86_64": "Disabled",
    "8.1.3.convergence.TaiShan V2": "Enabled",
    "8.1.3.block.TaiShan V2": "Enabled",
    "8.1.3.block.x86_64": "Enabled",
    "8.1.3.block.x86_v6": "Disabled",
    "8.1.5.convergence.x86_v6": "Disabled",
    "8.1.5.convergence.x86_64": "Disabled",
    "8.1.5.convergence.TaiShan V2": "Enabled",
    "8.1.5.block.TaiShan V2": "Enabled",
    "8.1.5.block.x86_64": "Enabled",
    "8.1.5.block.x86_v6": "Disabled",
    "8.1.6.convergence.x86_v6": "Disabled",
    "8.1.6.convergence.x86_64": "Disabled",
    "8.1.6.convergence.TaiShan V2": "Enabled",
    "8.1.6.block.TaiShan V2": "Enabled",
    "8.1.6.block.x86_64": "Enabled",
    "8.1.6.block.x86_v6": "Disabled",
    "8.2.0.convergence.x86_v6": "Disabled",
    "8.2.0.convergence.x86_64": "Disabled",
    "8.2.0.convergence.TaiShan V2": "Enabled",
    "8.2.0.block.TaiShan V2": "Enabled",
    "8.2.0.block.x86_64": "Enabled",
    "8.2.0.block.x86_v6": "Disabled",
    "8.2.0L15Y01.convergence.x86_v6": "Disabled",
    "8.2.0L15Y01.convergence.x86_64": "Disabled",
    "8.2.0L15Y01.convergence.TaiShan V2": "Enabled",
    "8.2.0L15Y01.block.TaiShan V2": "Enabled",
    "8.2.0L15Y01.block.x86_64": "Enabled",
    "8.2.1.convergence.x86_v6": "Disabled",
    "8.2.1.convergence.x86_64": "Disabled",
    "8.2.1.convergence.TaiShan V2": "Enabled",
    "8.2.1.block.TaiShan V2": "Enabled",
    "8.2.1.block.x86_64": "Enabled",
}


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)

    # BIOS设置
    try:
        bios_info, resource = get_all_bios_info(login_info, logger)
        value = bios_info.get(BIOS_KEY)
        # 在V6服务器的085版本bios，该字段有变动，变为NumaEn
        bios_key = BIOS_KEY
        if not value:
            bios_key = BIOS_KEY_COMPATIBLE
            value = bios_info.get(bios_key)
        logger.info("The dev NUMAEn value: {}".format(value))
        if not value:
            return ResultFactory.create_not_pass(
                resource, entity.create_msg(MsgKey.OBTAIN_INFO_FAILED))
        bios_should_value = VERSION_2_BIOS_SHOULD_VALUE.get("{}.{}".format(
            context_util.get_mapping_version(PY_JAVA_ENV),
            context_util.get_platform_id(PY_JAVA_ENV)))
        if value != bios_should_value:
            set_one_bios_info(login_info, bios_key, bios_should_value, logger)
        return ResultFactory.create_pass(resource)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
