#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
@time: 2020/12/26
@file: config_one_numa_enable.py
@function:
"""
import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish.redfish_util import get_all_bios_info, \
    set_one_bios_info

PY_JAVA_ENV = py_java_env
BIOS_KEY = "OneNumaEnable"
BIOS_SHOULD_VALUE = "Enabled"


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)

    # BIOS设置
    try:
        bios_info, resource = get_all_bios_info(login_info, logger)
        value = bios_info.get(BIOS_KEY)
        logger.info("The dev OneNumaEnable value: {}".format(value))
        if not value:
            return ResultFactory.create_pass(resource)
        if value != BIOS_SHOULD_VALUE:
            set_one_bios_info(login_info, BIOS_KEY, BIOS_SHOULD_VALUE, logger)
        return ResultFactory.create_pass(resource)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
