# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.

from Business.sh import reboot_server_with_ibmc
from Business.sh.config_lldp_for_nfv import NetCardSetService
from Common.base import context_util
from Common.base import entity
from Common.base.constant import ItemStatus
from Common.base.entity import ResultFactory
from Common.factory.deploy_factory import DeployFactory
from Common.protocol.redfish.entity.http import HttpClient


def execute(task):
    logger = entity.create_logger(__file__)
    java_py_env = task.getJythonContext()
    login_info = context_util.get_login_info(java_py_env)
    # 未选择开启lldp
    if not task.getParam().getIsOpenLldp():
        return ResultFactory.create_pass(err_msg=entity.create_msg('not.support'))
    dev_uid, resource = DeployFactory(java_py_env, login_info, logger).get_product_unique_id()
    # 产品型号不支持
    if not is_support_dev(dev_uid, java_py_env, logger):
        return ResultFactory.create_pass(origin_info=resource, err_msg=entity.create_msg('not.support'))
    # 打开网卡lldp
    net_card_set_service = NetCardSetService(task.getJythonContext())
    open_result, origin_info, err_msg = net_card_set_service.open_net_card_lldp_service()
    # 执行了打开lldp，则重启服务器
    if open_result != ItemStatus.PASS:
        return ResultFactory.create_not_pass(origin_info, err_msg)
    if not net_card_set_service.need_restart():
        return ResultFactory.create_pass(origin_info, err_msg)
    restart_result, restart_origin_info, restart_err_msg = reboot_server_with_ibmc.execute(task)
    # 重启服务器比较耗时，可能会导致redfish接口的Token超时无法使用，此处重启服务器后主动释放链接。
    HttpClient.release_session(login_info, logger)
    # 最终结果使用重启结果，重启信息不需要展示
    if restart_result != ItemStatus.PASS:
        return ResultFactory.create_not_pass(origin_info, entity.create_msg('reboot.server.failed'))
    return ResultFactory.create_pass(origin_info, err_msg)


def is_support_dev(dev_uid, java_py_env, logger):
    logger.info(dev_uid)
    support_uids = java_py_env.get("support_uids")
    logger.info(",".join(support_uids))
    return dev_uid in support_uids
