#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/06/11
@file: config_Secure_Boot_strategy.py
@function:
"""
import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.constant import MsgKey
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish.redfish_util import get_all_bios_info, \
    set_one_bios_info, get_product_unique_id

PY_JAVA_ENV = py_java_env
SECURE_BOOT_KEYS = ["SecureBoot", "OemSecureBoot"]
SECURE_BOOT_SHOULD_VALUE = "Disabled"
INVOLVE_PRODUCT_UNIQUE_IDS = {
    "2288H V5": ("0x01011500", "0x01011700", "0x0101ba00"),
    "5288 V5": ("0x01011501", "0x01011701")
}


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)

    # BIOS设置
    try:
        # 涉及判断
        if not is_involve_dev_type(login_info, logger):
            return ResultFactory.create_pass()
        bios_info, resource = get_all_bios_info(login_info, logger)
        value = None
        for key in SECURE_BOOT_KEYS:
            secure_boot_key = key
            if key in bios_info:
                value = bios_info.get(key)
                break
        logger.info("The dev SecureBoot value: {}".format(value))
        if not value:
            return ResultFactory.create_not_pass(
                resource, entity.create_msg(MsgKey.OBTAIN_INFO_FAILED))
        if value != SECURE_BOOT_SHOULD_VALUE:
            set_one_bios_info(login_info, secure_boot_key,
                              SECURE_BOOT_SHOULD_VALUE, logger)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
    return ResultFactory.create_pass(resource)


def is_involve_dev_type(login_info, logger):
    product_unique_id, _ = get_product_unique_id(login_info, logger)
    for dev_type in INVOLVE_PRODUCT_UNIQUE_IDS:
        if product_unique_id in INVOLVE_PRODUCT_UNIQUE_IDS.get(dev_type):
            return True
    return False
