#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/06/11
@file: config_SMMU_strategy.py
@function:
"""
import traceback
from Common.base import context_util
from Common.base.constant import MsgKey
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish.redfish_util import get_all_bios_info, \
    set_one_bios_info

PY_JAVA_ENV = py_java_env
SMMU_KEYS = ["EnableSMMU", "OemEnableSMMU"]
SMMU_SHOULD_VALUE = "Disabled"


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)

    # BIOS设置
    try:
        bios_info, resource = get_all_bios_info(login_info, logger)
        value = None
        for key in SMMU_KEYS:
            smmu_key = key
            if key in bios_info:
                value = bios_info.get(key)
                break
        logger.info("The dev SMMU value: {}".format(value))
        if not value:
            return ResultFactory.create_not_pass(
                resource, entity.create_msg(MsgKey.OBTAIN_INFO_FAILED))
        if value != SMMU_SHOULD_VALUE:
            set_one_bios_info(login_info, smmu_key, SMMU_SHOULD_VALUE, logger)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
    return ResultFactory.create_pass(resource)
